/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;

public class StiDutchKIXBarCodeType
extends StiBarCodeTypeService {
    protected String DutchKIXSymbols = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final String[] DutchKIXCodes = new String[]{"3300", "3210", "3201", "2310", "2301", "2211", "3120", "3030", "3021", "2130", "2121", "2031", "3102", "3012", "3003", "2112", "2103", "2013", "1320", "1230", "1221", "0330", "0321", "0231", "1302", "1212", "1203", "0312", "0303", "0213", "1122", "1032", "1023", "0132", "0123", "0033"};
    private double module = 20.0;
    private double height = 1.0;
    protected static final double DutchKIXSpaceLeft = (double)3.9f;
    protected static final double DutchKIXSpaceRight = (double)3.9f;
    protected static final double DutchKIXSpaceTop = (double)3.9f;
    protected static final double DutchKIXSpaceBottom = 2.0;
    protected static final double DutchKIXLineHeightLong = 10.0;
    protected static final double DutchKIXLineHeightShort = 6.200000047683716;
    protected static final double DutchKIXTextPosition = 16.90000009536743;
    protected static final double DutchKIXTextHeight = 5.0;
    protected static final double DutchKIXMainHeight = 22.90000009536743;
    protected static final double DutchKIXLineHeightForCut = 10.0;

    public StiDutchKIXBarCodeType() {
        this(20.0, 1.0);
    }

    public StiDutchKIXBarCodeType(double module, double height) {
        this.module = module;
        this.height = height;
    }

    public String getServiceName() {
        return "Royal TPG Post KIX 4-State";
    }

    @Override
    @StiDefaulValue(value="20.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 15.0) {
            this.module = 15.0;
        }
        if (value > 25.0) {
            this.module = 25.0;
        }
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 1.0) {
            this.height = 1.0;
        }
        if (value > 1.0) {
            this.height = 1.0;
        }
    }

    @Override
    public double getLabelFontHeight() {
        return 5.0;
    }

    @Override
    protected StiTextHorAlignment getTextAlignment() {
        return StiTextHorAlignment.Center;
    }

    private String CharTo4State(char inputChar) {
        int inputNumber = this.DutchKIXSymbols.indexOf(inputChar);
        return this.DutchKIXCodes[inputNumber];
    }

    private String StateToBar(String inputCode) {
        StringBuilder outputBar = new StringBuilder();
        for (int index = 0; index < inputCode.length(); ++index) {
            if (inputCode.charAt(index) == '0') {
                outputBar.append("c");
            } else if (inputCode.charAt(index) == '1') {
                outputBar.append("d");
            } else if (inputCode.charAt(index) == '2') {
                outputBar.append("e");
            } else if (inputCode.charAt(index) == '3') {
                outputBar.append("f");
            }
            outputBar.append("0");
        }
        return outputBar.toString();
    }

    private String MakeBarsArray(String code) {
        StringBuilder tempBarsArray = new StringBuilder();
        for (int index = 0; index < code.length(); ++index) {
            tempBarsArray.append(this.CharTo4State(code.charAt(index)));
        }
        return this.StateToBar(tempBarsArray.toString());
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = new String(this.CheckCodeSymbols(code, this.DutchKIXSymbols));
        String barsArray = this.MakeBarsArray(code);
        this.CalculateSizeFull(3.9f, 3.9f, 3.9f, 2.0, 6.200000047683716, 10.0, 16.90000009536743, 5.0, 22.90000009536743, 10.0, 1.0, zoom, code, code, barsArray, rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 20.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("Height")) continue;
            this.height = property.floatValue().floatValue();
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "2500GG30250";
    }
}

