/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;

public class StiCode93BarCodeType
extends StiBarCodeTypeService {
    private final String Code93Symbols = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";
    protected String[] Code93Table = new String[]{"131112", "111213", "111312", "111411", "121113", "121212", "121311", "111114", "131211", "141111", "211113", "211212", "211311", "221112", "221211", "231111", "112113", "112212", "112311", "122112", "132111", "111123", "111222", "111321", "121122", "131121", "212112", "212211", "211122", "211221", "221121", "222111", "112122", "112221", "122121", "123111", "121131", "311112", "311211", "321111", "112131", "113121", "211131", "121221", "312111", "311121", "122211", "111141", "1111411"};
    private double module = 13.0;
    private double height = 1.0;
    private double ratio = 2.2;
    protected static final double Code93SpaceLeft = 10.0;
    protected static final double Code93SpaceRight = 10.0;
    protected static final double Code93SpaceTop = 0.0;
    protected static final double Code93SpaceBottom = 1.0;
    protected static final double Code93LineHeightShort = 45.0;
    protected static final double Code93LineHeightLong = 45.0;
    protected static final double Code93TextPosition = 46.0;
    protected static final double Code93TextHeight = (double)8.33f;
    protected static final double Code93MainHeight = 55.0;
    protected static final double Code93LineHeightForCut = 45.0;

    public StiCode93BarCodeType() {
        this(13.0, 1.0, 2.2);
    }

    public StiCode93BarCodeType(double module, double height, double ratio) {
        this.module = module;
        this.height = height;
        this.ratio = ratio;
    }

    public String getServiceName() {
        return "Code93";
    }

    @Override
    @StiDefaulValue(value="13.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 2.0) {
            this.module = 2.0;
        }
        if (value > 40.0) {
            this.module = 40.0;
        }
        this.setRatio(this.getRatio());
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 0.5) {
            this.height = 0.5;
        }
        if (value > 2.0) {
            this.height = 2.0;
        }
    }

    @StiDefaulValue(value="2.2")
    @StiSerializable
    public final double getRatio() {
        return this.ratio;
    }

    public final void setRatio(double value) {
        this.ratio = value;
        double minRatio = this.getModule() > 20.0 ? 2.0f : 2.2f;
        if (value < minRatio) {
            this.ratio = minRatio;
        }
        if (value > 3.0) {
            this.ratio = 3.0;
        }
    }

    @Override
    public double getLabelFontHeight() {
        return 8.33f;
    }

    protected final String CodeToBar(String inputCode) {
        StringBuilder outputBar = new StringBuilder();
        boolean counter = true;
        for (int index = 0; index < inputCode.length(); ++index) {
            int currentsym = counter ? (inputCode.charAt(index) == '1' ? 52 : (inputCode.charAt(index) == '2' ? 53 : (inputCode.charAt(index) == '3' ? 54 : (inputCode.charAt(index) == '4' ? 55 : 52)))) : (inputCode.charAt(index) == '1' ? 48 : (inputCode.charAt(index) == '2' ? 49 : (inputCode.charAt(index) == '3' ? 50 : (inputCode.charAt(index) == '4' ? 51 : 48))));
            outputBar.append((char)currentsym);
            counter = !counter;
        }
        return outputBar.toString();
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%");
        int[] fullCode = new int[code.length() + 4];
        for (int index = 0; index < code.length(); ++index) {
            fullCode[index + 1] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(code.charAt(index));
        }
        int sum1 = 0;
        int multiplier = 1;
        for (int index = code.length() - 1; index >= 0; --index) {
            sum1 += fullCode[index + 1] * multiplier;
            if (++multiplier <= 20) continue;
            multiplier = 1;
        }
        fullCode[fullCode.length - 3] = sum1 % 47;
        int sum2 = 0;
        multiplier = 1;
        for (int index = code.length(); index >= 0; --index) {
            sum2 += fullCode[index + 1] * multiplier;
            if (++multiplier <= 15) continue;
            multiplier = 1;
        }
        fullCode[fullCode.length - 2] = sum2 % 47;
        fullCode[0] = this.Code93Table.length - 2;
        fullCode[fullCode.length - 1] = this.Code93Table.length - 1;
        StringBuilder barsArray = new StringBuilder();
        for (int index = 0; index < fullCode.length; ++index) {
            barsArray.append(this.CodeToBar(this.Code93Table[fullCode[index]]));
        }
        this.CalculateSizeFull(10.0, 10.0, 0.0, 1.0, 45.0, 45.0, 46.0, 8.33f, 55.0, 45.0, this.getRatio(), zoom, code, code, barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 13.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        jObject.AddPropertyFloat("Ratio", this.getRatio(), (double)2.2f);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("Ratio")) continue;
            this.ratio = property.floatValue().floatValue();
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "ABC123";
    }
}

