/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;

public class StiCodabarBarCodeType
extends StiBarCodeTypeService {
    private final String CodabarSymbols = "0123456789-$:/.+ABCD";
    private final String[] CodabarTable = new String[]{"11111221", "11112211", "11121121", "22111111", "11211211", "21111211", "12111121", "12112111", "12211111", "21121111", "11122111", "11221111", "21112121", "21211121", "21212111", "11222221", "11221211", "11121221", "12121121", "11122211"};
    private double module = 13.0;
    private double height = 1.0;
    private double ratio = 2.2;
    protected static final double CodabarSpaceLeft = 7.0;
    protected static final double CodabarSpaceRight = 7.0;
    protected static final double CodabarSpaceTop = 0.0;
    protected static final double CodabarSpaceBottom = 1.0;
    protected static final double CodabarLineHeightShort = 45.0;
    protected static final double CodabarLineHeightLong = 45.0;
    protected static final double CodabarTextPosition = 46.0;
    protected static final double CodabarTextHeight = (double)8.33f;
    protected static final double CodabarMainHeight = 55.0;
    protected static final double CodabarLineHeightForCut = 45.0;

    public StiCodabarBarCodeType() {
        this(13.0, 1.0, 2.2);
    }

    public StiCodabarBarCodeType(double module, double height, double ratio) {
        this.module = module;
        this.height = height;
        this.ratio = ratio;
    }

    public String getServiceName() {
        return "Codabar";
    }

    @Override
    @StiDefaulValue(value="13.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 7.5) {
            this.module = 7.5;
        }
        if (value > 40.0) {
            this.module = 40.0;
        }
        this.setRatio(this.getRatio());
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 0.5) {
            this.height = 0.5;
        }
        if (value > 2.0) {
            this.height = 2.0;
        }
    }

    @StiDefaulValue(value="2.2")
    @StiSerializable
    public final double getRatio() {
        return this.ratio;
    }

    public final void setRatio(double value) {
        this.ratio = value;
        double minRatio = this.getModule() > 20.0 ? 2.0f : 2.2f;
        if (value < minRatio) {
            this.ratio = minRatio;
        }
        if (value > 3.0) {
            this.ratio = 3.0;
        }
    }

    @Override
    public double getLabelFontHeight() {
        return 8.33f;
    }

    protected final String CodeToBar(String inputCode) {
        StringBuilder outputBar = new StringBuilder();
        boolean counter = true;
        for (int index = 0; index < inputCode.length(); ++index) {
            char currentsym = counter ? (inputCode.charAt(index) == '1' ? (char)'4' : '5') : (inputCode.charAt(index) == '1' ? (char)'0' : '1');
            outputBar.append(currentsym);
            counter = !counter;
        }
        return outputBar.toString();
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, "0123456789-$:/.+ABCD");
        int[] fullCode = new int[code.length()];
        for (int index = 0; index < code.length(); ++index) {
            fullCode[index] = "0123456789-$:/.+ABCD".indexOf(code.charAt(index));
        }
        StringBuilder barsArray = new StringBuilder();
        for (int index = 0; index < fullCode.length; ++index) {
            barsArray.append(this.CodeToBar(this.CodabarTable[fullCode[index]]));
        }
        this.CalculateSizeFull(7.0, 7.0, 0.0, 1.0, 45.0, 45.0, 46.0, 8.33f, 55.0, 45.0, this.getRatio(), zoom, code, code, barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", (double)((float)this.getModule()), 13.0);
        jObject.AddPropertyFloat("Height", (double)((float)this.getHeight()), 1.0);
        jObject.AddPropertyFloat("Ratio", (double)((float)this.getRatio()), (double)2.2f);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("Ratio")) continue;
            this.ratio = property.floatValue().floatValue();
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "A12345678B";
    }
}

