/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiCharsetHelper;
import com.stimulsoft.report.barCodes.BitMatrix;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.aztec.StiAztec;
import com.stimulsoft.report.barCodes.enums.StiAztecSize;
import java.awt.image.BufferedImage;

public class StiAztecBarCodeType
extends StiBarCodeTypeService {
    public String ServiceName = "Aztec";
    public String DefaultCodeValue = "12345678901";
    private double module = 40.0;
    private double height = 1.0;
    private int errorCorrectionLevel = 33;
    private StiAztecSize matrixSize = StiAztecSize.Automatic;
    private int codePage = 28591;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        jObject.AddPropertyFloat("Module", this.getModule(), 40.0);
        jObject.AddPropertyInt("ErrorCorrectionLevel", this.getErrorCorrectionLevel(), 33);
        jObject.AddPropertyEnum("MatrixSize", (Enum)this.matrixSize, (Enum)StiAztecSize.Automatic);
        jObject.AddPropertyInt("CodePage", this.codePage, 33);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("ErrorCorrectionLevel")) {
                this.setErrorCorrectionLevel((Integer)property.Value);
                continue;
            }
            if (property.Name.equals("MatrixSize")) {
                this.matrixSize = StiAztecSize.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("CodePage")) continue;
            this.codePage = (Integer)property.Value;
        }
    }

    @Override
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 5.0) {
            this.module = 5.0;
        }
        if (value > 400.0) {
            this.module = 400.0;
        }
    }

    @Override
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double height) {
        this.height = height;
    }

    @StiSerializable
    public int getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public void setErrorCorrectionLevel(int value) {
        this.errorCorrectionLevel = value;
        if (value < 10) {
            this.errorCorrectionLevel = 10;
        }
        if (value > 95) {
            this.errorCorrectionLevel = 95;
        }
    }

    @StiSerializable
    public int getCodePage() {
        return this.codePage;
    }

    public void setCodePage(int value) {
        if (StiCharsetHelper.ENCODINGS2.containsKey(value)) {
            this.codePage = value;
        }
    }

    @StiSerializable
    public StiAztecSize getMatrixSize() {
        return this.matrixSize;
    }

    public void setMatrixSize(StiAztecSize matrixSize) {
        this.matrixSize = matrixSize;
    }

    @Override
    public double getLabelFontHeight() {
        return 8.0;
    }

    @Override
    public String getDefaultCodeValue() {
        return "12345678901";
    }

    public boolean[] getVisibleProperties() {
        boolean[] props = new boolean[27];
        props[10] = true;
        props[12] = true;
        props[13] = true;
        return props;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code;
        this.getBarCodeData().Code = code = this.GetCode(barCode);
        try {
            BitMatrix bm = new BitMatrix(1, 1);
            boolean assembleData = false;
            if (!assembleData) {
                bm = StiAztec.encode((String)code, (int)this.errorCorrectionLevel, (StiAztecSize)this.matrixSize, (int)this.codePage, (boolean)false).Matrix;
            }
            int[] matrix = new int[bm.width * bm.height];
            for (int y = 0; y < bm.height; ++y) {
                int offset = y * bm.width;
                for (int x = 0; x < bm.width; ++x) {
                    matrix[offset + x] = bm.get(x, y) ? 1 : 0;
                }
            }
            this.getBarCodeData().MatrixGrid = matrix;
            this.getBarCodeData().MatrixWidth = bm.width;
            this.getBarCodeData().MatrixHeight = bm.height;
            this.getBarCodeData().MatrixRatioY = 1;
            this.draw2DBarCode(context, rect, barCode, zoom);
        }
        catch (Exception e) {
            this.drawBarCodeError(context, rect, barCode);
        }
    }

    public static BufferedImage GetBarcodeImage(String code, int zoom) {
        StiBarCode qr = new StiBarCode();
        qr.setBarCodeType(new StiAztecBarCodeType(10.0f, 33, StiAztecSize.Automatic, 28591));
        StiBarCodeTypeService.StiBarCodeData barCodeData = ((StiAztecBarCodeType)qr.getBarCodeType()).getBarCodeData();
        barCodeData.Code = code;
        BufferedImage resultImage = null;
        try {
            BitMatrix bm = StiAztec.encode((String)code, (int)33, (StiAztecSize)StiAztecSize.Automatic, (int)28591, (boolean)false).Matrix;
            int[] matrix = new int[bm.width * bm.height];
            for (int y = 0; y < bm.height; ++y) {
                int offset = y * bm.width;
                for (int x = 0; x < bm.width; ++x) {
                    matrix[offset + x] = bm.get(x, y) ? 1 : 0;
                }
            }
            barCodeData.MatrixGrid = matrix;
            barCodeData.MatrixWidth = bm.width;
            barCodeData.MatrixHeight = bm.height;
            barCodeData.MatrixRatioY = 1;
            int quietZone = 2;
            if (!qr.getShowQuietZones()) {
                quietZone = 0;
            }
            int imageWidth = (barCodeData.MatrixWidth + quietZone * 2) * zoom;
            int imageHeight = (barCodeData.MatrixHeight + quietZone * 2) * zoom;
            resultImage = new BufferedImage(imageWidth, imageHeight, 2);
            StiGraphics gr = new StiGraphics(resultImage.getGraphics());
            ((StiAztecBarCodeType)qr.getBarCodeType()).draw2DBarCode(gr, new StiRectangle(0L, 0L, (long)imageWidth, (long)imageHeight), qr, zoom);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultImage;
    }

    public StiBarCodeTypeService createNew() {
        return new StiAztecBarCodeType();
    }

    public StiAztecBarCodeType() {
        this(40.0f, 33, StiAztecSize.Automatic, 28591);
    }

    public StiAztecBarCodeType(float module, int errorCorrectionLevel, StiAztecSize matrixSize, int codePage) {
        this.module = module;
        this.setErrorCorrectionLevel(errorCorrectionLevel);
        this.matrixSize = matrixSize;
        this.setCodePage(codePage);
    }
}

