/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.report.barCodes.GaloisField;

public class GaloisFieldPolynomial {
    private final GaloisField field;
    private final int[] coefficients;

    public GaloisFieldPolynomial(GaloisField field, int[] coefficients) {
        if (coefficients == null || coefficients.length == 0) {
            throw new IllegalArgumentException();
        }
        this.field = field;
        int coefficientsLength = coefficients.length;
        if (coefficientsLength > 1 && coefficients[0] == 0) {
            int firstNonZero;
            for (firstNonZero = 1; firstNonZero < coefficientsLength && coefficients[firstNonZero] == 0; ++firstNonZero) {
            }
            if (firstNonZero == coefficientsLength) {
                this.coefficients = new int[]{0};
            } else {
                this.coefficients = new int[coefficientsLength - firstNonZero];
                System.arraycopy(coefficients, firstNonZero, this.coefficients, 0, this.coefficients.length);
            }
        } else {
            this.coefficients = coefficients;
        }
    }

    public int[] GetCoefficients() {
        return this.coefficients;
    }

    public int GetDegree() {
        return this.coefficients.length - 1;
    }

    public boolean IsZero() {
        return this.coefficients[0] == 0;
    }

    public int GetCoefficient(int degree) {
        return this.coefficients[this.coefficients.length - 1 - degree];
    }

    public GaloisFieldPolynomial AddOrSubtract(GaloisFieldPolynomial other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException("GaloisFieldPolynomial do not have same GaloisField field");
        }
        if (this.IsZero()) {
            return other;
        }
        if (other.IsZero()) {
            return this;
        }
        int[] smallerCoefficients = this.coefficients;
        int[] largerCoefficients = other.coefficients;
        if (smallerCoefficients.length > largerCoefficients.length) {
            int[] temp = smallerCoefficients;
            smallerCoefficients = largerCoefficients;
            largerCoefficients = temp;
        }
        int[] sumDiff = new int[largerCoefficients.length];
        int lengthDiff = largerCoefficients.length - smallerCoefficients.length;
        System.arraycopy(largerCoefficients, 0, sumDiff, 0, lengthDiff);
        for (int i = lengthDiff; i < largerCoefficients.length; ++i) {
            sumDiff[i] = GaloisField.AddOrSubtract(smallerCoefficients[i - lengthDiff], largerCoefficients[i]);
        }
        return new GaloisFieldPolynomial(this.field, sumDiff);
    }

    public GaloisFieldPolynomial Multiply(GaloisFieldPolynomial other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException("GaloisFieldPolynomial do not have same GaloisField field");
        }
        if (this.IsZero() || other.IsZero()) {
            return this.field.GetZero();
        }
        int[] aCoefficients = this.coefficients;
        int aLength = aCoefficients.length;
        int[] bCoefficients = other.coefficients;
        int bLength = bCoefficients.length;
        int[] product = new int[aLength + bLength - 1];
        for (int i = 0; i < aLength; ++i) {
            int aCoeff = aCoefficients[i];
            for (int j = 0; j < bLength; ++j) {
                product[i + j] = GaloisField.AddOrSubtract(product[i + j], this.field.Multiply(aCoeff, bCoefficients[j]));
            }
        }
        return new GaloisFieldPolynomial(this.field, product);
    }

    public GaloisFieldPolynomial MultiplyByMonomial(int degree, int coefficient) {
        if (degree < 0) {
            throw new IllegalArgumentException();
        }
        if (coefficient == 0) {
            return this.field.GetZero();
        }
        int size = this.coefficients.length;
        int[] product = new int[size + degree];
        for (int i = 0; i < size; ++i) {
            product[i] = this.field.Multiply(this.coefficients[i], coefficient);
        }
        return new GaloisFieldPolynomial(this.field, product);
    }

    public GaloisFieldPolynomial[] Divide(GaloisFieldPolynomial other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException("GaloisFieldPolynomial do not have same GaloisField field");
        }
        if (other.IsZero()) {
            throw new IllegalArgumentException("Divide by zero");
        }
        GaloisFieldPolynomial quotient = this.field.GetZero();
        GaloisFieldPolynomial remainder = this;
        int denominatorLeadingTerm = other.GetCoefficient(other.GetDegree());
        int inverseDenominatorLeadingTerm = this.field.Inverse(denominatorLeadingTerm);
        while (remainder.GetDegree() >= other.GetDegree() && !remainder.IsZero()) {
            int degreeDifference = remainder.GetDegree() - other.GetDegree();
            int scale = this.field.Multiply(remainder.GetCoefficient(remainder.GetDegree()), inverseDenominatorLeadingTerm);
            GaloisFieldPolynomial term = other.MultiplyByMonomial(degreeDifference, scale);
            GaloisFieldPolynomial iterationQuotient = this.field.BuildMonomial(degreeDifference, scale);
            quotient = quotient.AddOrSubtract(iterationQuotient);
            remainder = remainder.AddOrSubtract(term);
        }
        return new GaloisFieldPolynomial[]{quotient, remainder};
    }
}

