/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class StiNameValidator {
    private static final String patternStr = "([A-z0-9])*";
    private static final String patternStrR = "[^A-z0-9]";
    private static final Pattern p = Pattern.compile("([A-z0-9])*");

    public static String CorrectName(String str) {
        return StiNameValidator.CorrectName(str, true);
    }

    public static ArrayList<String> correctArrayName(ArrayList<String> array) {
        ArrayList<String> result = new ArrayList<String>();
        for (String string : array) {
            result.add(StiNameValidator.CorrectName(string));
        }
        return result;
    }

    public static String CorrectName(String str, StiReport report) {
        return StiNameValidator.CorrectName(str, true, report);
    }

    public static String CorrectName(String str, boolean checkKeywords) {
        return StiNameValidator.CorrectName(str, checkKeywords, null);
    }

    public static String CorrectName(String str, boolean checkKeywords, StiReport report) {
        StringBuilder sb = new StringBuilder(str == null ? "" : str);
        for (int pos = 0; pos < sb.length(); ++pos) {
            if (Character.isLetterOrDigit(sb.charAt(pos)) || sb.charAt(pos) == '_') continue;
            sb.setCharAt(pos, '_');
        }
        str = sb.toString();
        if (str.length() > 0 && Character.isDigit(str.charAt(0))) {
            str = "n" + str;
        }
        if (StiOptions.Engine.getFullTrust() && checkKeywords) {
            str = StiNameValidator.CheckKeyword(str, report);
        }
        return str;
    }

    private static String CheckKeyword(String str, StiReport report) {
        return str;
    }
}

