/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiNamingRule;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import java.util.Iterator;

public final class StiNameCreation {
    private StiNameCreation() {
    }

    public static StiNamingRule getNamingRule() {
        return StiOptions.Engine.getNamingRule();
    }

    public static void setNamingRule(StiNamingRule value) {
        StiOptions.Engine.setNamingRule(value);
    }

    private static String removeSpacesFromName(String baseName, boolean removeIncorrectSymbols, StiReport report) {
        if (removeIncorrectSymbols) {
            StringBuilder sb = new StringBuilder(baseName);
            int charIndex = 0;
            int len = baseName.length();
            for (int pos = 0; pos < len; ++pos) {
                if (baseName.charAt(pos) == ' ') {
                    sb.deleteCharAt(charIndex);
                    if (charIndex >= sb.length() || !Character.isLetter(sb.charAt(charIndex))) continue;
                    sb.setCharAt(charIndex, Character.toUpperCase(sb.charAt(charIndex)));
                    continue;
                }
                ++charIndex;
            }
            return StiNameValidator.CorrectName(sb.toString(), report);
        }
        return baseName;
    }

    public static String createSimpleName(StiReport report, String baseName) {
        return StiNameCreation.removeSpacesFromName(baseName, true, report) + report.IndexName++;
    }

    public static String createName(StiReport report, String baseName) {
        return StiNameCreation.createName(report, baseName, true, true);
    }

    public static String createName(StiReport report, String baseName, boolean addOne, boolean removeIncorrectSymbols) {
        return StiNameCreation.createName(report, baseName, addOne, removeIncorrectSymbols, false);
    }

    public static String createName(StiReport report, String baseName, boolean addOne, boolean removeIncorrectSymbols, boolean forceAdvancedNamingRule) {
        String newName = StiNameCreation.removeSpacesFromName(baseName, removeIncorrectSymbols, report);
        if (!(forceAdvancedNamingRule || report.getIsDesigning() && StiNameCreation.getNamingRule() != StiNamingRule.Simple)) {
            return newName + report.IndexName++;
        }
        StiComponentsCollection comps = report.getComponents();
        int counter = 1;
        if (comps.size() == 0 && report.getDataSources().size() == 0 && report.getDictionary().getDataSources().size() == 0 && report.getDictionary().getRelations().size() == 0 && report.getDictionary().getVariables().size() == 0) {
            if (addOne) {
                return newName + "1";
            }
            return newName;
        }
        while (true) {
            String testName = newName + counter;
            String checkName = !addOne && counter == 1 ? newName : testName;
            if (StiNameCreation.getObjectWithName(null, report, checkName) == null) {
                if (!addOne && counter == 1) {
                    return newName;
                }
                return testName;
            }
            ++counter;
        }
    }

    public static boolean isValidName(StiReport report, String name) {
        if (StiValidationUtil.isNullOrEmpty((String)name) || !Character.isLetter(name.charAt(0)) && name.charAt(0) != '_') {
            return false;
        }
        for (int pos = 0; pos < name.length(); ++pos) {
            if (Character.isLetterOrDigit(name.charAt(pos)) || name.charAt(pos) == '_') continue;
            return false;
        }
        StiComponentsCollection comps = report.GetComponents();
        for (StiComponent comp : comps) {
            if (!StiValidationUtil.equals((Object)name, (Object)comp.getName())) continue;
            return false;
        }
        return true;
    }

    public static Object getObjectWithName(Object checkedObject, StiReport report, String name) {
        if (report == null) {
            return null;
        }
        for (StiComponent comp : report.getComponents()) {
            if (!name.equals(comp.getName()) || checkedObject == comp) continue;
            return comp;
        }
        Iterator iterator = report.getDictionary().getDataSources().iterator();
        while (iterator.hasNext()) {
            StiDataSource dataSource = (StiDataSource)iterator.next();
            if (!name.equals(dataSource.getName()) || checkedObject == dataSource) continue;
            return dataSource;
        }
        for (StiBusinessObject businessObject : report.getDictionary().getBusinessObjects()) {
            if (!name.equals(businessObject.getName()) || checkedObject == businessObject) continue;
            return businessObject;
        }
        iterator = report.getDictionary().getVariables().iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            if (!name.equals(variable.getName()) || checkedObject == variable) continue;
            return variable;
        }
        return null;
    }

    public static String generateName(StiReport report, String localizedName, String name) {
        if (StiOptions.Engine.getForceGenerationLocalizedName()) {
            return localizedName;
        }
        if (!StiOptions.Engine.getForceGenerationNonLocalizedName() && report != null && report.getInfo().getGenerateLocalizedName()) {
            return localizedName;
        }
        String componentName = name;
        int sizeSti = 3;
        if (componentName.length() > 1 && componentName.substring(0, sizeSti).equals("Sti")) {
            componentName = componentName.substring(sizeSti);
        }
        return componentName;
    }

    public static String generateName(StiReport report, String localizedName, Class<?> type) {
        return StiNameCreation.generateName(report, localizedName, type.getName().substring(type.getName().lastIndexOf(".") + 1));
    }

    public static String generateName(StiComponent component) {
        return StiNameCreation.generateName(component.getReport(), component.getLocalizedName(), component.getClass());
    }

    public static String generateName(StiDataRelation relation) {
        return StiNameCreation.generateName(relation.getDictionary().getReport(), StiLocalization.Get((String)"PropertyMain", (String)"DataRelation"), relation.getClass());
    }

    public static String generateName(StiDataSource dataSource) {
        return StiNameCreation.generateName(dataSource.getDictionary().getReport(), StiLocalization.Get((String)"PropertyMain", (String)"DataSource"), dataSource.getClass());
    }

    public static String createResourceName(StiReport report, String baseName) {
        baseName = StiNameCreation.removeSpacesFromName(baseName, false, report);
        int counter = 1;
        while (true) {
            String testName;
            String string = testName = counter == 1 ? baseName : baseName + counter;
            if (!StiNameCreation.isResourceNameExists(report, testName)) {
                return testName;
            }
            ++counter;
        }
    }

    public static boolean isResourceNameExists(StiReport report, String name) {
        if (report == null) {
            return false;
        }
        name = name.toLowerCase().trim();
        Iterator iterator = report.dictionary.getResources().iterator();
        while (iterator.hasNext()) {
            StiResource res = (StiResource)iterator.next();
            if (!res.getName().toLowerCase().trim().equals(name)) continue;
            return true;
        }
        return false;
    }
}

