/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.data.functons;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.data.functons.StiMonth;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;

public class StiMonthToStrHelper {
    private static List<String[]> months;
    private static List<Boolean> defaultUpperCaseList;
    private static Hashtable<String, Integer> cultureIndexes;

    public static String monthName(StiDateTime dateTime, Locale locale) {
        return dateTime.toString("MMMM", locale);
    }

    public static String monthName(StiDateTime dateTime, Boolean localized) {
        if (!localized.booleanValue()) {
            return StiMonthToStrHelper.monthName(dateTime, Locale.getDefault());
        }
        switch (dateTime.month()) {
            case 1: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"MonthJanuary");
            }
            case 2: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"MonthFebruary");
            }
            case 3: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"MonthMarch");
            }
            case 4: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"MonthApril");
            }
            case 5: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"MonthMay");
            }
            case 6: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"MonthJune");
            }
            case 7: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"MonthJuly");
            }
            case 8: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"MonthAugust");
            }
            case 9: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"MonthSeptember");
            }
            case 10: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"MonthOctober");
            }
            case 11: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"MonthNovember");
            }
            case 12: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"MonthDecember");
            }
        }
        return StiMonthToStrHelper.monthName(dateTime, Locale.getDefault());
    }

    public static String monthName(StiDateTime dateTime, String culture) {
        return StiMonthToStrHelper.monthName(dateTime.month(), culture);
    }

    public static String monthName(int month, String culture) {
        String monthName = "";
        try {
            Locale result = Locale.getDefault();
            try {
                for (Locale locale : Locale.getAvailableLocales()) {
                    if (!(locale.getLanguage() + "-" + locale.getCountry()).equalsIgnoreCase(culture) && !locale.getLanguage().equalsIgnoreCase(culture) && !locale.getCountry().equalsIgnoreCase(culture)) continue;
                    result = locale;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DateFormatSymbols dfs = new DateFormatSymbols(result);
            return dfs.getMonths()[month];
        }
        catch (Exception e) {
            block9: {
                try {
                    String cultureName = culture.toLowerCase();
                    Integer index = cultureIndexes.get(cultureName);
                    if (month < months.get(index).length) {
                        monthName = months.get(index)[month - 1];
                    }
                    if (defaultUpperCaseList.get(index).booleanValue()) {
                        monthName = monthName.substring(0, 1).toUpperCase() + monthName.substring(1);
                    }
                }
                catch (Exception ee) {
                    if (StiOptions.Engine.logLevel < 10) break block9;
                    ee.printStackTrace();
                    e.printStackTrace();
                }
            }
            return monthName;
        }
    }

    public static String monthName(StiDateTime dateTime, String culture, Boolean upperCase) {
        String monthName = StiMonthToStrHelper.monthName(dateTime, culture).toLowerCase();
        return upperCase != false ? monthName.substring(0, 1).toUpperCase() + monthName.substring(1) : monthName;
    }

    public static void addCulture(String[] monthNames, String[] cultureNames, Boolean defaultUpperCase) {
        int index = months.size();
        months.add(monthNames);
        defaultUpperCaseList.add(defaultUpperCase);
        for (String culture : cultureNames) {
            cultureIndexes.put(culture.toLowerCase(), index);
        }
    }

    public static StiMonth month(String str) {
        if (StiValidationUtil.isNullOrWhiteSpace((String)str)) {
            return null;
        }
        str = str.toLowerCase().trim();
        for (String[] monthArray : months) {
            for (int index = 0; index < monthArray.length; ++index) {
                String monthName = monthArray[index].toLowerCase();
                if (monthName != str) continue;
                return StiMonth.values()[index + 1];
            }
        }
        return null;
    }

    public StiMonthToStrHelper() {
        months = new ArrayList<String[]>();
        defaultUpperCaseList = new ArrayList<Boolean>();
        cultureIndexes = new Hashtable();
        StiMonthToStrHelper.addCulture(new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"}, new String[]{"en"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"\u042f\u043d\u0432\u0430\u0440\u044c", "\u0424\u0435\u0432\u0440\u0430\u043b\u044c", "\u041c\u0430\u0440\u0442", "\u0410\u043f\u0440\u0435\u043b\u044c", "\u041c\u0430\u0439", "\u0418\u044e\u043d\u044c", "\u0418\u044e\u043b\u044c", "\u0410\u0432\u0433\u0443\u0441\u0442", "\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c", "\u041e\u043a\u0442\u044f\u0431\u0440\u044c", "\u041d\u043e\u044f\u0431\u0440\u044c", "\u0414\u0435\u043a\u0430\u0431\u0440\u044c"}, new String[]{"ru"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"}, new String[]{"es"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"gennaio", "febbraio", "marzo", "aprile", "maggio", "giugno", "luglio", "agosto", "settembre", "ottobre", "novembre", "dicembre"}, new String[]{"it"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"ianuarie", "februarie", "martie", "aprilie", "mai", "iunie", "iulie", "august", "septembrie", "octombrie", "noiembrie", "decembrie"}, new String[]{"ro"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"Janeiro", "Fevereiro", "Mar\u00e7o", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"}, new String[]{"pt"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"Jannar", "Frar", "Marzu", "April", "Mejju", "\u0120unju", "Lulju", "Awissu", "Settembru", "Ottubru", "Novembru", "Di\u010bembru"}, new String[]{"mt"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"janu\u00e1r", "febru\u00e1r", "m\u00e1rcius", "\u00e1prilis", "m\u00e1jus", "j\u00fanius", "j\u00falius", "augusztus", "szeptember", "okt\u00f3ber", "november", "december"}, new String[]{"hu"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"janu\u00e1r", "febru\u00e1r", "marec", "apr\u00edl", "m\u00e1j", "j\u00fan", "j\u00fal", "august", "september", "okt\u00f3ber", "november", "december"}, new String[]{"sk"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"jan\u00faar", "febr\u00faar", "mars", "apr\u00edl", "ma\u00ed", "j\u00fan\u00ed", "j\u00fal\u00ed", "\u00e1g\u00fast", "september", "okt\u00f3ber", "n\u00f3vember", "desember"}, new String[]{"is"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"januar", "februar", "mars", "apr\u00edl", "mai", "juni", "juli", "august", "september", "oktober", "november", "desember"}, new String[]{"fo"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"}, new String[]{"de"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"januari", "februari", "maart", "april", "mei", "juni", "juli", "augustus", "september", "oktober", "november", "december"}, new String[]{"nl"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "Nopember", "Desember"}, new String[]{"id"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"janv\u0101ris", "febru\u0101ris", "marts", "apr\u012blis", "maijs", "j\u016bnijs", "j\u016blijs", "augusts", "septembris", "oktobris", "novembris", "decembris"}, new String[]{"lv"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"janvier", "f\u00e9vrier", "mars", "avril", "mai", "juin", "juillet", "ao\u00fbt", "septembre", "octobre", "novembre", "d\u00e9cembre"}, new String[]{"fr"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"leden", "\u00fanor", "b\u0159ezen", "duben", "kv\u011bten", "\u010derven", "\u010dervenec", "srpen", "z\u00e1\u0159\u00ed", "\u0159\u00edjen", "listopad", "prosinec"}, new String[]{"cs"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"Mutarama", "Gashyantare", "Werurwe", "Mata", "Gicurasi", "Kamena", "Nyakanga", "Kanama", "Nzeli", "Ukwakira", "Ugushyingo", "Ukuboza"}, new String[]{"rw"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"Ocak", "\u015eubat", "Mart", "Nisan", "May\u0131s", "Haziran", "Temmuz", "A\u011fustos", "Eyl\u00fcl", "Ekim", "Kas\u0131m", "Aral\u0131k"}, new String[]{"tr"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"o\u0111\u0111ajagem\u00e1nnu", "guovvam\u00e1nnu", "njuk\u010dam\u00e1nnu", "cuo\u014bom\u00e1nnu", "miessem\u00e1nnu", "geassem\u00e1nnu", "suoidnem\u00e1nnu", "borgem\u00e1nnu", "\u010dak\u010dam\u00e1nnu", "golggotm\u00e1nnu", "sk\u00e1bmam\u00e1nnu", "juovlam\u00e1nnu"}, new String[]{"se"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"sausis", "vasaris", "kovas", "balandis", "gegu\u017e\u0117", "bir\u017eelis", "liepa", "rugpj\u016btis", "rugs\u0117jis", "spalis", "lapkritis", "gruodis"}, new String[]{"lt"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"sije\u010danj", "velja\u010da", "o\u017eujak", "travanj", "svibanj", "lipanj", "srpanj", "kolovoz", "rujan", "listopad", "studeni", "prosinac"}, new String[]{"hr"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"stycze\u0144", "luty", "marzec", "kwiecie\u0144", "maj", "czerwiec", "lipiec", "sierpie\u0144", "wrzesie\u0144", "pa\u017adziernik", "listopad", "grudzie\u0144"}, new String[]{"pl"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"tammikuu", "helmikuu", "maaliskuu", "huhtikuu", "toukokuu", "kes\u00e4kuu", "hein\u00e4kuu", "elokuu", "syyskuu", "lokakuu", "marraskuu", "joulukuu"}, new String[]{"fi"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"\u0458\u0430\u043d\u0443\u0430\u0440\u0438", "\u0444\u0435\u0432\u0440\u0443\u0430\u0440\u0438", "\u043c\u0430\u0440\u0442", "\u0430\u043f\u0440\u0438\u043b", "\u043c\u0430\u0458", "\u0458\u0443\u043d\u0438", "\u0458\u0443\u043b\u0438", "\u0430\u0432\u0433\u0443\u0441\u0442", "\u0441\u0435\u043f\u0442\u0435\u043c\u0432\u0440\u0438", "\u043e\u043a\u0442\u043e\u043c\u0432\u0440\u0438", "\u043d\u043e\u0435\u043c\u0432\u0440\u0438", "\u0434\u0435\u043a\u0435\u043c\u0432\u0440\u0438"}, new String[]{"mk"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"\u042f\u043d\u0443\u0430\u0440\u0438", "\u0424\u0435\u0432\u0440\u0443\u0430\u0440\u0438", "\u041c\u0430\u0440\u0442", "\u0410\u043f\u0440\u0438\u043b", "\u041c\u0430\u0439", "\u042e\u043d\u0438", "\u042e\u043b\u0438", "\u0410\u0432\u0433\u0443\u0441\u0442", "\u0421\u0435\u043f\u0442\u0435\u043c\u0432\u0440\u0438", "\u041e\u043a\u0442\u043e\u043c\u0432\u0440\u0438", "\u041d\u043e\u0435\u043c\u0432\u0440\u0438", "\u0414\u0435\u043a\u0435\u043c\u0432\u0440\u0438"}, new String[]{"bg"}, false);
        StiMonthToStrHelper.addCulture(new String[]{"\u0e21\u0e01\u0e23\u0e32\u0e04\u0e21", "\u0e01\u0e38\u0e21\u0e20\u0e32\u0e1e\u0e31\u0e19\u0e18\u0e4c", "\u0e21\u0e35\u0e19\u0e32\u0e04\u0e21", "\u0e40\u0e21\u0e29\u0e32\u0e22\u0e19", "\u0e1e\u0e24\u0e29\u0e20\u0e32\u0e04\u0e21", "\u0e21\u0e34\u0e16\u0e38\u0e19\u0e32\u0e22\u0e19", "\u0e01\u0e23\u0e01\u0e0e\u0e32\u0e04\u0e21", "\u0e2a\u0e34\u0e07\u0e2b\u0e32\u0e04\u0e21", "\u0e01\u0e31\u0e19\u0e22\u0e32\u0e22\u0e19", "\u0e15\u0e38\u0e25\u0e32\u0e04\u0e21", "\u0e1e\u0e24\u0e28\u0e08\u0e34\u0e01\u0e32\u0e22\u0e19", "\u0e18\u0e31\u0e19\u0e27\u0e32\u0e04\u0e21"}, new String[]{"th"}, false);
    }
}

