/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.data.functons;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.utils.StiLoggingUtil;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class StiDayOfWeekToStrHelper {
    private static List<String[]> days = new ArrayList<String[]>();
    private static List<Boolean> defaultUpperCaseList = new ArrayList<Boolean>();
    private static HashMap<String, Integer> cultureIndexes = new HashMap();

    public static String dayOfWeek(StiDateTime date) {
        return new DateFormatSymbols().getWeekdays()[date.zonedDateTime().getDayOfWeek().getValue()];
    }

    public static String dayOfWeek(StiDateTime date, boolean localized) {
        if (!localized) {
            return StiDayOfWeekToStrHelper.dayOfWeek(date);
        }
        switch (date.zonedDateTime().getDayOfWeek()) {
            case SUNDAY: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"DaySunday");
            }
            case MONDAY: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"DayMonday");
            }
            case TUESDAY: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"DayTuesday");
            }
            case WEDNESDAY: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"DayWednesday");
            }
            case THURSDAY: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"DayThursday");
            }
            case FRIDAY: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"DayFriday");
            }
            case SATURDAY: {
                return StiLocalization.Get((String)"A_WebViewer", (String)"DaySaturday");
            }
        }
        return StiDayOfWeekToStrHelper.dayOfWeek(date);
    }

    public static String dayOfWeek(StiDateTime dateTime, String culture) {
        String dayName;
        block5: {
            dayName = "";
            try {
                Locale locale = new Locale(culture);
                dayName = DateFormatSymbols.getInstance(locale).getWeekdays()[dateTime.zonedDateTime().getDayOfWeek().getValue()];
            }
            catch (Exception e) {
                int day = dateTime.zonedDateTime().getDayOfWeek().getValue();
                String cultureName = culture.toLowerCase();
                if (!cultureIndexes.containsKey(cultureName)) {
                    if (StiLoggingUtil.getLogLevel() >= 10) {
                        StiLoggingUtil.showWarning((String)("Function 'DayOfWeek': There is no data for specified culture " + cultureName), (Exception)new Exception());
                    }
                    return "";
                }
                int index = cultureIndexes.get(cultureName);
                if (day < days.get(index).length) {
                    dayName = days.get(index)[day];
                }
                if (!defaultUpperCaseList.get(index).booleanValue()) break block5;
                dayName = dayName.substring(0, 1).toUpperCase() + dayName.substring(1);
            }
        }
        return dayName;
    }

    public static String dayOfWeek(StiDateTime dateTime, String culture, boolean upperCase) {
        String dayName = StiDayOfWeekToStrHelper.dayOfWeek(dateTime, culture).toLowerCase();
        return upperCase ? dayName.substring(0, 1).toUpperCase() + dayName.substring(1) : dayName;
    }

    public static void addCulture(String[] monthNames, String[] cultureNames, boolean defaultUpperCase) {
        int index = days.size();
        days.add(monthNames);
        defaultUpperCaseList.add(defaultUpperCase);
        for (String culture : cultureNames) {
            cultureIndexes.put(culture.toLowerCase(), index);
        }
    }

    static {
        StiDayOfWeekToStrHelper.addCulture(new String[]{"dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"}, new String[]{"fr"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"domenica", "luned\u00ec", "marted\u00ec", "mercoled\u00ec", "gioved\u00ec", "venerd\u00ec", "sabato"}, new String[]{"it"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"domingo", "lunes", "martes", "mi\u00e9rcoles", "jueves", "viernes", "s\u00e1bado"}, new String[]{"es"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"domingo", "segunda-feira", "ter\u00e7a-feira", "quarta-feira", "quinta-feira", "sexta-feira", "s\u00e1bado"}, new String[]{"pt"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"duminic\u0103", "luni", "mar\u0163i", "miercuri", "joi", "vineri", "s\u00e2mb\u0103t\u0103"}, new String[]{"ro"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"Il-\u0126add", "It-Tnejn", "It-Tlieta", "L-Erbg\u0127a", "Il-\u0126amis", "Il-\u0120img\u0127a", "Is-Sibt"}, new String[]{"mt"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"Ku wa mbere", "Ku wa kabiri", "Ku wa gatatu", "Ku wa kane", "Ku wa gatanu", "Ku wa gatandatu", "Ku cyumweru"}, new String[]{"rw"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"}, new String[]{"id"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"nede\u013ea", "pondelok", "utorok", "streda", "\u0161tvrtok", "piatok", "sobota"}, new String[]{"sk"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"nedjelja", "ponedjeljak", "utorak", "srijeda", "\u010detvrtak", "petak", "subota"}, new String[]{"hr"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"niedziela", "poniedzia\u0142ek", "wtorek", "\u015broda", "czwartek", "pi\u0105tek", "sobota"}, new String[]{"pl"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"Pazar", "Pazartesi", "Sal\u0131", "\u00c7ar\u015famba", "Per\u015fembe", "Cuma", "Cumartesi"}, new String[]{"tr"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"sekmadienis", "pirmadienis", "antradienis", "tre\u010diadienis", "ketvirtadienis", "penktadienis", "\u0161e\u0161tadienis"}, new String[]{"lt"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"}, new String[]{"de"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"sotnabeaivi", "m\u00e1nnodat", "disdat", "gaskavahkku", "duorastat", "bearjadat", "l\u00e1vvardat"}, new String[]{"se"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"sunnudagur", "m\u00e1nadagur", "t\u00fdsdagur", "mikudagur", "h\u00f3sdagur", "fr\u00edggjadagur", "leygardagur"}, new String[]{"fo"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"sunnudagur", "m\u00e1nudagur", "\u00feri\u00f0judagur", "mi\u00f0vikudagur", "fimmtudagur", "f\u00f6studagur", "laugardagur"}, new String[]{"is"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"sunnuntai", "maanantai", "tiistai", "keskiviikko", "torstai", "perjantai", "lauantai"}, new String[]{"fi"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"sv\u0113tdiena", "pirmdiena", "otrdiena", "tre\u0161diena", "ceturtdiena", "piektdiena", "sestdiena"}, new String[]{"lv"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"vas\u00e1rnap", "h\u00e9tf\u0151", "kedd", "szerda", "cs\u00fct\u00f6rt\u00f6k", "p\u00e9ntek", "szombat"}, new String[]{"hu"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"zondag", "maandag", "dinsdag", "woensdag", "donderdag", "vrijdag", "zaterdag"}, new String[]{"nl"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"\u0432\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u044c\u0435", "\u043f\u043e\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u0438\u043a", "\u0432\u0442\u043e\u0440\u043d\u0438\u043a", "\u0441\u0440\u0435\u0434\u0430", "\u0447\u0435\u0442\u0432\u0435\u0440\u0433", "\u043f\u044f\u0442\u043d\u0438\u0446\u0430", "\u0441\u0443\u0431\u0431\u043e\u0442\u0430"}, new String[]{"ru"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"\u043d\u0435\u0434\u0435\u043b\u0430", "\u043f\u043e\u043d\u0435\u0434\u0435\u043b\u043d\u0438\u043a", "\u0432\u0442\u043e\u0440\u043d\u0438\u043a", "\u0441\u0440\u0435\u0434\u0430", "\u0447\u0435\u0442\u0432\u0440\u0442\u043e\u043a", "\u043f\u0435\u0442\u043e\u043a", "\u0441\u0430\u0431\u043e\u0442\u0430"}, new String[]{"mk"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"\u043d\u0435\u0434\u0435\u043b\u044f", "\u043f\u043e\u043d\u0435\u0434\u0435\u043b\u043d\u0438\u043a", "\u0432\u0442\u043e\u0440\u043d\u0438\u043a", "\u0441\u0440\u044f\u0434\u0430", "\u0447\u0435\u0442\u0432\u044a\u0440\u0442\u044a\u043a", "\u043f\u0435\u0442\u044a\u043a", "\u0441\u044a\u0431\u043e\u0442\u0430"}, new String[]{"bg"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"\u041d\u044f\u043c", "\u0414\u0430\u0432\u0430\u0430", "\u041c\u044f\u0433\u043c\u0430\u0440", "\u041b\u0445\u0430\u0433\u0432\u0430", "\u041f\u04af\u0440\u044d\u0432", "\u0411\u0430\u0430\u0441\u0430\u043d", "\u0411\u044f\u043c\u0431\u0430"}, new String[]{"mn"}, false);
        StiDayOfWeekToStrHelper.addCulture(new String[]{"\u0e2d\u0e32\u0e17\u0e34\u0e15\u0e22\u0e4c", "\u0e08\u0e31\u0e19\u0e17\u0e23\u0e4c", "\u0e2d\u0e31\u0e07\u0e04\u0e32\u0e23", "\u0e1e\u0e38\u0e18", "\u0e1e\u0e24\u0e2b\u0e31\u0e2a\u0e1a\u0e14\u0e35", "\u0e28\u0e38\u0e01\u0e23\u0e4c", "\u0e40\u0e2a\u0e32\u0e23\u0e4c"}, new String[]{"th"}, false);
    }
}

