/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiTableOfContents;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.web.helper.StiEncodingHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class StiTableOfContentsHelper {
    private static List<String> getIdents(Object comp, StiTableOfContents tableOfContents) {
        StiText text;
        StiBand band;
        StiGroupHeaderBand groupHeaderBand;
        StiPage page;
        StiReport report;
        HashSet<String> strs = new HashSet<String>();
        StiReport stiReport = report = comp instanceof StiReport ? (StiReport)comp : null;
        if (report != null) {
            if (!StiValidationUtil.isNullOrWhiteSpace((String)tableOfContents.getReportPointer())) {
                strs.add(tableOfContents.getReportPointer());
            }
            if (!StiValidationUtil.isNullOrWhiteSpace((String)report.getReportAlias())) {
                strs.add(report.getReportAlias());
            }
            if (!StiValidationUtil.isNullOrWhiteSpace((String)report.getReportName())) {
                strs.add(report.getReportName());
            }
        }
        StiPage stiPage = page = comp instanceof StiPage ? (StiPage)comp : null;
        if (page != null) {
            if (!StiValidationUtil.isNullOrWhiteSpace((String)page.getAlias())) {
                strs.add(page.getAlias());
            }
            if (!StiValidationUtil.isNullOrWhiteSpace((String)page.getName())) {
                strs.add(page.getName());
            }
        }
        StiGroupHeaderBand stiGroupHeaderBand = groupHeaderBand = comp instanceof StiGroupHeaderBand ? (StiGroupHeaderBand)comp : null;
        if (groupHeaderBand != null && !StiValidationUtil.isNullOrWhiteSpace((String)groupHeaderBand.getCondition().getValue()) && groupHeaderBand.getCondition().getValue().contains("{")) {
            strs.add(groupHeaderBand.getCondition().getValue());
        }
        StiBand stiBand = band = comp instanceof StiBand ? (StiBand)comp : null;
        if (band != null) {
            if (!StiValidationUtil.isNullOrWhiteSpace((String)band.getBookmark().getValue()) && band.getBookmark().getValue().contains("{")) {
                strs.add(band.getBookmark().getValue());
            }
            if (!StiValidationUtil.isNullOrWhiteSpace((String)band.getHyperlink().getValue()) && band.getHyperlink().getValue().contains("{")) {
                strs.add(band.getHyperlink().getValue());
            }
            for (StiComponent c : band.getComponents()) {
                StiText element;
                if (!(c instanceof StiText) || StiValidationUtil.isNullOrWhiteSpace((String)(element = (StiText)c).getText().getValue()) || !element.getText().getValue().contains("{")) continue;
                strs.add(element.getText().getValue());
            }
        }
        StiText stiText = text = comp instanceof StiText ? (StiText)comp : null;
        if (text != null) {
            if (!StiValidationUtil.isNullOrWhiteSpace((String)text.getBookmark().getValue()) && text.getBookmark().getValue().contains("{")) {
                strs.add(text.getBookmark().getValue());
            }
            if (!StiValidationUtil.isNullOrWhiteSpace((String)text.getHyperlink().getValue()) && text.getHyperlink().getValue().contains("{")) {
                strs.add(text.getHyperlink().getValue());
            }
            if (!StiValidationUtil.isNullOrWhiteSpace((String)text.getText().getValue()) && (text.getText().getValue().contains("{") || strs.size() == 0)) {
                strs.add(text.getText().getValue());
            }
        }
        if (strs.size() == 0) {
            strs.add("");
        }
        return new ArrayList<String>(strs);
    }

    public static void getIdentsCollection(StiReport report, HashMap param, HashMap callbackResult) {
        HashMap<String, List<String>> idents = new HashMap<String, List<String>>();
        StiTableOfContents tableOfContents = (StiTableOfContents)report.GetComponentByName((String)param.get("tableOfContentsName"));
        if (tableOfContents != null) {
            List componentsNames = (List)param.get("componentsNames");
            for (int i = 0; i < componentsNames.size(); ++i) {
                StiComponent component = report.GetComponentByName((String)componentsNames.get(i));
                if (component == null) continue;
                idents.put(component.getName(), StiTableOfContentsHelper.getIdents(component, tableOfContents));
            }
        }
        callbackResult.put("idents", idents);
    }

    public static void updateComponentsPointerValues(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        HashMap changedComponents = (HashMap)param.get("changedComponents");
        StiTableOfContents tableOfContents = (StiTableOfContents)report.GetComponentByName((String)param.get("tableOfContentsName"));
        if (changedComponents != null && tableOfContents != null) {
            for (Object changedComponent : changedComponents.keySet()) {
                HashMap componentParams = (HashMap)changedComponents.get(changedComponent);
                String componentType = (String)componentParams.get("componentType");
                String componentName = (String)componentParams.get("componentName");
                String pointerValue = StiEncodingHelper.decodeString((String)((String)componentParams.get("pointerValue")));
                if (componentType == "StiReport") {
                    tableOfContents.setReportPointer(pointerValue);
                    continue;
                }
                StiComponent component = report.GetComponentByName(componentName);
                if (component == null) continue;
                component.getPointer().setValue(pointerValue);
            }
        }
    }
}

