/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.base.zip.StiGZipHelper;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.dictionary.enums.StiResourceType;
import com.stimulsoft.report.enums.StiRenderedWith;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.html.StiHtmlExportBookmarksMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportQuality;
import com.stimulsoft.report.export.tools.html.StiHtmlTextWriter;
import com.stimulsoft.report.helpers.StiResourceArrayToDataSet;
import com.stimulsoft.report.options.ExportOptions;
import com.stimulsoft.web.helper.StiEncodingHelper;
import com.stimulsoft.web.helper.StiReportResourceHelper;
import com.stimulsoft.webdesigner.helper.StiDictionaryHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.SAXException;

public class StiReportResourcesHelper {
    public static String getReportThumbnailParameters(StiReport report, double zoom) throws IOException, StiException {
        if (!report.getIsRendered()) {
            try {
                report.Render(false);
            }
            catch (Exception e) {
                report = new StiReport();
            }
        }
        if (report.getRenderedPages().size() == 0) {
            return "";
        }
        report.renderedWith = StiRenderedWith.Java;
        ExportOptions.Html.setUseComponentStyleName((boolean)false);
        StiHtmlExportService service = new StiHtmlExportService();
        service.setRenderAsDocument(false);
        service.setStyles(new ArrayList());
        service.setClearOnFinish(false);
        service.setRenderStyles(false);
        StiHtmlExportSettings settings = new StiHtmlExportSettings();
        settings.setPageRange(new StiPagesRange(0));
        settings.setZoom(zoom);
        settings.setImageFormat(StiImageFormat.Png);
        settings.setExportQuality(StiHtmlExportQuality.High);
        settings.setExportBookmarksMode(StiHtmlExportBookmarksMode.ReportOnly);
        settings.setRemoveEmptySpaceAtBottom(false);
        settings.setUseWatermarkMargins(true);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        service.exportHtml(report, (OutputStream)stream, settings);
        String htmlText = new String(stream.toByteArray(), "UTF-8");
        stream.close();
        stream = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        StiHtmlTextWriter htmlWriter = new StiHtmlTextWriter(writer);
        service.setHtmlWriter(htmlWriter);
        if (service.getTableRender() != null) {
            service.getTableRender().renderStylesTable(true, false, false);
        }
        htmlWriter.flush();
        writer.flush();
        String htmlTextStyles = writer.toString();
        writer.close();
        stream.close();
        service.clear();
        StiPage page = report.getRenderedPages().get(0);
        String pageMargins = String.format("%spx %spx %spx %spx", Math.round(report.getUnit().ConvertToHInches(page.getMargins().getTop()) * zoom), Math.round(report.getUnit().ConvertToHInches(page.getMargins().getRight()) * zoom), Math.round(report.getUnit().ConvertToHInches(page.getMargins().getBottom()) * zoom), Math.round(report.getUnit().ConvertToHInches(page.getMargins().getLeft()) * zoom));
        String pageBackground = StiBrush.ToColor((StiBrush)page.getBrush()).toHTML();
        return String.format("<div style='display: inline-block; border: 1px solid #c6c6c6; background:%s; padding:%s'><style type='text/css'>%s</style>%s</div>", pageBackground, pageMargins, htmlTextStyles, htmlText);
    }

    private static boolean isPackedFile(byte[] content) {
        if (content == null) {
            return false;
        }
        return content[0] == 31 && content[1] == 139 && content[2] == 8 || content[0] == 80 && content[1] == 75 && content[2] == 3;
    }

    public static String getStringContentForJSFromResourceContent(StiResourceType resourceType, byte[] content) throws IOException, SAXException, StiDeserializationException, StiException {
        String resultContent = null;
        if (resourceType == StiResourceType.Image) {
            resultContent = StiReportEdit.imageToBase64(content);
        } else if (resourceType != StiResourceType.Rtf) {
            if (resourceType == StiResourceType.Txt) {
                String contentText = StiGZipHelper.convertByteArrayToString((byte[])content);
                resultContent = StiEncodingHelper.encode((String)contentText);
            } else if (resourceType == StiResourceType.Report || resourceType == StiResourceType.ReportSnapshot) {
                StiReport report = new StiReport();
                if (StiReportResourcesHelper.isPackedFile(content)) {
                    byte[] unpacked = StiGZipHelper.unpack((byte[])content);
                    if (resourceType == StiResourceType.Report) {
                        report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(unpacked));
                        report.setIsRendered(false);
                    } else {
                        report = StiSerializeManager.deserializeDocument((InputStream)new ByteArrayInputStream(unpacked)).getReport();
                    }
                } else if (resourceType == StiResourceType.Report) {
                    report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(content));
                    report.setIsRendered(false);
                } else {
                    report = StiSerializeManager.deserializeDocument((InputStream)new ByteArrayInputStream(content)).getReport();
                }
                resultContent = StiEncodingHelper.encode((String)StiReportResourcesHelper.getReportThumbnailParameters(report, 0.2));
            } else if (StiReportResourceHelper.isFontResourceType((StiResourceType)resourceType)) {
                return StiReportResourceHelper.getBase64DataFromFontResourceContent((StiResourceType)resourceType, (byte[])content);
            }
        }
        return resultContent;
    }

    public static void getResourceContent(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws IOException, SAXException, StiDeserializationException, StiException {
        StiResource resource = report.getDictionary().getResources().get((String)param.get("resourceName"));
        if (resource != null) {
            callbackResult.put("resourceType", resource.getType());
            callbackResult.put("resourceName", resource.getName());
            callbackResult.put("resourceSize", resource.getContent() != null ? resource.getContent().length : 0);
            callbackResult.put("haveContent", resource.getContent() != null);
            if (resource.getContent() != null) {
                callbackResult.put("resourceContent", StiReportResourcesHelper.getStringContentForJSFromResourceContent(resource.getType(), resource.getContent()));
            }
        }
    }

    public static void getResourceText(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws UnsupportedEncodingException {
        StiResource resource = report.getDictionary().getResources().get((String)param.get("resourceName"));
        if (resource != null && resource.getContent() != null) {
            callbackResult.put("resourceText", new String(StiBase64EncoderUtil.encode((byte[])resource.getContent()), "UTF-8"));
        }
    }

    public static void setResourceText(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        StiResource resource = report.getDictionary().getResources().get((String)param.get("resourceName"));
        if (resource != null && param.get("resourceText") != null) {
            resource.setContent(StiBase64DecoderUtil.decode((String)((String)param.get("resourceText"))));
        }
    }

    public static void getResourceViewData(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws UnsupportedEncodingException, JSONException, StiException {
        byte[] resourceContent;
        StiResource resource = report.getDictionary().getResources().get((String)param.get("resourceName"));
        String contentBase64Str = (String)param.get("resourceContent");
        byte[] byArray = resourceContent = contentBase64Str != null ? StiBase64DecoderUtil.decode((String)contentBase64Str.substring(contentBase64Str.indexOf("base64,") + 7)) : null;
        if (resource != null && resource.getContent() != null || resourceContent != null) {
            DataSet dataSet = StiResourceArrayToDataSet.get((StiResourceType)StiResourceType.valueOf((String)((String)param.get("resourceType"))), (byte[])(resourceContent != null ? resourceContent : resource.getContent()));
            HashMap resultTables = new HashMap();
            for (DataTable dataTable : dataSet.getTables()) {
                ArrayList resultData = new ArrayList();
                ArrayList<StiDataColumn> dictionaryColumns = new ArrayList<StiDataColumn>();
                ArrayList<String> captions = new ArrayList<String>();
                for (int k = 0; k < dataTable.getColumns().size(); ++k) {
                    StiDataColumn dictionaryColumn = new StiDataColumn(((StiDataColumn)dataTable.getColumns().get(k)).getCaption(), ((StiDataColumn)dataTable.getColumns().get(k)).getCaption(), ((StiDataColumn)dataTable.getColumns().get(k)).getSystemType());
                    captions.add(((StiDataColumn)dataTable.getColumns().get(k)).getCaption());
                    dictionaryColumns.add(dictionaryColumn);
                }
                resultData.add(captions);
                for (int i = 0; i < dataTable.getRows().size(); ++i) {
                    ArrayList<HashMap<String, String>> rowArray = new ArrayList<HashMap<String, String>>();
                    resultData.add(rowArray);
                    for (int k = 0; k < dataTable.getColumns().size(); ++k) {
                        rowArray.add(StiDictionaryHelper.getViewDataItemValue(((DataRow)dataTable.getRows().get(i)).getValue(k), (StiDataColumn)dictionaryColumns.get(k)));
                    }
                }
                resultTables.put(dataTable.getTableName(), resultData);
            }
            callbackResult.put("dataTables", resultTables);
        }
    }

    public static StiResourceType getResourceTypeByFileName(String fileName) {
        if ((fileName = fileName.toLowerCase()).endsWith(".csv")) {
            return StiResourceType.Csv;
        }
        if (fileName.endsWith(".dbf")) {
            return StiResourceType.Dbf;
        }
        if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
            return StiResourceType.Excel;
        }
        if (fileName.endsWith(".json")) {
            return StiResourceType.Json;
        }
        if (fileName.endsWith(".xml")) {
            return StiResourceType.Xml;
        }
        if (fileName.endsWith(".xsd")) {
            return StiResourceType.Xsd;
        }
        if (fileName.endsWith(".ttf")) {
            return StiResourceType.FontTtf;
        }
        if (fileName.endsWith(".otf")) {
            return StiResourceType.FontOtf;
        }
        if (fileName.endsWith(".woff")) {
            return StiResourceType.FontWoff;
        }
        if (fileName.endsWith(".ttc")) {
            return StiResourceType.FontTtc;
        }
        if (fileName.endsWith(".eot")) {
            return StiResourceType.FontEot;
        }
        if (fileName.endsWith(".rtf")) {
            return StiResourceType.Rtf;
        }
        if (fileName.endsWith(".txt")) {
            return StiResourceType.Txt;
        }
        if (fileName.endsWith(".mrt") || fileName.endsWith(".mrz")) {
            return StiResourceType.Report;
        }
        if (fileName.endsWith(".mdc") || fileName.endsWith(".mdz")) {
            return StiResourceType.ReportSnapshot;
        }
        if (fileName.endsWith(".gif") || fileName.endsWith(".png") || fileName.endsWith(".jpeg") || fileName.endsWith(".jpg") || fileName.endsWith(".wmf") || fileName.endsWith(".bmp") || fileName.endsWith(".tiff") || fileName.endsWith(".ico") || fileName.endsWith(".emf") || fileName.endsWith(".svg")) {
            return StiResourceType.Image;
        }
        return StiResourceType.Image;
    }

    public static boolean isDataResourceType(StiResourceType resourceType) {
        return resourceType == StiResourceType.Json || resourceType == StiResourceType.Csv || resourceType == StiResourceType.Xml || resourceType == StiResourceType.Dbf || resourceType == StiResourceType.Excel;
    }

    public static String convertBase64MetaFileToBase64Png(String fileContent) {
        byte[] imageBytes = StiBase64DecoderUtil.decode((String)fileContent.substring(fileContent.indexOf("base64,") + 7));
        return StiReportEdit.getBase64PngFromMetaFileBytes(imageBytes);
    }
}

