/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.base.utils.StiXmlTextWriter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiConvert;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.service.helper.StiMapSvgHelper;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.maps.StiMapData;
import com.stimulsoft.report.maps.enums.StiDisplayNameType;
import com.stimulsoft.report.maps.enums.StiMapID;
import com.stimulsoft.report.maps.enums.StiMapMode;
import com.stimulsoft.report.maps.enums.StiMapSource;
import com.stimulsoft.report.maps.enums.StiMapStyleIdent;
import com.stimulsoft.report.maps.enums.StiMapType;
import com.stimulsoft.report.maps.style.StiMapStyleFX;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiMapStyle;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;

public class StiMapHelper {
    public static HashMap<String, Object> getMapProperties(StiMap map) throws UnsupportedEncodingException, JSONException, IOException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", map.getName());
        properties.put("mapMode", map.getMapMode());
        properties.put("mapType", map.getMapType());
        properties.put("mapID", map.getMapID());
        properties.put("showValue", map.isShowValue());
        properties.put("displayNameType", map.getDisplayNameType());
        properties.put("mapData", StiMapHelper.getMapDataForJS(map));
        properties.put("dataFrom", map.getDataFrom());
        properties.put("colorEach", map.isColorEach());
        properties.put("keyDataColumn", map.getKeyDataColumn());
        properties.put("nameDataColumn", map.getNameDataColumn());
        properties.put("valueDataColumn", map.getValueDataColumn());
        properties.put("groupDataColumn", map.getGroupDataColumn());
        properties.put("colorDataColumn", map.getColorDataColumn());
        properties.put("latitudeDataColumn", map.getLatitude());
        properties.put("longitudeDataColumn", map.getLongitude());
        return properties;
    }

    public static void setMapProperties(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        StiMap map;
        StiMap stiMap = map = report.GetComponentByName((String)param.get("componentName")) != null ? (StiMap)report.GetComponentByName((String)param.get("componentName")) : null;
        if (map != null) {
            HashMap props = (HashMap)param.get("properties");
            map.setMapMode(StiMapMode.valueOf((String)((String)props.get("mapMode"))));
            map.setMapID(StiMapID.valueOf((String)((String)props.get("mapID"))));
            map.setMapType(StiMapType.valueOf((String)((String)props.get("mapType"))));
            map.setShowValue(((Boolean)props.get("showValue")).booleanValue());
            map.setColorEach(((Boolean)props.get("colorEach")).booleanValue());
            map.setDisplayNameType(StiDisplayNameType.valueOf((String)((String)props.get("displayNameType"))));
            map.setDataFrom(StiMapSource.valueOf((String)((String)props.get("dataFrom"))));
            boolean dataFromDataColumns = map.getDataFrom() == StiMapSource.DataColumns;
            map.setKeyDataColumn(dataFromDataColumns ? (String)props.get("keyDataColumn") : "");
            map.setNameDataColumn(dataFromDataColumns ? (String)props.get("nameDataColumn") : "");
            map.setValueDataColumn(dataFromDataColumns ? (String)props.get("valueDataColumn") : "");
            map.setGroupDataColumn(dataFromDataColumns ? (String)props.get("groupDataColumn") : "");
            map.setColorDataColumn(dataFromDataColumns ? (String)props.get("colorDataColumn") : "");
            map.setLatitude((String)props.get("latitudeDataColumn"));
            map.setLongitude((String)props.get("longitudeDataColumn"));
            if (param.get("updateMapData") != null) {
                map.setMapData(null);
                callbackResult.put("mapData", StiMapHelper.getMapDataForJS(map));
            }
            callbackResult.put("svgContent", StiReportEdit.getSvgContent((StiComponent)map, StiReportEdit.strToDouble((String)param.get("zoom"))));
            callbackResult.put("componentName", param.get("componentName"));
        }
    }

    public static void updateMapData(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        StiMap map = (StiMap)report.GetComponentByName((String)param.get("componentName"));
        if (map != null) {
            List mapData = map.GetMapData();
            Collections.sort(mapData, new Comparator<StiMapData>(){

                @Override
                public int compare(StiMapData o1, StiMapData o2) {
                    return o1.getKey() != null ? o1.getKey().compareTo(o2.getKey()) : 0;
                }
            });
            StiMapData rowData = (StiMapData)mapData.get(StiConvert.toInt32((Object)param.get("rowIndex")));
            String columnName = (String)param.get("columnName");
            if ("name".equals(columnName)) {
                rowData.setName((String)param.get("textValue"));
            } else if ("value".equals(columnName)) {
                rowData.setValue((String)param.get("textValue"));
            } else if ("group".equals(columnName)) {
                rowData.setGroup((String)param.get("textValue"));
            } else if ("color".equals(columnName)) {
                rowData.setColor((String)param.get("textValue"));
            }
            JSONArray jMapData = new JSONArray();
            for (StiMapData md : mapData) {
                HashMap<String, String> jmd = new HashMap<String, String>();
                if (md.getColor() != null) {
                    jmd.put("Color", md.getColor());
                }
                if (md.getGroup() != null) {
                    jmd.put("Group", md.getGroup());
                }
                if (md.getKey() != null) {
                    jmd.put("Key", md.getKey());
                }
                if (md.getName() != null) {
                    jmd.put("Name", md.getName());
                }
                if (md.getValue() != null) {
                    jmd.put("Value", md.getValue());
                }
                jMapData.put(jmd);
            }
            map.setMapData(jMapData.toString());
            callbackResult.put("svgContent", StiReportEdit.getSvgContent((StiComponent)map, StiReportEdit.strToDouble((String)param.get("zoom"))));
            callbackResult.put("componentName", param.get("componentName"));
        }
    }

    public static ArrayList<HashMap<String, Object>> getMapDataForJS(StiMap map) throws UnsupportedEncodingException, JSONException, IOException {
        ArrayList<HashMap<String, Object>> resultData = new ArrayList<HashMap<String, Object>>();
        List mapData = map.GetMapData();
        Collections.sort(mapData, new Comparator<StiMapData>(){

            @Override
            public int compare(StiMapData o1, StiMapData o2) {
                return o1.getKey() != null ? o1.getKey().compareTo(o2.getKey()) : 0;
            }
        });
        boolean allowGroup = StiMapHelper.allowGroup(map);
        boolean allowColor = StiMapHelper.allowColor(map);
        for (StiMapData data : mapData) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("key", data.getKey());
            row.put("name", data.getName());
            row.put("value", data.getValue());
            if (allowGroup) {
                row.put("group", data.getGroup());
            }
            if (allowColor) {
                row.put("color", data.getColor());
            }
            resultData.add(row);
        }
        return resultData;
    }

    private static boolean allowGroup(StiMap map) {
        return map.getMapType() == StiMapType.Group || map.getMapType() == StiMapType.HeatmapWithGroup;
    }

    private static boolean allowColor(StiMap map) {
        return map.getMapType() == StiMapType.Individual;
    }

    public static HashMap<String, Object> getStyle(StiMap map) {
        HashMap<String, Object> style = new HashMap<String, Object>();
        style.put("type", StiValidationUtil.isNullOrEmpty((String)map.getComponentStyle()) ? "StiMapStyleIdent" : "StiMapStyle");
        style.put("name", StiValidationUtil.isNullOrEmpty((String)map.getComponentStyle()) ? map.getMapStyle().toString() : map.getComponentStyle());
        return style;
    }

    private static List<StiMapStyle> getMapStyles(StiReport report) {
        ArrayList<StiMapStyle> mapStyles = new ArrayList<StiMapStyle>();
        for (StiBaseStyle style : report.getStyles()) {
            if (!(style instanceof StiMapStyle)) continue;
            StiMapStyle customStyle = new StiMapStyle(style.getName());
            mapStyles.add(customStyle);
        }
        mapStyles.addAll(StiOptions.Services.getMapStyles());
        return mapStyles;
    }

    public static String getMapSampleImage(StiMap map, int width, int height, float zoom) throws Exception {
        StiSvgExportService.StiSvgHelper.StiSvgData svgData = new StiSvgExportService.StiSvgHelper.StiSvgData();
        svgData.X = 0.0;
        svgData.Y = 0.0;
        svgData.Width = width;
        svgData.Height = height;
        svgData.Component = map;
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("svg");
        writer.writeAttributeString("version", "1.1");
        writer.writeAttributeString("baseProfile", "full");
        writer.writeAttributeString("xmlns", "http://www.w3.org/2000/svg");
        writer.writeAttributeString("xmlns:xlink", "http://www.w3.org/1999/xlink");
        writer.writeAttributeString("xmlns:ev", "http://www.w3.org/2001/xml-events");
        writer.writeAttributeString("height", String.valueOf(svgData.Height));
        writer.writeAttributeString("width", String.valueOf(svgData.Width));
        StiMapSvgHelper.drawMap((StiXmlTextWriter)writer, (StiMap)map, (double)width, (double)height, (Boolean)false);
        writer.writeFullEndElement();
        return StiXmlHelper.serialize((Document)writer.getDocument());
    }

    public static void setMapStyle(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        StiMap map;
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        String styleType = (String)param.get("styleType");
        String styleName = (String)param.get("styleName");
        if (component == null) {
            return;
        }
        StiMap stiMap = map = component instanceof StiMap ? (StiMap)component : null;
        if ("StiMapStyle".equals(styleType)) {
            map.setComponentStyle(styleName);
        } else {
            map.setComponentStyle("");
            map.setMapStyle(StiMapStyleIdent.valueOf((String)styleName));
        }
    }

    public static void getStylesContent(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        StiMap component = (StiMap)report.GetComponentByName((String)param.get("componentName"));
        StiMap mapCloned = (StiMap)component.clone();
        ArrayList stylesContent = new ArrayList();
        if (mapCloned != null) {
            for (StiMapStyle style : StiMapHelper.getMapStyles(report)) {
                if (style instanceof StiMapStyleFX) {
                    mapCloned.setMapStyle(((StiMapStyleFX)style).getStyleId());
                } else {
                    mapCloned.setComponentStyle(style.getName());
                }
                HashMap<String, Object> content = new HashMap<String, Object>();
                int width = 130;
                int height = 50;
                content.put("image", StiMapHelper.getMapSampleImage(mapCloned, width, height, 1.0f));
                content.put("type", style instanceof StiMapStyleFX ? "StiMapStyleIdent" : "StiMapStyle");
                content.put("name", style instanceof StiMapStyleFX ? mapCloned.getMapStyle().toString() : mapCloned.getComponentStyle());
                content.put("width", width);
                content.put("height", height);
                stylesContent.add(content);
            }
        }
        callbackResult.put("stylesContent", stylesContent);
    }
}

