/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.StiAlignValue;
import com.stimulsoft.base.StiBaseOptions;
import com.stimulsoft.base.StiJsonConverterVersion;
import com.stimulsoft.base.StiValueCollection;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.elements.StiKeyHelper;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiEventObject;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.base.system.type.StiTypeList;
import com.stimulsoft.base.system.type.StiTypeNullable;
import com.stimulsoft.base.system.type.StiTypeRange;
import com.stimulsoft.base.system.type.StiTypeValue;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.base.utils.StiRtfHelper;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.ICloneable;
import com.stimulsoft.report.IStiAlias;
import com.stimulsoft.report.IStiIgnoryStyle;
import com.stimulsoft.report.StiJsonToDataSetConverter;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.helper.StiUsedResourceHelper;
import com.stimulsoft.report.codedom.StiCodeDomExpressionHelper;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiHeaderBand;
import com.stimulsoft.report.components.enums.StiSystemTextType;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiCalcDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumnsCollection;
import com.stimulsoft.report.dictionary.StiDataParameter;
import com.stimulsoft.report.dictionary.StiDataParametersCollection;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDataRelationCollection;
import com.stimulsoft.report.dictionary.StiDataRelationsCollection;
import com.stimulsoft.report.dictionary.StiDatabaseInformation;
import com.stimulsoft.report.dictionary.StiDialogInfoItem;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.StiSystemVariablesHelper;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariablesCollection;
import com.stimulsoft.report.dictionary.adapters.StiAbstractAdapter;
import com.stimulsoft.report.dictionary.adapters.StiJDBCParameters;
import com.stimulsoft.report.dictionary.adapters.StiJdbcAdapter;
import com.stimulsoft.report.dictionary.adapters.StiMsSqlAdapter;
import com.stimulsoft.report.dictionary.adapters.StiMySqlAdapter;
import com.stimulsoft.report.dictionary.adapters.StiOracleAdapter;
import com.stimulsoft.report.dictionary.adapters.StiPostgreSqlAdapter;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObjectsCollection;
import com.stimulsoft.report.dictionary.data.DBNull;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataStoreSource;
import com.stimulsoft.report.dictionary.dataSources.StiOracleSource;
import com.stimulsoft.report.dictionary.dataSources.StiSqlSource;
import com.stimulsoft.report.dictionary.dataSources.StiUserSource;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import com.stimulsoft.report.dictionary.databases.StiJDBCDatabase;
import com.stimulsoft.report.dictionary.databases.StiJsonDatabase;
import com.stimulsoft.report.dictionary.databases.StiXmlDatabase;
import com.stimulsoft.report.dictionary.enums.StiDataType;
import com.stimulsoft.report.dictionary.enums.StiDateTimeType;
import com.stimulsoft.report.dictionary.enums.StiItemsInitializationType;
import com.stimulsoft.report.dictionary.enums.StiResourceType;
import com.stimulsoft.report.dictionary.enums.StiSelectionMode;
import com.stimulsoft.report.dictionary.enums.StiSqlSourceType;
import com.stimulsoft.report.dictionary.enums.StiTypeMode;
import com.stimulsoft.report.dictionary.enums.StiVariableInitBy;
import com.stimulsoft.report.dictionary.enums.StiVariableSortDirection;
import com.stimulsoft.report.dictionary.enums.StiVariableSortField;
import com.stimulsoft.report.dictionary.functions.StiFunction;
import com.stimulsoft.report.dictionary.functions.StiFunctions;
import com.stimulsoft.report.engine.engineV1.builders.StiDataBandV1Builder;
import com.stimulsoft.report.helpers.StiResourceTypeHelper;
import com.stimulsoft.report.json.StiJsonToDataSetConverterV2;
import com.stimulsoft.report.options.DesignerOptions;
import com.stimulsoft.report.options.EngineOptions;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiStyle;
import com.stimulsoft.report.utils.data.StiDataColumnsUtil;
import com.stimulsoft.report.utils.data.StiSqlField;
import com.stimulsoft.report.utils.data.StiTableFieldsRequest;
import com.stimulsoft.report.utils.data.StiXmlTable;
import com.stimulsoft.report.utils.data.StiXmlTableFieldsRequest;
import com.stimulsoft.web.helper.StiEncodingHelper;
import com.stimulsoft.web.helper.StiGalleriesHelper;
import com.stimulsoft.web.helper.StiReportResourceHelper;
import com.stimulsoft.web.utils.StiConnectionType;
import com.stimulsoft.web.utils.StiConstants;
import com.stimulsoft.webdesigner.StiWebDesignerOptions;
import com.stimulsoft.webdesigner.enums.StiImagesID;
import com.stimulsoft.webdesigner.helper.StiFontResourceHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import com.stimulsoft.webdesigner.helper.StiViewDataHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class StiDictionaryHelper {
    private static Logger LOG = Logger.getLogger("com.stimulsoft.webdesigner.helper.StiDictionaryHelper");
    private static final String[] SYSTEM_TYPES = new String[]{"bool", "byte", "byte[]", "char", "datetime", "decimal", "double", "guid", "short", "int", "long", "sbyte", "float", "String", "timespan", "ushort", "uint", "ulong", "image", "bool (Nullable)", "byte (Nullable)", "char (Nullable)", "datetime (Nullable)", "decimal (Nullable)", "double (Nullable)", "guid (Nullable)", "short (Nullable)", "int (Nullable)", "long (Nullable)", "byte (Nullable)", "sbyte (Nullable)", "float (Nullable)", "timespan (Nullable)", "ushort (Nullable)", "uint (Nullable)", "ulong (Nullable)", "object", "refcursor"};

    private static HashMap<String, Object> databaseItem(String name, String nameInSource, String alias, boolean dataInStore) {
        HashMap<String, Object> dataBaseItem = new HashMap<String, Object>();
        dataBaseItem.put("typeItem", "DataBase");
        dataBaseItem.put("typeIcon", dataInStore ? "DataStore" : "ConnectionFail");
        dataBaseItem.put("typeConnection", null);
        dataBaseItem.put("name", name);
        dataBaseItem.put("alias", alias);
        dataBaseItem.put("nameInSource", nameInSource);
        dataBaseItem.put("dataInStore", dataInStore);
        dataBaseItem.put("dataSources", new ArrayList());
        return dataBaseItem;
    }

    private static HashMap<String, Object> resourceItem(StiResource resource, StiReport report) {
        HashMap<String, Object> resourceItem = new HashMap<String, Object>();
        resourceItem.put("typeItem", "Resource");
        resourceItem.put("type", resource.getType());
        resourceItem.put("typeIcon", resource.getContent() != null ? "Resources.Resource" + resource.getType() : "Resources.Resource");
        resourceItem.put("name", resource.getName());
        resourceItem.put("alias", resource.getAlias());
        resourceItem.put("availableInTheViewer", resource.isAvailableInTheViewer());
        return resourceItem;
    }

    private static HashMap<String, Object> imagesGalleryItem(String name, StiSystemTypeEnum type, String source) {
        HashMap<String, Object> galleryItem = new HashMap<String, Object>();
        galleryItem.put("name", name);
        galleryItem.put("type", type.name());
        galleryItem.put("src", source);
        return galleryItem;
    }

    private static HashMap<String, Object> imagesGalleryItem(String name, String type, String source) {
        HashMap<String, Object> galleryItem = new HashMap<String, Object>();
        galleryItem.put("name", name);
        galleryItem.put("type", type);
        galleryItem.put("src", source);
        return galleryItem;
    }

    private static HashMap<String, Object> richTextGalleryItem(String name, Object type, String imageName) {
        HashMap<String, Object> galleryItem = new HashMap<String, Object>();
        galleryItem.put("name", name);
        galleryItem.put("type", type.toString());
        galleryItem.put("imageName", imageName);
        return galleryItem;
    }

    public static void getImagesGallery(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        List variables = StiGalleriesHelper.getImageVariables((StiReport)report);
        ArrayList resultVariables = new ArrayList();
        for (StiVariable stiVariable : variables) {
        }
        List resources = StiGalleriesHelper.getImageResources((StiReport)report);
        ArrayList<HashMap<String, Object>> resultResources = new ArrayList<HashMap<String, Object>>();
        for (StiResource resource : resources) {
            String base64Content = "";
            if (resource.content != null) {
                if (StiImageHelper.isMetafile((byte[])resource.content)) {
                    base64Content = StiReportEdit.getBase64PngFromMetaFileBytes(resource.getContent());
                } else {
                    try {
                        base64Content = StiReportEdit.imageToBase64(resource.getContent());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }
            resultResources.add(StiDictionaryHelper.imagesGalleryItem(resource.getName(), "StiResource", base64Content));
        }
        ArrayList<HashMap<String, Object>> resultColumns = new ArrayList<HashMap<String, Object>>();
        if (DesignerOptions.Editors.allowConnectToDataInGallery) {
            try {
                List columns = StiGalleriesHelper.getImageColumns((StiReport)report);
                ArrayList<StiDataSource> dataSources = new ArrayList<StiDataSource>();
                for (StiDataColumn col : columns) {
                    if (dataSources.contains(col.getDataSource())) continue;
                    dataSources.add(col.getDataSource());
                }
                report.getDictionary().connect(true, dataSources);
                for (StiDataColumn column : columns) {
                    StiImage image = StiGalleriesHelper.getImageFromColumn((StiDataColumn)column, (StiReport)report);
                    if (image == null) continue;
                    resultColumns.add(StiDictionaryHelper.imagesGalleryItem(column.getColumnPath(), "StiDataColumn", StiReportEdit.imageToBase64(image)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Hashtable imagesGallery = new Hashtable();
        imagesGallery.put("variables", resultVariables);
        imagesGallery.put("resources", resultResources);
        imagesGallery.put("columns", resultColumns);
        callbackResult.put("imagesGallery", imagesGallery);
    }

    public static void getRichTextGallery(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        List variables = StiGalleriesHelper.getRichTextVariables((StiReport)report);
        ArrayList<HashMap<String, Object>> resultVariables = new ArrayList<HashMap<String, Object>>();
        for (StiVariable variable : variables) {
            String imageName = "Resources." + (variable.getValueObject() instanceof String && StiRtfHelper.isRtfText((String)((String)variable.getValueObject())) ? "BigResourceRtf" : "BigResourceTxt");
            resultVariables.add(StiDictionaryHelper.richTextGalleryItem(variable.name, variable.getType(), imageName));
        }
        List resources = StiGalleriesHelper.getRichTextResources((StiReport)report);
        ArrayList<HashMap<String, Object>> resultResources = new ArrayList<HashMap<String, Object>>();
        for (StiResource resource : resources) {
            resultResources.add(StiDictionaryHelper.richTextGalleryItem(resource.getName(), resource.getType(), "Resources.BigResource" + resource.type.toString()));
        }
        ArrayList resultColumns = new ArrayList();
        HashMap richTextGallery = new HashMap();
        richTextGallery.put("variables", resultVariables);
        richTextGallery.put("resources", resultResources);
        richTextGallery.put("columns", resultColumns);
        callbackResult.put("richTextGallery", richTextGallery);
    }

    private static HashMap<String, Object> databaseItem(StiDatabase database) {
        HashMap<String, Object> dataBaseItem = StiDictionaryHelper.databaseItem(database.getName(), database.getString(), database.getAlias(), false);
        dataBaseItem.put("typeIcon", "Connection");
        dataBaseItem.put("typeConnection", database.getServiceType().getName().substring(database.getServiceType().getName().lastIndexOf(46) + 1));
        dataBaseItem.put("serviceName", database.getServiceName());
        if (database instanceof StiXmlDatabase) {
            dataBaseItem.put("pathData", StiEncodingHelper.encode((String)((StiXmlDatabase)database).getPathData()));
            dataBaseItem.put("pathSchema", StiEncodingHelper.encode((String)((StiXmlDatabase)database).getPathSchema()));
            dataBaseItem.put("xmlType", "AdoNetXml");
            dataBaseItem.put("embeddedData", ((StiXmlDatabase)database).getEmbeddedData() != null);
        } else if (database instanceof StiJsonDatabase) {
            String pathData = ((StiJsonDatabase)database).getPathData();
            if (pathData != null) {
                dataBaseItem.put("pathData", StiEncodingHelper.encode((String)pathData));
            }
            dataBaseItem.put("embeddedData", ((StiJsonDatabase)database).getEmbeddedData() != null);
        } else {
            try {
                String connectionString = (String)database.getClass().getMethod("getConnectionString", new Class[0]).invoke((Object)database, new Object[0]);
                dataBaseItem.put("connectionString", connectionString != null ? StiEncodingHelper.encode((String)connectionString) : "");
                Boolean promptUserNameAndPassword = (Boolean)database.getClass().getMethod("getPromptUserNameAndPassword", new Class[0]).invoke((Object)database, new Object[0]);
                dataBaseItem.put("promptUserNameAndPassword", promptUserNameAndPassword != null ? promptUserNameAndPassword : false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dataBaseItem;
    }

    private static HashMap<String, Object> datasourceItem(StiDataSource datasource) {
        HashMap<String, Object> datasourceItem;
        block7: {
            Method method;
            block6: {
                String typeIcon = "DataSource";
                if (datasource.getInherited()) {
                    typeIcon = "LockedDataSource";
                }
                datasourceItem = new HashMap<String, Object>();
                datasourceItem.put("typeItem", "DataSource");
                datasourceItem.put("typeIcon", typeIcon);
                datasourceItem.put("isCloud", false);
                datasourceItem.put("typeDataSource", datasource.getClass().getName().substring(datasource.getClass().getName().lastIndexOf(46) + 1));
                datasourceItem.put("typeDataAdapter", datasource.getClass().getName().substring(datasource.getClass().getName().lastIndexOf(46) + 1));
                datasourceItem.put("name", datasource.getName());
                datasourceItem.put("correctName", StiNameValidator.CorrectName((String)datasource.getName()));
                datasourceItem.put("nameInSource", ((StiDataStoreSource)datasource).getNameInSource());
                datasourceItem.put("alias", datasource.getAlias());
                datasourceItem.put("relations", StiDictionaryHelper.getRelationsTree(null, datasource.GetParentRelations(), false, new HashMap<String, Object>()));
                datasourceItem.put("parameters", StiDictionaryHelper.getParametersTree(datasource.getParameters(), false));
                datasourceItem.put("columns", StiDictionaryHelper.getColumnsTree(datasource.getColumns(), false));
                if (datasource instanceof StiSqlSource) {
                    datasourceItem.put("parameterTypes", StiDictionaryHelper.getDataParameterTypes((StiSqlSource)datasource));
                    datasourceItem.put("reconnectOnEachRow", false);
                    datasourceItem.put("commandTimeout", String.valueOf(((StiSqlSource)datasource).getCommandTimeout()));
                }
                try {
                    method = datasource.getClass().getMethod("getSqlCommand", new Class[0]);
                    datasourceItem.put("sqlCommand", StiEncodingHelper.encode((String)((String)method.invoke((Object)datasource, new Object[0]))));
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block6;
                    e.printStackTrace();
                }
            }
            try {
                method = datasource.getClass().getMethod("getType", new Class[0]);
                datasourceItem.put("type", ((StiSqlSourceType)method.invoke((Object)datasource, new Object[0])).toString());
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block7;
                e.printStackTrace();
            }
        }
        return datasourceItem;
    }

    private static HashMap<String, Object> columnItem(StiDataColumn column) {
        HashMap<String, Object> columnItem = new HashMap<String, Object>();
        columnItem.put("typeItem", "Parameters".equals(column.getCaption()) ? "Parameter" : "Column");
        columnItem.put("typeIcon", "Parameters".equals(column.getCaption()) ? "Parameter" : StiDictionaryHelper.getDataColumnImageIdFromType(column.getSystemType(), true).toString());
        columnItem.put("type", StiDictionaryHelper.getTypeValueToString(column.getSystemType()));
        columnItem.put("name", column.getName());
        columnItem.put("correctName", StiNameValidator.CorrectName((String)column.getName()));
        columnItem.put("alias", column.getAlias());
        columnItem.put("nameInSource", column.getNameInSource());
        columnItem.put("isCalcColumn", column instanceof StiCalcDataColumn);
        columnItem.put("expression", column instanceof StiCalcDataColumn ? StiEncodingHelper.encode((String)((StiCalcDataColumn)column).getExpression()) : "");
        return columnItem;
    }

    private static HashMap<String, Object> ParameterItem(StiDataParameter parameter) {
        HashMap<String, Object> parameterItem = new HashMap<String, Object>();
        parameterItem.put("typeItem", "Parameter");
        parameterItem.put("typeIcon", "Parameter");
        parameterItem.put("type", parameter.getType());
        parameterItem.put("size", parameter.getSize());
        parameterItem.put("name", parameter.getName());
        parameterItem.put("correctName", StiNameValidator.CorrectName((String)parameter.getName()));
        parameterItem.put("expression", StiEncodingHelper.encode((String)parameter.getExpression()));
        return parameterItem;
    }

    private static HashMap<String, Object> columnItem2(StiSqlField column) {
        HashMap<String, Object> columnItem = new HashMap<String, Object>();
        columnItem.put("typeItem", "Column");
        columnItem.put("typeIcon", StiDictionaryHelper.getIconTypeForColumn(column.getSystemType()).toString());
        columnItem.put("type", StiDictionaryHelper.getTypeValueToString(column.getSystemType()));
        columnItem.put("name", column.getName());
        columnItem.put("correctName", StiNameValidator.CorrectName((String)column.getName()));
        columnItem.put("alias", column.getName());
        columnItem.put("nameInSource", column.getName());
        columnItem.put("isCalcColumn", false);
        columnItem.put("expression", "");
        return columnItem;
    }

    private static HashMap<String, Object> relationItem(StiDataRelation relation, HashMap<String, Object> upLevelRelations) {
        HashMap<String, Object> relationItem = new HashMap<String, Object>();
        relationItem.put("typeItem", "Relation");
        relationItem.put("typeIcon", relation.getInherited() ? "LockedRelation" : "Relation");
        relationItem.put("name", relation.getName());
        relationItem.put("correctName", StiNameValidator.CorrectName((String)relation.getName()));
        relationItem.put("alias", relation.getAlias());
        relationItem.put("nameInSource", relation.getNameInSource());
        relationItem.put("active", relation.isActive());
        relationItem.put("parentDataSource", relation.getParentSource() != null ? relation.getParentSource().getName() : "");
        relationItem.put("childDataSource", relation.getChildSource() != null ? relation.getChildSource().getName() : "");
        ArrayList<String> jsParentColumns = new ArrayList<String>();
        for (String parentColumns : relation.getParentColumns()) {
            jsParentColumns.add(parentColumns);
        }
        relationItem.put("parentColumns", jsParentColumns);
        ArrayList<String> jsChildColumns = new ArrayList<String>();
        for (String childColumns : relation.getChildColumns()) {
            jsChildColumns.add(childColumns);
        }
        relationItem.put("childColumns", jsChildColumns);
        upLevelRelations.put(relation.getNameInSource(), true);
        relationItem.put("relations", relation.getParentSource() != null ? StiDictionaryHelper.getRelationsTree(relation, relation.getParentSource().GetParentRelations(), false, upLevelRelations) : new ArrayList());
        upLevelRelations.remove(relation.getNameInSource());
        return relationItem;
    }

    private static HashMap<String, Object> businessObjectItem(StiBusinessObject businessObject) {
        HashMap<String, Object> businessObjectItem = new HashMap<String, Object>();
        businessObjectItem.put("typeItem", "BusinessObject");
        businessObjectItem.put("typeIcon", "BusinessObject");
        businessObjectItem.put("category", businessObject.getCategory());
        businessObjectItem.put("name", businessObject.getName());
        businessObjectItem.put("correctName", StiNameValidator.CorrectName((String)businessObject.getName()));
        businessObjectItem.put("alias", businessObject.getAlias());
        businessObjectItem.put("columns", StiDictionaryHelper.getColumnsTree(businessObject.getColumns()));
        businessObjectItem.put("businessObjects", StiDictionaryHelper.getChildBusinessObjectsTree(businessObject));
        businessObjectItem.put("fullName", businessObject.GetFullName());
        return businessObjectItem;
    }

    private static HashMap<String, Object> variableItem(StiVariable variable) {
        HashMap<String, Object> variableItem = new HashMap<String, Object>();
        variableItem.put("typeItem", "Variable");
        variableItem.put("typeIcon", StiDictionaryHelper.getDataColumnImageIdFromType(variable.getSystemType(), !variable.getInherited()).toString());
        variableItem.put("basicType", StiDictionaryHelper.getVariableBasicType(variable));
        variableItem.put("type", StiDictionaryHelper.getVariableType(variable));
        variableItem.put("name", variable.getName());
        variableItem.put("correctName", StiNameValidator.CorrectName((String)variable.getName()));
        variableItem.put("alias", variable.getAlias());
        variableItem.put("category", variable.getCategory());
        variableItem.put("description", StiEncodingHelper.encode((String)variable.getDescription()));
        variableItem.put("initBy", variable.getInitBy());
        variableItem.put("readOnly", variable.getReadOnly());
        variableItem.put("allowUseAsSqlParameter", variable.isAllowUseAsSqlParameter());
        variableItem.put("requestFromUser", variable.getRequestFromUser());
        variableItem.put("allowUserValues", variable.getDialogInfo().getAllowUserValues());
        variableItem.put("dateTimeFormat", variable.getDialogInfo().getDateTimeType());
        variableItem.put("sortDirection", variable.getDialogInfo().getSortDirection());
        variableItem.put("sortField", variable.getDialogInfo().getSortField());
        variableItem.put("dataSource", variable.getDialogInfo().getItemsInitializationType());
        variableItem.put("selection", variable.getSelection().toString());
        variableItem.put("formatMask", StiEncodingHelper.encode((String)variable.getDialogInfo().getMask()));
        variableItem.put("items", StiDictionaryHelper.getItems(variable, (String)variableItem.get("type")));
        variableItem.put("keys", variable.getDialogInfo().getKeysColumn());
        variableItem.put("values", variable.getDialogInfo().getValuesColumn());
        variableItem.put("dependentValue", variable.getDialogInfo().isBindingValue());
        variableItem.put("dependentVariable", variable.getDialogInfo().getBindingVariable() != null ? variable.getDialogInfo().getBindingVariable().getName() : "");
        variableItem.put("dependentColumn", variable.getDialogInfo().getBindingValuesColumn());
        if ("Value".equals(variableItem.get("basicType")) || "NullableValue".equals(variableItem.get("basicType"))) {
            if (variable.getInitBy() == StiVariableInitBy.Value) {
                if ("image".equals(variableItem.get("type"))) {
                    variableItem.put("value", variable.getValueObject() != null ? StiReportEdit.imageToBase64(variable.getValueObject().toString()) : null);
                } else {
                    String valueString;
                    String string = valueString = variable.getValue() != null ? variable.getValue() : "";
                    if (variable.getValueObject() != null && "datetime".equals(variableItem.get("type"))) {
                        valueString = ((StiDateTime)variable.getValueObject()).format("MM/dd/yyyy hh:mm:ss a");
                    }
                    variableItem.put("value", StiEncodingHelper.encode((String)valueString));
                }
            } else {
                variableItem.put("expression", StiEncodingHelper.encode((String)variable.getValue()));
            }
        } else if ("Range".equals(variableItem.get("basicType"))) {
            if (variable.getInitBy() == StiVariableInitBy.Value) {
                Object fromObject = ((Range)variable.getValueObject()).getFromObject();
                Object toObject = ((Range)variable.getValueObject()).getToObject();
                String fromObjectString = "";
                String toObjectString = "";
                if (fromObject != null) {
                    String string = fromObjectString = "datetime".equals(variableItem.get("type")) ? ((StiDateTime)fromObject).formatEnDateTime() : fromObject.toString();
                }
                if (toObject != null) {
                    toObjectString = "datetime".equals(variableItem.get("type")) ? ((StiDateTime)toObject).formatEnDateTime() : toObject.toString();
                }
                variableItem.put("valueFrom", StiEncodingHelper.encode((String)fromObjectString));
                variableItem.put("valueTo", StiEncodingHelper.encode((String)toObjectString));
            } else {
                variableItem.put("expressionFrom", StiEncodingHelper.encode((String)variable.getInitByExpressionFrom()));
                variableItem.put("expressionTo", StiEncodingHelper.encode((String)variable.getInitByExpressionTo()));
            }
        }
        return variableItem;
    }

    private static HashMap<String, Object> tableItem(DataTable table) {
        HashMap<String, Object> tableItem = new HashMap<String, Object>();
        tableItem.put("typeItem", "Table");
        tableItem.put("name", table.getTableName());
        tableItem.put("correctName", StiNameValidator.CorrectName((String)table.getTableName()));
        tableItem.put("columns", StiDictionaryHelper.getColumnsTree2(table.getColumns()));
        tableItem.put("query", table.getQuery());
        return tableItem;
    }

    private static HashMap<String, Object> functionItem(StiFunction function, StiReport report) {
        HashMap<String, Object> functionItem = new HashMap<String, Object>();
        functionItem.put("typeItem", "Function");
        functionItem.put("typeIcon", "Function");
        functionItem.put("name", function.getFunctionName());
        functionItem.put("caption", function.getFunctionString(report.getScriptLanguage()));
        functionItem.put("descriptionHeader", function.GetLongFunctionString(report.getScriptLanguage()));
        functionItem.put("description", function.getDescription());
        functionItem.put("returnDescription", function.getReturnDescription());
        ArrayList<String> argumentDescriptions = new ArrayList<String>();
        for (String argumentDescription : function.getArgumentDescriptions()) {
            argumentDescriptions.add(argumentDescription);
        }
        functionItem.put("argumentDescriptions", argumentDescriptions);
        ArrayList<String> argumentNames = new ArrayList<String>();
        for (String argumentName : function.getArgumentNames()) {
            argumentNames.add(argumentName);
        }
        functionItem.put("argumentNames", argumentNames);
        functionItem.put("text", String.format("%s(%s)", function.getFunctionName(), function.getArgumentNames() == null || function.getArgumentNames().length == 0 ? "" : StiDictionaryHelper.repeatString(",", function.getArgumentNames().length - 1)));
        return functionItem;
    }

    private static String repeatString(String st, int length) {
        String result = "";
        for (int i = 0; i < length; ++i) {
            result = result + st;
        }
        return result;
    }

    private static HashMap<String, Object> functionsCategoryItem(String name, String typeIcon) {
        HashMap<String, Object> categoryItem = new HashMap<String, Object>();
        categoryItem.put("typeItem", "FunctionsCategory");
        categoryItem.put("typeIcon", typeIcon);
        categoryItem.put("name", name);
        categoryItem.put("items", new ArrayList());
        return categoryItem;
    }

    private static ArrayList<HashMap<String, Object>> getDataParameterTypes(StiSqlSource source) {
        ArrayList<HashMap<String, Object>> types = new ArrayList<HashMap<String, Object>>();
        int i = 0;
        for (String type : SYSTEM_TYPES) {
            HashMap<String, Object> typeObject = new HashMap<String, Object>();
            typeObject.put("typeValue", i++);
            typeObject.put("typeName", type);
            types.add(typeObject);
        }
        if (source instanceof StiOracleSource) {
            HashMap<String, Object> typeObject = new HashMap<String, Object>();
            typeObject.put("typeValue", i++);
            typeObject.put("typeName", "RefCursor");
            types.add(typeObject);
        }
        return types;
    }

    private static String getItemType(StiDialogInfoItem itemVariable) {
        if (itemVariable instanceof StiDialogInfoItem.StiExpressionDialogInfoItem || itemVariable instanceof StiDialogInfoItem.StiExpressionRangeDialogInfoItem) {
            return "expression";
        }
        return "value";
    }

    private static Object getItemKeyObject(Object itemKey, String type, String itemType) {
        String keyObject = null;
        if (itemKey != null) {
            keyObject = StiEncodingHelper.encode((String)("datetime".equalsIgnoreCase(type) && "value".equalsIgnoreCase(itemType) ? ((StiDateTime)itemKey).formatEnDateTime() : itemKey.toString()));
        }
        return keyObject;
    }

    private static Object getItems(StiVariable variable, String type) {
        ArrayList items = new ArrayList();
        int index = 0;
        if (variable.getDialogInfo().getKeys() != null && variable.getDialogInfo().getKeys().size() != 0) {
            List itemsVariable = variable.getDialogInfo().getDialogInfoItems(variable.getType());
            for (StiDialogInfoItem itemVariable : itemsVariable) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                String itemType = StiDictionaryHelper.getItemType(itemVariable);
                item.put("type", itemType);
                item.put("value", StiEncodingHelper.encode((String)itemVariable.getValue()));
                try {
                    new JSONObject((Object)itemVariable.ValueBinding).toString();
                    item.put("valueBinding", itemVariable.ValueBinding);
                }
                catch (Exception e) {
                    item.put("valueBinding", itemVariable.ValueBinding != null ? itemVariable.ValueBinding.toString() : null);
                }
                item.put("key", StiDictionaryHelper.getItemKeyObject(itemVariable.getKey(), type, itemType));
                item.put("keyTo", StiDictionaryHelper.getItemKeyObject(itemVariable.getTo(), type, itemType));
                items.add(item);
                ++index;
            }
        }
        return index != 0 ? items : null;
    }

    private static StiDatabase createDataBaseByTypeName(String typeDatabase, StiWebDesignerOptions options) throws InstantiationException, IllegalAccessException {
        for (Class<? extends StiDatabase> class_ : options.getConnectionTypes()) {
            if (!typeDatabase.equals(class_.getName().substring(class_.getName().lastIndexOf(46) + 1)) && !typeDatabase.equals(class_.getName())) continue;
            return class_.newInstance();
        }
        return null;
    }

    private static StiDataSource createDataAdapterByTypeName(String typeDataAdapter, StiWebDesignerOptions options, StiDictionary dictionary, String nameInSource) throws InstantiationException, IllegalAccessException {
        if (("StiDataTableSource".equals(typeDataAdapter = typeDataAdapter.replace("AdapterService", "Source")) || "StiSqlSource".equals(typeDataAdapter)) && dictionary != null && nameInSource != null) {
            if (nameInSource.indexOf(46) >= 0) {
                nameInSource = nameInSource.substring(0, nameInSource.indexOf(46));
            }
            for (StiDatabase source : dictionary.getDatabases()) {
                if (!source.getName().equalsIgnoreCase(nameInSource)) continue;
                typeDataAdapter = source.getClass().getName();
                typeDataAdapter = typeDataAdapter.substring(typeDataAdapter.lastIndexOf(46) + 1).replace("Database", "") + "Source";
            }
        }
        for (Class<? extends StiDataSource> class_ : options.getDataSources()) {
            if (!typeDataAdapter.equalsIgnoreCase(class_.getName().substring(class_.getName().lastIndexOf(46) + 1))) continue;
            return class_.newInstance();
        }
        return null;
    }

    private static void copyProperties(String[] propertyNames, HashMap<String, Object> fromObject, HashMap<String, Object> toObject) throws JSONException {
        for (String propName : propertyNames) {
            toObject.put(propName, fromObject.get(propName));
        }
    }

    public static StiDataColumnsCollection getColumnsByTypeAndNameOfObject(StiReport report, HashMap<String, Object> props) {
        String currentParentType = (String)props.get("currentParentType");
        StiDataSource resultObject = null;
        if ("DataSource".equals(currentParentType) && (resultObject = report.getDictionary().getDataSources().get((String)props.get("currentParentName"))) != null) {
            return resultObject.getColumns();
        }
        if ("BusinessObject".equals(currentParentType)) {
            resultObject = StiDictionaryHelper.getBusinessObjectByFullName(report, props.get("currentParentName"));
            return ((StiBusinessObject)resultObject).getColumns();
        }
        return null;
    }

    private static HashMap<String, Object> getDatabaseByName(String name, ArrayList<HashMap<String, Object>> databasesTree) {
        for (HashMap<String, Object> database : databasesTree) {
            if (!((String)database.get("name")).toLowerCase().equals(name.toLowerCase())) continue;
            return database;
        }
        return null;
    }

    private static void updateColumns(StiDataColumnsCollection columns, ArrayList<HashMap<String, Object>> columnsSource) throws JSONException {
        columns.clear();
        for (int i = 0; i < columnsSource.size(); ++i) {
            HashMap<String, Object> columnProps = columnsSource.get(i);
            Object column = (Boolean)columnProps.get("isCalcColumn") != false ? new StiCalcDataColumn() : new StiDataColumn();
            columns.add((StiDataColumn)column);
            StiDictionaryHelper.applyColumnProps((StiDataColumn)column, columnProps);
        }
    }

    private static void updateParameters(StiDataParametersCollection parameters, ArrayList<HashMap<String, Object>> parametersSource) throws JSONException {
        parameters.clear();
        for (int i = 0; i < parametersSource.size(); ++i) {
            HashMap<String, Object> parametersProps = parametersSource.get(i);
            StiDataParameter parameter = new StiDataParameter();
            parameters.add((Object)parameter);
            StiDictionaryHelper.applyParameterProps(parameter, parametersProps);
        }
    }

    private static String getVariableBasicType(StiVariable variable) {
        if (variable.getSystemType().isNullable()) {
            return "NullableValue";
        }
        if (variable.getSystemType().isList()) {
            return "List";
        }
        if (variable.getSystemType().isRange()) {
            return "Range";
        }
        return "Value";
    }

    private static String getVariableType(StiVariable variable) {
        if (variable.getType() == StiSystemTypeEnum.SystemString) {
            return "String";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemChar) {
            return "char";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemBoolean) {
            return "bool";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemDateTime) {
            return "datetime";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemTimeSpan) {
            return "timespan";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemGuid) {
            return "guid";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemDrawingImage) {
            return "image";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemFloat) {
            return "float";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemDouble) {
            return "double";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemDecimal) {
            return "decimal";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemInt32) {
            return "int";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemUInt32) {
            return "uint";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemInt16) {
            return "short";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemUInt16) {
            return "ushort";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemInt64) {
            return "long";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemUInt64) {
            return "ulong";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemByte) {
            return "byte";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemSByte) {
            return "sbyte";
        }
        return "Object";
    }

    private static Object getValueByType(String StringValue, String typeVariable, String basicType, boolean canReturnNull) {
        String decimalSeparator = ".";
        if ("String".equalsIgnoreCase(typeVariable)) {
            return StringValue;
        }
        if ("".equalsIgnoreCase(StringValue) && "NullableValue".equalsIgnoreCase(basicType) && canReturnNull) {
            return null;
        }
        if ("float".equalsIgnoreCase(typeVariable)) {
            float value;
            block43: {
                value = 0.0f;
                try {
                    value = Float.parseFloat(StringValue.replace(".", ",").replace(",", decimalSeparator));
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block43;
                    e.printStackTrace();
                }
            }
            return Float.valueOf(value);
        }
        if ("double".equalsIgnoreCase(typeVariable)) {
            double value;
            block44: {
                value = 0.0;
                try {
                    value = Double.parseDouble(StringValue.replace(".", ",").replace(",", decimalSeparator));
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block44;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("decimal".equalsIgnoreCase(typeVariable)) {
            double value;
            block45: {
                value = 0.0;
                try {
                    value = Double.parseDouble(StringValue.replace(".", ",").replace(",", decimalSeparator));
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block45;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("int".equalsIgnoreCase(typeVariable) || "uint".equalsIgnoreCase(typeVariable)) {
            int value;
            block46: {
                value = 0;
                try {
                    value = Integer.parseInt(StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block46;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("short".equalsIgnoreCase(typeVariable) || "ushort".equalsIgnoreCase(typeVariable)) {
            short value;
            block47: {
                value = 0;
                try {
                    value = Short.parseShort(StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block47;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("long".equalsIgnoreCase(typeVariable) || "ulong".equalsIgnoreCase(typeVariable)) {
            long value;
            block48: {
                value = 0L;
                try {
                    value = Long.parseLong(StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block48;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("byte".equalsIgnoreCase(typeVariable) || "sbyte".equalsIgnoreCase(typeVariable)) {
            byte value;
            block49: {
                value = 0;
                try {
                    value = Byte.parseByte(StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block49;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("char".equalsIgnoreCase(typeVariable)) {
            char value;
            block50: {
                value = ' ';
                try {
                    value = StringValue.charAt(0);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block50;
                    e.printStackTrace();
                }
            }
            return Character.valueOf(value);
        }
        if ("bool".equalsIgnoreCase(typeVariable)) {
            boolean value;
            block51: {
                value = false;
                try {
                    value = Boolean.parseBoolean(StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block51;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("datetime".equalsIgnoreCase(typeVariable)) {
            StiDateTime value;
            block52: {
                if ("".equalsIgnoreCase(StringValue) && canReturnNull) {
                    return null;
                }
                value = StiDateTime.currentDate();
                try {
                    value = StiDateTime.fromString((String)StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block52;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("timespan".equalsIgnoreCase(typeVariable)) {
            StiTimeSpan value;
            block53: {
                if ("".equalsIgnoreCase(StringValue) && canReturnNull) {
                    return null;
                }
                value = StiTimeSpan.ZERO;
                try {
                    value = StiTimeSpan.valueOf((String)StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block53;
                    e.printStackTrace();
                }
            }
            return value;
        }
        if ("guid".equalsIgnoreCase(typeVariable)) {
            StiGuid variableGuid;
            block54: {
                if ("".equalsIgnoreCase(StringValue) && "NullableValue".equalsIgnoreCase(basicType) && canReturnNull) {
                    return null;
                }
                variableGuid = StiGuid.EMPTY;
                try {
                    variableGuid = new StiGuid(StringValue);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block54;
                    e.printStackTrace();
                }
            }
            return variableGuid;
        }
        if ("Object".equalsIgnoreCase(typeVariable)) {
            if ("".equalsIgnoreCase(StringValue) && canReturnNull) {
                return null;
            }
            return StringValue;
        }
        return null;
    }

    private static void setDialogInfoItems(StiVariable variable, Object itemsObject, String type, String basicType) throws JSONException {
        if (itemsObject == null) {
            variable.getDialogInfo().setKeys(new ArrayList());
            variable.getDialogInfo().setValues(new ArrayList());
            return;
        }
        ArrayList items = itemsObject != null ? (ArrayList)itemsObject : new ArrayList();
        String[] keys = new String[items.size()];
        String[] values = new String[items.size()];
        for (int index = 0; index < items.size(); ++index) {
            Object keyObject;
            HashMap item;
            block8: {
                item = (HashMap)items.get(index);
                keyObject = null;
                String itemType = (String)item.get("type");
                String key = item.get("key") != null ? StiEncodingHelper.decodeString((String)((String)item.get("key"))) : "";
                String keyTo = item.get("keyTo") != null ? StiEncodingHelper.decodeString((String)((String)item.get("keyTo"))) : "";
                String value = item.get("value") != null ? StiEncodingHelper.decodeString((String)((String)item.get("value"))) : "";
                try {
                    if ("expression".equals(itemType)) {
                        keyObject = !"Range".equals(basicType) ? String.format("{{%s}}", key) : String.format("{{%s<<|>>%s}}", key, keyTo);
                    } else if (!"Range".equals(basicType)) {
                        Object obj;
                        keyObject = !"datetime".equals(type) ? ((obj = StiDictionaryHelper.getValueByType(key, type, basicType, false)) != null ? obj.toString() : "") : key;
                    } else {
                        Range range = (Range)Class.forName("com.stimulsoft.base.range." + variable.getSystemType().getSerializeValue().replace("System.", "") + "Range").newInstance();
                        range.setFromObject(StiDictionaryHelper.getValueByType(key, type, basicType, false));
                        range.setToObject(StiDictionaryHelper.getValueByType(keyTo, type, basicType, false));
                        keyObject = String.format("%s,%s,%s", variable.getSystemType().getSerializeValue().replace("System.", ""), range.getFromObject(), range.getToObject());
                    }
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block8;
                    e.printStackTrace();
                }
            }
            keys[index] = keyObject == null ? "" : keyObject.toString();
            values[index] = StiEncodingHelper.decodeString((String)((String)item.get("value")));
        }
        variable.getDialogInfo().setKeys(Arrays.asList(keys));
        variable.getDialogInfo().setValues(Arrays.asList(values));
    }

    public static StiBusinessObject getBusinessObjectByFullName(StiReport report, Object fullName) {
        StiBusinessObjectsCollection businessObjectsCollection = report.getDictionary().getBusinessObjects();
        StiBusinessObject businessObject = null;
        if (fullName != null && ((ArrayList)fullName).size() != 0) {
            ArrayList fullNameArray = (ArrayList)fullName;
            for (int i = fullNameArray.size() - 1; i >= 0; --i) {
                businessObject = businessObjectsCollection.getItem((String)fullNameArray.get(i));
                if (businessObject == null) {
                    return null;
                }
                businessObjectsCollection = businessObject.getBusinessObjects();
            }
        }
        return businessObject;
    }

    private static HashMap<String, Object> getAjaxDataFromDatabaseInformation(StiDatabaseInformation information) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        List[] collections = new List[]{information.getTables(), information.getViews(), information.getStoredProcedures()};
        String[] types = new String[]{"Table", "View", "StoredProcedure"};
        for (int i = 0; i < collections.length; ++i) {
            ArrayList<HashMap<String, Object>> tables = new ArrayList<HashMap<String, Object>>();
            for (DataTable table : collections[i]) {
                HashMap<String, Object> item = StiDictionaryHelper.tableItem(table);
                item.put("typeItem", types[i]);
                tables.add(item);
            }
            if (tables.size() <= 0) continue;
            data.put(types[i] + "s", tables);
        }
        return data;
    }

    private static StiDatabaseInformation convertAjaxDatabaseInfoToDatabaseInfo(ArrayList<HashMap<String, Object>> data, boolean allInfo) throws JSONException {
        StiDatabaseInformation information = new StiDatabaseInformation();
        for (int i = 0; i < data.size(); ++i) {
            HashMap<String, Object> tableObject = data.get(i);
            DataTable dataTable = new DataTable((String)tableObject.get("name"), (String)tableObject.get("query"));
            ArrayList columns = allInfo ? (ArrayList)tableObject.get("allColumns") : (ArrayList)tableObject.get("columns");
            for (int j = 0; j < columns.size(); ++j) {
                HashMap columnObject = (HashMap)columns.get(j);
                StiDataColumn dataColumn = new StiDataColumn((String)columnObject.get("name"), (String)columnObject.get("name"), StiDictionaryHelper.getTypeFromString((String)columnObject.get("type"), "value"));
                dataTable.getColumns().add(dataColumn);
                if (!"StoredProcedure".equals(tableObject.get("typeItem"))) continue;
                dataColumn.setCaption("Parameter".equals(columnObject.get("typeItem")) ? "Parameters" : "Columns");
            }
            if (tableObject.containsKey("query")) {
                // empty if block
            }
            if ("Table".equals(tableObject.get("typeItem"))) {
                information.getTables().add(dataTable);
                Collections.sort(information.getTables(), new StiSortDataTableComparer());
            } else if ("View".equals(tableObject.get("typeItem"))) {
                information.getViews().add(dataTable);
                Collections.sort(information.getViews(), new StiSortDataTableComparer());
            }
            if (!"StoredProcedure".equals(tableObject.get("typeItem"))) continue;
            information.getStoredProcedures().add(dataTable);
            Collections.sort(information.getStoredProcedures(), new StiSortDataTableComparer());
        }
        return information;
    }

    private static void applyDataSourceProps(StiDataSource dataSource, HashMap<String, Object> dataSourceProps) throws JSONException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String[] props;
        for (String propName : props = new String[]{"name", "nameInSource", "alias", "sqlCommand", "type", "reconnectOnEachRow", "commandTimeout"}) {
            Method property;
            block3: {
                String propNameUpper = propName.substring(0, 1).toUpperCase() + propName.substring(1);
                property = null;
                try {
                    Class[] classArray = new Class[1];
                    classArray[0] = !"type".equals(propName) ? (!"commandTimeout".equals(propName) ? String.class : Integer.TYPE) : StiSqlSourceType.class;
                    property = dataSource.getClass().getMethod("set" + propNameUpper, classArray);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block3;
                    e.printStackTrace();
                }
            }
            if (property == null || !dataSourceProps.containsKey(propName)) continue;
            Object p = "type".equals(propName) ? StiSqlSourceType.valueOf((String)((String)dataSourceProps.get(propName))) : ("sqlCommand".equals(propName) ? StiEncodingHelper.decodeString((String)((String)dataSourceProps.get(propName))) : ("reconnectOnEachRow".equals(propName) ? dataSourceProps.get(propName) : ("commandTimeout".equals(propName) ? Integer.valueOf(StiReportEdit.strToInt(dataSourceProps.get(propName))) : dataSourceProps.get(propName))));
            property.invoke((Object)dataSource, p);
        }
    }

    private static void applyDataSourceProperties(StiDataSource dataSource, HashMap dataSourceProps, StiReport report) throws JSONException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String[] props;
        for (String propName : props = new String[]{"name", "alias", "nameInSource", "sqlCommand", "type", "reconnectOnEachRow", "commandTimeout"}) {
            Method property;
            block3: {
                String propNameUpper = propName.substring(0, 1).toUpperCase() + propName.substring(1);
                property = null;
                try {
                    property = dataSource.getClass().getMethod("set" + propNameUpper, !"Type".equals(propName) ? String.class : StiSqlSourceType.class);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block3;
                    e.printStackTrace();
                }
            }
            if (property == null || !dataSourceProps.containsKey(propName)) continue;
            Object p = "type".equals(propName) ? StiSqlSourceType.valueOf((String)((String)dataSourceProps.get(propName))) : ("sqlCommand".equals(propName) ? StiEncodingHelper.decodeString((String)((String)dataSourceProps.get(propName))) : ("reconnectOnEachRow".equals(propName) ? (Comparable<Boolean>)Boolean.valueOf(Boolean.parseBoolean(dataSourceProps.get(propName).toString())) : (Comparable<Boolean>)("commandTimeout".equals(propName) ? Integer.valueOf(StiReportEdit.strToInt(dataSourceProps.get(propName).toString())) : dataSourceProps.get(propName))));
            property.invoke((Object)dataSource, p);
        }
    }

    private static String fixName(StiDatabase database, StiDictionary dictionary, String name) {
        Boolean res = true;
        while (res.booleanValue()) {
            res = false;
            for (StiDatabase db : dictionary.getDatabases()) {
                if (db == database || !db.getName().equals(name)) continue;
                res = true;
                name = name + "_";
            }
        }
        return name;
    }

    private static void applyConnectionProps(StiDatabase database, HashMap<String, Object> connectionProps, StiDictionary dictionary) {
        String[] props;
        for (String propName : props = new String[]{"name", "alias", "connectionString", "pathData", "pathSchema", "promptUserNameAndPassword"}) {
            String propNameUpper = propName.substring(0, 1).toUpperCase() + propName.substring(1);
            try {
                Method method = database.getClass().getMethod("set" + propNameUpper, !propName.equals("promptUserNameAndPassword") ? String.class : Boolean.class);
                if (method == null || !connectionProps.containsKey(propName)) continue;
                Object p = null;
                if ("connectionString".equals(propName) || "pathData".equals(propName) || "pathSchema".equals(propName)) {
                    p = StiEncodingHelper.decodeString((String)((String)connectionProps.get(propName)));
                } else if ("promptUserNameAndPassword".equals(propName) || "firstRowIsHeader".equals(propName)) {
                    p = connectionProps.get(propName);
                } else if (!"embeddedData".equals(propName)) {
                    p = connectionProps.get(propName);
                }
                if ("name".equals(propName)) {
                    p = StiDictionaryHelper.fixName(database, dictionary, (String)p);
                }
                method.invoke((Object)database, p);
            }
            catch (NoSuchMethodException e) {
                if (StiOptions.Engine.logLevel < 20) continue;
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static void applyColumnProps(StiDataColumn column, HashMap<String, Object> columnProps) {
        column.setAlias((String)columnProps.get("alias"));
        column.setName((String)columnProps.get("name"));
        column.setNameInSource((String)columnProps.get("nameInSource"));
        column.setSystemType(StiDictionaryHelper.getTypeFromString((String)columnProps.get("type"), "value"));
        if (column instanceof StiCalcDataColumn) {
            ((StiCalcDataColumn)column).setExpression(StiEncodingHelper.decodeString((String)((String)columnProps.get("expression"))));
        }
    }

    private static void applyParameterProps(StiDataParameter parameter, HashMap<String, Object> parameterProps) throws JSONException {
        parameter.setName((String)parameterProps.get("name"));
        parameter.setType(StiReportEdit.strToInt(parameterProps.get("type")));
        parameter.setSize(StiReportEdit.strToInt(parameterProps.get("size")));
        parameter.setExpression(StiEncodingHelper.decodeString((String)((String)parameterProps.get("expression"))));
    }

    private static void applyRelationProps(StiReport report, StiDataRelation relation, HashMap<String, Object> relationProps) throws JSONException {
        boolean isRelationActive = relation.isActive();
        relation.setAlias((String)relationProps.get("alias"));
        relation.setActive(Func.Convert.toBoolean((Object)relationProps.get("active")));
        relation.setName((String)relationProps.get("name"));
        relation.setNameInSource((String)relationProps.get("nameInSource"));
        relation.setParentSource(report.getDictionary().getDataSources().get((String)relationProps.get("parentDataSource")));
        relation.setChildSource(report.getDictionary().getDataSources().get((String)relationProps.get("childDataSource")));
        relation.setChildColumns((ArrayList)relationProps.get("childColumns"));
        relation.setParentColumns((ArrayList)relationProps.get("parentColumns"));
        if (Func.Convert.toBoolean((Object)relationProps.get("copyModeActivated"))) {
            relation.setActive(false);
            String relationName = relation.getName();
            if (StiDictionaryHelper.dataSourceContainDataRelation(relation.getChildSource(), relationName)) {
                int index2 = 1;
                while (true) {
                    String string = relationName = index2 == 1 ? relation.getName() + StiLocalization.Get((String)"Report", (String)"CopyOf") : relation.getName() + StiLocalization.Get((String)"Report", (String)"CopyOf") + index2;
                    if (!StiDictionaryHelper.dataSourceContainDataRelation(relation.getChildSource(), relationName)) break;
                    ++index2;
                }
            }
            String nameInSource = relation.getNameInSource();
            if (StiDictionaryHelper.dataSourceContainNameInSource(relation.getChildSource(), nameInSource)) {
                int index2 = 1;
                while (true) {
                    String string = nameInSource = index2 == 1 ? relation.getName() + StiLocalization.Get((String)"Report", (String)"CopyOf") : relation.getName() + StiLocalization.Get((String)"Report", (String)"CopyOf") + index2;
                    if (!StiDictionaryHelper.dataSourceContainNameInSource(relation.getChildSource(), nameInSource)) break;
                    ++index2;
                }
            }
            if (StiValidationUtil.equals((Object)relation.getName(), (Object)relation.getAlias())) {
                relation.setAlias(relationName);
            }
            relation.setName(relationName);
            relation.setNameInSource(nameInSource);
        }
        if (!isRelationActive && relation.isActive()) {
            StiDataRelationsCollection relations = relation.getChildSource().GetParentRelations();
            for (StiDataRelation rl : relations) {
                if (rl == relation) continue;
                rl.setActive(false);
            }
        }
    }

    private static boolean dataSourceContainDataRelation(StiDataSource dataSource, String relationName) {
        StiDataRelationsCollection relations = dataSource.GetParentRelations();
        for (StiDataRelation relation : relations) {
            if (!StiValidationUtil.equals((Object)relation.getName(), (Object)relationName)) continue;
            return true;
        }
        return false;
    }

    private static boolean dataSourceContainNameInSource(StiDataSource dataSource, String nameInSource) {
        StiDataRelationsCollection relations = dataSource.GetParentRelations();
        for (StiDataRelation relation : relations) {
            if (!StiValidationUtil.equals((Object)relation.getNameInSource(), (Object)nameInSource)) continue;
            return true;
        }
        return false;
    }

    private static void applyBusinessObjectProps(StiBusinessObject businessObject, HashMap<String, Object> businessObjectProps) {
        businessObject.setAlias((String)businessObjectProps.get("alias"));
        businessObject.setName((String)businessObjectProps.get("name"));
        businessObject.setCategory((String)businessObjectProps.get("category"));
    }

    private static void applyVariableProps(StiReport report, StiVariable variable, HashMap<String, Object> variableProps) throws JSONException {
        String type = (String)variableProps.get("type");
        String basicType = (String)variableProps.get("basicType");
        StiTypeMode typeMode = StiValidationUtil.isEmpty((Object)variableProps.get("basicType")) ? StiTypeMode.Value : StiTypeMode.valueOf((String)((String)variableProps.get("basicType")));
        StiSystemType variableType = StiDictionaryHelper.getTypeFromString(((String)variableProps.get("type")).toLowerCase(), basicType);
        variable.setSystemType(variableType);
        variable.setAlias((String)variableProps.get("alias"));
        variable.setName((String)variableProps.get("name"));
        variable.setDescription(StiEncodingHelper.decodeString((String)((String)variableProps.get("description"))));
        variable.setCategory((String)variableProps.get("category"));
        if (variableProps.containsKey("initBy")) {
            variable.setInitBy(StiVariableInitBy.valueOf((String)((String)variableProps.get("initBy"))));
        }
        variable.setReadOnly(((Boolean)variableProps.get("readOnly")).booleanValue());
        variable.setRequestFromUser(((Boolean)variableProps.get("requestFromUser")).booleanValue());
        variable.setAllowUseAsSqlParameter(((Boolean)variableProps.get("allowUseAsSqlParameter")).booleanValue());
        variable.getDialogInfo().setAllowUserValues(((Boolean)variableProps.get("allowUserValues")).booleanValue());
        variable.getDialogInfo().setDateTimeType(StiDateTimeType.valueOf((String)((String)variableProps.get("dateTimeFormat"))));
        variable.getDialogInfo().setSortDirection(StiVariableSortDirection.valueOf((String)((String)variableProps.get("sortDirection"))));
        variable.getDialogInfo().setSortField(StiVariableSortField.valueOf((String)((String)variableProps.get("sortField"))));
        variable.getDialogInfo().setItemsInitializationType(StiItemsInitializationType.valueOf((String)((String)variableProps.get("dataSource"))));
        variable.getDialogInfo().setMask(StiEncodingHelper.decodeString((String)((String)variableProps.get("formatMask"))));
        variable.getDialogInfo().setKeysColumn((String)variableProps.get("keys"));
        variable.getDialogInfo().setValuesColumn((String)variableProps.get("values"));
        variable.setSelection(StiSelectionMode.valueOf((String)((String)variableProps.get("selection"))));
        variable.getDialogInfo().setBindingValue(((Boolean)variableProps.get("dependentValue")).booleanValue());
        variable.getDialogInfo().setBindingVariable(StiValidationUtil.isNullOrEmpty((String)((String)variableProps.get("dependentVariable"))) ? null : report.getDictionary().getVariables().get((String)variableProps.get("dependentVariable")));
        variable.getDialogInfo().setBindingValuesColumn((String)variableProps.get("dependentColumn"));
        if (typeMode == StiTypeMode.Value || typeMode == StiTypeMode.NullableValue) {
            if (variable.getType() == StiSystemTypeEnum.SystemDrawingImage) {
                variable.setValueObject(variableProps.get("value") != null ? StiReportEdit.base64ToImage((String)variableProps.get("value")) : null);
            } else {
                if (variable.getInitBy() == StiVariableInitBy.Value && variableProps.get("value") != null) {
                    variable.setValueObject(StiDictionaryHelper.getValueByType(StiEncodingHelper.decodeString((String)((String)variableProps.get("value"))), type, basicType, true));
                }
                if (variable.getInitBy() == StiVariableInitBy.Expression && variableProps.get("expression") != null) {
                    String expression = StiEncodingHelper.decodeString((String)((String)variableProps.get("expression")));
                    if (!StiValidationUtil.isNullOrEmpty((String)expression) && expression.startsWith("{") && expression.endsWith("}")) {
                        expression = expression.substring(1, expression.length() - 2);
                    }
                    variable.setValueObject((Object)expression);
                }
            }
        } else if (typeMode == StiTypeMode.Range) {
            block22: {
                if (variable.getInitBy() == StiVariableInitBy.Value) {
                    try {
                        Range range = (Range)Class.forName("com.stimulsoft.base.range." + ((StiTypeRange)variableType).getEnumType().toString().replace("System", "") + "Range").newInstance();
                        if (variableProps.containsKey("valueFrom")) {
                            range.setFromObject(StiDictionaryHelper.getValueByType(StiEncodingHelper.decodeString((String)((String)variableProps.get("valueFrom"))), type, basicType, true));
                        }
                        if (variableProps.containsKey("valueTo")) {
                            range.setToObject(StiDictionaryHelper.getValueByType(StiEncodingHelper.decodeString((String)((String)variableProps.get("valueTo"))), type, basicType, true));
                        }
                        variable.setValueObject((Object)range);
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel < 10) break block22;
                        e.printStackTrace();
                    }
                }
            }
            if (variable.getInitBy() == StiVariableInitBy.Expression) {
                String expressionTo;
                String expressionFrom;
                if (variableProps.get("expressionFrom") != null) {
                    variable.setInitByExpressionFrom(StiEncodingHelper.decodeString((String)((String)variableProps.get("expressionFrom"))));
                }
                if (variableProps.get("expressionTo") != null) {
                    variable.setInitByExpressionTo(StiEncodingHelper.decodeString((String)((String)variableProps.get("expressionTo"))));
                }
                if (!StiValidationUtil.isNullOrEmpty((String)(expressionFrom = StiEncodingHelper.decodeString((String)((String)variableProps.get("expressionFrom"))))) && expressionFrom.startsWith("{") && expressionFrom.endsWith("}")) {
                    expressionFrom = expressionFrom.substring(1, expressionFrom.length() - 2);
                }
                if (!StiValidationUtil.isNullOrEmpty((String)(expressionTo = StiEncodingHelper.decodeString((String)((String)variableProps.get("expressionTo"))))) && expressionTo.startsWith("{") && expressionTo.endsWith("}")) {
                    expressionTo = expressionTo.substring(1, expressionFrom.length() - 2);
                }
                if (variableProps.get("expressionFrom") != null) {
                    variable.setInitByExpressionFrom(expressionFrom);
                }
                if (variableProps.get("expressionTo") != null) {
                    variable.setInitByExpressionTo(expressionTo);
                }
            }
        }
        if (variable.getDialogInfo().getItemsInitializationType() == StiItemsInitializationType.Columns) {
            variableProps.put("items", null);
        }
        StiDictionaryHelper.setDialogInfoItems(variable, variableProps.get("items"), type, basicType);
    }

    private static void applyResourceProps(StiReport report, StiResource resource, HashMap<String, Object> resourceProps) {
        resource.setName((String)resourceProps.get("name"));
        resource.setAlias((String)resourceProps.get("alias"));
        resource.setAvailableInTheViewer(Func.Convert.toBoolean((Object)resourceProps.get("availableInTheViewer")));
        if (resourceProps.get("type") != null) {
            resource.setType(StiResourceType.valueOf((String)((String)resourceProps.get("type"))));
            if (((Boolean)resourceProps.get("haveContent")).booleanValue()) {
                if (resourceProps.get("loadedContent") != null) {
                    String contentBase64Str = (String)resourceProps.get("loadedContent");
                    resource.setContent(StiBase64DecoderUtil.decode((String)contentBase64Str.substring(contentBase64Str.indexOf("base64,") + 7)));
                }
            } else {
                resource.setContent(null);
            }
        }
    }

    public static StiImagesID getIconTypeForColumn(StiSystemType type) {
        return StiDictionaryHelper.getDataColumnImageIdFromType(type, true);
    }

    public static StiImagesID getLockedCalcImageIDFromType(StiSystemType systemType, boolean inherited) {
        StiSystemTypeEnum type;
        StiSystemTypeEnum stiSystemTypeEnum = type = systemType != null ? systemType.getEnumType() : null;
        if (type == StiSystemTypeEnum.SystemBoolean) {
            return inherited ? StiImagesID.LockedCalcColumnBool : StiImagesID.CalcColumnBool;
        }
        if (type == StiSystemTypeEnum.SystemChar) {
            return inherited ? StiImagesID.LockedCalcColumnChar : StiImagesID.CalcColumnChar;
        }
        if (type == StiSystemTypeEnum.SystemDateTime || type == StiSystemTypeEnum.SystemTimeSpan) {
            return inherited ? StiImagesID.LockedCalcColumnDateTime : StiImagesID.CalcColumnDateTime;
        }
        if (type == StiSystemTypeEnum.SystemDecimal) {
            return inherited ? StiImagesID.LockedCalcColumnDecimal : StiImagesID.CalcColumnDecimal;
        }
        if (type == StiSystemTypeEnum.SystemInt16 || type == StiSystemTypeEnum.SystemUInt16 || type == StiSystemTypeEnum.SystemInt64 || type == StiSystemTypeEnum.SystemUInt64 || type == StiSystemTypeEnum.SystemByte || type == StiSystemTypeEnum.SystemSByte || type == StiSystemTypeEnum.SystemInt32 || type == StiSystemTypeEnum.SystemUInt32) {
            return inherited ? StiImagesID.LockedCalcColumnInt : StiImagesID.CalcColumnInt;
        }
        if (type == StiSystemTypeEnum.SystemFloat || type == StiSystemTypeEnum.SystemDouble) {
            return inherited ? StiImagesID.LockedCalcColumnFloat : StiImagesID.CalcColumnFloat;
        }
        if (type == StiSystemTypeEnum.SystemDrawingImage) {
            return inherited ? StiImagesID.LockedCalcColumnImage : StiImagesID.CalcColumnImage;
        }
        if (type != null && systemType.isList()) {
            return inherited ? StiImagesID.LockedCalcColumnBinary : StiImagesID.CalcColumnBinary;
        }
        return inherited ? StiImagesID.LockedCalcColumnString : StiImagesID.CalcColumnString;
    }

    private static StiImagesID getDataColumnImageIdFromType(StiSystemType systemType, boolean isDataColumn) {
        StiSystemTypeEnum type;
        StiSystemTypeEnum stiSystemTypeEnum = type = systemType != null ? systemType.getEnumType() : null;
        if (type == StiSystemTypeEnum.SystemBoolean) {
            return isDataColumn ? StiImagesID.DataColumnBool : StiImagesID.LockedDataColumnBool;
        }
        if (type == StiSystemTypeEnum.SystemChar) {
            return isDataColumn ? StiImagesID.DataColumnChar : StiImagesID.LockedDataColumnChar;
        }
        if (type == StiSystemTypeEnum.SystemDateTime || type == StiSystemTypeEnum.SystemTimeSpan) {
            return isDataColumn ? StiImagesID.DataColumnDateTime : StiImagesID.LockedDataColumnDateTime;
        }
        if (type == StiSystemTypeEnum.SystemDecimal) {
            return isDataColumn ? StiImagesID.DataColumnDecimal : StiImagesID.LockedDataColumnDecimal;
        }
        if (type == StiSystemTypeEnum.SystemInt32 || type == StiSystemTypeEnum.SystemUInt32 || type == StiSystemTypeEnum.SystemInt64 || type == StiSystemTypeEnum.SystemUInt64 || type == StiSystemTypeEnum.SystemByte || type == StiSystemTypeEnum.SystemSByte || type == StiSystemTypeEnum.SystemInt16 || type == StiSystemTypeEnum.SystemUInt16) {
            return isDataColumn ? StiImagesID.DataColumnInt : StiImagesID.LockedDataColumnInt;
        }
        if (type == StiSystemTypeEnum.SystemFloat || type == StiSystemTypeEnum.SystemDouble) {
            return isDataColumn ? StiImagesID.DataColumnFloat : StiImagesID.LockedDataColumnFloat;
        }
        if (type == StiSystemTypeEnum.SystemDrawingImage || type == StiSystemTypeEnum.SystemDrawingBitmap) {
            return isDataColumn ? StiImagesID.DataColumnImage : StiImagesID.LockedDataColumnImage;
        }
        if (type == StiSystemTypeEnum.SystemChar && systemType.isRange()) {
            return isDataColumn ? StiImagesID.VariableRangeChar : StiImagesID.LockedVariableRangeChar;
        }
        if ((type == StiSystemTypeEnum.SystemDateTime || type == StiSystemTypeEnum.SystemTimeSpan) && systemType.isRange()) {
            return isDataColumn ? StiImagesID.VariableRangeDateTime : StiImagesID.LockedVariableRangeDateTime;
        }
        if (type == StiSystemTypeEnum.SystemDecimal && systemType.isRange()) {
            return isDataColumn ? StiImagesID.VariableRangeDecimal : StiImagesID.LockedVariableRangeDecimal;
        }
        if ((type == StiSystemTypeEnum.SystemInt16 || type == StiSystemTypeEnum.SystemUInt16 || type == StiSystemTypeEnum.SystemInt32 || type == StiSystemTypeEnum.SystemUInt32 || type == StiSystemTypeEnum.SystemInt64 || type == StiSystemTypeEnum.SystemUInt64 || type == StiSystemTypeEnum.SystemByte || type == StiSystemTypeEnum.SystemSByte) && systemType.isRange()) {
            return isDataColumn ? StiImagesID.VariableRangeInt : StiImagesID.LockedVariableRangeInt;
        }
        if ((type == StiSystemTypeEnum.SystemFloat || type == StiSystemTypeEnum.SystemDouble) && systemType.isRange()) {
            return isDataColumn ? StiImagesID.VariableRangeFloat : StiImagesID.LockedVariableRangeFloat;
        }
        if ((type == StiSystemTypeEnum.SystemString || type == StiSystemTypeEnum.SystemGuid) && systemType.isRange()) {
            return isDataColumn ? StiImagesID.VariableRangeString : StiImagesID.LockedVariableRangeString;
        }
        if (type == StiSystemTypeEnum.SystemBoolean && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListBool : StiImagesID.LockedVariableListBool;
        }
        if ((type == StiSystemTypeEnum.SystemString || type == StiSystemTypeEnum.SystemGuid) && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListString : StiImagesID.LockedVariableListString;
        }
        if (type == StiSystemTypeEnum.SystemChar && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListChar : StiImagesID.LockedVariableListChar;
        }
        if ((type == StiSystemTypeEnum.SystemDateTime || type == StiSystemTypeEnum.SystemTimeSpan) && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListDateTime : StiImagesID.LockedVariableListDateTime;
        }
        if (type == StiSystemTypeEnum.SystemDecimal && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListDecimal : StiImagesID.LockedVariableListDecimal;
        }
        if ((type == StiSystemTypeEnum.SystemInt16 || type == StiSystemTypeEnum.SystemUInt16 || type == StiSystemTypeEnum.SystemInt32 || type == StiSystemTypeEnum.SystemUInt32 || type == StiSystemTypeEnum.SystemInt64 || type == StiSystemTypeEnum.SystemUInt64 || type == StiSystemTypeEnum.SystemByte || type == StiSystemTypeEnum.SystemSByte) && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListInt : StiImagesID.LockedVariableListInt;
        }
        if ((type == StiSystemTypeEnum.SystemFloat || type == StiSystemTypeEnum.SystemDouble) && systemType.isList()) {
            return isDataColumn ? StiImagesID.VariableListFloat : StiImagesID.LockedVariableListFloat;
        }
        if (type != null && systemType.isList()) {
            return isDataColumn ? StiImagesID.DataColumnBinary : StiImagesID.LockedDataColumnBinary;
        }
        return isDataColumn ? StiImagesID.DataColumnString : StiImagesID.LockedDataColumnString;
    }

    public static String getTypeValueToString(StiSystemType stype) {
        String nType;
        StiSystemTypeEnum type = stype.getEnumType();
        String string = nType = stype.isNullable() ? " (Nullable)" : "";
        if (type == null) {
            return "null";
        }
        if (type == StiSystemTypeEnum.SystemBoolean) {
            return "bool" + nType;
        }
        if (type == StiSystemTypeEnum.SystemByte) {
            return "byte" + nType;
        }
        if (type == StiSystemTypeEnum.SystemByteArray) {
            return "byte[]";
        }
        if (type == StiSystemTypeEnum.SystemChar) {
            return "char" + nType;
        }
        if (type == StiSystemTypeEnum.SystemDateTime) {
            return "datetime" + nType;
        }
        if (type == StiSystemTypeEnum.SystemDecimal) {
            return "decimal" + nType;
        }
        if (type == StiSystemTypeEnum.SystemDouble) {
            return "double" + nType;
        }
        if (type == StiSystemTypeEnum.SystemGuid) {
            return "guid" + nType;
        }
        if (type == StiSystemTypeEnum.SystemInt16) {
            return "short" + nType;
        }
        if (type == StiSystemTypeEnum.SystemInt32) {
            return "int" + nType;
        }
        if (type == StiSystemTypeEnum.SystemInt64) {
            return "long" + nType;
        }
        if (type == StiSystemTypeEnum.SystemSByte) {
            return "sbyte" + nType;
        }
        if (type == StiSystemTypeEnum.SystemFloat) {
            return "float" + nType;
        }
        if (type == StiSystemTypeEnum.SystemString) {
            return "String" + nType;
        }
        if (type == StiSystemTypeEnum.SystemTimeSpan) {
            return "timespan" + nType;
        }
        if (type == StiSystemTypeEnum.SystemUInt16) {
            return "ushort" + nType;
        }
        if (type == StiSystemTypeEnum.SystemUInt32) {
            return "uint" + nType;
        }
        if (type == StiSystemTypeEnum.SystemUInt64) {
            return "ulong" + nType;
        }
        if (type == StiSystemTypeEnum.SystemDrawingImage) {
            return "image";
        }
        if (type == StiSystemTypeEnum.RefCursor) {
            return "RefCursor";
        }
        if (type == StiSystemTypeEnum.SystemObject) {
            return "object";
        }
        return "object";
    }

    public static StiSystemType getTypeFromString(String type, String basicType) {
        StiSystemTypeEnum result = StiSystemTypeEnum.SystemObject;
        if (type.equalsIgnoreCase("null")) {
            result = null;
        }
        if (type.equalsIgnoreCase("bool")) {
            result = StiSystemTypeEnum.SystemBoolean;
        }
        if (type.equalsIgnoreCase("byte")) {
            result = StiSystemTypeEnum.SystemByte;
        }
        if (type.equalsIgnoreCase("byte[]")) {
            result = StiSystemTypeEnum.SystemByteArray;
        }
        if (type.equalsIgnoreCase("char")) {
            result = StiSystemTypeEnum.SystemChar;
        }
        if (type.equalsIgnoreCase("datetime")) {
            result = StiSystemTypeEnum.SystemDateTime;
        }
        if (type.equalsIgnoreCase("decimal")) {
            result = StiSystemTypeEnum.SystemDecimal;
        }
        if (type.equalsIgnoreCase("double")) {
            result = StiSystemTypeEnum.SystemDouble;
        }
        if (type.equalsIgnoreCase("guid")) {
            result = StiSystemTypeEnum.SystemGuid;
        }
        if (type.equalsIgnoreCase("short")) {
            result = StiSystemTypeEnum.SystemInt16;
        }
        if (type.equalsIgnoreCase("int")) {
            result = StiSystemTypeEnum.SystemInt32;
        }
        if (type.equalsIgnoreCase("long")) {
            result = StiSystemTypeEnum.SystemInt64;
        }
        if (type.equalsIgnoreCase("sbyte")) {
            result = StiSystemTypeEnum.SystemSByte;
        }
        if (type.equalsIgnoreCase("float")) {
            result = StiSystemTypeEnum.SystemFloat;
        }
        if (type.equalsIgnoreCase("String")) {
            result = StiSystemTypeEnum.SystemString;
        }
        if (type.equalsIgnoreCase("timespan")) {
            result = StiSystemTypeEnum.SystemTimeSpan;
        }
        if (type.equalsIgnoreCase("ushort")) {
            result = StiSystemTypeEnum.SystemUInt16;
        }
        if (type.equalsIgnoreCase("uint")) {
            result = StiSystemTypeEnum.SystemUInt32;
        }
        if (type.equalsIgnoreCase("ulong")) {
            result = StiSystemTypeEnum.SystemUInt64;
        }
        if (type.equalsIgnoreCase("image")) {
            result = StiSystemTypeEnum.SystemDrawingImage;
        }
        if (type.equalsIgnoreCase("refcursor")) {
            result = StiSystemTypeEnum.RefCursor;
        }
        if (type.equalsIgnoreCase("bool (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemBoolean;
        }
        if (type.equalsIgnoreCase("byte (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemByte;
        }
        if (type.equalsIgnoreCase("char (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemChar;
        }
        if (type.equalsIgnoreCase("datetime (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemDateTime;
        }
        if (type.equalsIgnoreCase("decimal (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemDecimal;
        }
        if (type.equalsIgnoreCase("double (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemDouble;
        }
        if (type.equalsIgnoreCase("guid (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemGuid;
        }
        if (type.equalsIgnoreCase("short (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemInt16;
        }
        if (type.equalsIgnoreCase("int (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemInt32;
        }
        if (type.equalsIgnoreCase("long (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemInt64;
        }
        if (type.equalsIgnoreCase("sbyte (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemByte;
        }
        if (type.equalsIgnoreCase("float (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemFloat;
        }
        if (type.equalsIgnoreCase("timespan (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemTimeSpan;
        }
        if (type.equalsIgnoreCase("ushort (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemUInt16;
        }
        if (type.equalsIgnoreCase("uint (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemUInt32;
        }
        if (type.equalsIgnoreCase("ulong (Nullable)")) {
            basicType = "NullableValue";
            result = StiSystemTypeEnum.SystemUInt64;
        }
        if (type.equalsIgnoreCase("Object")) {
            result = StiSystemTypeEnum.SystemObject;
        }
        if ("list".equalsIgnoreCase(basicType)) {
            StiTypeList result2 = new StiTypeList(result.getSystemType());
            switch (result.getSystemType().getEnumType()) {
                case SystemString: {
                    result2.setSerializeValue("Stimulsoft.Report.StringList");
                    break;
                }
                case SystemSingle: {
                    result2.setSerializeValue("Stimulsoft.Report.FloatList");
                    break;
                }
                case SystemDouble: {
                    result2.setSerializeValue("Stimulsoft.Report.DoubleList");
                    break;
                }
                case SystemDecimal: {
                    result2.setSerializeValue("Stimulsoft.Report.DecimalLis");
                    break;
                }
                case SystemDateTime: {
                    result2.setSerializeValue("Stimulsoft.Report.DateTimeList");
                    break;
                }
                case SystemTimeSpan: {
                    result2.setSerializeValue("Stimulsoft.Report.TimeSpanList");
                    break;
                }
                case SystemByte: {
                    result2.setSerializeValue("Stimulsoft.Report.ByteList");
                    break;
                }
                case SystemInt16: {
                    result2.setSerializeValue("Stimulsoft.Report.ShortList");
                    break;
                }
                case SystemInt32: {
                    result2.setSerializeValue("Stimulsoft.Report.IntList");
                    break;
                }
                case SystemInt64: {
                    result2.setSerializeValue("Stimulsoft.Report.LongList");
                    break;
                }
                case SystemBoolean: {
                    result2.setSerializeValue("Stimulsoft.Report.BoolList");
                    break;
                }
                case SystemChar: {
                    result2.setSerializeValue("Stimulsoft.Report.CharList");
                    break;
                }
                case SystemGuid: {
                    result2.setSerializeValue("Stimulsoft.Report.GuidList");
                    break;
                }
            }
            return result2;
        }
        if ("range".equalsIgnoreCase(basicType)) {
            StiTypeRange result2 = new StiTypeRange((StiTypeValue)result.getSystemType());
            switch (result.getSystemType().getEnumType()) {
                case SystemString: {
                    result2.setSerializeValue("Stimulsoft.Report.StringRange");
                    break;
                }
                case SystemSingle: {
                    result2.setSerializeValue("Stimulsoft.Report.FloatRange");
                    break;
                }
                case SystemDouble: {
                    result2.setSerializeValue("Stimulsoft.Report.DoubleRange");
                    break;
                }
                case SystemDecimal: {
                    result2.setSerializeValue("Stimulsoft.Report.DecimalLis");
                    break;
                }
                case SystemDateTime: {
                    result2.setSerializeValue("Stimulsoft.Report.DateTimeRange");
                    break;
                }
                case SystemTimeSpan: {
                    result2.setSerializeValue("Stimulsoft.Report.TimeSpanRange");
                    break;
                }
                case SystemByte: {
                    result2.setSerializeValue("Stimulsoft.Report.ByteRange");
                    break;
                }
                case SystemInt16: {
                    result2.setSerializeValue("Stimulsoft.Report.ShortRange");
                    break;
                }
                case SystemInt32: {
                    result2.setSerializeValue("Stimulsoft.Report.IntRange");
                    break;
                }
                case SystemInt64: {
                    result2.setSerializeValue("Stimulsoft.Report.LongRange");
                    break;
                }
                case SystemBoolean: {
                    result2.setSerializeValue("Stimulsoft.Report.BoolRange");
                    break;
                }
                case SystemChar: {
                    result2.setSerializeValue("Stimulsoft.Report.CharRange");
                    break;
                }
                case SystemGuid: {
                    result2.setSerializeValue("Stimulsoft.Report.GuidRange");
                    break;
                }
            }
            return result2;
        }
        if ("NullableValue".equals(basicType)) {
            return new StiTypeNullable(result.getSystemType());
        }
        return result.getSystemType();
    }

    public static ArrayList<HashMap<String, Object>> getResourcesTree(StiReport report) {
        ArrayList<HashMap<String, Object>> resourcesTree = new ArrayList<HashMap<String, Object>>();
        for (StiResource resource : report.getDictionary().getResources()) {
            HashMap<String, Object> resourceItem = StiDictionaryHelper.resourceItem(resource, report);
            if (StiReportResourceHelper.isFontResourceType((StiResourceType)resource.getType())) {
                StiFontResourceHelper.addFontToReport(report, resource, resourceItem);
            }
            resourcesTree.add(resourceItem);
        }
        return resourcesTree;
    }

    public static HashMap<String, Object> getDictionaryTree(StiReport report) {
        HashMap<String, Object> dictionary = new HashMap<String, Object>();
        dictionary.put("databases", StiDictionaryHelper.getDataBasesTree(report));
        dictionary.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
        dictionary.put("variables", StiDictionaryHelper.getVariablesTree(report));
        dictionary.put("systemVariables", StiDictionaryHelper.getSystemVariablesTree(report));
        dictionary.put("functions", StiDictionaryHelper.getFunctionsTree(report));
        dictionary.put("resources", StiDictionaryHelper.getResourcesTree(report));
        return dictionary;
    }

    public static ArrayList<HashMap<String, Object>> getFunctionsTree(StiReport report) {
        String[] categories;
        StiDictionary dictionary = report.getDictionary();
        ArrayList<HashMap<String, Object>> functionsTree = new ArrayList<HashMap<String, Object>>();
        Hashtable hash = StiFunctions.getFunctionsGrouppedInCategories();
        for (String category : categories = hash.keySet().toArray(new String[0])) {
            HashMap<String, Object> categoryItem = StiDictionaryHelper.functionsCategoryItem(category, "Folder");
            functionsTree.add(categoryItem);
            List list = (List)hash.get(category);
            HashMap<String, String> hashFunctions = new HashMap<String, String>();
            for (StiFunction function : list) {
                hashFunctions.put(function.getGroupFunctionName(), function.getGroupFunctionName());
            }
            Object[] functions = hashFunctions.keySet().toArray(new String[0]);
            Arrays.sort(functions);
            for (Object function : functions) {
                Object[] funcs = StiFunctions.getFunctions((StiReport)dictionary.getReport(), (String)function, (boolean)false);
                Arrays.sort(funcs);
                HashMap<String, Object> parentNode = categoryItem;
                if (funcs.length > 1) {
                    parentNode = StiDictionaryHelper.functionsCategoryItem((String)function, "Function");
                    ArrayList items = (ArrayList)categoryItem.get("items");
                    items.add(parentNode);
                }
                for (Object func : funcs) {
                    HashMap<String, Object> functionItem = StiDictionaryHelper.functionItem((StiFunction)func, report);
                    ArrayList items = (ArrayList)parentNode.get("items");
                    items.add(functionItem);
                }
            }
        }
        return functionsTree;
    }

    public static ArrayList<String> getSystemVariablesTree(StiReport report) {
        ArrayList<String> systemVariables = new ArrayList<String>();
        systemVariables.addAll(Arrays.asList(StiSystemVariablesHelper.getSystemVariables((StiReport)report)));
        return systemVariables;
    }

    private static ArrayList<HashMap<String, Object>> getDataBasesTree(StiReport report) {
        StiDictionary dictionary = report.getDictionary();
        ArrayList<HashMap<String, Object>> databasesTree = new ArrayList<HashMap<String, Object>>();
        for (StiDatabase database : dictionary.getDatabases()) {
            if (!dictionary.getRestrictions().isAllowShow(database.getName(), StiDataType.Database)) continue;
            databasesTree.add(StiDictionaryHelper.databaseItem(database));
        }
        for (StiDataSource dataSource : dictionary.getDataSources()) {
            if (!dictionary.getRestrictions().isAllowShow(dataSource.getName(), StiDataType.DataSource)) continue;
            String category = dataSource.GetCategoryName();
            HashMap<String, Object> databaseItem = StiDictionaryHelper.getDatabaseByName(category, databasesTree);
            if (databaseItem == null) {
                databaseItem = StiDictionaryHelper.databaseItem(category, category, category, false);
                databaseItem.put("isCloud", false);
                databasesTree.add(databaseItem);
            }
            ((ArrayList)databaseItem.get("dataSources")).add(StiDictionaryHelper.datasourceItem(dataSource));
        }
        return databasesTree;
    }

    private static boolean isExistInDatabases(StiReport report, String databaseName) {
        StiDictionary dictionary = report.getDictionary();
        for (StiDatabase database : dictionary.getDatabases()) {
            if (!dictionary.getRestrictions().isAllowShow(database.getName(), StiDataType.Database) || !database.getName().equalsIgnoreCase(databaseName)) continue;
            return true;
        }
        for (StiDataSource dataSource : dictionary.getDataSources()) {
            if (!dictionary.getRestrictions().isAllowShow(dataSource.getName(), StiDataType.DataSource)) continue;
            String category = dataSource.GetCategoryName();
            if (dictionary.getDatabases().get(category) != null || !category.equalsIgnoreCase(databaseName)) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<HashMap<String, Object>> getObjectsTreeByCategories(StiReport report, StiValueCollection<?> collectionObjects) {
        StiDictionary dictionary = report.getDictionary();
        ArrayList<HashMap<String, Object>> mainTree = new ArrayList<HashMap<String, Object>>();
        Hashtable<String, ArrayList> categories = new Hashtable<String, ArrayList>();
        boolean isVariablesCollection = collectionObjects instanceof StiVariablesCollection;
        StiVariable variable = null;
        StiBusinessObject businessObject = null;
        for (Object object_ : collectionObjects) {
            ArrayList objects;
            String category;
            if (isVariablesCollection) {
                variable = (StiVariable)object_;
            } else {
                businessObject = (StiBusinessObject)object_;
            }
            String name = isVariablesCollection ? variable.getName() : businessObject.getName();
            String string = category = isVariablesCollection ? variable.getCategory() : businessObject.getCategory();
            if (!dictionary.getRestrictions().isAllowShow(name, StiDataType.Variable)) continue;
            if (StiValidationUtil.isEmpty((String)category)) {
                objects = mainTree;
            } else if (categories.get(category) == null) {
                objects = new ArrayList();
                categories.put(category, objects);
                HashMap<String, Object> categoryObject = new HashMap<String, Object>();
                categoryObject.put("typeItem", "Category");
                categoryObject.put("name", category);
                categoryObject.put("categoryItems", objects);
                if (isVariablesCollection) {
                    categoryObject.put("requestFromUser", variable.getRequestFromUser());
                    categoryObject.put("readOnly", variable.getReadOnly());
                }
                mainTree.add(categoryObject);
            } else {
                objects = (ArrayList)categories.get(category);
            }
            if (!isVariablesCollection) {
                objects.add(StiDictionaryHelper.businessObjectItem(businessObject));
                continue;
            }
            if (variable.getName().length() <= 0) continue;
            objects.add(StiDictionaryHelper.variableItem(variable));
        }
        return mainTree;
    }

    private static ArrayList<HashMap<String, Object>> getBusinessObjectsTree(StiReport report) {
        return new ArrayList<HashMap<String, Object>>();
    }

    private static ArrayList<StiBusinessObject> getChildBusinessObjectsTree(StiBusinessObject businessObject) {
        ArrayList<StiBusinessObject> businessObjets = new ArrayList<StiBusinessObject>();
        if (businessObject.getBusinessObjects() != null) {
            for (StiBusinessObject childBusinessObject : businessObject.getBusinessObjects()) {
                businessObjets.add(childBusinessObject);
            }
        }
        return businessObjets;
    }

    private static ArrayList<HashMap<String, Object>> getVariablesTree(StiReport report) {
        return StiDictionaryHelper.getObjectsTreeByCategories(report, report.getDictionary().getVariables());
    }

    private static ArrayList<HashMap<String, Object>> getColumnsTree2(StiDataColumnsCollection columnsCollection) {
        ArrayList<HashMap<String, Object>> columns = new ArrayList<HashMap<String, Object>>();
        for (StiDataColumn column : columnsCollection) {
            HashMap<String, Object> columnItem = new HashMap<String, Object>();
            columnItem.put("typeItem", "Parameters".equals(column.getCaption()) ? "Parameter" : "Column");
            columnItem.put("typeIcon", StiDictionaryHelper.getDataColumnImageIdFromType(column.getSystemType(), true).toString());
            columnItem.put("type", StiDictionaryHelper.getTypeValueToString(column.getSystemType()));
            columnItem.put("name", column.getName());
            columnItem.put("correctName", StiNameValidator.CorrectName((String)column.getName()));
            columnItem.put("nameInSource", column.getName());
            columnItem.put("alias", column.getName());
            columnItem.put("isCalcColumn", false);
            columnItem.put("expression", "");
            columns.add(columnItem);
        }
        return columns;
    }

    private static ArrayList<HashMap<String, Object>> getColumnsTree(StiDataColumnsCollection columnsCollection, boolean isCloud) {
        ArrayList<HashMap<String, Object>> columns = new ArrayList<HashMap<String, Object>>();
        for (StiDataColumn column : columnsCollection) {
            HashMap<String, Object> columnObject = StiDictionaryHelper.columnItem(column);
            columnObject.put("isCloud", isCloud);
            columns.add(columnObject);
        }
        return columns;
    }

    private static ArrayList<HashMap<String, Object>> getColumnsTree(StiDataColumnsCollection columnsCollection) {
        ArrayList<HashMap<String, Object>> columns = new ArrayList<HashMap<String, Object>>();
        for (StiDataColumn column : columnsCollection) {
            columns.add(StiDictionaryHelper.columnItem(column));
        }
        return columns;
    }

    private static ArrayList<HashMap<String, Object>> getColumnsTree2(List<StiSqlField> fields) {
        ArrayList<HashMap<String, Object>> columns = new ArrayList<HashMap<String, Object>>();
        for (StiSqlField column : fields) {
            columns.add(StiDictionaryHelper.columnItem2(column));
        }
        return columns;
    }

    private static ArrayList<HashMap<String, Object>> getParametersTree(StiDataParametersCollection parametersCollection, boolean isCloud) {
        ArrayList<HashMap<String, Object>> parameters = new ArrayList<HashMap<String, Object>>();
        for (StiDataParameter parameter : parametersCollection) {
            HashMap<String, Object> parameterObject = StiDictionaryHelper.ParameterItem(parameter);
            parameterObject.put("isCloud", isCloud);
            parameters.add(parameterObject);
        }
        return parameters;
    }

    private static ArrayList<HashMap<String, Object>> getRelationsTree(StiDataRelation parentRelation, StiDataRelationsCollection relations, boolean isCloud, HashMap<String, Object> upLevelRelations) {
        ArrayList<HashMap<String, Object>> relationsTree = new ArrayList<HashMap<String, Object>>();
        for (StiDataRelation relation : relations) {
            if (parentRelation == relation) continue;
            if (upLevelRelations.containsKey(relation.getNameInSource())) {
                return new ArrayList<HashMap<String, Object>>();
            }
            HashMap<String, Object> relationObject = StiDictionaryHelper.relationItem(relation, upLevelRelations);
            relationObject.put("isCloud", isCloud);
            relationsTree.add(relationObject);
        }
        return relationsTree;
    }

    private static ArrayList<HashMap<String, Object>> getRelationsTree(StiDataRelationCollection relationsCollection) {
        ArrayList<HashMap<String, Object>> relations = new ArrayList<HashMap<String, Object>>();
        for (StiDataRelation relation : relationsCollection) {
            HashMap<String, Object> relationItem = new HashMap<String, Object>();
            relationItem.put("typeItem", "Relation");
            relationItem.put("typeIcon", "Relation");
            ArrayList<String> jsParentColumns = new ArrayList<String>();
            for (String parentColumn : relation.getParentColumns()) {
                jsParentColumns.add(parentColumn);
            }
            relationItem.put("parentColumns", jsParentColumns);
            ArrayList<String> jsChildColumns = new ArrayList<String>();
            for (String childColumn : relation.getChildColumns()) {
                jsChildColumns.add(childColumn);
            }
            relationItem.put("childColumns", jsChildColumns);
            relations.add(relationItem);
        }
        return relations;
    }

    public static void getConnectionTypes(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult, StiWebDesignerOptions options) throws InstantiationException, IllegalAccessException {
        ArrayList connectionTypes = new ArrayList();
        HashMap connections = new HashMap();
        ArrayList<StiDatabase> listCreatedConnection = new ArrayList<StiDatabase>();
        for (Object database : report.getDictionary().getDatabases()) {
            if (!report.getDictionary().getRestrictions().isAllowShow(database.getName(), StiDataType.Database)) continue;
            listCreatedConnection.add((StiDatabase)database);
        }
        if (listCreatedConnection.size() > 0) {
            ArrayList reportConnections = new ArrayList();
            connections.put("ReportConnections", reportConnections);
            Collections.sort(listCreatedConnection, new Comparator<StiDatabase>(){

                @Override
                public int compare(StiDatabase o1, StiDatabase o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (StiDatabase database : listCreatedConnection) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("name", database.getName());
                properties.put("typeConnection", database.getServiceType().getName().substring(database.getServiceType().getName().lastIndexOf(46) + 1));
                reportConnections.add(properties);
            }
        }
        ArrayList sqlConnections = new ArrayList();
        ArrayList fileConnections = new ArrayList();
        for (Class<? extends StiDatabase> class_ : options.getConnectionTypes()) {
            StiDatabase db = class_.newInstance();
            String name = class_.getName().substring(class_.getName().lastIndexOf(46) + 1);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("name", db.getServiceName());
            properties.put("typeConnection", class_.getName().substring(class_.getName().lastIndexOf(46) + 1));
            if (name.indexOf("Xml") >= 0 || name.indexOf("Json") >= 0) {
                fileConnections.add(properties);
                continue;
            }
            sqlConnections.add(properties);
        }
        connections.put("SQL", sqlConnections);
        connections.put("Files", fileConnections);
        callbackResult.put("connections", connections);
    }

    public static void getDataAdapterTypes(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult, StiWebDesignerOptions options) {
        ArrayList<String> dataAdapterTypes = new ArrayList<String>();
        for (Class<? extends StiDataSource> class_ : options.getDataSources()) {
            dataAdapterTypes.add(class_.getName().substring(class_.getName().lastIndexOf(46) + 1));
        }
        ArrayList connections = new ArrayList();
        for (StiDatabase database : report.getDictionary().getDatabases()) {
            if (!report.getDictionary().getRestrictions().isAllowShow(database.getName(), StiDataType.Database)) continue;
            HashMap<String, String> connection = new HashMap<String, String>();
            connection.put("name", database.getName());
            connection.put("fullName", database.getName() + " [" + database.getClass().getName().substring(database.getClass().getName().lastIndexOf(46) + 1) + "]");
            connections.add(connection);
        }
        callbackResult.put("dataAdapterTypes", dataAdapterTypes);
        callbackResult.put("connections", connections);
    }

    public static void createOrEditConnection(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult, StiWebDesignerOptions options) throws JSONException, InstantiationException, IllegalAccessException {
        HashMap connectionProps = (HashMap)param.get("connectionFormResult");
        StiDatabase database = null;
        if ("Edit".equals(connectionProps.get("mode"))) {
            database = report.getDictionary().getDatabases().get((String)connectionProps.get("oldName"));
        } else {
            String typeConnection = (String)connectionProps.get("typeConnection");
            database = StiDictionaryHelper.createDataBaseByTypeName(typeConnection, options);
            if (database != null) {
                report.getDictionary().getDatabases().add((Object)database);
            }
        }
        if (database != null) {
            StiDictionaryHelper.applyConnectionProps(database, connectionProps, report.getDictionary());
            callbackResult.put("itemObject", StiDictionaryHelper.databaseItem(database));
        }
        callbackResult.put("mode", connectionProps.get("mode"));
        callbackResult.put("skipSchemaWizard", connectionProps.get("skipSchemaWizard"));
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void deleteConnection(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        boolean canDelete;
        StiDatabase database = report.getDictionary().getDatabases().get((String)param.get("connectionName"));
        boolean bl = canDelete = database != null && report.getDictionary().getDatabases().contains((Object)database);
        if (canDelete) {
            report.getDictionary().getDatabases().remove((Object)database);
        }
        HashMap dataSourceNames = (HashMap)param.get("dataSourceNames");
        for (String key : dataSourceNames.keySet()) {
            StiDataSource dataSource = report.getDictionary().getDataSources().get((String)dataSourceNames.get(key));
            if (dataSource == null) continue;
            report.getDictionary().getDataSources().remove((Object)dataSource);
        }
        callbackResult.put("deleteResult", canDelete);
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void createOrEditRelation(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        HashMap relationProps = (HashMap)param.get("relationFormResult");
        StiDataRelation relation = null;
        if ("Edit".equals(relationProps.get("mode")) && !Func.Convert.toBoolean(relationProps.get("copyModeActivated"))) {
            relation = report.getDictionary().getRelations().get((String)relationProps.get("oldNameInSource"));
        } else {
            relation = new StiDataRelation();
            report.getDictionary().getRelations().add(relation);
        }
        if (relation != null) {
            StiDictionaryHelper.applyRelationProps(report, relation, relationProps);
            callbackResult.put("itemObject", StiDictionaryHelper.relationItem(relation, new HashMap<String, Object>()));
        }
        StiDictionaryHelper.copyProperties(new String[]{"mode", "oldNameInSource", "changedChildDataSource", "copyModeActivated"}, relationProps, callbackResult);
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void deleteRelation(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        boolean canDelete;
        StiDataRelation relation = report.getDictionary().getRelations().get((String)param.get("relationNameInSource"));
        boolean bl = canDelete = relation != null && report.getDictionary().getRelations().contains((Object)relation);
        if (canDelete) {
            report.getDictionary().getRelations().remove((Object)relation);
        }
        callbackResult.put("deleteResult", canDelete);
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void createOrEditColumn(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        HashMap columnProps = (HashMap)param.get("columnFormResult");
        Object column = null;
        StiDataColumnsCollection columns = StiDictionaryHelper.getColumnsByTypeAndNameOfObject(report, columnProps);
        if (columns != null) {
            if ("Edit".equals(columnProps.get("mode"))) {
                column = columns.get((String)columnProps.get("oldName"));
            } else {
                column = Func.Convert.toBoolean(columnProps.get("isCalcColumn")) ? new StiCalcDataColumn() : new StiDataColumn();
                if (Func.Convert.toBoolean(columnProps.get("isDataTransformationColumn"))) {
                    // empty if block
                }
                columns.add(column);
            }
        }
        if (column != null) {
            StiDictionaryHelper.applyColumnProps(column, (HashMap)param.get("columnFormResult"));
            callbackResult.put("itemObject", StiDictionaryHelper.columnItem(column));
        }
        StiDictionaryHelper.copyProperties(new String[]{"currentParentType", "currentParentName", "mode"}, (HashMap)param.get("columnFormResult"), callbackResult);
        if ("DataSource".equals(columnProps.get("currentParentType"))) {
            callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
        } else {
            callbackResult.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
        }
    }

    public static void createOrEditParameter(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        HashMap parameterProps = (HashMap)param.get("parameterFormResult");
        StiDataSource dataSource = report.getDictionary().getDataSources().get((String)parameterProps.get("currentParentName"));
        if (dataSource != null) {
            StiDataParameter parameter = null;
            StiDataParametersCollection parameters = dataSource.getParameters();
            if ("Edit".equals(parameterProps.get("mode"))) {
                parameter = parameters.getByName((String)parameterProps.get("oldName"));
            } else {
                parameter = new StiDataParameter();
                parameters.add((Object)parameter);
            }
            if (parameter != null) {
                StiDictionaryHelper.applyParameterProps(parameter, parameterProps);
                callbackResult.put("itemObject", StiDictionaryHelper.ParameterItem(parameter));
            }
        }
        StiDictionaryHelper.copyProperties(new String[]{"currentParentName", "mode"}, parameterProps, callbackResult);
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void deleteParameter(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        block5: {
            try {
                StiDataSource dataSource = report.getDictionary().getDataSources().get((String)param.get("currentParentName"));
                if (dataSource != null) {
                    StiDataParametersCollection parameters = dataSource.getParameters();
                    StiDataParameter parameter = null;
                    boolean canDelete = false;
                    if (parameters != null) {
                        parameter = parameters.getByName((String)param.get("parameterName"));
                        boolean bl = canDelete = parameter != null && !parameter.getInherited() && parameters.contains((Object)parameter);
                        if (canDelete) {
                            parameters.remove((Object)parameter);
                        }
                    }
                    callbackResult.put("deleteResult", canDelete);
                    StiDictionaryHelper.copyProperties(new String[]{"currentParentName", "mode"}, param, callbackResult);
                }
            }
            catch (Exception e) {
                callbackResult.put("error", e.getMessage());
                if (StiOptions.Engine.logLevel < 10) break block5;
                e.printStackTrace();
            }
        }
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void deleteColumn(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        StiDataColumnsCollection columns = StiDictionaryHelper.getColumnsByTypeAndNameOfObject(report, param);
        StiDataColumn column = null;
        boolean canDelete = false;
        if (columns != null) {
            column = columns.get((String)param.get("columnName"));
            boolean bl = canDelete = column != null && !column.getInherited() && columns.contains((Object)column);
            if (canDelete) {
                columns.remove((Object)column);
            }
        }
        callbackResult.put("deleteResult", canDelete);
        StiDictionaryHelper.copyProperties(new String[]{"currentParentType", "currentParentName", "mode"}, param, callbackResult);
        if ("DataSource".equals(param.get("currentParentType"))) {
            callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
        } else {
            callbackResult.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
        }
    }

    public static void createOrEditDataSource(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult, StiWebDesignerOptions options) throws InstantiationException, IllegalAccessException, StiException, JSONException, IllegalArgumentException, InvocationTargetException {
        HashMap dataSourceProps = (HashMap)param.get("dataSourceFormResult");
        StiDataSource dataSource = null;
        if ("Edit".equals(dataSourceProps.get("mode"))) {
            dataSource = report.getDictionary().getDataSources().get((String)dataSourceProps.get("oldName"));
        } else {
            dataSource = StiDictionaryHelper.createDataAdapterByTypeName((String)dataSourceProps.get("typeDataAdapter"), options, report.getDictionary(), (String)dataSourceProps.get("nameInSource"));
            if (dataSource != null) {
                report.getDictionary().getDataSources().add((Object)dataSource);
                dataSource.setDictionary(report.getDictionary());
            }
        }
        if (dataSource != null) {
            StiDictionaryHelper.applyDataSourceProps(dataSource, dataSourceProps);
            StiDictionaryHelper.updateColumns(dataSource.getColumns(), (ArrayList)dataSourceProps.get("columns"));
            StiDictionaryHelper.updateParameters(dataSource.getParameters(), (ArrayList)dataSourceProps.get("parameters"));
            callbackResult.put("itemObject", StiDictionaryHelper.datasourceItem(dataSource));
        }
        callbackResult.put("mode", dataSourceProps.get("mode"));
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void deleteDataSource(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        boolean canDelete;
        StiDataSource dataSource = report.getDictionary().getDataSources().get((String)param.get("dataSourceName"));
        boolean bl = canDelete = dataSource != null && report.getDictionary().getDataSources().contains((Object)dataSource);
        if (canDelete) {
            report.getDictionary().getDataSources().remove((Object)dataSource);
            if (param.get("dataSourceNameInSource") != null && !(dataSource instanceof StiUserSource)) {
                StiDatabase dataStore;
                boolean canRemoveDataStore = true;
                for (StiDataSource dsSource : report.getDictionary().getDataSources()) {
                    if (dsSource == null || !StiValidationUtil.equals((Object)((StiDataStoreSource)dsSource).getNameInSource(), (Object)param.get("dataSourceNameInSource"))) continue;
                    canRemoveDataStore = false;
                    break;
                }
                if (canRemoveDataStore && (dataStore = report.getDictionary().getDataStore().get((String)param.get("dataSourceNameInSource"))) != null) {
                    report.getDictionary().getDataStore().remove((Object)dataStore);
                }
            }
        }
        callbackResult.put("deleteResult", canDelete);
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void createOrEditBusinessObject(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        HashMap businessObjectProps = (HashMap)param.get("businessObjectFormResult");
        StiBusinessObject businessObject = null;
        if ("Edit".equals(businessObjectProps.get("mode"))) {
            businessObject = StiDictionaryHelper.getBusinessObjectByFullName(report, businessObjectProps.get("businessObjectFullName"));
        } else {
            businessObject = new StiBusinessObject();
            StiBusinessObject parentBusinessObject = StiDictionaryHelper.getBusinessObjectByFullName(report, businessObjectProps.get("businessObjectFullName"));
            StiBusinessObjectsCollection businessObjectsCollection = parentBusinessObject != null ? parentBusinessObject.getBusinessObjects() : report.getDictionary().getBusinessObjects();
            businessObjectsCollection.add((Object)businessObject);
            if (parentBusinessObject != null) {
                callbackResult.put("parentBusinessObjectFullName", businessObjectProps.get("businessObjectFullName"));
            }
        }
        if (businessObject != null) {
            StiDictionaryHelper.applyBusinessObjectProps(businessObject, businessObjectProps);
            StiDictionaryHelper.updateColumns(businessObject.getColumns(), (ArrayList)businessObjectProps.get("columns"));
            callbackResult.put("itemObject", businessObject);
        }
        callbackResult.put("mode", businessObjectProps.get("mode"));
        callbackResult.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
    }

    public static void deleteBusinessObject(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        boolean canDelete;
        StiBusinessObject businessObject = StiDictionaryHelper.getBusinessObjectByFullName(report, param.get("businessObjectFullName"));
        boolean bl = canDelete = businessObject != null;
        if (canDelete) {
            StiBusinessObjectsCollection businessObjectsCollection = businessObject.getParentBusinessObject() != null ? businessObject.getParentBusinessObject().getBusinessObjects() : report.getDictionary().getBusinessObjects();
            businessObjectsCollection.remove((Object)businessObject);
        }
        callbackResult.put("deleteResult", canDelete);
        callbackResult.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
    }

    public static void createOrEditVariable(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        HashMap variableProps = (HashMap)param.get("variableFormResult");
        StiVariable variable = null;
        if ("Edit".equals(variableProps.get("mode"))) {
            variable = report.getDictionary().getVariables().get((String)variableProps.get("oldName"));
        } else {
            variable = new StiVariable();
            report.getDictionary().getVariables().add(variable);
        }
        if (variable != null) {
            StiDictionaryHelper.applyVariableProps(report, variable, variableProps);
            callbackResult.put("itemObject", StiDictionaryHelper.variableItem(variable));
        }
        StiDictionaryHelper.copyProperties(new String[]{"mode", "oldName"}, variableProps, callbackResult);
        callbackResult.put("variables", StiDictionaryHelper.getVariablesTree(report));
    }

    public static void deleteVariable(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        boolean canDelete;
        StiVariable variable = report.getDictionary().getVariables().get((String)param.get("variableName"));
        boolean bl = canDelete = variable != null && report.getDictionary().getVariables().contains((Object)variable);
        if (canDelete) {
            report.getDictionary().getVariables().remove((Object)variable);
        }
        callbackResult.put("deleteResult", canDelete);
        callbackResult.put("variables", StiDictionaryHelper.getVariablesTree(report));
    }

    public static void deleteVariablesCategory(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        report.getDictionary().getVariables().removeCategory((String)param.get("categoryName"));
        callbackResult.put("variables", StiDictionaryHelper.getVariablesTree(report));
    }

    public static void editVariablesCategory(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        HashMap categoryProps = (HashMap)param.get("categoryFormResult");
        String oldCategoryName = (String)categoryProps.get("oldName");
        String newCategoryName = (String)categoryProps.get("name");
        boolean requestFromUser = Func.Convert.toBoolean(categoryProps.get("requestFromUser"));
        boolean readOnly = Func.Convert.toBoolean(categoryProps.get("readOnly"));
        for (StiVariable variable : report.getDictionary().getVariables()) {
            if (!oldCategoryName.equals(variable.getCategory())) continue;
            variable.setCategory(newCategoryName);
            if (!variable.getIsCategory()) continue;
            variable.setRequestFromUser(requestFromUser);
            variable.setReadOnly(readOnly);
        }
        callbackResult.put("requestFromUser", requestFromUser);
        callbackResult.put("readOnly", readOnly);
        callbackResult.put("newName", newCategoryName);
        callbackResult.put("variables", StiDictionaryHelper.getVariablesTree(report));
    }

    public static void createVariablesCategory(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        HashMap categoryProps = (HashMap)param.get("categoryFormResult");
        StiVariable category = new StiVariable((String)categoryProps.get("name"));
        category.setRequestFromUser(Func.Convert.toBoolean(categoryProps.get("requestFromUser")));
        category.setReadOnly(Func.Convert.toBoolean(categoryProps.get("readOnly")));
        report.getDictionary().getVariables().add(category);
        callbackResult.put("name", categoryProps.get("name"));
        callbackResult.put("requestFromUser", category.getRequestFromUser());
        callbackResult.put("readOnly", category.getReadOnly());
        callbackResult.put("variables", StiDictionaryHelper.getVariablesTree(report));
    }

    public static void createOrEditResource(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        HashMap resourceProps = (HashMap)param.get("resourceFormResult");
        StiResource resource = null;
        if ("Edit".equals(resourceProps.get("mode"))) {
            resource = report.getDictionary().getResources().get((String)resourceProps.get("oldName"));
        } else {
            StiResource sourceResource;
            resource = new StiResource();
            report.getDictionary().getResources().add((Object)resource);
            if (resourceProps.get("saveCopy") != null && (sourceResource = report.getDictionary().getResources().get((String)resourceProps.get("oldName"))) != null && sourceResource.getContent() != null) {
                resource.setContent(sourceResource.content);
            }
        }
        if (resource != null) {
            StiDictionaryHelper.applyResourceProps(report, resource, resourceProps);
            callbackResult.put("itemObject", StiDictionaryHelper.resourceItem(resource, report));
        }
        StiDictionaryHelper.copyProperties(new String[]{"mode", "oldName"}, resourceProps, callbackResult);
        report.loadFonts();
        callbackResult.put("resources", StiDictionaryHelper.getResourcesTree(report));
    }

    public static void deleteResource(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        boolean canDelete;
        StiResource resource = report.getDictionary().getResources().get((String)param.get("resourceName"));
        boolean bl = canDelete = resource != null && report.getDictionary().getResources().contains((Object)resource);
        if (canDelete && param.get("ignoreCheckUsed") == null) {
            List usedFileDatabeses = StiUsedResourceHelper.getDatabasesUsedResource((StiReport)report, (StiResource)resource);
            List usedComponents = StiUsedResourceHelper.getComponentsUsedResource((StiReport)report, (StiResource)resource);
            if (usedFileDatabeses.size() > 0 || usedComponents.size() > 0) {
                ArrayList usedObjects = new ArrayList();
                for (StiDatabase database : usedFileDatabeses) {
                    usedObjects.add(StiDictionaryHelper.databaseItem(database));
                }
                for (StiComponent component : usedComponents) {
                    HashMap<String, String> componentItem = new HashMap<String, String>();
                    componentItem.put("typeItem", "Component");
                    componentItem.put("name", component.getName());
                    componentItem.put("alias", component.getAlias());
                    componentItem.put("type", component.getClass().getName().substring(component.getClass().getName().lastIndexOf(".") + 1));
                    usedObjects.add(componentItem);
                }
                callbackResult.put("usedObjects", usedObjects);
                callbackResult.put("resourceName", resource.getName());
                canDelete = false;
            } else {
                canDelete = true;
            }
        }
        if (canDelete) {
            report.getDictionary().getResources().remove((Object)resource);
            callbackResult.put("resources", StiDictionaryHelper.getResourcesTree(report));
        }
        callbackResult.put("deleteResult", canDelete);
    }

    public static void deleteBusinessObjectCategory(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        ArrayList<StiBusinessObject> collectionForRemove = new ArrayList<StiBusinessObject>();
        for (StiBusinessObject businessObject : report.getDictionary().getBusinessObjects()) {
            if (!businessObject.getCategory().equals(param.get("categoryName"))) continue;
            collectionForRemove.add(businessObject);
        }
        for (StiBusinessObject businessObject : collectionForRemove) {
            report.getDictionary().getBusinessObjects().remove((Object)businessObject);
        }
        callbackResult.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
    }

    public static void editBusinessObjectCategory(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        HashMap categoryProps = (HashMap)param.get("categoryFormResult");
        String oldCategoryName = (String)categoryProps.get("oldName");
        String newCategoryName = (String)categoryProps.get("name");
        for (StiBusinessObject businessObject : report.getDictionary().getBusinessObjects()) {
            if (!businessObject.getCategory().equals(oldCategoryName)) continue;
            businessObject.setCategory(newCategoryName);
        }
        StiDictionaryHelper.copyProperties(new String[]{"oldName", "name"}, categoryProps, callbackResult);
        callbackResult.put("businessObjects", StiDictionaryHelper.getBusinessObjectsTree(report));
    }

    public static void synchronizeDictionary(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        callbackResult.put("dictionary", StiDictionaryHelper.getDictionaryTree(report));
    }

    public static void newDictionary(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        report.getDictionary().getVariables().clear();
        report.getDictionary().getDataSources().clear();
        report.getDictionary().getRelations().clear();
        report.getDictionary().getDataStore().clear();
        report.getDictionary().getResources().clear();
        report.getDictionary().getDatabases().clear();
        callbackResult.put("dictionary", StiDictionaryHelper.getDictionaryTree(report));
    }

    public static void getAllConnections(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult, StiWebDesignerOptions options) throws InstantiationException, IllegalAccessException {
        HashMap result = new HashMap();
        for (StiDatabase db : report.getDictionary().getDatabases()) {
            String category = db.getName();
            if (result.get(category) == null) {
                result.put(category, new ArrayList());
            }
            if (db instanceof StiXmlDatabase) {
                try {
                    InputStream is = ((StiXmlDatabase)db).getSchemaInputStream(report);
                    StiXmlTableFieldsRequest request = StiDataColumnsUtil.parceXSDSchema((InputStream)is);
                    for (StiXmlTable table : request.getTables()) {
                        String name = category + "." + table.getName();
                        List datas = (List)result.get(category);
                        if (datas.contains(name)) continue;
                        datas.add(name);
                    }
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (db instanceof StiJsonDatabase) {
                try {
                    DataSet dataSet = StiBaseOptions.getDefaultJsonConverterVersion() == StiJsonConverterVersion.ConverterV1 ? StiJsonToDataSetConverter.getDataTable((Object)((StiJsonDatabase)db).getJSONObject(report)) : StiJsonToDataSetConverterV2.getDataSet((Object)((StiJsonDatabase)db).getJSONObject(report));
                    for (DataTable table : dataSet.getTables()) {
                        String name = category + "." + table.getName();
                        List datas = (List)result.get(category);
                        if (datas.contains(name)) continue;
                        datas.add(name);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    callbackResult.put("error", e.getClass() + " " + e.getMessage());
                    continue;
                }
            }
            try {
                StiJDBCDatabase jdb = (StiJDBCDatabase)db;
                StiAbstractAdapter adapter = StiDictionaryHelper.getAdapter(jdb.getConnectionString(), db.getClass().getName().substring(db.getClass().getName().lastIndexOf(46) + 1));
                Connection con = StiDictionaryHelper.getConnection(adapter.getJdbcParameters());
                StiDatabaseInformation information = db.getDatabaseInformation(con, adapter, report);
                for (DataTable table : information.getTables()) {
                    String name = category + "." + table.getName();
                    List datas = (List)result.get(category);
                    if (datas.contains(name)) continue;
                    datas.add(name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                callbackResult.put("error", e.getClass() + " " + e.getMessage());
            }
        }
        callbackResult.put("connections", result);
    }

    public static StiJDBCParameters getJDBCConnection(String connectionString, String connectionType) {
        return StiDictionaryHelper.getAdapter(connectionString, connectionType).getJdbcParameters();
    }

    public static StiAbstractAdapter getAdapter(String connectionString, String connectionType) {
        if ("StiJDBCDatabase".equals(connectionType)) {
            connectionType = "StiJdbcDatabase";
        }
        StiConnectionType type = StiConnectionType.valueOf((String)connectionType);
        switch (type) {
            case StiJdbcDatabase: {
                return new StiJdbcAdapter(connectionString);
            }
            case StiMySqlDatabase: {
                return new StiMySqlAdapter(connectionString);
            }
            case StiPostgreSQLDatabase: {
                return new StiPostgreSqlAdapter(connectionString);
            }
            case StiOracleDatabase: {
                return new StiOracleAdapter(connectionString);
            }
            case StiMsSqlDatabase: 
            case StiSqlDatabase: {
                return new StiMsSqlAdapter(connectionString);
            }
        }
        throw new IllegalArgumentException("This type of connection '" + type.name() + "' is not supported");
    }

    private static StiDataStoreSource saveDataSourceParam(StiDataStoreSource dataSourceWithParam, StiReport report, StiDataStoreSource dataSource, HashMap<String, Object> param) throws InstantiationException, IllegalAccessException, JSONException {
        if (dataSource == null) {
            return null;
        }
        ArrayList currColumns = (ArrayList)param.get("columns");
        ArrayList currParameters = (ArrayList)param.get("parameters");
        if (dataSourceWithParam == null) {
            dataSourceWithParam = (StiDataStoreSource)dataSource.getClass().newInstance();
            dataSourceWithParam.setDictionary(report.getDictionary());
        }
        StiDataColumnsCollection columns = new StiDataColumnsCollection();
        columns.addAll((Collection)dataSourceWithParam.getColumns());
        dataSourceWithParam.getColumns().clear();
        for (int i = 0; i < currColumns.size(); ++i) {
            HashMap columnProps = (HashMap)currColumns.get(i);
            Object column = (Boolean)columnProps.get("isCalcColumn") != false ? new StiCalcDataColumn() : new StiDataColumn();
            StiDictionaryHelper.applyColumnProps((StiDataColumn)column, columnProps);
            StiDataColumn cl = dataSourceWithParam.getColumns().get((String)columnProps.get("name"));
            if (cl == null) {
                dataSourceWithParam.getColumns().add((StiDataColumn)column);
                continue;
            }
            dataSourceWithParam.getColumns().add(cl);
        }
        if (dataSourceWithParam instanceof StiSqlSource) {
            StiDataParametersCollection parameters = new StiDataParametersCollection();
            parameters.addAll((Collection)dataSourceWithParam.getParameters());
            dataSourceWithParam.getParameters().clear();
            for (int i = 0; i < currParameters.size(); ++i) {
                StiDataParameter parameter = new StiDataParameter();
                StiDictionaryHelper.applyParameterProps(parameter, (HashMap)currParameters.get(i));
                StiDataParameter pr = dataSourceWithParam.getParameters().getByName(parameter.getName());
                if (pr == null) {
                    dataSourceWithParam.getParameters().add((Object)parameter);
                    continue;
                }
                dataSourceWithParam.getParameters().add((Object)pr);
            }
            ((StiSqlSource)dataSourceWithParam).setSqlCommand(StiEncodingHelper.decodeString((String)((String)param.get("sqlCommand"))));
            if (param.get("commandTimeout") != null) {
                ((StiSqlSource)dataSourceWithParam).setCommandTimeout(StiReportEdit.strToInt(param.get("commandTimeout")));
            }
            if ("Table".equals(param.get("type"))) {
                ((StiSqlSource)dataSourceWithParam).setType(StiSqlSourceType.Table);
            } else {
                ((StiSqlSource)dataSourceWithParam).setType(StiSqlSourceType.StoredProcedure);
            }
        }
        dataSourceWithParam.setNameInSource((String)param.get("nameInSource"));
        dataSourceWithParam.setName((String)param.get("name"));
        dataSourceWithParam.setAlias((String)param.get("alias"));
        if (dataSourceWithParam.getName().equals(dataSourceWithParam.getAlias())) {
            dataSourceWithParam.setAlias((String)param.get("name"));
        }
        dataSourceWithParam.setName((String)param.get("name"));
        return dataSourceWithParam;
    }

    private static boolean isCategoryVariable(StiVariable variable) {
        return StiValidationUtil.isNullOrEmpty((String)variable.getName()) && !StiValidationUtil.isNullOrEmpty((String)variable.getCategory());
    }

    public static String createTempSampleData(StiReport report) {
        String dataGuid = StiGuid.newGuid().toString();
        DataTable table = new DataTable(dataGuid);
        table.getColumns().add(new StiDataColumn("col1", "col1", StiSystemTypeEnum.SystemInt16.getSystemType()));
        table.getColumns().add(new StiDataColumn("col2", "col2", StiSystemTypeEnum.SystemInt16.getSystemType()));
        DataRow dr = table.NewRow();
        dr.addCell("col1", (Object)750);
        dr.addCell("col2", (Object)1000);
        table.getRows().add((Object)dr);
        return dataGuid;
    }

    public static void removeTempSampleData(StiReport report, String dataGuid) {
        if (report.getDictionary().getDataStore().contains((Object)dataGuid)) {
            report.getDictionary().getDataStore().remove((Object)report.getDictionary().getDataStore().get(dataGuid));
        }
        if (report.getDictionary().getDataSources().contains((Object)dataGuid)) {
            report.getDictionary().getDataSources().remove((Object)report.getDictionary().getDataSources().get(dataGuid));
        }
    }

    private static StiVariable getVariableCategory(StiReport report, String categoryName) {
        for (StiVariable variable : report.getDictionary().getVariables()) {
            if (!StiValidationUtil.equals((Object)variable.getCategory(), (Object)categoryName) || !"".equals(variable.getName())) continue;
            return variable;
        }
        return null;
    }

    private static String getUniqueName(StiReport report, StiDataType type, String baseName, String copyOfText, boolean isVariableCategories) {
        int index = 2;
        String name = baseName = baseName + copyOfText;
        while (!(type == StiDataType.Resource && !report.getDictionary().getResources().contains((Object)name) || type == StiDataType.DataSource && !report.getDictionary().getDataSources().contains((Object)name) || type == StiDataType.DataRelation && !report.getDictionary().getRelations().contains((Object)name) || type == StiDataType.Database && !report.getDictionary().getDatabases().contains((Object)name) || type == StiDataType.Variable && !report.getDictionary().getVariables().contains(name) && !isVariableCategories || type == StiDataType.Variable && !report.getDictionary().getVariables().containsCategory(name) && isVariableCategories)) {
            name = baseName + index++;
        }
        return name;
    }

    public static void duplicateDictionaryElement(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        block17: {
            try {
                StiDatabase element = null;
                StiDataType type = StiDataType.Total;
                HashMap itemObject = (HashMap)param.get("itemObject");
                String typeItem = (String)itemObject.get("typeItem");
                String itemName = (String)itemObject.get("name");
                String itemNameInSource = (String)itemObject.get("nameInSource");
                callbackResult.put("typeItem", typeItem);
                if ("Category".equals(typeItem)) {
                    StiVariable newVariable = new StiVariable(StiDictionaryHelper.getUniqueName(report, StiDataType.Variable, itemName, (String)param.get("locCopyOf"), true));
                    newVariable.setKey(StiKeyHelper.generateKey());
                    report.getDictionary().getVariables().add(newVariable);
                    callbackResult.put("variables", StiDictionaryHelper.getVariablesTree(report));
                    callbackResult.put("name", newVariable.getCategory());
                    return;
                }
                if ("DataBase".equals(typeItem)) {
                    element = report.getDictionary().getDatabases().get(itemName);
                    type = StiDataType.Database;
                } else if ("DataSource".equals(typeItem)) {
                    element = report.getDictionary().getDataSources().get(itemName);
                    type = StiDataType.DataSource;
                } else if ("Relation".equals(typeItem)) {
                    element = report.getDictionary().getRelations().get(itemNameInSource);
                    type = StiDataType.DataRelation;
                } else if ("Variable".equals(typeItem)) {
                    element = report.getDictionary().getVariables().get(itemName);
                    type = StiDataType.Variable;
                } else if ("Resource".equals(typeItem)) {
                    element = report.getDictionary().getResources().get(itemName);
                    type = StiDataType.Resource;
                }
                if (element == null) break block17;
                IStiName oldName = (IStiName)element;
                IStiAlias oldAlias = (IStiAlias)element;
                Object newElement = ((ICloneable)element).clone();
                IStiName newName = (IStiName)newElement;
                IStiAlias newAlias = (IStiAlias)newElement;
                newName.setName(StiDictionaryHelper.getUniqueName(report, type, oldName.getName(), (String)param.get("locCopyOf"), true));
                newAlias.setAlias(StiValidationUtil.equals((Object)oldName.getName(), (Object)oldAlias.getAlias()) ? newName.getName() : oldAlias.getAlias());
                if (type == StiDataType.Variable) {
                    StiVariable newVariable = (StiVariable)newElement;
                    report.getDictionary().getVariables().add(newVariable);
                    callbackResult.put("itemObject", StiDictionaryHelper.variableItem(newVariable));
                    callbackResult.put("variables", StiDictionaryHelper.getVariablesTree(report));
                    break block17;
                }
                if (type == StiDataType.DataSource) {
                    StiDataSource newDataSource = (StiDataSource)newElement;
                    report.getDictionary().getDataSources().add((Object)newDataSource);
                    newDataSource.setDictionary(report.getDictionary());
                    callbackResult.put("itemObject", StiDictionaryHelper.datasourceItem(newDataSource));
                    callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
                    break block17;
                }
                if (type == StiDataType.DataRelation) {
                    StiDataRelation newRelation = (StiDataRelation)newElement;
                    report.getDictionary().getRelations().add(newRelation);
                    callbackResult.put("itemObject", StiDictionaryHelper.relationItem(newRelation, new HashMap<String, Object>()));
                    callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
                    break block17;
                }
                if (type == StiDataType.Database) {
                    StiDatabase newDatabase = (StiDatabase)newElement;
                    report.getDictionary().getDatabases().add((Object)newDatabase);
                    callbackResult.put("itemObject", StiDictionaryHelper.databaseItem(newDatabase));
                    callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
                    break block17;
                }
                if (type == StiDataType.Resource) {
                    StiResource newResource = (StiResource)newElement;
                    report.getDictionary().getResources().add((Object)newResource);
                    callbackResult.put("itemObject", StiDictionaryHelper.resourceItem(newResource, report));
                    callbackResult.put("resources", StiDictionaryHelper.getResourcesTree(report));
                    break block17;
                }
                throw new StiException("The " + type + " is not supported in the StiActions.Dictionary.InvokeElementDuplicate method!");
            }
            catch (Exception ee) {
                LOG.severe(ee.getMessage());
                ee.printStackTrace();
            }
        }
    }

    private static void applyParametersToSqlSourse(StiSqlSource sqlSource, HashMap<String, Object> parameters) throws JSONException {
        for (String key : parameters.keySet()) {
            if (!key.startsWith("{") || !key.endsWith("}")) continue;
            while (sqlSource.getSqlCommand().indexOf(key) >= 0) {
                sqlSource.setSqlCommand(sqlSource.getSqlCommand().replace(key, StiEncodingHelper.decodeString((String)((String)parameters.get(key)))));
            }
        }
        for (StiDataParameter parameter : sqlSource.getParameters()) {
            if (!parameters.containsKey(parameter.getName())) continue;
            String text = StiEncodingHelper.decodeString((String)((String)parameters.get(parameter.getName())));
            parameter.setValue(text);
            try {
                int dbType = parameter.getType();
                if (dbType == 4 || dbType == 14 || dbType == 22 || dbType == 33) {
                    parameter.setParameterValue((Object)StiDateTime.Parse((String)text));
                    continue;
                }
                if (dbType == 0 || dbType == 19) {
                    parameter.setParameterValue((Object)Boolean.parseBoolean(text));
                    continue;
                }
                if (dbType == 3 || dbType == 13 || dbType == 21) {
                    parameter.setParameterValue((Object)text);
                    continue;
                }
                if (dbType == 8 || dbType == 9 || dbType == 10 || dbType == 1 || dbType == 11 || dbType == 15 || dbType == 16 || dbType == 17 || dbType == 20 || dbType == 27 || dbType == 28 || dbType == 29 || dbType == 30 || dbType == 31 || dbType == 35 || dbType == 36 || dbType == 34) {
                    parameter.setParameterValue((Object)Long.parseLong(text));
                    continue;
                }
                if (dbType == 5 || dbType == 24) {
                    parameter.setParameterValue((Object)new BigDecimal(text.replace(',', '.')));
                    continue;
                }
                if (dbType == 6 || dbType == 12 || dbType == 25 || dbType == 32) {
                    parameter.setParameterValue((Object)Double.parseDouble(text.replace(',', '.')));
                    continue;
                }
                if (dbType == 7 || dbType == 26) {
                    parameter.setParameterValue((Object)new StiGuid(text));
                    continue;
                }
                parameter.setParameterValue((Object)text);
            }
            catch (Exception e) {
                parameter.setParameterValue((Object)DBNull.getValue());
                if (StiOptions.Engine.logLevel < 10) continue;
                e.printStackTrace();
            }
        }
    }

    public static void retrieveColumns(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException, ClassNotFoundException, SQLException, StiException, InstantiationException, IllegalAccessException {
        StiDictionary dictionary = report.getDictionary();
        ArrayList<Object> columns = new ArrayList();
        ArrayList parameters = new ArrayList();
        StiDataStoreSource dataSource = null;
        StiDataStoreSource currentDataSource = null;
        Object adapter = null;
        String nameInSource = (String)param.get("nameInSource");
        String dataSourceName = "Edit".equals(param.get("mode")) && param.get("oldName") != null ? (String)param.get("oldName") : (String)param.get("name");
        currentDataSource = (StiDataStoreSource)dictionary.getDataSources().get(dataSourceName);
        if (currentDataSource == null) {
            currentDataSource = (StiDataStoreSource)StiDictionaryHelper.createDataAdapterByTypeName((String)param.get("typeDataAdapter"), new StiWebDesignerOptions(), dictionary, (String)param.get("nameInSource"));
        }
        dataSource = StiDictionaryHelper.saveDataSourceParam(dataSource, report, currentDataSource, param);
        if (nameInSource.trim().length() == 0) {
            dictionary.Disconnect();
            callbackResult.put("error", String.format(StiLocalization.Get((String)"Errors", (String)"FieldRequire").replaceAll("{0}", "%s"), StiLocalization.Get((String)"Report", (String)"LabelNameInSource")));
            return;
        }
        if (dataSource != null) {
            for (StiDatabase db : dictionary.getDatabases()) {
                String tableName;
                String sName;
                if (db instanceof StiXmlDatabase) {
                    try {
                        String string = sName = nameInSource.indexOf(".") >= 0 ? nameInSource.substring(0, nameInSource.lastIndexOf(".")) : nameInSource;
                        if (!db.getName().equalsIgnoreCase(sName)) continue;
                        tableName = nameInSource.substring(nameInSource.lastIndexOf(".") + 1);
                        InputStream is = ((StiXmlDatabase)db).getSchemaInputStream(report);
                        StiXmlTableFieldsRequest request = StiDataColumnsUtil.parceXSDSchema((InputStream)is);
                        for (StiXmlTable table : request.getTables()) {
                            if (!table.getName().equals(tableName)) continue;
                            columns = StiDictionaryHelper.getColumnsTree2(table.getColumns());
                        }
                        is.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        callbackResult.put("error", e.getClass() + " " + e.getMessage());
                    }
                    continue;
                }
                if (db instanceof StiJsonDatabase) {
                    try {
                        String string = sName = nameInSource.indexOf(".") >= 0 ? nameInSource.substring(0, nameInSource.lastIndexOf(".")) : nameInSource;
                        if (!db.getName().equalsIgnoreCase(sName)) continue;
                        tableName = nameInSource.substring(nameInSource.lastIndexOf(".") + 1);
                        DataSet dataSet = StiBaseOptions.getDefaultJsonConverterVersion() == StiJsonConverterVersion.ConverterV1 ? StiJsonToDataSetConverter.getDataTable((Object)((StiJsonDatabase)db).getJSONObject(report)) : StiJsonToDataSetConverterV2.getDataSet((Object)((StiJsonDatabase)db).getJSONObject(report));
                        for (DataTable table : dataSet.getTables()) {
                            if (!table.getName().equals(tableName)) continue;
                            columns = StiDictionaryHelper.getColumnsTree2(table.getColumns());
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        callbackResult.put("error", e.getClass() + " " + e.getMessage());
                        continue;
                    }
                }
                if (!db.getName().toLowerCase().equals(nameInSource.toLowerCase())) continue;
                try {
                    StiSqlSource sqlSource = (StiSqlSource)dataSource;
                    sqlSource.setSqlCommand(StiEncodingHelper.decodeString((String)((String)param.get("sqlCommand"))));
                    sqlSource.setType(StiSqlSourceType.valueOf((String)((String)param.get("type"))));
                    if (param.containsKey("parametersValues") && param.get("parametersValues") != null) {
                        StiDictionaryHelper.applyParametersToSqlSourse(sqlSource, (HashMap)param.get("parametersValues"));
                    }
                    if (param.containsKey("onlyParameters") && param.get("parametersValues") != null) continue;
                    StiJDBCDatabase jdb = (StiJDBCDatabase)db;
                    String connectionsString = sqlSource.getSqlCommand();
                    Connection con = StiDictionaryHelper.getConnection(StiDictionaryHelper.getJDBCConnection(jdb.getConnectionString(), db.getClass().getName().substring(db.getClass().getName().lastIndexOf(46) + 1)));
                    StiTableFieldsRequest request = StiDataColumnsUtil.getFields((Connection)con, (String)connectionsString, (StiDataSource)dataSource);
                    List fields = request.getColumns();
                    for (StiSqlField field : fields) {
                        String baseName;
                        if (!StiValidationUtil.isNullOrEmpty((String)field.getName())) continue;
                        String columnName = baseName = StiLocalization.Get((String)"PropertyMain", (String)"Column");
                        int index = 1;
                        boolean contains = true;
                        while (true) {
                            contains = false;
                            for (StiSqlField field2 : fields) {
                                if (!StiValidationUtil.equals((Object)field2.getName(), (Object)columnName)) continue;
                                contains = true;
                            }
                            if (!contains) break;
                            columnName = baseName + index++;
                        }
                        field.setName(columnName);
                    }
                    columns = StiDictionaryHelper.getColumnsTree2(fields);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    callbackResult.put("error", e.getClass() + " " + e.getMessage());
                }
            }
        }
        if (report.handlerDesignerEvents != null) {
            try {
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("event", "RetrieveColumns");
                eventParams.put("inputParam", param);
                eventParams.put("report", report);
                eventParams.put("columns", columns);
                eventParams.put("parameters", parameters);
                report.handlerDesignerEvents.invoke(new StiEventObject(eventParams));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        callbackResult.put("columns", columns);
        callbackResult.put("parameters", parameters);
    }

    public static Connection getConnection(StiJDBCParameters param) throws ClassNotFoundException, SQLException {
        Class.forName(param.getDriverName());
        Properties info = new Properties();
        if (param.getUser() != null) {
            info.setProperty("user", param.getUser());
        }
        if (param.getPassword() != null) {
            info.setProperty("password", param.getPassword());
        }
        if (param.isDefaultEncoding()) {
            info.setProperty("useUnicode", "true");
            info.setProperty("characterEncoding", StiConstants.ENCODING.value);
        }
        info.putAll((Map<?, ?>)param.getOther());
        return DriverManager.getConnection(param.getConnectionURL(), param.getUser(), param.getPassword());
    }

    public static void getDatabaseData(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        StiDatabase db = report.getDictionary().getDatabases().get((String)param.get("databaseName"));
        StiDictionaryHelper.getDatabaseData(db, callbackResult, report);
    }

    public static void getDatabaseData(StiDatabase db, HashMap<String, Object> callbackResult, StiReport report) {
        block12: {
            if (db != null) {
                try {
                    StiDatabaseInformation information = null;
                    if (db instanceof StiXmlDatabase || db instanceof StiJsonDatabase) {
                        try {
                            information = db.getDatabaseInformation(null, null, report);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            callbackResult.put("error", e.getClass() + " " + e.getMessage());
                        }
                    } else {
                        StiJDBCDatabase jdb = (StiJDBCDatabase)db;
                        if (StiValidationUtil.isNullOrEmpty((String)jdb.getConnectionString())) {
                            callbackResult.put("data", "{}");
                            return;
                        }
                        StiAbstractAdapter adapter = StiDictionaryHelper.getAdapter(jdb.getConnectionString(), db.getClass().getName().substring(db.getClass().getName().lastIndexOf(46) + 1));
                        Connection con = StiDictionaryHelper.getConnection(adapter.getJdbcParameters());
                        information = db.getDatabaseInformation(con, adapter, report);
                    }
                    if (information != null) {
                        HashMap<String, Object> info = StiDictionaryHelper.getAjaxDataFromDatabaseInformation(information);
                        if (report.handlerDesignerEvents != null) {
                            try {
                                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                                eventParams.put("event", "GetDatabaseData");
                                eventParams.put("database", db);
                                eventParams.put("report", report);
                                eventParams.put("info", info);
                                report.handlerDesignerEvents.invoke(new StiEventObject(eventParams));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        callbackResult.put("data", info);
                        break block12;
                    }
                    callbackResult.put("data", "{}");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    callbackResult.put("data", "{}");
                    callbackResult.put("error", e.getClass() + " " + e.getMessage());
                }
            }
        }
    }

    public static void applySelectedData(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        ArrayList data = (ArrayList)param.get("data");
        String databaseName = (String)param.get("databaseName");
        StiDatabase database = report.getDictionary().getDatabases().get(databaseName);
        if (database != null && data.size() > 0) {
            try {
                StiDatabaseInformation info = StiDictionaryHelper.convertAjaxDatabaseInfoToDatabaseInfo(data, false);
                StiDatabaseInformation allInfo = StiDictionaryHelper.convertAjaxDatabaseInfoToDatabaseInfo(data, true);
                database.applyDatabaseInformation(info, report, allInfo);
                for (int i = 0; i < data.size(); ++i) {
                    HashMap dataSourceObject = (HashMap)data.get(i);
                    if (dataSourceObject.get("relations") == null) continue;
                    ArrayList relations = (ArrayList)dataSourceObject.get("relations");
                    for (int j = 0; j < relations.size(); ++j) {
                        HashMap relationObject = (HashMap)relations.get(j);
                        StiDataRelation relation = new StiDataRelation();
                        report.getDictionary().getRelations().add(relation);
                        StiDictionaryHelper.applyRelationProps(report, relation, relationObject);
                    }
                }
                callbackResult.put("dictionary", StiDictionaryHelper.getDictionaryTree(report));
                if (data != null && data.size() > 0) {
                    callbackResult.put("selectedDataSource", data.get(data.size() - 1));
                }
                callbackResult.put("databaseName", databaseName);
            }
            catch (Exception e) {
                e.printStackTrace();
                callbackResult.put("error", e.getClass() + " " + e.getMessage());
            }
        }
    }

    public static void testConnection(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult, StiWebDesignerOptions options) throws JSONException, InstantiationException, IllegalAccessException {
        try {
            String typeConnection = (String)param.get("typeConnection");
            String connectionString = StiEncodingHelper.decodeString((String)((String)param.get("connectionString")));
            StiDatabase db = StiDictionaryHelper.createDataBaseByTypeName(typeConnection, options);
            if (db instanceof StiJDBCDatabase) {
                StiAbstractAdapter adapter = StiDictionaryHelper.getAdapter(connectionString, db.getClass().getName().substring(db.getClass().getName().lastIndexOf(46) + 1));
                Connection con = StiDictionaryHelper.getConnection(adapter.getJdbcParameters());
                ((StiJDBCDatabase)db).testConnection(con, adapter);
            } else if (db instanceof StiXmlDatabase) {
                if (((StiXmlDatabase)db).getDataInputStream(report) == null) {
                    callbackResult.put("testResult", StiLocalization.getValue((String)"DesignerFx", (String)"ConnectionError"));
                }
            } else if (db instanceof StiJsonDatabase && ((StiJsonDatabase)db).getJSONObject(report) == null) {
                callbackResult.put("testResult", StiLocalization.getValue((String)"DesignerFx", (String)"ConnectionError"));
            }
        }
        catch (Exception e) {
            callbackResult.put("testResult", StiLoggingUtil.getHtmlError((String)"", (Exception)e));
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return;
        }
        callbackResult.put("testResult", StiLocalization.getValue((String)"DesignerFx", (String)"ConnectionSuccessfull"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runQueryScript(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        block8: {
            StiDictionary dictionary = report.getDictionary();
            StiDataStoreSource dataSource = null;
            StiDataStoreSource currentDataSource = null;
            try {
                String dataSourceName = "Edit".equals(param.get("mode")) && param.get("oldName") != null ? (String)param.get("oldName") : (String)param.get("name");
                currentDataSource = (StiDataStoreSource)dictionary.getDataSources().get(dataSourceName);
                if (currentDataSource == null) {
                    currentDataSource = (StiDataStoreSource)StiDictionaryHelper.createDataStoreSourceFromParams(report, param, dictionary);
                }
                dataSource = StiDictionaryHelper.saveDataSourceParam(dataSource, report, currentDataSource, param);
                if (param.containsKey("parametersValues") && param.get("parametersValues") != null && dataSource instanceof StiSqlSource) {
                    StiDictionaryHelper.applyParametersToSqlSourse((StiSqlSource)dataSource, (HashMap)param.get("parametersValues"));
                }
                if (dataSource == null) break block8;
                if (StiValidationUtil.isNullOrEmpty((String)dataSource.getNameInSource())) {
                    callbackResult.put("resultQueryScript", StiLocalization.format((String)"Errors", (String)"FieldRequire", (Object[])new Object[]{StiLocalization.Get((String)"Report", (String)"LabelNameInSource")}));
                    return;
                }
                try {
                    dataSource.setDictionary(dictionary);
                    dataSource.connect();
                    callbackResult.put("resultQueryScript", "successfully");
                }
                finally {
                    dataSource.disconnect();
                    dictionary.Disconnect();
                }
            }
            catch (Exception ee) {
                callbackResult.put("resultQueryScript", ee.getMessage() != null ? ee.getMessage() : ee.getCause());
                ee.printStackTrace();
            }
        }
    }

    private static StiDataSource createDataStoreSourceFromParams(StiReport report, HashMap param, StiDictionary dictionary) throws IllegalArgumentException, JSONException, IllegalAccessException, InvocationTargetException, InstantiationException {
        StiDataSource dataSource = StiDictionaryHelper.createDataAdapterByTypeName((String)param.get("typeDataAdapter"), new StiWebDesignerOptions(), dictionary, (String)param.get("nameInSource"));
        if (dataSource != null) {
            dataSource.setDictionary(report.getDictionary());
            StiDictionaryHelper.applyDataSourceProperties(dataSource, param, report);
        }
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void viewData(StiReport report, HashMap param, HashMap callbackResult) {
        StiDictionary dictionary = report.getDictionary();
        StiDataStoreSource currentDataSource = null;
        StiDataStoreSource dataSource = null;
        try {
            if ("Edit".equals(param.get("mode"))) {
                currentDataSource = (StiDataStoreSource)dictionary.getDataSources().get((String)param.get("name"));
            }
            if (currentDataSource == null) {
                currentDataSource = (StiDataStoreSource)StiDictionaryHelper.createDataStoreSourceFromParams(report, param, dictionary);
            }
            if ((dataSource = StiDictionaryHelper.saveDataSourceParam(dataSource, report, currentDataSource, param)) != null) {
                dataSource.setDictionary(dictionary);
                if (param.containsKey("parametersValues") && param.get("parametersValues") != null && dataSource instanceof StiSqlSource) {
                    StiDictionaryHelper.applyParametersToSqlSourse((StiSqlSource)dataSource, (HashMap)param.get("parametersValues"));
                }
                dataSource.connect();
                StiViewDataHelper viewDataHelper = new StiViewDataHelper((StiDataSource)dataSource);
                DataTable dataTable = viewDataHelper.ResultDataTable;
                ArrayList resultData = new ArrayList();
                ArrayList<StiDataColumn> dictionaryColumns = new ArrayList<StiDataColumn>();
                ArrayList<String> captions = new ArrayList<String>();
                for (int k = 0; k < dataTable.getColumns().size(); ++k) {
                    StiDataColumn dictionaryColumn = dataSource.getColumns().get(((StiDataColumn)dataTable.getColumns().get(k)).getName());
                    captions.add(((StiDataColumn)dataTable.getColumns().get(k)).getName());
                    dictionaryColumns.add(dictionaryColumn);
                }
                resultData.add(captions);
                for (int i = 0; i < dataTable.getRows().size(); ++i) {
                    ArrayList<HashMap<String, String>> rowArray = new ArrayList<HashMap<String, String>>();
                    resultData.add(rowArray);
                    for (int k = 0; k < dataTable.getColumns().size(); ++k) {
                        rowArray.add(StiDictionaryHelper.getViewDataItemValue(((DataRow)dataTable.getRows().get(i)).getValue(k), (StiDataColumn)dictionaryColumns.get(k)));
                    }
                }
                callbackResult.put("resultData", resultData);
                callbackResult.put("dataSourceName", dataSource.getName());
            }
        }
        catch (Exception e) {
            callbackResult.put("error", e.getMessage() != null ? e.getMessage() : "Error " + e.getCause().toString());
            e.printStackTrace();
        }
        finally {
            dataSource.disconnect();
        }
    }

    public static HashMap<String, String> getViewDataItemValue(Object item, StiDataColumn dictionaryColumn) {
        HashMap<String, String> resultItem = new HashMap<String, String>();
        String type = dictionaryColumn != null ? dictionaryColumn.getClass().getName() : (item != null ? item.getClass().getName() : "");
        resultItem.put("type", type);
        if (item instanceof byte[]) {
            resultItem.put("value", String.format("data:image;base64,%s", new Object[]{StiBase64DecoderUtil.decode((byte[])((byte[])item))}));
        }
        if (item instanceof StiImage) {
            resultItem.put("value", String.format("data:image;base64,%s", new Object[]{StiBase64DecoderUtil.decode((String)((StiImage)item).getImageBytes())}));
        } else {
            resultItem.put("value", item != null ? item.toString() : "");
        }
        return resultItem;
    }

    public static StiDatabase createNewDatabaseFromResource(StiReport report, StiResource resource) {
        if (resource.getType() == StiResourceType.Json) {
            return new StiJsonDatabase();
        }
        if (resource.getType() == StiResourceType.Xml) {
            return new StiXmlDatabase();
        }
        return null;
    }

    public static String getNewDatabaseName(StiReport report, String fileName) {
        String baseName = fileName.trim();
        int counter = 1;
        while (true) {
            String testName;
            String string = testName = counter == 1 ? baseName : baseName + counter;
            if (!StiDictionaryHelper.isExistInDatabases(report, testName)) {
                return testName;
            }
            ++counter;
        }
    }

    public static void getSqlParameterTypes(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws InstantiationException, IllegalAccessException, JSONException {
        String typeDataSource = (String)((HashMap)param.get("dataSource")).get("typeDataSource");
        StiDataSource dataSource = null;
        for (Class<? extends StiDataSource> source : new StiWebDesignerOptions().getDataSources()) {
            if (!source.getName().endsWith(typeDataSource)) continue;
            dataSource = source.newInstance();
        }
        if (dataSource != null && dataSource instanceof StiSqlSource) {
            callbackResult.put("sqlParameterTypes", StiDictionaryHelper.getDataParameterTypes((StiSqlSource)dataSource));
        }
    }

    public static void createFieldOnDblClick(StiReport report, HashMap<String, Object> param, HashMap callbackResult) throws Exception {
        Iterator parameters;
        StiDataColumn column = null;
        StiDataParameter parameter = null;
        StiDataSource dataSource = null;
        StiDataBand dataBand = null;
        StiDataBand firstDataBand = null;
        StiDataBand selectedDataBand = null;
        StiPage currentPage = report.getPages().get((String)param.get("pageName"));
        ArrayList selectedComponentNames = (ArrayList)param.get("selectedComponents");
        ArrayList<HashMap<String, Object>> newComponents = new ArrayList<HashMap<String, Object>>();
        double zoom = StiReportEdit.strToDouble((String)param.get("zoom"));
        if (param.containsKey("columnName") && param.get("columnName") != null) {
            StiDataColumnsCollection columns = StiDictionaryHelper.getColumnsByTypeAndNameOfObject(report, param);
            if (columns != null) {
                column = columns.get((String)param.get("columnName"));
            }
            if (column != null) {
                dataSource = column.getDataSource();
            }
        } else if (param.containsKey("parameterName") && param.get("parameterName") != null && (dataSource = report.getDictionary().getDataSources().get((String)param.get("currentParentName"))) != null && (parameters = dataSource.getParameters()) != null) {
            parameter = parameters.getByName((String)param.get("parameterName"));
        }
        for (StiComponent component : currentPage.GetComponents()) {
            component.setIsSelected(false);
        }
        for (int i = 0; i < selectedComponentNames.size(); ++i) {
            String componentName = (String)selectedComponentNames.get(i);
            StiComponent component = report.GetComponentByName(componentName);
            if (component == null) continue;
            component.select();
        }
        ArrayList<StiDataBand> selectedDataBands = new ArrayList<StiDataBand>();
        StiComponentsCollection comps = currentPage.GetComponents();
        for (StiComponent component : comps) {
            StiDataBand band = component instanceof StiDataBand ? (StiDataBand)component : null;
            if (band == null) continue;
            if (firstDataBand == null) {
                firstDataBand = band;
            }
            if (selectedDataBand == null && band.getIsSelected()) {
                selectedDataBand = band;
            }
            if (band.getDataSource() != dataSource) continue;
            selectedDataBands.add(band);
        }
        if (selectedDataBands.size() > 0) {
            for (StiDataBand band : selectedDataBands) {
                if (dataBand == null) {
                    dataBand = band;
                    continue;
                }
                if (dataBand.getIsSelected() || !band.getIsSelected()) continue;
                dataBand = band;
                break;
            }
        }
        if (dataBand == null) {
            dataBand = selectedDataBand != null ? selectedDataBand : firstDataBand;
        }
        if (dataBand != null) {
            StiStyle style = new StiStyle();
            double posX = 0.0;
            for (StiComponent comp : dataBand.getComponents()) {
                if (!(posX < comp.getRight())) continue;
                posX = comp.getRight();
                if (comp instanceof IStiIgnoryStyle) continue;
                style = StiBaseStyle.getStyle((StiComponent)comp);
            }
            double width = StiAlignValue.alignToMaxGrid((double)(dataBand.width / 8.0), (double)currentPage.getGridSize(), (boolean)true);
            StiRectangle rect = new StiRectangle(posX, 0.0, width, dataBand.getHeight());
            StiText newComp = null;
            if (column != null && (column.getType() == StiSystemTypeEnum.SystemDrawingImage || column.getType() == StiSystemTypeEnum.SystemDrawingBitmap)) {
                newComp = new StiImage(rect);
                ((StiImage)newComp).setDataColumn(column.getColumnPath());
            } else {
                newComp = new StiText(rect);
                newComp.setText((String)param.get("fullName"));
                newComp.setType(StiSystemTextType.DataColumn);
            }
            if (!(newComp instanceof IStiIgnoryStyle)) {
                if (param.containsKey("lastStyleProperties") && param.get("lastStyleProperties") != null) {
                    StiReportEdit.setAllProperties((StiComponent)newComp, (ArrayList)param.get("lastStyleProperties"));
                } else {
                    style.SetStyleToComponent((StiComponent)newComp);
                }
            }
            dataBand.getComponents().add((StiComponent)newComp);
            newComponents.add(StiReportEdit.getComponentMainProperties((StiComponent)newComp, zoom));
            StiDataBandV1Builder builder = new StiDataBandV1Builder();
            StiComponentsCollection headers = builder.getHeaders(dataBand);
            for (StiComponent cmp : headers) {
                StiHeaderBand header = (StiHeaderBand)cmp;
                posX = 0.0;
                for (StiComponent comp : header.getComponents()) {
                    if (!(posX < comp.getRight())) continue;
                    posX = comp.getRight();
                    if (comp instanceof IStiIgnoryStyle) continue;
                    style = StiBaseStyle.getStyle((StiComponent)comp);
                }
                StiText text = new StiText(rect);
                text.setHeight(header.getHeight());
                text.setHorAlignment(StiTextHorAlignment.Center);
                if (!(text instanceof IStiIgnoryStyle)) {
                    style.SetStyleToComponent((StiComponent)text);
                }
                if (column != null) {
                    text.setText(column.getAlias());
                } else {
                    String str = parameter.getName();
                    if (str.startsWith("@")) {
                        str = str.substring(1);
                    }
                    text.setText(str);
                }
                header.getComponents().add((StiComponent)text);
                newComponents.add(StiReportEdit.getComponentMainProperties((StiComponent)text, zoom));
            }
        }
        callbackResult.put("pageName", currentPage.getName());
        callbackResult.put("newComponents", newComponents);
        callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, currentPage));
    }

    public static void getParamsFromQueryString(StiReport report, HashMap param, HashMap callbackResult) {
        StiSqlSource dataSource;
        StiDataSource ds = report.getDictionary().getDataSources().get((String)param.get("dataSourceName"));
        StiSqlSource stiSqlSource = dataSource = ds instanceof StiSqlSource ? (StiSqlSource)ds : null;
        if (dataSource != null) {
            String queryString = StiEncodingHelper.decodeString((String)((String)param.get("queryString")));
            List exps = dataSource.getAllowExpressions() ? StiCodeDomExpressionHelper.getLexem((String)queryString) : new ArrayList();
            ArrayList<String> parameters = new ArrayList<String>();
            for (String value : exps) {
                if (!value.startsWith("{") || !value.endsWith("}")) continue;
                parameters.add(value);
            }
            callbackResult.put("params", parameters);
        }
    }

    public static void getSampleConnectionString(StiReport report, HashMap param, HashMap callbackResult, StiWebDesignerOptions options) throws InstantiationException, IllegalAccessException {
        String typeConnection = (String)param.get("typeConnection");
        StiDatabase database = StiDictionaryHelper.createDataBaseByTypeName(typeConnection, options);
        if (database instanceof StiJDBCDatabase) {
            callbackResult.put("connectionString", ((StiJDBCDatabase)database).createSqlConnector().getSampleConnectionString());
        }
    }

    public static void createDatabaseFromResource(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        HashMap resourceProps = (HashMap)param.get("resourceObject");
        StiResource resource = new StiResource();
        report.getDictionary().getResources().add((Object)resource);
        StiDictionaryHelper.applyResourceProps(report, resource, resourceProps);
        callbackResult.put("resourceItemObject", StiDictionaryHelper.resourceItem(resource, report));
        callbackResult.put("resources", StiDictionaryHelper.getResourcesTree(report));
        StiDatabase database = StiDictionaryHelper.createNewDatabaseFromResource(report, resource);
        if (database != null) {
            database.setName(StiDictionaryHelper.getNewDatabaseName(report, resource.getName()));
            database.setAlias(database.getName());
            if (database instanceof StiJsonDatabase) {
                ((StiJsonDatabase)database).setPathData("resource://" + resource.getName());
            } else if (database instanceof StiXmlDatabase) {
                ((StiXmlDatabase)database).setPathData("resource://" + resource.getName());
            }
            report.getDictionary().getDatabases().add((Object)database);
            database.createDataSources(report.getDictionary());
            callbackResult.put("newDataBaseName", database.getName());
            callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
        }
    }

    public static void deleteAllDataSources(StiReport report, HashMap param, HashMap callbackResult) {
        if (param.containsKey("dataSources") && param.get("dataSources") != null) {
            ArrayList dataSources = (ArrayList)param.get("dataSources");
            for (HashMap dataSourceObject : dataSources) {
                StiDatabase database;
                StiDatabase dataStore;
                StiDataSource dataSource = report.getDictionary().getDataSources().get((String)dataSourceObject.get("name"));
                String connectionName = dataSource.GetCategoryName();
                if (dataSource == null || (!param.containsKey("connectionName") || param.get("connectionName") == null) && !StiValidationUtil.equals((Object)connectionName, param.get("connectionName"))) continue;
                report.getDictionary().getDataSources().remove((Object)dataSource);
                if (dataSourceObject.containsKey("nameInSource") && (dataStore = report.getDictionary().getDataStore().get((String)dataSourceObject.get("nameInSource"))) != null) {
                    report.getDictionary().getDataStore().remove((Object)dataStore);
                }
                if (StiValidationUtil.isNullOrEmpty((String)connectionName) || (database = report.getDictionary().getDatabases().get(connectionName)) == null) continue;
                boolean allowDelete = true;
                for (StiDataSource dataSource_ : report.getDictionary().getDataSources()) {
                    if (!StiValidationUtil.equals((Object)dataSource_.GetCategoryName(), (Object)connectionName)) continue;
                    allowDelete = false;
                    break;
                }
                if (!allowDelete) continue;
                report.getDictionary().getDatabases().remove((Object)database);
            }
        } else {
            report.getDictionary().getDataSources().clear();
            report.getDictionary().getDatabases().clear();
            report.getDictionary().getDataStore().clear();
        }
        callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
    }

    public static void getVariableItemsFromDataColumn(StiReport report, HashMap param, HashMap callbackResult) {
        report.getDictionary().connect(false, null);
        ArrayList items = new ArrayList();
        Object[] keys = StiDataColumn.GetDatasFromDataColumn((StiDictionary)report.getDictionary(), (String)((String)param.get("keysColumn")));
        Object[] values = StiDataColumn.GetDatasFromDataColumn((StiDictionary)report.getDictionary(), (String)((String)param.get("valuesColumn")));
        if (keys != null || values != null) {
            int maxLength = Math.max(keys.length, values.length);
            for (int index = 0; index < maxLength; ++index) {
                Hashtable<String, String> item = new Hashtable<String, String>();
                item.put("key", index < keys.length ? (String)keys[index] : "");
                item.put("value", index < values.length ? (String)values[index] : "");
                items.add(item);
            }
        }
        report.getDictionary().Disconnect();
        callbackResult.put("items", items);
    }

    public static void moveDictionaryItem(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        HashMap fromObject = (HashMap)param.get("fromObject");
        HashMap toObject = (HashMap)param.get("toObject");
        String direction = (String)param.get("direction");
        if (fromObject != null && toObject != null) {
            StiDataColumnsCollection columns;
            String typeItem = (String)fromObject.get("typeItem");
            if ("Variable".equals(typeItem) || "Category".equals(typeItem)) {
                StiVariable toVariable;
                StiVariable fromVariable = "Category".equals(fromObject.get("typeItem")) ? StiDictionaryHelper.getVariableCategory(report, (String)fromObject.get("name")) : report.getDictionary().getVariables().get((String)fromObject.get("name"));
                StiVariable stiVariable = toVariable = "Category".equals(toObject.get("typeItem")) ? StiDictionaryHelper.getVariableCategory(report, (String)toObject.get("name")) : report.getDictionary().getVariables().get((String)toObject.get("name"));
                if (toVariable == null && !StiValidationUtil.equals(toObject.get("typeItem"), (Object)"VariablesMainItem") || fromVariable == null || fromVariable == toVariable) {
                    return;
                }
                if ("VariablesMainItem".equals(toObject.get("typeItem"))) {
                    fromVariable.setCategory("");
                    report.getDictionary().getVariables().add(fromVariable);
                    callbackResult.put("moveCompleted", true);
                } else if (!StiDictionaryHelper.isCategoryVariable(fromVariable) && !StiDictionaryHelper.isCategoryVariable(toVariable)) {
                    int fromIndex = report.getDictionary().getVariables().indexOf((Object)fromVariable);
                    int toIndex = report.getDictionary().getVariables().indexOf((Object)toVariable);
                    report.getDictionary().getVariables().remove((Object)fromVariable);
                    int toIndex2 = report.getDictionary().getVariables().indexOf((Object)toVariable);
                    if (fromIndex < toIndex) {
                        report.getDictionary().getVariables().add(toIndex2 + 1, (Object)fromVariable);
                    } else {
                        report.getDictionary().getVariables().add(toIndex2, (Object)fromVariable);
                    }
                    fromVariable.setCategory(toVariable.getCategory());
                    callbackResult.put("moveCompleted", true);
                } else if (!StiDictionaryHelper.isCategoryVariable(fromVariable) && StiDictionaryHelper.isCategoryVariable(toVariable)) {
                    int index = report.getDictionary().getVariables().getLastCategoryIndex(toVariable.getCategory());
                    report.getDictionary().getVariables().remove((Object)fromVariable);
                    if (index + 1 < report.getDictionary().getVariables().size()) {
                        report.getDictionary().getVariables().add(index + 1, (Object)fromVariable);
                    } else {
                        report.getDictionary().getVariables().add(fromVariable);
                    }
                    fromVariable.setCategory(toVariable.getCategory());
                    callbackResult.put("moveCompleted", true);
                } else if (StiDictionaryHelper.isCategoryVariable(fromVariable) && StiDictionaryHelper.isCategoryVariable(toVariable)) {
                    report.getDictionary().getVariables().moveCategoryTo(fromVariable.getCategory(), toVariable.getCategory());
                    callbackResult.put("moveCompleted", true);
                } else {
                    int index = report.getDictionary().getVariables().indexOf((Object)toVariable);
                    report.getDictionary().getVariables().remove((Object)fromVariable);
                    report.getDictionary().getVariables().add(index, (Object)fromVariable);
                    if (!StiDictionaryHelper.isCategoryVariable(fromVariable)) {
                        fromVariable.setCategory(toVariable.getCategory());
                    }
                    callbackResult.put("moveCompleted", true);
                }
            } else if ("DataSource".equals(typeItem)) {
                StiDataSource fromDataSource = report.getDictionary().getDataSources().get((String)fromObject.get("name"));
                StiDataSource toDataSource = report.getDictionary().getDataSources().get((String)toObject.get("name"));
                if (fromDataSource != null && toDataSource != null) {
                    StiDataRelationsCollection relations = new StiDataRelationsCollection(report.getDictionary());
                    for (StiDataRelation relation : report.getDictionary().getRelations()) {
                        if (relation.getParentSource() != fromDataSource && relation.getChildSource() != fromDataSource) continue;
                        relations.add(0, (Object)relation);
                    }
                    int index = report.getDictionary().getDataSources().indexOf((Object)toDataSource);
                    report.getDictionary().getDataSources().remove((Object)fromDataSource);
                    report.getDictionary().getDataSources().add(index, (Object)fromDataSource);
                    if (relations.size() > 0) {
                        for (StiDataRelation relation : relations) {
                            report.getDictionary().getRelations().add(relation);
                        }
                        relations.clear();
                    }
                    callbackResult.put("moveCompleted", true);
                }
            } else if ("Column".equals(typeItem) && (columns = StiDictionaryHelper.getColumnsByTypeAndNameOfObject(report, param)) != null) {
                StiDataColumn fromColumn = columns.get((String)fromObject.get("name"));
                StiDataColumn toColumn = columns.get((String)toObject.get("name"));
                if (toColumn == null || fromColumn == null || fromColumn == toColumn) {
                    return;
                }
                int index = columns.indexOf((Object)toColumn);
                columns.remove((Object)fromColumn);
                columns.add(index, (Object)fromColumn);
                callbackResult.put("moveCompleted", true);
            }
            callbackResult.put("direction", direction);
            callbackResult.put("fromObject", param.get("fromObject"));
            callbackResult.put("toObject", param.get("toObject"));
            callbackResult.put("variablesTree", StiDictionaryHelper.getVariablesTree(report));
            callbackResult.put("databases", StiDictionaryHelper.getDataBasesTree(report));
        }
    }

    public static void moveConnectionDataToResource(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        try {
            String[] propertyNames = new String[]{"pathSchema", "pathData"};
            String typeConnection = (String)param.get("typeConnection");
            for (String propertyName : propertyNames) {
                String path = (String)param.get(propertyName);
                if (StiValidationUtil.isNullOrEmpty((String)path) || (path = StiEncodingHelper.decodeString((String)path)).toLowerCase().startsWith("resource://")) continue;
                String resName = StiNameCreation.createResourceName((StiReport)report, (String)path.substring(0, path.lastIndexOf(".")));
                StiResourceType type = StiResourceTypeHelper.getTypeFromExtension((String)path.substring(path.lastIndexOf(".")).toLowerCase());
                if (type == null) continue;
                File file = new File(path);
                if (file.length() > (long)EngineOptions.ReportResources.MaximumSize) {
                    callbackResult.put("error", StiLocalization.Get((String)"Notices", (String)"QuotaMaximumFileSizeExceeded"));
                    return;
                }
                byte[] content = null;
                try {
                    content = StiIOUtil.toByteArray((InputStream)new URI(path).toURL().openStream());
                }
                catch (Exception e) {
                    try {
                        content = StiIOUtil.toByteArray((InputStream)new FileInputStream(path));
                    }
                    catch (Exception e2) {
                        callbackResult.put("error", e.getMessage() + "\n" + e2.getMessage());
                    }
                }
                StiResource resource = new StiResource(resName, resName, type, content);
                report.getDictionary().getResources().add((Object)resource);
                callbackResult.put(propertyName, "resource://" + resName);
            }
            callbackResult.put("resourcesTree", StiDictionaryHelper.getResourcesTree(report));
        }
        catch (Exception e) {
            callbackResult.put("error", e.getMessage());
            e.printStackTrace();
        }
    }

    public static class StiSortDataTableComparer
    implements Comparator<DataTable> {
        @Override
        public int compare(DataTable x, DataTable y) {
            if (x.getTableName() == null) {
                if (y.getTableName() == null) {
                    return 0;
                }
                return -1;
            }
            if (y.getTableName() == null) {
                return 1;
            }
            return y.getTableName().compareTo(y.getTableName());
        }
    }
}

