/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.core.styles.StiCustomStyleCoreXF;
import com.stimulsoft.report.chart.enums.StiShowSeriesLabels;
import com.stimulsoft.report.chart.interfaces.IStiChart;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.constantLines.IStiConstantLines;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.strips.IStiStrips;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.areas.StiArea;
import com.stimulsoft.report.chart.view.areas.StiAxisArea;
import com.stimulsoft.report.chart.view.conditions.StiChartCondition;
import com.stimulsoft.report.chart.view.conditions.StiChartConditionsCollection;
import com.stimulsoft.report.chart.view.constantLines.StiConstantLines;
import com.stimulsoft.report.chart.view.filter.StiChartFilter;
import com.stimulsoft.report.chart.view.filter.StiChartFiltersCollection;
import com.stimulsoft.report.chart.view.series.StiSeries;
import com.stimulsoft.report.chart.view.series.bubble.StiBubbleSeries;
import com.stimulsoft.report.chart.view.series.candlestick.StiCandlestickSeries;
import com.stimulsoft.report.chart.view.series.clusteredBar.StiClusteredBarSeries;
import com.stimulsoft.report.chart.view.series.clusteredColumn.StiAreaSeries;
import com.stimulsoft.report.chart.view.series.clusteredColumn.StiBaseLineSeries;
import com.stimulsoft.report.chart.view.series.clusteredColumn.StiClusteredColumnSeries;
import com.stimulsoft.report.chart.view.series.clusteredColumn.StiLineSeries;
import com.stimulsoft.report.chart.view.series.clusteredColumn.StiSplineAreaSeries;
import com.stimulsoft.report.chart.view.series.clusteredColumn.StiSplineSeries;
import com.stimulsoft.report.chart.view.series.clusteredColumn.StiSteppedAreaSeries;
import com.stimulsoft.report.chart.view.series.clusteredColumn.StiSteppedLineSeries;
import com.stimulsoft.report.chart.view.series.doughnut.StiDoughnutSeries;
import com.stimulsoft.report.chart.view.series.fullStackedBar.StiFullStackedBarSeries;
import com.stimulsoft.report.chart.view.series.fullStackedColumn.StiFullStackedAreaSeries;
import com.stimulsoft.report.chart.view.series.fullStackedColumn.StiFullStackedColumnSeries;
import com.stimulsoft.report.chart.view.series.fullStackedColumn.StiFullStackedLineSeries;
import com.stimulsoft.report.chart.view.series.fullStackedColumn.StiFullStackedSplineAreaSeries;
import com.stimulsoft.report.chart.view.series.fullStackedColumn.StiFullStackedSplineSeries;
import com.stimulsoft.report.chart.view.series.funnel.StiFunnelSeries;
import com.stimulsoft.report.chart.view.series.gantt.StiGanttSeries;
import com.stimulsoft.report.chart.view.series.pie.StiPieSeries;
import com.stimulsoft.report.chart.view.series.radar.StiRadarAreaSeries;
import com.stimulsoft.report.chart.view.series.radar.StiRadarLineSeries;
import com.stimulsoft.report.chart.view.series.radar.StiRadarPointSeries;
import com.stimulsoft.report.chart.view.series.radar.StiRadarSeries;
import com.stimulsoft.report.chart.view.series.range.StiRangeBarSeries;
import com.stimulsoft.report.chart.view.series.range.StiRangeSeries;
import com.stimulsoft.report.chart.view.series.range.StiSplineRangeSeries;
import com.stimulsoft.report.chart.view.series.range.StiSteppedRangeSeries;
import com.stimulsoft.report.chart.view.series.scatter.StiScatterLineSeries;
import com.stimulsoft.report.chart.view.series.scatter.StiScatterSeries;
import com.stimulsoft.report.chart.view.series.scatter.StiScatterSplineSeries;
import com.stimulsoft.report.chart.view.series.stackedBar.StiStackedBarSeries;
import com.stimulsoft.report.chart.view.series.stackedColumn.StiStackedAreaSeries;
import com.stimulsoft.report.chart.view.series.stackedColumn.StiStackedBaseLineSeries;
import com.stimulsoft.report.chart.view.series.stackedColumn.StiStackedColumnSeries;
import com.stimulsoft.report.chart.view.series.stackedColumn.StiStackedLineSeries;
import com.stimulsoft.report.chart.view.series.stackedColumn.StiStackedSplineAreaSeries;
import com.stimulsoft.report.chart.view.series.stackedColumn.StiStackedSplineSeries;
import com.stimulsoft.report.chart.view.series.stock.StiStockSeries;
import com.stimulsoft.report.chart.view.seriesLabels.StiNoneLabels;
import com.stimulsoft.report.chart.view.seriesLabels.StiSeriesLabels;
import com.stimulsoft.report.chart.view.seriesLabels.axis.StiCenterAxisLabels;
import com.stimulsoft.report.chart.view.seriesLabels.axis.StiInsideBaseAxisLabels;
import com.stimulsoft.report.chart.view.seriesLabels.axis.StiInsideEndAxisLabels;
import com.stimulsoft.report.chart.view.seriesLabels.axis.StiLeftAxisLabels;
import com.stimulsoft.report.chart.view.seriesLabels.axis.StiOutsideAxisLabels;
import com.stimulsoft.report.chart.view.seriesLabels.axis.StiOutsideBaseAxisLabels;
import com.stimulsoft.report.chart.view.seriesLabels.axis.StiOutsideEndAxisLabels;
import com.stimulsoft.report.chart.view.seriesLabels.axis.StiRightAxisLabels;
import com.stimulsoft.report.chart.view.seriesLabels.axis.StiValueAxisLabels;
import com.stimulsoft.report.chart.view.seriesLabels.funnel.StiCenterFunnelLabels;
import com.stimulsoft.report.chart.view.seriesLabels.funnel.StiOutsideLeftFunnelLabels;
import com.stimulsoft.report.chart.view.seriesLabels.funnel.StiOutsideRightFunnelLabels;
import com.stimulsoft.report.chart.view.seriesLabels.pie.StiCenterPieLabels;
import com.stimulsoft.report.chart.view.seriesLabels.pie.StiInsideEndPieLabels;
import com.stimulsoft.report.chart.view.seriesLabels.pie.StiOutsidePieLabels;
import com.stimulsoft.report.chart.view.seriesLabels.pie.StiTwoColumnsPieLabels;
import com.stimulsoft.report.chart.view.strips.StiStrips;
import com.stimulsoft.report.chart.view.styles.StiChartStyle;
import com.stimulsoft.report.chart.view.styles.StiCustomStyle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentHelper;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiFilterCondition;
import com.stimulsoft.report.components.enums.StiFilterDataType;
import com.stimulsoft.report.components.enums.StiFilterItem;
import com.stimulsoft.report.components.enums.StiFilterMode;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.service.helper.StiChartSvgHelper;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.web.helper.StiEncodingHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiChartHelper {
    static Class<? extends StiSeriesLabels>[] SERIES_LABELS = new Class[]{StiNoneLabels.class, StiInsideBaseAxisLabels.class, StiInsideEndAxisLabels.class, StiCenterAxisLabels.class, StiOutsideBaseAxisLabels.class, StiOutsideEndAxisLabels.class, StiOutsideAxisLabels.class, StiLeftAxisLabels.class, StiValueAxisLabels.class, StiRightAxisLabels.class, StiCenterFunnelLabels.class, StiOutsideRightFunnelLabels.class, StiOutsideLeftFunnelLabels.class, StiInsideEndPieLabels.class, StiCenterPieLabels.class, StiOutsidePieLabels.class, StiTwoColumnsPieLabels.class};
    static Class<? extends StiSeries>[] SERIES = new Class[]{StiBubbleSeries.class, StiCandlestickSeries.class, StiClusteredBarSeries.class, StiAreaSeries.class, StiBaseLineSeries.class, StiClusteredColumnSeries.class, StiLineSeries.class, StiSplineAreaSeries.class, StiSplineSeries.class, StiSteppedAreaSeries.class, StiSteppedLineSeries.class, StiDoughnutSeries.class, StiFullStackedBarSeries.class, StiFullStackedAreaSeries.class, StiFullStackedColumnSeries.class, StiFullStackedLineSeries.class, StiFullStackedSplineAreaSeries.class, StiFullStackedSplineSeries.class, StiFunnelSeries.class, StiGanttSeries.class, StiPieSeries.class, StiRadarAreaSeries.class, StiRadarLineSeries.class, StiRadarPointSeries.class, StiRadarSeries.class, StiRangeBarSeries.class, StiRangeSeries.class, StiSplineRangeSeries.class, StiSteppedRangeSeries.class, StiScatterLineSeries.class, StiScatterSeries.class, StiScatterSplineSeries.class, StiStackedBarSeries.class, StiStackedAreaSeries.class, StiStackedBaseLineSeries.class, StiStackedColumnSeries.class, StiStackedLineSeries.class, StiStackedSplineAreaSeries.class, StiStackedSplineSeries.class, StiStockSeries.class};

    public static HashMap<String, Object> getChartProperties(StiChart chart) throws ParserConfigurationException, IOException, TransformerException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", chart.getName());
        properties.put("series", StiChartHelper.getSeriesArray(chart));
        properties.put("chartImage", StiChartHelper.getChartSampleImage(chart, 400, 400, 1.0f));
        properties.put("typesCollection", StiChartHelper.getTypesCollection(chart));
        properties.put("area", StiChartHelper.getArea(chart));
        properties.put("style", StiChartHelper.getStyle(chart));
        properties.put("labels", StiChartHelper.getLabels(chart.getSeriesLabels()));
        properties.put("properties", StiChartHelper.getMainProperties(chart));
        properties.put("constantLines", StiChartHelper.getConstantLines(chart));
        properties.put("strips", StiChartHelper.getStrips(chart));
        properties.put("conditions", StiChartHelper.getConditions(chart.getSeriesLabelsConditions()));
        return properties;
    }

    public static List<HashMap<String, Object>> getSeriesArray(StiChart chart) {
        ArrayList<HashMap<String, Object>> seriesArray = new ArrayList<HashMap<String, Object>>();
        for (IStiSeries series : chart.getSeries()) {
            seriesArray.add(StiChartHelper.getSeries(series));
        }
        return seriesArray;
    }

    public static HashMap<String, Object> getSeries(IStiSeries series) {
        HashMap<String, Object> seriesObject = new HashMap<String, Object>();
        seriesObject.put("name", series.getCoreTitle() + " [" + series.toString() + "]");
        seriesObject.put("type", series.getClass().getName());
        try {
            seriesObject.put("properties", StiChartHelper.getSeriesProperties(series));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        seriesObject.put("labels", StiChartHelper.getLabels(series.getSeriesLabels()));
        seriesObject.put("conditions", StiChartHelper.getConditions(series.getConditions()));
        seriesObject.put("filters", StiChartHelper.getFilters(series.getFilters()));
        return seriesObject;
    }

    public static List<HashMap<String, Object>> getConditions(StiChartConditionsCollection conditions) {
        ArrayList<HashMap<String, Object>> conditionsArray = new ArrayList<HashMap<String, Object>>();
        for (StiChartCondition condition : conditions) {
            HashMap<String, Object> propertiesCondition = new HashMap<String, Object>();
            propertiesCondition.put("FieldIs", condition.getItem());
            propertiesCondition.put("Value", StiEncodingHelper.encode((String)condition.getValue()));
            propertiesCondition.put("Color", StiReportEdit.getStringFromColor(condition.getColor()));
            propertiesCondition.put("DataType", condition.getDataType());
            propertiesCondition.put("Condition", condition.getCondition());
            conditionsArray.add(propertiesCondition);
        }
        return conditionsArray;
    }

    public static List<HashMap<String, Object>> getFilters(StiChartFiltersCollection filters) {
        ArrayList<HashMap<String, Object>> filtersArray = new ArrayList<HashMap<String, Object>>();
        for (StiChartFilter filter : filters) {
            HashMap<String, Object> propertiesFilter = new HashMap<String, Object>();
            propertiesFilter.put("FieldIs", filter.getItem());
            propertiesFilter.put("DataType", filter.getDataType());
            propertiesFilter.put("Value", StiEncodingHelper.encode((String)filter.getValue()));
            propertiesFilter.put("Condition", filter.getCondition());
            filtersArray.add(propertiesFilter);
        }
        return filtersArray;
    }

    public static List<String> getTypesCollection(StiChart chart) {
        Class[] types;
        ArrayList<String> typesCollection = new ArrayList<String>();
        for (Class type : types = chart.getArea() != null ? chart.getArea().GetSeriesTypes() : new Class[]{}) {
            typesCollection.add(type.getName());
        }
        return typesCollection;
    }

    public static HashMap<String, Object> getArea(StiChart chart) {
        HashMap<String, Object> area = new HashMap<String, Object>();
        if (chart.getArea() != null) {
            area.put("type", chart.getArea().getClass().getName().substring(chart.getArea().getClass().getName().lastIndexOf(46) + 1));
            try {
                area.put("properties", StiChartHelper.getAreaProperties((StiArea)chart.getArea()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return area;
    }

    public static HashMap<String, Object> getStyle(StiChart chart) {
        HashMap<String, Object> style = new HashMap<String, Object>();
        style.put("type", chart.getStyle().getClass().getName().substring(chart.getStyle().getClass().getName().lastIndexOf(46) + 1));
        style.put("name", chart.getStyle() instanceof StiCustomStyle && ((StiCustomStyleCoreXF)chart.getStyle().getCore()).getReportStyle() != null ? ((StiCustomStyleCoreXF)chart.getStyle().getCore()).getReportStyle().getName() : "");
        return style;
    }

    public static HashMap<String, Object> getMainProperties(StiChart chart) {
        String[] propNamesTable;
        String[] propNamesTitle;
        String[] propNamesLegend;
        String[] propNamesCommon;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Object> propertiesCommon = new HashMap<String, Object>();
        for (String propName : propNamesCommon = new String[]{"AllowApplyStyle", "ProcessAtEnd", "Rotation", "HorSpacing", "VertSpacing", "DataSource", "BusinessObject", "DataRelation", "MasterComponent", "CountData", "Filters", "Sort"}) {
            Object value = StiReportEdit.getPropertyValue(propName, chart);
            if (value == null) continue;
            propertiesCommon.put(propName, value);
        }
        properties.put("Common", propertiesCommon);
        HashMap<String, Object> propertiesLegend = new HashMap<String, Object>();
        for (String propName : propNamesLegend = new String[]{"AllowApplyStyle", "BorderColor", "Brush", "Columns", "Direction", "Font", "HideSeriesWithEmptyTitle", "HorAlignment", "HorSpacing", "LabelsColor", "MarkerAlignment", "MarkerBorder", "MarkerSize", "MarkerVisible", "ShowShadow", "Title", "TitleColor", "TitleFont", "VertAlignment", "VertSpacing", "Visible"}) {
            Object value = StiReportEdit.getPropertyValue(propName, chart.getLegend());
            if (value == null) continue;
            propertiesLegend.put(propName, value);
        }
        properties.put("Legend", propertiesLegend);
        HashMap<String, Object> propertiesTitle = new HashMap<String, Object>();
        for (String propName : propNamesTitle = new String[]{"Alignment", "AllowApplyStyle", "Antialiasing", "Brush", "Dock", "Font", "Spacing", "Text", "Visible"}) {
            Object value = StiReportEdit.getPropertyValue(propName, chart.getTitle());
            if (value == null) continue;
            propertiesTitle.put(propName, value);
        }
        properties.put("Title", propertiesTitle);
        HashMap<String, Object> propertiesTable = new HashMap<String, Object>();
        for (String propName : propNamesTable = new String[]{"AllowApplyStyle", "Font", "GridLineColor", "GridLinesHor", "GridLinesVert", "GridOutline", "MarkerVisible", "Visible", "Header.TextAfter", "Header.TextColor", "Header.WordWrap", "Header.Brush", "Header.Font", "DataCells.TextColor", "DataCells.ShrinkFontToFit", "DataCells.ShrinkFontToFitMinimumSize", "DataCells.Font"}) {
            Object value = StiReportEdit.getPropertyValue(propName, chart.getTable());
            if (value == null) continue;
            propertiesTable.put(propName, value);
        }
        properties.put("Table", propertiesTable);
        return properties;
    }

    public static List<HashMap<String, Object>> getConstantLines(StiChart chart) {
        ArrayList<HashMap<String, Object>> constantLinesArray = new ArrayList<HashMap<String, Object>>();
        for (IStiConstantLines constantLine : chart.getConstantLines()) {
            HashMap<String, Object> constantLineObj = new HashMap<String, Object>();
            constantLineObj.put("name", constantLine.getText());
            constantLineObj.put("properties", StiChartHelper.getConstantLineProperties(constantLine));
            constantLinesArray.add(constantLineObj);
        }
        return constantLinesArray;
    }

    public static HashMap<String, Object> getConstantLineProperties(IStiConstantLines constantLine) {
        String[] propNames;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String propName : propNames = new String[]{"AxisValue", "LineColor", "LineStyle", "LineWidth", "Orientation", "ShowBehind", "Visible", "AllowApplyStyle", "Antialiasing", "Font", "Position", "Text", "TitleVisible"}) {
            Object value = StiReportEdit.getPropertyValue(propName, constantLine);
            if (value == null) continue;
            properties.put(propName, value);
        }
        return properties;
    }

    public static List<HashMap<String, Object>> getStrips(StiChart chart) {
        ArrayList<HashMap<String, Object>> stripsArray = new ArrayList<HashMap<String, Object>>();
        for (IStiStrips strip : chart.getStrips()) {
            HashMap<String, Object> stripObj = new HashMap<String, Object>();
            stripObj.put("name", strip.getText());
            stripObj.put("properties", StiChartHelper.getStripsProperties(strip));
            stripsArray.add(stripObj);
        }
        return stripsArray;
    }

    public static HashMap<String, Object> getStripsProperties(IStiStrips strip) {
        String[] propNames;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String propName : propNames = new String[]{"AllowApplyStyle", "MaxValue", "MinValue", "Orientation", "ShowBehind", "StripBrush", "Visible", "Antialiasing", "Font", "Text", "TitleColor", "TitleVisible"}) {
            Object value = StiReportEdit.getPropertyValue(propName, strip);
            if (value == null) continue;
            properties.put(propName, value);
        }
        return properties;
    }

    public static HashMap<String, Object> getLabels(IStiSeriesLabels seriesLabels) {
        HashMap<String, Object> labels = new HashMap<String, Object>();
        if (seriesLabels != null) {
            labels.put("type", seriesLabels.getClass().getName());
            labels.put("properties", StiChartHelper.getLabelsProperties((StiSeriesLabels)seriesLabels));
        }
        return labels;
    }

    public static HashMap<String, Object> getSeriesProperties(IStiSeries series) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method piTopN;
        HashMap<String, Object> properties;
        block20: {
            Method piTrendLine;
            block19: {
                Method piInteraction;
                block18: {
                    String[] markerGroups;
                    String[] propNamesCommon;
                    properties = new HashMap<String, Object>();
                    HashMap<String, Object> propertiesCommon = new HashMap<String, Object>();
                    for (String propName : propNamesCommon = new String[]{"ValueDataColumn", "Value", "ListOfValues", "ValueDataColumnEnd", "ValueEnd", "ListOfValuesEnd", "ValueDataColumnClose", "ValueClose", "ListOfValuesClose", "ValueDataColumnHigh", "ValueHigh", "ListOfValuesHigh", "ValueDataColumnLow", "ValueLow", "ListOfValuesLow", "ValueDataColumnOpen", "ValueOpen", "ListOfValuesOpen", "WeightDataColumn", "Weight", "ListOfWeights", "ArgumentDataColumn", "Argument", "ListOfArguments", "Format", "SortBy", "SortDirection", "AutoSeriesKeyDataColumn", "AutoSeriesColorDataColumn", "AutoSeriesTitleDataColumn", "BorderColor", "BorderWidth", "Brush", "BrushNegative", "ShowShadow", "AllowApplyStyle", "AllowApplyBrushNegative", "AllowApplyColorNegative", "ShowInLegend", "ShowSeriesLabels", "ShowZeros", "Title", "Width", "YAxis", "LabelsOffset", "Lighting", "LineColor", "LineColorNegative", "LineStyle", "LineWidth", "ShowNulls", "PointAtCenter", "Tension", "TopmostLine", "AllowApplyBorderColor", "AllowApplyBrush", "Diameter", "CutPieList", "StartAngle", "Distance", "Icon"}) {
                        Object object = StiReportEdit.getPropertyValue(propName, series);
                        if (object == null) continue;
                        propertiesCommon.put(propName, object);
                    }
                    properties.put("Common", propertiesCommon);
                    for (String string : markerGroups = new String[]{"Marker", "LineMarker"}) {
                        String[] propNamesMarker;
                        Method piMarkerGroup;
                        block17: {
                            piMarkerGroup = null;
                            try {
                                piMarkerGroup = series.getClass().getMethod("get" + string, new Class[0]);
                            }
                            catch (Exception e) {
                                if (StiOptions.Engine.logLevel < 10) break block17;
                                e.printStackTrace();
                            }
                        }
                        if (piMarkerGroup == null || !StiChartHelper.isBrowsable(piMarkerGroup)) continue;
                        HashMap<String, Object> propertiesMarker = new HashMap<String, Object>();
                        for (String propName : propNamesMarker = new String[]{"Angle", "BorderColor", "Brush", "ShowInLegend", "Size", "Step", "Type", "Visible"}) {
                            Object value = StiReportEdit.getPropertyValue(propName, piMarkerGroup.invoke((Object)series, new Object[0]));
                            if (value == null) continue;
                            propertiesMarker.put(propName, value);
                        }
                        properties.put(string, propertiesMarker);
                    }
                    piInteraction = null;
                    try {
                        piInteraction = series.getClass().getMethod("getInteraction", new Class[0]);
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel < 10) break block18;
                        e.printStackTrace();
                    }
                }
                if (piInteraction != null && StiChartHelper.isBrowsable(piInteraction)) {
                    String[] propNamesInteraction;
                    HashMap<String, Object> propertiesInteraction = new HashMap<String, Object>();
                    for (String propName : propNamesInteraction = new String[]{"AllowSeries", "AllowSeriesElements", "DrillDownEnabled", "DrillDownPage", "DrillDownReport", "HyperlinkDataColumn", "TagDataColumn", "ToolTipDataColumn", "Hyperlink", "Tag", "ToolTip", "ListOfHyperlinks", "ListOfTags", "ListOfToolTips"}) {
                        Object value = StiReportEdit.getPropertyValue(propName, piInteraction.invoke((Object)series, new Object[0]));
                        if (value == null) continue;
                        propertiesInteraction.put(propName, value);
                    }
                    properties.put("Interaction", propertiesInteraction);
                }
                piTrendLine = null;
                try {
                    piTrendLine = series.getClass().getMethod("getTrendLine", new Class[0]);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block19;
                    e.printStackTrace();
                }
            }
            if (piTrendLine != null && StiChartHelper.isBrowsable(piTrendLine)) {
                String[] stringArray;
                HashMap<String, Object> propertiesTrendLine = new HashMap<String, Object>();
                for (String propName : stringArray = new String[]{"LineColor", "LineStyle", "LineWidth", "ShowShadow"}) {
                    Object value = StiReportEdit.getPropertyValue(propName, piTrendLine.invoke((Object)series, new Object[0]));
                    if (value == null) continue;
                    propertiesTrendLine.put(propName, value);
                }
                properties.put("TrendLine", propertiesTrendLine);
            }
            piTopN = null;
            try {
                piTopN = series.getClass().getMethod("getTopN", new Class[0]);
            }
            catch (Exception exception) {
                if (StiOptions.Engine.logLevel < 10) break block20;
                exception.printStackTrace();
            }
        }
        if (piTopN != null && StiChartHelper.isBrowsable(piTopN)) {
            String[] propNamesTopN;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String propName : propNamesTopN = new String[]{"Count", "Mode", "OthersText", "ShowOthers"}) {
                Object value = StiReportEdit.getPropertyValue(propName, piTopN.invoke((Object)series, new Object[0]));
                if (value == null) continue;
                hashMap.put(propName, value);
            }
            properties.put("TopN", hashMap);
        }
        return properties;
    }

    public static HashMap<String, Object> getAreaProperties(StiArea area) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String[] interlacingTypes;
        String[] gridLinesTypes;
        String[] axisTypes;
        String[] propNamesCommon;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Object> propertiesCommon = new HashMap<String, Object>();
        for (String propName : propNamesCommon = new String[]{"Brush", "AllowApplyStyle", "BorderColor", "ColorEach", "RadarStyle", "ReverseHor", "ReverseVert", "ShowShadow"}) {
            Object value = StiReportEdit.getPropertyValue(propName, area);
            if (value == null) continue;
            propertiesCommon.put(propName, value);
        }
        properties.put("Common", propertiesCommon);
        for (String axisType : axisTypes = new String[]{"XAxis", "YAxis", "XTopAxis", "YRightAxis"}) {
            String[] propAxisNames;
            Method piAxis;
            block13: {
                piAxis = null;
                try {
                    piAxis = area.getClass().getMethod("get" + axisType, new Class[0]);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block13;
                    e.printStackTrace();
                }
            }
            if (piAxis == null || !StiChartHelper.isBrowsable(piAxis)) continue;
            HashMap<String, Object> propertiesAxis = new HashMap<String, Object>();
            for (String propName : propAxisNames = new String[]{"AllowApplyStyle", "ArrowStyle", "DateTimeStep.Interpolation", "DateTimeStep.NumberOfValues", "DateTimeStep.Step", "Interaction.RangeScrollEnabled", "Interaction.ShowScrollBar", "Labels.Brush", "Labels.AllowApplyStyle", "Labels.Angle", "Labels.Antialiasing", "Labels.Color", "Labels.DrawBorder", "Labels.Font", "Labels.Format", "Labels.RotationLabels", "Labels.Placement", "Labels.Step", "Labels.TextAfter", "Labels.TextAlignment", "Labels.TextBefore", "Labels.Width", "Labels.WordWrap", "LineColor", "LineStyle", "LineWidth", "LogarithmicScale", "Range.Auto", "Range.Minimum", "Range.Maximum", "ShowEdgeValues", "ShowXAxis", "StartFromZero", "Ticks.Length", "Ticks.LengthUnderLabels", "Ticks.MinorCount", "Ticks.MinorLength", "Ticks.MinorVisible", "Ticks.Step", "Ticks.Visible", "Title.Alignment", "Title.AllowApplyStyle", "Title.Antialiasing", "Title.Color", "Title.Direction", "Title.Font", "Title.Text", "Visible"}) {
                Object value = StiReportEdit.getPropertyValue(propName, piAxis.invoke((Object)area, new Object[0]));
                if (value == null) continue;
                propertiesAxis.put(propName, value);
            }
            properties.put(axisType, propertiesAxis);
        }
        for (String gridLinesType : gridLinesTypes = new String[]{"GridLinesHor", "GridLinesHorRight", "GridLinesVert"}) {
            String[] propGridLinesNames;
            Method piGridLines;
            block14: {
                piGridLines = null;
                try {
                    piGridLines = area.getClass().getMethod("get" + gridLinesType, new Class[0]);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block14;
                    e.printStackTrace();
                }
            }
            if (piGridLines == null || !StiChartHelper.isBrowsable(piGridLines)) continue;
            HashMap<String, Object> propertiesGridLines = new HashMap<String, Object>();
            for (String propName : propGridLinesNames = new String[]{"AllowApplyStyle", "Color", "MinorColor", "MinorCount", "MinorStyle", "MinorVisible", "Style", "Visible"}) {
                Object value = StiReportEdit.getPropertyValue(propName, piGridLines.invoke((Object)area, new Object[0]));
                if (value == null) continue;
                propertiesGridLines.put(propName, value);
            }
            properties.put(gridLinesType, propertiesGridLines);
        }
        for (String interlacingType : interlacingTypes = new String[]{"InterlacingHor", "InterlacingVert"}) {
            String[] propInterlacingNames;
            Method piInterlacing;
            block15: {
                piInterlacing = null;
                try {
                    piInterlacing = area.getClass().getMethod("get" + interlacingType, new Class[0]);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block15;
                    e.printStackTrace();
                }
            }
            if (piInterlacing == null || !StiChartHelper.isBrowsable(piInterlacing)) continue;
            HashMap<String, Object> propertiesInterlacing = new HashMap<String, Object>();
            for (String propName : propInterlacingNames = new String[]{"AllowApplyStyle", "InterlacedBrush", "Visible"}) {
                Object value = StiReportEdit.getPropertyValue(propName, piInterlacing.invoke((Object)area, new Object[0]));
                if (value == null) continue;
                propertiesInterlacing.put(propName, value);
            }
            properties.put(interlacingType, propertiesInterlacing);
        }
        return properties;
    }

    public static HashMap<String, Object> getLabelsProperties(StiSeriesLabels labels) {
        String[] propNamesCommon;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Object> propertiesCommon = new HashMap<String, Object>();
        for (String propName : propNamesCommon = new String[]{"AllowApplyStyle", "Angle", "Antialiasing", "DrawBorder", "BorderColor", "Brush", "Font", "Format", "LabelColor", "LineColor", "LegendValueType", "LineLength", "MarkerAlignment", "MarkerSize", "MarkerVisible", "PreventIntersection", "ShowInPercent", "ShowNulls", "ShowZeros", "Step", "TextAfter", "TextBefore", "UseSeriesColor", "ValueType", "ValueTypeSeparator", "Visible", "Width", "WordWrap"}) {
            Object value = StiReportEdit.getPropertyValue(propName, labels);
            if (value == null) continue;
            propertiesCommon.put(propName, value);
        }
        properties.put("Common", propertiesCommon);
        return properties;
    }

    private static void setConditionsValue(StiChartConditionsCollection conditions, ArrayList<HashMap<String, Object>> conditionValues) throws JSONException {
        conditions.clear();
        for (HashMap<String, Object> conditionValue : conditionValues) {
            StiChartCondition condition = new StiChartCondition();
            if (conditionValue.get("FieldIs") != null) {
                condition.setItem(StiFilterItem.valueOf((String)((String)conditionValue.get("FieldIs"))));
            }
            if (conditionValue.get("DataType") != null) {
                condition.setDataType(StiFilterDataType.valueOf((String)((String)conditionValue.get("DataType"))));
            }
            if (conditionValue.get("Condition") != null) {
                condition.setCondition(StiFilterCondition.valueOf((String)((String)conditionValue.get("Condition"))));
            }
            if (conditionValue.get("Color") != null) {
                condition.setColor(StiReportEdit.strToColor((String)conditionValue.get("Color")));
            }
            if (conditionValue.get("Value") != null) {
                condition.setValue(StiEncodingHelper.decodeString((String)((String)conditionValue.get("Value"))));
            }
            conditions.add((Object)condition);
        }
    }

    private static void setFiltersValue(StiChartFiltersCollection filters, ArrayList<HashMap<String, Object>> filterValues) throws JSONException {
        filters.clear();
        for (int i = 0; i < filterValues.size(); ++i) {
            HashMap<String, Object> filterValue = filterValues.get(i);
            StiChartFilter filter = new StiChartFilter();
            if (filterValue.get("FieldIs") != null) {
                filter.setItem(StiFilterItem.valueOf((String)((String)filterValue.get("FieldIs"))));
            }
            if (filterValue.get("DataType") != null) {
                filter.setDataType(StiFilterDataType.valueOf((String)((String)filterValue.get("DataType"))));
            }
            if (filterValue.get("Condition") != null) {
                filter.setCondition(StiFilterCondition.valueOf((String)((String)filterValue.get("Condition"))));
            }
            if (filterValue.get("Value") != null) {
                filter.setValue(StiEncodingHelper.decodeString((String)((String)filterValue.get("Value"))));
            }
            filters.add((Object)filter);
        }
    }

    private static boolean isBrowsable(Method p) {
        boolean res = true;
        return res;
    }

    public static String getChartSampleImage(StiChart chart, int width, int height, float zoom) throws ParserConfigurationException, IOException, TransformerException {
        StiSvgExportService.StiSvgHelper.StiSvgData svgData = new StiSvgExportService.StiSvgHelper.StiSvgData();
        svgData.X = 0.0;
        svgData.Y = 0.0;
        svgData.Width = width;
        svgData.Height = height;
        svgData.Component = chart;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element svg = doc.createElement("svg");
        doc.appendChild(svg);
        svg.setAttribute("version", "1.1");
        svg.setAttribute("baseProfile", "full");
        svg.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        svg.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        svg.setAttribute("xmlns:ev", "http://www.w3.org/2001/xml-events");
        svg.setAttribute("height", String.valueOf(svgData.Height));
        svg.setAttribute("width", String.valueOf(svgData.Width));
        StiChartSvgHelper.writeChart((Element)svg, (StiSvgExportService.StiSvgHelper.StiSvgData)svgData, (double)zoom, (Boolean)false, (Document)doc);
        return StiXmlHelper.serialize((Document)doc);
    }

    private static void addDefaultSeries(StiChart chart) throws InstantiationException, IllegalAccessException {
        Class<?> seriesType = chart.getSeries().size() > 0 ? ((IStiSeries)chart.getSeries().get(0)).getClass() : chart.getArea().GetDefaultSeriesType();
        chart.getSeries().clear();
        StiSeries series = (StiSeries)seriesType.newInstance();
        series.setShowShadow(false);
        chart.getSeries().add((IStiSeries)series);
        if (!(series instanceof StiFunnelSeries)) {
            series = (StiSeries)seriesType.newInstance();
            chart.getSeries().add((IStiSeries)series);
            series.setShowShadow(false);
        }
        chart.getSeries().applyStyle(chart.getStyle());
    }

    public static StiChart cloneChart(StiChart chart) throws InstantiationException, IllegalAccessException {
        StiChart chartCloned = (StiChart)StiComponentHelper.clone((StiComponent)chart);
        chartCloned.getLegend().setVisible(false);
        chartCloned.getSeriesLabels().setVisible(false);
        IStiArea area = chartCloned.getArea();
        if (area != null && area instanceof StiAxisArea) {
            ((StiAxisArea)area).getAxisCore().SwitchOff();
        }
        StiChartHelper.addDefaultSeries(chartCloned);
        chartCloned.getTitle().setVisible(false);
        chartCloned.getConstantLines().clear();
        chartCloned.getStrips().clear();
        chartCloned.getCore().applyStyle(chartCloned.getStyle());
        chartCloned.setBrush((StiBrush)new StiEmptyBrush());
        chartCloned.getArea().setBrush((StiBrush)new StiEmptyBrush());
        StiReport report = StiReport.newInstance();
        chartCloned.setPage(report.pages.get(0));
        chartCloned.setParent((StiContainer)report.pages.get(0));
        return chartCloned;
    }

    private static void addUserChartStyles(StiReport report, List<StiChartStyle> chartStyles) {
        for (StiBaseStyle style : report.getStyles()) {
            if (!(style instanceof com.stimulsoft.report.styles.StiChartStyle)) continue;
            StiCustomStyle customStyle = new StiCustomStyle(style.getName());
            customStyle.getCustomCore().ReportChartStyle = (com.stimulsoft.report.styles.StiChartStyle)style;
            chartStyles.add((StiChartStyle)customStyle);
        }
    }

    private static List<StiChartStyle> getChartStyles(StiReport report) {
        ArrayList<StiChartStyle> chartStyles = new ArrayList<StiChartStyle>();
        StiChartHelper.addUserChartStyles(report, chartStyles);
        for (StiChartStyle style : StiOptions.Services.getChartStyles()) {
            chartStyles.add(style);
        }
        Collections.reverse(chartStyles);
        return chartStyles;
    }

    private static String findClass(String shortName, List<String> fullNames, Class<?>[] classes) {
        if (fullNames != null) {
            for (String className : fullNames) {
                if (!className.endsWith(shortName)) continue;
                return className;
            }
        } else {
            for (Class<?> className : classes) {
                if (!className.getName().endsWith(shortName)) continue;
                return className.getName();
            }
        }
        return shortName;
    }

    public static void addSeries(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws ParserConfigurationException, IOException, TransformerException {
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        if (component == null) {
            return;
        }
        StiChart chart = (StiChart)component;
        String seriesType = (String)param.get("seriesType");
        try {
            StiSeries series = (StiSeries)Class.forName(StiChartHelper.findClass(seriesType, null, SERIES)).newInstance();
            series.setChart((IStiChart)chart);
            chart.getSeries().add((IStiSeries)series);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        callbackResult.put("properties", StiChartHelper.getChartProperties(chart));
    }

    public static void removeSeries(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws ParserConfigurationException, IOException, TransformerException {
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        int seriesIndex = (Integer)param.get("seriesIndex");
        if (component == null || seriesIndex == -1) {
            return;
        }
        StiChart chart = (StiChart)component;
        chart.getSeries().remove(seriesIndex);
        callbackResult.put("properties", StiChartHelper.getChartProperties(chart));
    }

    public static void seriesMove(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws ParserConfigurationException, IOException, TransformerException {
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        int seriesIndex = (Integer)param.get("seriesIndex");
        String direction = (String)param.get("direction");
        if (component == null || seriesIndex == -1) {
            return;
        }
        StiChart chart = (StiChart)component;
        IStiSeries series = (IStiSeries)chart.getSeries().get(seriesIndex);
        chart.getSeries().remove(seriesIndex);
        seriesIndex = "Up".equals(direction) ? --seriesIndex : ++seriesIndex;
        chart.getSeries().add(seriesIndex, series);
        callbackResult.put("properties", StiChartHelper.getChartProperties(chart));
        callbackResult.put("selectedIndex", seriesIndex);
    }

    public static void addConstantLineOrStrip(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws ParserConfigurationException, IOException, TransformerException {
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        if (component == null) {
            return;
        }
        StiChart chart = (StiChart)component;
        String itemType = (String)param.get("itemType");
        if ("ConstantLines".equals(itemType)) {
            StiConstantLines constantLine = new StiConstantLines();
            chart.getConstantLines().add((IStiConstantLines)constantLine);
            constantLine.setChart((IStiChart)chart);
        } else {
            StiStrips strip = new StiStrips();
            StiGradientBrush brush = new StiGradientBrush(StiColor.fromArgb((int)100, (int)250, (int)240, (int)150), StiColor.fromArgb((int)100, (int)150, (int)120, (int)60), 90.0);
            strip.setStripBrush((StiBrush)brush);
            chart.getStrips().add((IStiStrips)strip);
            strip.setChart((IStiChart)chart);
        }
        callbackResult.put("properties", StiChartHelper.getChartProperties(chart));
        callbackResult.put("itemType", itemType);
    }

    public static void removeConstantLineOrStrip(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws ParserConfigurationException, IOException, TransformerException {
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        int itemIndex = (Integer)param.get("itemIndex");
        String itemType = (String)param.get("itemType");
        if (component == null || itemIndex == -1) {
            return;
        }
        StiChart chart = (StiChart)component;
        if ("ConstantLines".equals(itemType)) {
            chart.getConstantLines().remove(itemIndex);
        } else {
            chart.getStrips().remove(itemIndex);
        }
        callbackResult.put("properties", StiChartHelper.getChartProperties(chart));
        callbackResult.put("itemType", itemType);
    }

    public static void constantLineOrStripMove(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws ParserConfigurationException, IOException, TransformerException {
        int nextIndex;
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        int itemIndex = (Integer)param.get("itemIndex");
        String direction = (String)param.get("direction");
        String itemType = (String)param.get("itemType");
        if (component == null || itemIndex == -1) {
            return;
        }
        StiChart chart = (StiChart)component;
        int n = nextIndex = "Up".equals(direction) ? itemIndex - 1 : itemIndex + 1;
        if ("ConstantLines".equals(itemType)) {
            IStiConstantLines constantLine = (IStiConstantLines)chart.getConstantLines().get(itemIndex);
            chart.getConstantLines().remove(itemIndex);
            chart.getConstantLines().add(nextIndex, (Object)constantLine);
        } else {
            IStiStrips strip = (IStiStrips)chart.getStrips().get(itemIndex);
            chart.getStrips().remove(itemIndex);
            chart.getStrips().add(nextIndex, (Object)strip);
        }
        callbackResult.put("properties", StiChartHelper.getChartProperties(chart));
        callbackResult.put("selectedIndex", nextIndex);
        callbackResult.put("itemType", itemType);
    }

    public static void getLabelsContent(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws InstantiationException, IllegalAccessException, ParserConfigurationException, IOException, TransformerException {
        int height;
        int width;
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        Integer seriesIndex = param.get("seriesIndex") != null ? (Integer)param.get("seriesIndex") : -1;
        if (component == null) {
            return;
        }
        StiChart chart = (StiChart)component;
        ArrayList labelsContent = new ArrayList();
        IStiSeries currentSeries = seriesIndex != -1 ? (IStiSeries)chart.getSeries().get(seriesIndex.intValue()) : null;
        StiChart chartCloned = StiChartHelper.cloneChart(chart);
        if (currentSeries != null) {
            for (int index = 0; index < chartCloned.getSeries().size(); ++index) {
                if (index == seriesIndex) continue;
                chartCloned.getSeries().remove(index);
            }
        }
        if (chartCloned.getSeries().size() > 0) {
            ((IStiSeries)chartCloned.getSeries().get(0)).setShowSeriesLabels(StiShowSeriesLabels.FromChart);
        }
        ArrayList<StiSeriesLabels> services = new ArrayList<StiSeriesLabels>();
        for (Class<? extends StiSeriesLabels> service : SERIES_LABELS) {
            if (!chart.getArea().getCore().CheckInLabelsTypes(service)) continue;
            services.add(service.newInstance());
        }
        Collections.sort(services, new LabelsComparer());
        if (services.size() < 6) {
            width = 160;
            height = 110;
        } else {
            width = 80;
            height = 80;
        }
        for (StiSeriesLabels labels : services) {
            if (!chart.getArea().getCore().CheckInLabelsTypes(labels.getClass())) continue;
            chartCloned.setSeriesLabels((IStiSeriesLabels)((StiSeriesLabels)labels.clone()));
            chartCloned.getCore().applyStyle(chartCloned.getStyle());
            HashMap<String, Object> content = new HashMap<String, Object>();
            content.put("caption", labels.toString());
            content.put("image", StiChartHelper.getChartSampleImage(chartCloned, width, height, 0.8f));
            content.put("type", labels.getClass().getName().substring(labels.getClass().getName().lastIndexOf(46) + 1));
            content.put("width", width);
            content.put("height", height);
            labelsContent.add(content);
        }
        callbackResult.put("labelsContent", labelsContent);
        if (currentSeries != null) {
            callbackResult.put("isSeriesLables", true);
        }
    }

    public static void getStylesContent(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult, boolean forStylesControl) throws InstantiationException, IllegalAccessException, ParserConfigurationException, IOException, TransformerException {
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        if (component == null) {
            component = new StiChart();
        }
        StiChart chart = (StiChart)component;
        ArrayList stylesContent = new ArrayList();
        StiChart chartCloned = StiChartHelper.cloneChart(chart);
        for (StiChartStyle style : StiChartHelper.getChartStyles(report)) {
            StiCustomStyle customStyle;
            chartCloned.setStyle((IStiChartStyle)((StiChartStyle)style.clone()));
            StiCustomStyle stiCustomStyle = customStyle = style instanceof StiCustomStyle ? (StiCustomStyle)style : null;
            if (customStyle != null) {
                chartCloned.setCustomStyleName(customStyle.getCustomCore().ReportChartStyle.getName());
            }
            chartCloned.getCore().applyStyle(chartCloned.getStyle());
            int width = forStylesControl ? 138 : 80;
            HashMap<String, Object> content = new HashMap<String, Object>();
            content.put("image", StiChartHelper.getChartSampleImage(chartCloned, width, forStylesControl ? 67 : 80, 1.0f));
            content.put("type", style.getClass().getName().substring(style.getClass().getName().lastIndexOf(46) + 1));
            content.put("name", style instanceof StiCustomStyle ? ((StiCustomStyleCoreXF)style.getCore()).getReportStyleName() : "");
            content.put("width", width);
            content.put("height", forStylesControl ? 67 : 80);
            stylesContent.add(content);
        }
        callbackResult.put("stylesContent", stylesContent);
    }

    public static void setLabelsType(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws ParserConfigurationException, IOException, TransformerException {
        int seriesIndex;
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        String labelsType = (String)param.get("labelsType");
        int n = seriesIndex = param.get("seriesIndex") != null ? (Integer)param.get("seriesIndex") : -1;
        if (component == null) {
            return;
        }
        StiChart chart = (StiChart)component;
        StiSeriesLabels labels = null;
        try {
            labels = (StiSeriesLabels)Class.forName(StiChartHelper.findClass(labelsType, null, SERIES_LABELS)).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (labels != null) {
            if (seriesIndex != -1) {
                ((IStiSeries)chart.getSeries().get(seriesIndex)).setSeriesLabels((IStiSeriesLabels)labels);
                ((IStiSeries)chart.getSeries().get(seriesIndex)).getSeriesLabels().getCore().applyStyle(chart.getStyle());
            } else {
                chart.setSeriesLabels((IStiSeriesLabels)labels);
                chart.getSeriesLabels().getCore().applyStyle(chart.getStyle());
            }
        }
        callbackResult.put("properties", StiChartHelper.getChartProperties(chart));
        callbackResult.put("isSeriesLabels", seriesIndex != -1);
    }

    public static void setChartStyle(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws ParserConfigurationException, IOException, TransformerException {
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        String styleType = (String)param.get("styleType");
        String styleName = (String)param.get("styleName");
        if (component == null) {
            return;
        }
        StiChart chart = (StiChart)component;
        if (styleType.endsWith("StiCustomStyle")) {
            StiBaseStyle reportStyle = chart.getReport().getStyles().get(styleName);
            if (reportStyle != null) {
                StiCustomStyle customStyle = new StiCustomStyle(reportStyle.getName());
                customStyle.getCustomCore().ReportChartStyle = (com.stimulsoft.report.styles.StiChartStyle)reportStyle;
                chart.setStyle((IStiChartStyle)customStyle);
                chart.setCustomStyleName(customStyle.getCustomCore().ReportChartStyle.getName());
            }
        } else {
            IStiChartStyle baseStyle = null;
            try {
                baseStyle = (IStiChartStyle)Class.forName("com.stimulsoft.report.chart.view.styles." + styleType).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (baseStyle != null) {
                chart.setStyle(baseStyle);
            }
        }
        chart.getCore().applyStyle(chart.getStyle());
        callbackResult.put("properties", StiChartHelper.getChartProperties(chart));
    }

    public static void setChartPropertyValue(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        int seriesIndex;
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        if (component == null) {
            return;
        }
        StiChart chart = (StiChart)component;
        String panelName = (String)param.get("panelName");
        String propertyName = (String)param.get("propertyName");
        int n = seriesIndex = param.get("seriesIndex") != null ? (Integer)param.get("seriesIndex") : -1;
        if (param.get("ownerName") != null && !"ConstantLines".equals(param.get("ownerName")) && !"Strips".equals(param.get("ownerName"))) {
            propertyName = param.get("ownerName") + "." + propertyName;
        }
        Object mainObject = null;
        if ("Chart".equals(panelName)) {
            if (param.get("indexConstantLines") != null) {
                int indexConstantLines = (Integer)param.get("indexConstantLines");
                if (indexConstantLines != -1) {
                    mainObject = chart.getConstantLines().get(indexConstantLines);
                }
            } else if (param.get("indexStrips") != null) {
                int indexStrips = (Integer)param.get("indexStrips");
                if (indexStrips != -1) {
                    mainObject = chart.getStrips().get(indexStrips);
                }
            } else {
                mainObject = chart;
            }
        } else if ("Series".equals(panelName) || "SeriesLabels".equals(panelName)) {
            Object object = mainObject = seriesIndex != -1 ? chart.getSeries().get(seriesIndex) : null;
            if ("SeriesLabels".equals(panelName)) {
                propertyName = "SeriesLabels." + propertyName;
            }
        } else if ("Labels".equals(panelName)) {
            mainObject = chart.getSeriesLabels();
        } else if ("Area".equals(panelName)) {
            mainObject = chart.getArea();
        }
        if (mainObject != null) {
            StiReportEdit.setPropertyValue(chart.getReport(), propertyName, mainObject, param.get("propertyValue"));
        }
        callbackResult.put("properties", StiChartHelper.getChartProperties(chart));
    }

    public static void setContainerValue(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException, ParserConfigurationException, IOException, TransformerException {
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        Integer seriesIndex = param.get("seriesIndex") != null ? (Integer)param.get("seriesIndex") : -1;
        if (component == null) {
            return;
        }
        StiChart chart = (StiChart)component;
        if ("SeriesConditions".equals(param.get("containerType"))) {
            if (seriesIndex != -1) {
                StiChartHelper.setConditionsValue(((IStiSeries)chart.getSeries().get(seriesIndex.intValue())).getConditions(), (ArrayList)param.get("value"));
            }
        } else if ("LabelsConditions".equals(param.get("containerType"))) {
            StiChartHelper.setConditionsValue(chart.getSeriesLabelsConditions(), (ArrayList)param.get("value"));
        } else if ("SeriesFilters".equals(param.get("containerType")) && seriesIndex != -1) {
            if (param.get("filterMode") != null) {
                ((StiSeries)chart.getSeries().get(seriesIndex.intValue())).setFilterMode(StiFilterMode.valueOf((String)((String)param.get("filterMode"))));
            }
            StiChartHelper.setFiltersValue(((IStiSeries)chart.getSeries().get(seriesIndex.intValue())).getFilters(), (ArrayList)param.get("value"));
        }
        callbackResult.put("properties", StiChartHelper.getChartProperties(chart));
        if (param.get("andCloseForm") != null) {
            callbackResult.put("closeChartForm", param.get("andCloseForm"));
        }
    }

    private static class LabelsComparer
    implements Comparator<StiSeriesLabels> {
        private LabelsComparer() {
        }

        @Override
        public int compare(StiSeriesLabels x, StiSeriesLabels y) {
            return new Integer(x.getCore().getPosition()).compareTo(y.getCore().getPosition());
        }
    }
}

