/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.helper.StiExportsHelper;
import com.stimulsoft.web.helper.StiRequestParamsHelper;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import com.stimulsoft.web.proxyee.StiHttpServletResponse;
import com.stimulsoft.web.proxyee.StiServletContext;
import com.stimulsoft.webdesigner.StiWebDesigner;
import com.stimulsoft.webdesigner.StiWebDesignerCommands;
import com.stimulsoft.webdesigner.StiWebDesignerOptions;
import com.stimulsoft.webdesigner.StiWebDesignerRender;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public class StiWebDesignerHelper {
    public static StiExportSettings getExportSettings(StiRequestParams requestParams) {
        return StiExportsHelper.getExportSettings((StiRequestParams)requestParams);
    }

    public String getWebDesigner(URL context, StiHttpServletRequest request, StiHttpServletResponse response, Object handler, StiServletContext servletContext) throws IOException, StiException, DOMException, JSONException {
        return this.getWebDesigner("WebDesigner1" + StiGuid.newGuidStringPlain(), context, request, response, handler, servletContext);
    }

    public String getWebDesigner(StiWebDesignerOptions options, URL context, StiHttpServletRequest request, StiHttpServletResponse response, Object handler, StiServletContext servletContext) throws IOException, StiException, DOMException, JSONException {
        return this.getWebDesigner("WebDesigner1" + StiGuid.newGuidStringPlain(), options, context, request, response, handler, servletContext);
    }

    public String getWebDesigner(String designerID, URL context, StiHttpServletRequest request, StiHttpServletResponse response, Object handler, StiServletContext servletContext) throws IOException, StiException, DOMException, JSONException {
        return this.getWebDesigner(designerID, new StiWebDesignerOptions(), context, request, response, handler, servletContext);
    }

    public String getWebDesigner(String designerID, StiWebDesignerOptions options, URL context, StiHttpServletRequest request, StiHttpServletResponse response, Object handler, Object servletContext) throws IOException, StiException, DOMException, JSONException {
        if (options == null) {
            options = new StiWebDesignerOptions();
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)designerID)) {
            options.setDesignerID(designerID);
        } else {
            options.setDesignerID("WebDesigner1" + StiGuid.newGuidStringPlain());
        }
        StiWebDesignerRender designer = new StiWebDesignerRender(options, context, request);
        try {
            return designer.getDesigner(context, handler, request, response, servletContext);
        }
        catch (Throwable e) {
            throw new StiException(e);
        }
    }

    private static HashMap<String, String> getCssConstants(StringBuffer cssText) {
        HashMap<String, String> constants = new HashMap<String, String>();
        int startIndex = cssText.indexOf("@");
        String constantsStr = cssText.substring(startIndex, cssText.lastIndexOf(";") - startIndex);
        String[] constantsArray = constantsStr.split(";");
        for (int i = 0; i < constantsArray.length; ++i) {
            String[] tmpArray = constantsArray[i].split("=");
            if (tmpArray.length != 2) continue;
            constants.put(tmpArray[0].trim(), tmpArray[1]);
        }
        return constants;
    }

    public StiReport getActionReportObject(StiHttpServletRequest httpContext, StiHttpServletResponse response, StringBuffer jsonParams) throws IOException, JSONException, SAXException, StiDeserializationException {
        StiRequestParams requestParams = StiWebDesignerHelper.getRequestParams(httpContext, response, jsonParams);
        return StiWebDesignerHelper.getActionReportObject(requestParams, httpContext);
    }

    public static StiRequestParams getRequestParams(StiHttpServletRequest httpContext, StiHttpServletResponse response, StringBuffer jsonParams) throws IOException, JSONException {
        StiRequestParams requestParams = StiRequestParamsHelper.get((StiHttpServletRequest)httpContext, (StiHttpServletResponse)response, (StringBuffer)jsonParams);
        requestParams.cache.helper = StiWebDesigner.getCacheHelper();
        return requestParams;
    }

    public static StiReport getActionReportObject(StiRequestParams requestParams, StiHttpServletRequest httpContext) throws JSONException, IOException, SAXException, StiDeserializationException {
        if (requestParams.action == StiAction.OpenReport) {
            try {
                return StiWebDesignerCommands.loadReportFromContent(requestParams);
            }
            catch (Exception e) {
                return null;
            }
        }
        StiReport currentReport = StiWebDesignerHelper.getReportObject(httpContext, requestParams);
        if (requestParams.action == StiAction.CreateReport) {
            StiReport newReport = StiWebDesignerCommands.getNewReport(requestParams);
            if (currentReport != null) {
                StiReportEdit.copyReportDictionary(currentReport, newReport);
            }
            return newReport;
        }
        if (requestParams.action == StiAction.PreviewReport) {
            return StiReportEdit.cloneReport(currentReport, true);
        }
        return currentReport;
    }

    public static StiReport getReportObject(StiHttpServletRequest httpContext, StiRequestParams requestParams) {
        return requestParams.cache.helper.getReportInternal(requestParams, httpContext);
    }
}

