/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.requestfromuser.value;

import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariableItem;
import com.stimulsoft.viewer.requestfromuser.StiDialogInfoValue;
import com.stimulsoft.viewer.requestfromuser.StiNewRequestFromUserDialogCreatingEventArgs;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestCheckBox;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestComboBox;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestPanel;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestTextField;
import com.stimulsoft.viewer.requestfromuser.value.IStiValueItemControl;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StiValueCharItemControl
extends StiRequestPanel
implements IStiValueItemControl {
    private static final long serialVersionUID = -3245853900353155288L;
    private StiRequestTextField textBox;
    private StiRequestComboBox comboBox;
    private StiRequestCheckBox checkBoxNotAssigned;

    public StiValueCharItemControl(StiVariable variable) {
        super(null);
        StiNewRequestFromUserDialogCreatingEventArgs arg;
        this.initializeComponent();
        String defaultValue = variable.getValue().toString();
        boolean allowUserValues = variable.getDialogInfo().getAllowUserValues();
        List list = variable.getDialogInfoItems();
        if (list.size() > 0) {
            this.createComboBox();
            for (StiVariableItem item : list) {
                StiDialogInfoValue infoValue = new StiDialogInfoValue(item);
                this.comboBox.addItem(infoValue);
                if (!defaultValue.equals(item.getValueString())) continue;
                this.comboBox.setSelectedIndex(this.comboBox.getItemCount() - 1);
            }
            if (!allowUserValues) {
                this.comboBox.setEditable(false);
                if (this.comboBox.getSelectedIndex() == -1) {
                    this.comboBox.setSelectedIndex(0);
                }
            }
        } else {
            this.createTextBox();
            this.textBox.setText(defaultValue);
            this.textBox.setEditable(allowUserValues);
        }
        if (this.comboBox != null) {
            arg = new StiNewRequestFromUserDialogCreatingEventArgs(variable, this.comboBox.getWidth());
            this.comboBox.setWidth(arg.getWidth());
        } else if (this.textBox != null) {
            arg = new StiNewRequestFromUserDialogCreatingEventArgs(variable, this.textBox.getWidth());
            this.textBox.setWidth(arg.getWidth());
        }
        this.checkBoxNotAssigned.setVisible(false);
        if (this.checkBoxNotAssigned.isVisible()) {
            if (this.checkBoxNotAssigned.isVisible()) {
                this.checkBoxNotAssigned.setLeft(this.checkBoxNotAssigned.getRight() + 5);
            } else if (this.textBox != null && this.textBox.isVisible()) {
                this.checkBoxNotAssigned.setLeft(this.textBox.getRight() + 5);
            } else if (this.comboBox != null && this.comboBox.isVisible()) {
                this.checkBoxNotAssigned.setLeft(this.comboBox.getRight() + 5);
            }
        }
        if (this.checkBoxNotAssigned.isVisible()) {
            this.setWidth(this.checkBoxNotAssigned.getRight() + 2);
        } else if (this.textBox != null && this.textBox.isVisible()) {
            this.setWidth(this.textBox.getRight() + 2);
        } else if (this.comboBox != null && this.comboBox.isVisible()) {
            this.setWidth(this.comboBox.getRight() + 2);
        }
        if (variable.getValueObject() == null && this.checkBoxNotAssigned.isVisible()) {
            this.checkBoxNotAssigned.setSelected(true);
        }
    }

    @Override
    public Object getValue() {
        if (this.checkBoxNotAssigned.isSelected()) {
            return null;
        }
        String textValue = "";
        textValue = this.comboBox != null ? (this.comboBox.getSelectedItem() instanceof StiDialogInfoValue ? ((StiDialogInfoValue)this.comboBox.getSelectedItem()).getKey().toString() : this.comboBox.getSelectedItem().toString()) : this.textBox.getText();
        return Character.valueOf(textValue.length() > 0 ? textValue.charAt(0) : (char)' ');
    }

    private void checkBoxNotAssignedCheckedChanged() {
        if (this.textBox != null) {
            this.textBox.setEnabled(!this.checkBoxNotAssigned.isSelected());
        } else if (this.comboBox != null) {
            this.comboBox.setEnabled(!this.checkBoxNotAssigned.isSelected());
        }
    }

    private void createTextBox() {
        this.textBox = new StiRequestTextField();
        this.textBox.setLocation(0, 0);
        this.textBox.setSize(180, 20);
        this.add(this.textBox);
    }

    private void createComboBox() {
        this.comboBox = new StiRequestComboBox(true);
        this.comboBox.setMaximumRowCount(25);
        this.comboBox.setEditable(true);
        this.comboBox.setLocation(0, 0);
        this.comboBox.setSize(180, 21);
        this.add(this.comboBox);
    }

    private void initializeComponent() {
        this.checkBoxNotAssigned = new StiRequestCheckBox();
        this.checkBoxNotAssigned.setLocation(182, 2);
        this.checkBoxNotAssigned.setName("checkBoxNotAssigned");
        this.checkBoxNotAssigned.setText("Not Assigned");
        this.checkBoxNotAssigned.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StiValueCharItemControl.this.checkBoxNotAssignedCheckedChanged();
            }
        });
        this.add(this.checkBoxNotAssigned);
        this.setName("StiValueCharItemControl");
        this.setSize(198, 21);
    }

    public StiRequestCheckBox getCheckBoxNotAssigned() {
        return this.checkBoxNotAssigned;
    }
}

