/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.requestfromuser.components;

import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.lib.utils.StiDateUtil;
import com.stimulsoft.report.dictionary.StiVariableItem;
import com.stimulsoft.viewer.requestfromuser.ButtonListInfo;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class StiCheckButton
extends JButton {
    private static final long serialVersionUID = -4120337049881312563L;
    private static final ImageIcon ICON_CHECKED = StiResourceUtil.loadIcon((String)"/icons/ZoomChecked.png");
    private Object tag;
    private boolean selected = false;
    private boolean autoCheckOnClick = false;
    private ButtonListInfo btInfo;
    private StiVariableItem infoItem;

    public StiCheckButton(ButtonListInfo btInfo, StiVariableItem infoItem) {
        this.btInfo = btInfo;
        this.infoItem = infoItem;
        this.setText(String.format("%s[%s]", infoItem.getLabel() == null ? "" : infoItem.getLabel() + " ", this.getValueString()));
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.setHorizontalAlignment(2);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setFocusable(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StiCheckButton.this.autoCheckOnClick) {
                    StiCheckButton.this.setSelected(!StiCheckButton.this.selected);
                }
            }
        });
    }

    public String getValueString() {
        if (this.infoItem.getKeyObject() instanceof StiDateTime) {
            return ((StiDateTime)this.infoItem.getKeyObject()).format(this.getDateFormat());
        }
        return this.infoItem.getKeyObject().toString();
    }

    private String getDateFormat() {
        if (this.btInfo.getType() == StiSystemTypeEnum.SystemTimeSpan) {
            return "HH:mm:ss";
        }
        switch (this.btInfo.getVariable().getDialogInfo().getDateTimeType()) {
            case DateAndTime: {
                return StiDateUtil.DEFAULT_DATE_TIME_PATTERN;
            }
            case Date: {
                return StiDateUtil.DEFAULT_DATE_PATTERN;
            }
        }
        return "HH:mm:ss";
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        this.setIcon(selected ? ICON_CHECKED : null);
        this.setMargin(new Insets(1, selected ? 1 : 21, 1, 1));
    }

    public boolean isAutoCheckOnClick() {
        return this.autoCheckOnClick;
    }

    public void setAutoCheckOnClick(boolean autoCheckOnClick) {
        this.autoCheckOnClick = autoCheckOnClick;
    }
}

