/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.panels;

import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.report.viewer.StiPageViewMode;
import com.stimulsoft.viewer.controls.visual.StiLabel;
import com.stimulsoft.viewer.controls.visual.StiSlider;
import com.stimulsoft.viewer.controls.visual.StiToggleFlatButton;
import com.stimulsoft.viewer.enums.StiViewState;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventable;
import com.stimulsoft.viewer.events.StiViewerEventDispatcher;
import com.stimulsoft.viewer.logic.StiViewModel;
import com.stimulsoft.viewer.utils.StiTooltipUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StiViewModeToolBar
extends JToolBar
implements StiViewEventable {
    private static final long serialVersionUID = -2811804664741382826L;
    private StiToggleFlatButton buttonViewModeSinglePage;
    private StiToggleFlatButton buttonViewModeContinuous;
    private StiToggleFlatButton buttonViewModeMultiplePages;
    private StiLabel labelZoom;
    private StiSlider sliderZoom;
    private ButtonGroup pageGroup = new ButtonGroup();
    private StiViewerEventDispatcher eventDispatcher = new StiViewerEventDispatcher();
    private StiViewModel model;
    private Boolean valueSliderChanged = false;

    public StiViewModeToolBar(StiViewModel model) {
        this.setFloatable(false);
        this.model = model;
        this.buildComponent();
        this.bindEvents();
        this.enableControls(false);
    }

    private void buildComponent() {
        String url = "http://www.stimulsoft.com/en/documentation/online/user-manual/index.html?viewing_reports_displaying_mode.htm";
        this.buttonViewModeSinglePage = new StiToggleFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/ViewModeSinglePage.png"), StiTooltipUtil.formatTooltip("PageViewModeSinglePage", "ViewModeSinglePage", "(Shift + F2)"), 113, 64, url);
        this.add(this.buttonViewModeSinglePage);
        this.buttonViewModeContinuous = new StiToggleFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/ViewModeContinuous.png"), StiTooltipUtil.formatTooltip("PageViewModeContinuous", "ViewModeContinuous", "(Shift + F3)"), 114, 64, url);
        this.add(this.buttonViewModeContinuous);
        this.buttonViewModeMultiplePages = new StiToggleFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/ViewModeMultiplePages.png"), StiTooltipUtil.formatTooltip("PageViewModeMultiplePages", "ViewModeMultiplePages", "(Shift + F4)"), 115, 64, url);
        this.add(this.buttonViewModeMultiplePages);
        this.addSeparator();
        this.labelZoom = new StiLabel("100 %");
        this.add(this.labelZoom);
        this.sliderZoom = new StiSlider();
        this.add(this.sliderZoom);
        this.sliderZoom.setFocusable(false);
        this.pageGroup.add(this.buttonViewModeSinglePage);
        this.pageGroup.add(this.buttonViewModeContinuous);
        this.pageGroup.add(this.buttonViewModeMultiplePages);
        this.buttonViewModeSinglePage.setSelected(true);
    }

    private void bindEvents() {
        this.buttonViewModeSinglePage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewModeToolBar.this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("PageViewModeChanged", StiPageViewMode.SinglePage));
            }
        });
        this.buttonViewModeMultiplePages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewModeToolBar.this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("PageViewModeChanged", StiPageViewMode.MultiplePages));
            }
        });
        this.buttonViewModeContinuous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewModeToolBar.this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("PageViewModeChanged", StiPageViewMode.Continuous));
            }
        });
        this.sliderZoom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StiSlider slider = (StiSlider)e.getSource();
                if (slider.getValueIsAdjusting() || !StiViewModeToolBar.this.valueSliderChanged.booleanValue()) {
                    StiViewModeToolBar.this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("ChangeViewState", (Object)StiViewState.Own));
                    StiViewModeToolBar.this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("ZoomChanged", slider.getValue()));
                }
                StiViewModeToolBar.this.labelZoom.setText(slider.getValue() + " %");
            }
        });
        this.model.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StiViewModeToolBar.this.enableControls(evt.getNewValue() != null);
            }
        });
        this.model.addPropertyChangeListener("pageViewMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StiPageViewMode mode = (StiPageViewMode)evt.getNewValue();
                StiViewModeToolBar.this.buttonViewModeSinglePage.setSelected(mode.equals((Object)StiPageViewMode.SinglePage));
                StiViewModeToolBar.this.buttonViewModeMultiplePages.setSelected(mode.equals((Object)StiPageViewMode.MultiplePages));
                StiViewModeToolBar.this.buttonViewModeContinuous.setSelected(mode.equals((Object)StiPageViewMode.Continuous));
            }
        });
        this.model.addPropertyChangeListener("zoom", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StiViewModeToolBar.this.valueSliderChanged = true;
                StiViewModeToolBar.this.sliderZoom.setValue((int)((Double)evt.getNewValue() * 100.0));
                StiViewModeToolBar.this.valueSliderChanged = false;
            }
        });
    }

    private void enableControls(Boolean enabled) {
        this.buttonViewModeSinglePage.setEnabled(enabled);
        this.buttonViewModeContinuous.setEnabled(enabled);
        this.buttonViewModeMultiplePages.setEnabled(enabled);
        this.labelZoom.setEnabled(enabled);
        this.sliderZoom.setEnabled(enabled);
    }

    @Override
    public StiViewerEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }
}

