/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.panels;

import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.interfaces.IStiText;
import com.stimulsoft.viewer.controls.visual.StiFlatButton;
import com.stimulsoft.viewer.controls.visual.StiLabel;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventable;
import com.stimulsoft.viewer.events.StiViewerEventDispatcher;
import com.stimulsoft.viewer.logic.StiViewModel;
import com.stimulsoft.viewer.utils.StiViewSettings;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class StiFindToolBar
extends JToolBar
implements StiViewEventable,
StiViewSettings {
    private static final long serialVersionUID = -2811804664741382826L;
    private StiFlatButton buttonFindClose;
    private StiFlatButton buttonFindPrevious;
    private StiFlatButton buttonFindNext;
    private JCheckBox checkboxMatchCase;
    private JCheckBox checkboxWholeWord;
    private StiFlatButton buttonPageLast;
    private StiLabel labelFindWhat;
    private StiViewerEventDispatcher eventDispatcher = new StiViewerEventDispatcher();
    private StiViewModel model;
    private JFrame parentFrame;
    private JTextField textBoxFind;
    private String previousValue;
    private Boolean previousWholeWord;
    private Boolean previousCase;
    private List<StiComponent> findedComponents = new ArrayList<StiComponent>();
    private int currentComponent;
    private static int findCount = 1;
    private int findCountOld = 1;

    public StiFindToolBar(StiViewModel model, JFrame parentFrame) {
        this.model = model;
        this.parentFrame = parentFrame;
        this.setFloatable(false);
        this.buildComponent();
        this.bindEvents();
        this.setupSettings();
        this.setMaximumSize(new Dimension(5000, 30));
    }

    private void buildComponent() {
        this.buttonFindClose = new StiFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/FindClose.png"), null, null);
        this.add(this.buttonFindClose);
        this.buttonFindClose.setOpaque(false);
        this.buttonFindClose.setFocusable(false);
        this.addSeparator();
        this.labelFindWhat = new StiLabel(StiLocalization.getValue((String)"FormViewerFind", (String)"FindWhat"));
        this.add(this.labelFindWhat);
        this.labelFindWhat.setFocusable(false);
        this.addSeparator();
        this.textBoxFind = new JTextField();
        this.add(this.textBoxFind);
        this.textBoxFind.setMaximumSize(new Dimension(150, 30));
        this.addSeparator();
        this.buttonFindPrevious = new StiFlatButton(StiLocalization.getValue((String)"FormViewerFind", (String)"FindPrevious"), StiResourceUtil.loadIcon((String)"/icons/FindPrevious.png"), null, null);
        this.add(this.buttonFindPrevious);
        this.buttonFindPrevious.setOpaque(false);
        this.buttonFindPrevious.setFocusable(false);
        this.addSeparator();
        this.buttonFindNext = new StiFlatButton(StiLocalization.getValue((String)"FormViewerFind", (String)"FindNext"), StiResourceUtil.loadIcon((String)"/icons/FindNext.png"), StiLocalization.getValue((String)"FormViewerFind", (String)"FindNext"), 118, 0, null);
        this.add(this.buttonFindNext);
        this.buttonFindNext.setOpaque(false);
        this.buttonFindNext.setFocusable(false);
        this.addSeparator();
        this.checkboxMatchCase = new JCheckBox(StiLocalization.getHingValue((String)"Editor", (String)"MatchCase"));
        this.add(this.checkboxMatchCase);
        this.checkboxMatchCase.setOpaque(false);
        this.checkboxMatchCase.setFocusable(false);
        this.addSeparator();
        this.checkboxWholeWord = new JCheckBox(StiLocalization.getHingValue((String)"Editor", (String)"MatchWholeWord"));
        this.add(this.checkboxWholeWord);
        this.checkboxWholeWord.setOpaque(false);
        this.checkboxWholeWord.setFocusable(false);
    }

    private void setupSettings() {
        this.checkboxMatchCase.setSelected(StiSettings.getBoolValue((String)"viewer", (String)"FindMatchCase", (Boolean)false));
        this.checkboxWholeWord.setSelected(StiSettings.getBoolValue((String)"viewer", (String)"FindMatchWholeWord", (Boolean)false));
    }

    private void bindEvents() {
        this.buttonFindClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiFindToolBar.this.hideFindPanel();
            }
        });
        this.buttonFindNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiFindToolBar.this.startFind();
            }
        });
        this.buttonFindPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiFindToolBar.this.startFindPrevious();
            }
        });
        this.textBoxFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiFindToolBar.this.startFind();
            }
        });
        this.textBoxFind.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    StiFindToolBar.this.hideFindPanel();
                }
            }
        });
        this.checkboxMatchCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiSettings.setBoolValue((String)"viewer", (String)"FindMatchCase", (Boolean)StiFindToolBar.this.checkboxMatchCase.isSelected());
            }
        });
        this.checkboxWholeWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiSettings.setBoolValue((String)"viewer", (String)"FindMatchWholeWord", (Boolean)StiFindToolBar.this.checkboxWholeWord.isSelected());
            }
        });
    }

    private void hideFindPanel() {
        this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ShowFindPannel", false));
    }

    public void showToolbar(Boolean show) {
        if (show.booleanValue()) {
            this.setVisible(true);
            this.textBoxFind.setText("");
            this.textBoxFind.requestFocusInWindow();
        } else {
            this.changeVisuals(new HashSet<StiComponent>(this.findedComponents));
            for (int index = 0; index < this.findedComponents.size(); ++index) {
                this.findedComponents.get(index).setHighlightState(StiHighlightState.Hide);
            }
            this.findedComponents.clear();
            this.previousValue = null;
            this.setVisible(false);
        }
    }

    private void startFindPrevious() {
        StiReport report = this.getModel().getReport();
        HashSet<StiComponent> changeVisuals = new HashSet<StiComponent>();
        if (report != null) {
            String value = this.textBoxFind.getText();
            Boolean matchCase = this.checkboxMatchCase.isSelected();
            Boolean matchWholeWord = this.checkboxWholeWord.isSelected();
            if (!value.equals(this.previousValue) || matchCase != this.previousCase || matchWholeWord != this.previousWholeWord) {
                this.previousValue = value;
                this.previousWholeWord = matchWholeWord;
                this.previousCase = matchCase;
                if (!matchCase.booleanValue()) {
                    value = value.toUpperCase();
                }
                changeVisuals.addAll(this.findedComponents);
                for (int index = 0; index < this.findedComponents.size(); ++index) {
                    this.findedComponents.get(index).setHighlightState(StiHighlightState.Hide);
                }
                this.findedComponents.clear();
                for (StiPage page : report.getRenderedPages()) {
                    for (StiComponent comp : page.getComponents()) {
                        IStiText text;
                        if (!(comp instanceof IStiText) || (text = (IStiText)comp) == null || text.getText() == null || text.getTextInternal() == null) continue;
                        String s = text.getTextInternal();
                        if (!matchCase.booleanValue()) {
                            s = s.toUpperCase();
                        }
                        if (matchWholeWord.booleanValue()) {
                            int endIndex;
                            int startIndex = s.indexOf(value);
                            if (startIndex == -1 || startIndex > 0 && Character.isLetterOrDigit(s.charAt(startIndex - 1)) || (endIndex = startIndex + value.length()) < s.length() && Character.isLetterOrDigit(s.charAt(endIndex))) continue;
                            this.findedComponents.add(comp);
                            continue;
                        }
                        if (s.indexOf(value) < 0) continue;
                        this.findedComponents.add(comp);
                    }
                }
                for (int index = 0; index < this.findedComponents.size(); ++index) {
                    this.findedComponents.get(index).setHighlightState(StiHighlightState.Show);
                }
                if (this.findedComponents != null && this.findedComponents.size() > 0) {
                    this.findedComponents.get(0).setHighlightState(StiHighlightState.Active);
                }
                changeVisuals.addAll(this.findedComponents);
                this.currentComponent = 0;
            } else if (this.findedComponents != null && this.findedComponents.size() > 0) {
                changeVisuals.add(this.findedComponents.get(this.currentComponent));
                this.findedComponents.get(this.currentComponent).setHighlightState(StiHighlightState.Show);
                --this.currentComponent;
                if (this.currentComponent == -1) {
                    this.currentComponent = this.findedComponents.size() - 1;
                }
                this.findedComponents.get(this.currentComponent).setHighlightState(StiHighlightState.Active);
                changeVisuals.add(this.findedComponents.get(this.currentComponent));
            }
            this.changeVisuals(changeVisuals);
            if (this.findedComponents.size() == 0) {
                JOptionPane.showMessageDialog(this.parentFrame, StiLocalization.getValue((String)"FormView", (String)"CantFind"));
            } else {
                this.findedComponents.get(this.currentComponent).setHighlightState(StiHighlightState.Active);
                this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ScrollToComponent", this.findedComponents.get(this.currentComponent)));
            }
            findCount = Math.max(this.findCountOld, this.findedComponents.size() + 1);
            this.findCountOld = this.findedComponents.size() + 1;
        }
    }

    private void startFind() {
        HashSet<StiComponent> changeVisuals = new HashSet<StiComponent>();
        StiReport report = this.getModel().getReport();
        if (report != null) {
            String value = this.textBoxFind.getText();
            Boolean matchCase = this.checkboxMatchCase.isSelected();
            Boolean matchWholeWord = this.checkboxWholeWord.isSelected();
            if (!value.equals(this.previousValue) || matchCase != this.previousCase || matchWholeWord != this.previousWholeWord) {
                this.previousValue = value;
                this.previousWholeWord = matchWholeWord;
                this.previousCase = matchCase;
                if (!matchCase.booleanValue()) {
                    value = value.toUpperCase();
                }
                changeVisuals.addAll(this.findedComponents);
                for (int index = 0; index < this.findedComponents.size(); ++index) {
                    this.findedComponents.get(index).setHighlightState(StiHighlightState.Hide);
                }
                this.findedComponents.clear();
                for (StiPage page : report.getRenderedPages()) {
                    for (StiComponent comp : page.getComponents()) {
                        IStiText text;
                        if (!(comp instanceof IStiText) || (text = (IStiText)comp) == null || text.getText() == null || text.getTextInternal() == null) continue;
                        String s = text.getTextInternal();
                        if (!matchCase.booleanValue()) {
                            s = s.toUpperCase();
                        }
                        if (matchWholeWord.booleanValue()) {
                            int endIndex;
                            int startIndex = s.indexOf(value);
                            if (startIndex == -1 || startIndex > 0 && Character.isLetterOrDigit(s.charAt(startIndex - 1)) || (endIndex = startIndex + value.length()) < s.length() && Character.isLetterOrDigit(s.charAt(endIndex))) continue;
                            this.findedComponents.add(comp);
                            continue;
                        }
                        if (s.indexOf(value) < 0) continue;
                        this.findedComponents.add(comp);
                    }
                }
                for (int index = 0; index < this.findedComponents.size(); ++index) {
                    this.findedComponents.get(index).setHighlightState(StiHighlightState.Show);
                }
                changeVisuals.addAll(this.findedComponents);
                this.currentComponent = 0;
            } else if (this.findedComponents != null && this.findedComponents.size() > 0) {
                changeVisuals.add(this.findedComponents.get(this.currentComponent));
                this.findedComponents.get(this.currentComponent).setHighlightState(StiHighlightState.Show);
                ++this.currentComponent;
                if (this.currentComponent >= this.findedComponents.size()) {
                    this.currentComponent = 0;
                }
                changeVisuals.add(this.findedComponents.get(this.currentComponent));
            }
            this.changeVisuals(changeVisuals);
            if (this.findedComponents.size() == 0) {
                JOptionPane.showMessageDialog(this.parentFrame, StiLocalization.getValue((String)"FormView", (String)"CantFind"));
            } else {
                this.findedComponents.get(this.currentComponent).setHighlightState(StiHighlightState.Active);
                this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ScrollToComponent", this.findedComponents.get(this.currentComponent)));
            }
            findCount = Math.max(this.findCountOld, this.findedComponents.size() + 1);
            this.findCountOld = this.findedComponents.size() + 1;
        }
    }

    private void changeVisuals(Set<StiComponent> visuals) {
        this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ChangeBitmapVisual", visuals));
    }

    private StiFindToolBar getThis() {
        return this;
    }

    private void changePage(Integer pageIndex) {
        this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("CurrentPageChanged", pageIndex));
    }

    @Override
    public StiViewerEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    private StiViewModel getModel() {
        return this.model;
    }
}

