/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.panels;

import com.stimulsoft.base.panels.renderer.StiTreeRenderer;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiBookmark;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.viewer.visual.StiTreeNode;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewerEventDispatcher;
import com.stimulsoft.viewer.logic.StiViewModel;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;

public class StiBookmarkPannel
extends JScrollPane
implements TreeSelectionListener {
    private static final long serialVersionUID = 2346906785483045945L;
    public static final int DEFAULT_WIDTH = 180;
    private StiViewModel stiViewModel;
    private StiViewerEventDispatcher eventDispatcher = new StiViewerEventDispatcher();
    private JTree tree;

    public StiBookmarkPannel(StiViewModel model) {
        super(new JTree(), 20, 30);
        this.stiViewModel = model;
        this.tree = (JTree)this.getViewport().getView();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer((TreeCellRenderer)new StiTreeRenderer());
        this.tree.addTreeSelectionListener(this);
    }

    public void buildBookmarksTree() {
        if (this.getReport() != null && this.getReport().getBookmark() != null) {
            DefaultMutableTreeNode treeItems = this.getTreeNodeFromBookmarks(this.getReport().getBookmark());
            this.tree.setModel(new DefaultTreeModel(treeItems, false));
            if (this.getReport() != null && this.getReport().getBookmark() != null && this.getReport().getBookmark().getBookmarks().size() > 0) {
                this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("ShowBookmarkPannel", true));
            } else {
                this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("ShowBookmarkPannel", false));
            }
        }
    }

    private DefaultMutableTreeNode getTreeNodeFromBookmarks(StiBookmark bookmark) {
        DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode(new StiTreeNode(bookmark));
        this.fillTreeNodeFromBookmarks(bookmark, parentNode);
        return parentNode;
    }

    private void fillTreeNodeFromBookmarks(StiBookmark parentBookmark, DefaultMutableTreeNode parentNode) {
        for (StiBookmark bookmark : parentBookmark.getBookmarks()) {
            DefaultMutableTreeNode createdNode = new DefaultMutableTreeNode(new StiTreeNode(bookmark));
            parentNode.add(createdNode);
            this.fillTreeNodeFromBookmarks(bookmark, createdNode);
        }
    }

    public void removeBookmark() {
        this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("ShowBookmark", 0));
    }

    private StiReport getReport() {
        return this.stiViewModel.getDocument() != null ? this.stiViewModel.getDocument().getReport() : null;
    }

    private void showBookmark(StiComponent bookmarkComponent) {
        this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("ShowBookmark", bookmarkComponent, true));
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (selNode == null) {
            return;
        }
        Object nodeInfo = selNode.getUserObject();
        if (nodeInfo instanceof StiTreeNode) {
            StiTreeNode node = (StiTreeNode)nodeInfo;
            StiBookmark bookmark = node.getBookmark();
            StiPage bookmarkComponent = null;
            if (StiValidationUtil.isNotNullOrEmpty((String)bookmark.getComponentGuid())) {
                for (StiPage page : this.getReport().getRenderedPages()) {
                    if (page.getGuid() == null || !page.getGuid().equals(bookmark.getComponentGuid())) continue;
                    bookmarkComponent = page;
                    break;
                }
                if (bookmarkComponent == null) {
                    for (StiPage page : this.getReport().getRenderedPages()) {
                        for (StiComponent component : page.getComponents()) {
                            if (component.getGuid() == null || !component.getGuid().equals(bookmark.getComponentGuid())) continue;
                            bookmarkComponent = component;
                            break;
                        }
                        if (bookmarkComponent == null) continue;
                        break;
                    }
                }
                if (bookmarkComponent != null) {
                    this.showBookmark((StiComponent)bookmarkComponent);
                }
            } else if (bookmark.getIsManualBookmark()) {
                for (StiPage page : this.getReport().getRenderedPages()) {
                    if (page.getBookmarkValue() == null || !page.getBookmark().equals(bookmark.getText())) continue;
                    bookmarkComponent = page;
                    break;
                }
                if (bookmarkComponent == null) {
                    block4: for (StiPage page : this.getReport().getRenderedPages()) {
                        for (StiComponent component : page.getComponents()) {
                            if (component.getBookmarkValue() == null || !component.getBookmarkValue().equals(bookmark.getText())) continue;
                            bookmarkComponent = component;
                            continue block4;
                        }
                    }
                }
                if (bookmarkComponent != null) {
                    this.showBookmark((StiComponent)bookmarkComponent);
                }
            } else {
                ArrayList<String> path = new ArrayList<String>();
                while (selNode != null && selNode.getParent() instanceof DefaultMutableTreeNode) {
                    if (selNode.getUserObject() instanceof StiTreeNode) {
                        path.add(((StiTreeNode)selNode.getUserObject()).getBookmark().getText());
                    }
                    selNode = selNode.getParent() instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)selNode.getParent() : null;
                }
                int componentIndex = 0;
                StiPage lastPage = null;
                StiComponentsCollection componentsOnPages = new StiComponentsCollection();
                for (StiPage renderedPage : this.getReport().getRenderedPages()) {
                    componentsOnPages.AddRange(renderedPage.components);
                }
                for (int index = path.size() - 1; index >= 0; --index) {
                    String bookmarkText = (String)path.get(index);
                    while (componentIndex < componentsOnPages.size()) {
                        StiComponent component = (StiComponent)componentsOnPages.get(componentIndex);
                        if (!component.getPage().equals(lastPage) && (lastPage = component.getPage()).getBookmarkValue() != null && lastPage.getBookmarkValue().equals(bookmarkText)) {
                            bookmarkComponent = lastPage;
                            break;
                        }
                        if (component.getBookmarkValue() != null && component.getBookmarkValue().equals(bookmarkText)) {
                            bookmarkComponent = component;
                            break;
                        }
                        ++componentIndex;
                    }
                    if (bookmarkComponent != null) {
                        this.showBookmark((StiComponent)bookmarkComponent);
                        continue;
                    }
                    componentIndex = 0;
                }
            }
            if (bookmarkComponent == null) {
                this.removeBookmark();
            }
        } else {
            this.removeBookmark();
        }
    }

    public StiViewerEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }
}

