/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form.export;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiPdfExportSettings;
import com.stimulsoft.report.export.tools.StiColorImageFormat;
import com.stimulsoft.report.export.tools.StiMonochromeDitheringType;
import com.stimulsoft.report.export.tools.pdf.StiPdfImageCompressionMethod;
import com.stimulsoft.viewer.controls.visual.StiLabel;
import com.stimulsoft.viewer.form.export.StiBaseExportDialog;
import java.awt.HeadlessException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StiPdfExportDialog
extends StiBaseExportDialog {
    private static final long serialVersionUID = -2168454809464111685L;
    protected static String[] COMPRESSION_METHODS = new String[]{"Jpeg", "Flate", "Simple Monochrome", "Ordered Monochrome", "FloydSt. Monochrome"};
    protected JComboBox imageResolutionComboBox;
    protected JComboBox imageCompressionComboBox;
    protected JComboBox imageQualityComboBox;
    protected JCheckBox standartPDFFontsCheckBox;
    protected JCheckBox embeddedFontsCheckBox;
    protected JCheckBox useUnicodeCheckBox;
    protected JCheckBox pdfAComplianceCheckBox;

    public StiPdfExportDialog(JFrame parent, Boolean sendEmail, int curretPage) throws HeadlessException {
        super(parent, sendEmail, curretPage);
    }

    public static StiExportSettings showDialog(JFrame parent, Boolean sendEmail, int curretPage) {
        StiPdfExportDialog dialog = new StiPdfExportDialog(parent, sendEmail, curretPage);
        dialog.setVisible(true);
        return dialog.okResult ? dialog.getExportSettings() : null;
    }

    @Override
    protected void buildComponent() {
        super.buildComponent();
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ImageCompressionMethod")), "ImageCompressionMethod"), 0, 0, 1);
        this.imageCompressionComboBox = new JComboBox<String>(COMPRESSION_METHODS);
        this.addC(this.imageCompressionComboBox, 1, 0, 2, 0.0);
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ImageResolution")), "ImageResolution"), 0, 1, 1);
        this.imageResolutionComboBox = new JComboBox<String>(RTF_IMAGE_RESOLUTIONS);
        this.addC(this.imageResolutionComboBox, 1, 1, 1, 0.5);
        this.addC(new JLabel("dpi"), 2, 1, 1, 0.0);
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ImageQuality")), "ImageQualityPdf"), 0, 2, 1);
        this.imageQualityComboBox = new JComboBox<String>(IMAGE_QUALITY);
        this.addC(this.imageQualityComboBox, 1, 2, 1, 0.5);
        this.addC(new JLabel("%"), 2, 2, 1, 0.0);
        this.standartPDFFontsCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"StandardPDFFonts"));
        this.addC(this.addInfo(this.standartPDFFontsCheckBox, "StandardPdfFonts"), 0, 3, 1, 0.5, -1);
        this.embeddedFontsCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"EmbeddedFonts"));
        this.addC(this.addInfo(this.embeddedFontsCheckBox, "EmbeddedFonts"), 0, 4, 1, 0.5, -1);
        this.useUnicodeCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"UseUnicode"));
        this.addC(this.addInfo(this.useUnicodeCheckBox, "UseUnicode"), 0, 5, 1, 0.5, -1);
        this.pdfAComplianceCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"PdfACompliance"));
        this.addC(this.addInfo(this.pdfAComplianceCheckBox, "PdfACompliance"), 0, 6, 1, 0.5, -1);
        this.expandPanel.setWidth(370);
        this.expandPanel.setExpandedHeight(250);
        this.bindEvents();
        this.loadSettings();
    }

    protected void bindEvents() {
        this.imageCompressionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StiPdfExportDialog.this.imageQualityComboBox.setEnabled(StiPdfExportDialog.this.imageCompressionComboBox.getSelectedIndex() == 0);
            }
        });
        this.standartPDFFontsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    StiPdfExportDialog.this.embeddedFontsCheckBox.setSelected(false);
                    StiPdfExportDialog.this.useUnicodeCheckBox.setSelected(false);
                }
            }
        });
        this.embeddedFontsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    StiPdfExportDialog.this.standartPDFFontsCheckBox.setSelected(false);
                }
            }
        });
        this.useUnicodeCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    StiPdfExportDialog.this.standartPDFFontsCheckBox.setSelected(false);
                }
            }
        });
        this.pdfAComplianceCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected = ((JCheckBox)e.getSource()).isSelected();
                StiPdfExportDialog.this.standartPDFFontsCheckBox.setEnabled(!selected);
                StiPdfExportDialog.this.embeddedFontsCheckBox.setEnabled(!selected);
                StiPdfExportDialog.this.useUnicodeCheckBox.setEnabled(!selected);
            }
        });
    }

    @Override
    protected StiExportSettings getExportSettings() {
        StiPdfExportSettings settings = new StiPdfExportSettings(super.getExportSettings());
        settings.setImageQuality(Float.parseFloat((String)this.imageQualityComboBox.getItemAt(this.imageQualityComboBox.getSelectedIndex())) / 100.0f);
        int imageResolution = 75;
        try {
            imageResolution = Integer.parseInt(((String)this.imageResolutionComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
        }
        catch (Exception e) {
            System.out.println("Unable to parse Image Resulution value: " + this.imageResolutionComboBox.getSelectedItem());
            e.printStackTrace();
        }
        if (this.imageCompressionComboBox.getSelectedIndex() == 0) {
            settings.setImageCompressionMethod(StiPdfImageCompressionMethod.Jpeg);
        } else {
            settings.setImageCompressionMethod(StiPdfImageCompressionMethod.Flate);
        }
        StiMonochromeDitheringType ditheringType = StiMonochromeDitheringType.None;
        StiPdfImageCompressionMethod compression = StiPdfImageCompressionMethod.Flate;
        StiColorImageFormat imageFormat = StiColorImageFormat.Color;
        switch (this.imageCompressionComboBox.getSelectedIndex()) {
            case 0: {
                compression = StiPdfImageCompressionMethod.Jpeg;
                break;
            }
            case 2: {
                imageFormat = StiColorImageFormat.Monochrome;
                break;
            }
            case 3: {
                imageFormat = StiColorImageFormat.Monochrome;
                ditheringType = StiMonochromeDitheringType.Ordered;
                break;
            }
            case 4: {
                imageFormat = StiColorImageFormat.Monochrome;
                ditheringType = StiMonochromeDitheringType.FloydSteinberg;
            }
        }
        settings.setDitheringType(ditheringType);
        settings.setImageFormat(imageFormat);
        settings.setImageCompressionMethod(compression);
        settings.setImageResolution((float)imageResolution);
        settings.setStandardPdfFonts(this.standartPDFFontsCheckBox.isSelected());
        settings.setEmbeddedFonts(this.embeddedFontsCheckBox.isSelected());
        settings.setUseUnicode(this.useUnicodeCheckBox.isSelected());
        settings.setPdfACompliance(this.pdfAComplianceCheckBox.isSelected());
        return settings;
    }

    private void loadSettings() {
        this.selectStringCombo(this.imageResolutionComboBox, StiSettings.getStringValue((String)"Export", (String)"PdfImageResolution", (String)"100"));
        this.selectStringCombo(this.imageQualityComboBox, StiSettings.getStringValue((String)"Export", (String)"PdfImageQuality", (String)"75"));
        this.selectStringCombo(this.imageCompressionComboBox, StiSettings.getStringValue((String)"Export", (String)"PdfIMageCompressionMethod", (String)"Jpeg"));
        this.standartPDFFontsCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"PdfStandardPDFFonts", (Boolean)false));
        this.embeddedFontsCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"PdfEmbedFonts", (Boolean)false));
        this.useUnicodeCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"PdfUseUnicode", (Boolean)false));
        this.pdfAComplianceCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"PdfPDFACompliance", (Boolean)false));
        this.expandPanel.setExpanded(StiSettings.getBoolValue((String)"Export", (String)"PdfSettingsPanelExpanded", (Boolean)false));
        this.openAfterExport.setSelected(StiSettings.getBoolValue((String)"Export", (String)"PdfOpenAfterExport", (Boolean)true));
    }

    @Override
    protected void saveSettings() {
        StiSettings.setStringValue((String)"Export", (String)"PdfImageResolution", (String)((String)this.imageResolutionComboBox.getSelectedItem()));
        StiSettings.setStringValue((String)"Export", (String)"PdfIMageCompressionMethod", (String)((String)this.imageCompressionComboBox.getSelectedItem()));
        StiSettings.setStringValue((String)"Export", (String)"PdfImageQuality", (String)((String)this.imageQualityComboBox.getSelectedItem()));
        StiSettings.setBoolValue((String)"Export", (String)"PdfStandardPDFFonts", (Boolean)this.standartPDFFontsCheckBox.isSelected());
        StiSettings.setBoolValue((String)"Export", (String)"PdfEmbedFonts", (Boolean)this.embeddedFontsCheckBox.isSelected());
        StiSettings.setBoolValue((String)"Export", (String)"PdfUseUnicode", (Boolean)this.useUnicodeCheckBox.isSelected());
        StiSettings.setBoolValue((String)"Export", (String)"PdfPDFACompliance", (Boolean)this.pdfAComplianceCheckBox.isSelected());
        StiSettings.setBoolValue((String)"Export", (String)"PdfSettingsPanelExpanded", (Boolean)this.expandPanel.getExpanded());
        StiSettings.setBoolValue((String)"Export", (String)"PdfOpenAfterExport", (Boolean)this.openAfterExport.isSelected());
    }
}

