/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form.export;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.html.StiHtmlExportMode;
import com.stimulsoft.viewer.controls.visual.StiLabel;
import com.stimulsoft.viewer.form.export.StiBaseExportDialog;
import java.awt.HeadlessException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class StiHtmlExportDialog
extends StiBaseExportDialog {
    private static final long serialVersionUID = 8504451915597681783L;
    private static String[] ZOOM_VALUES = new String[]{"25%", "50%", "75%", "100%", "125%", "150%", "200%"};
    private static String[] IMAGE_FORMATS = new String[]{"Jpeg", "Bmp", "Png"};
    private static String[] EXPORT_MODE = new String[]{"Table", "Span", "Div"};
    protected JComboBox zoomComboBox;
    protected JComboBox imageFormatComboBox;
    protected JComboBox exportModeComboBox;
    protected JCheckBox pageBreakCheckBox;

    private StiHtmlExportDialog(JFrame parent, Boolean sendEmail, int curretPage) throws HeadlessException {
        super(parent, sendEmail, curretPage);
    }

    public static StiExportSettings showDialog(JFrame parent, Boolean sendEmail, int curretPage) {
        StiHtmlExportDialog dialog = new StiHtmlExportDialog(parent, sendEmail, curretPage);
        dialog.setVisible(true);
        return dialog.okResult ? dialog.getExportSettings() : null;
    }

    @Override
    protected void buildComponent() {
        super.buildComponent();
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ImageFormat")), "ImageFormat"), 0, 0, 1);
        this.imageFormatComboBox = new JComboBox<String>(IMAGE_FORMATS);
        this.addC(this.imageFormatComboBox, 1, 0, 1, 0.5);
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"Scale")), "ScaleHtml"), 0, 1, 1);
        this.zoomComboBox = new JComboBox<String>(ZOOM_VALUES);
        this.addC(this.zoomComboBox, 1, 1, 1);
        this.zoomComboBox.setEditable(true);
        this.zoomComboBox.setSelectedIndex(3);
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ExportMode")), "ExportModeHtml"), 0, 2, 1);
        this.exportModeComboBox = new JComboBox<String>(EXPORT_MODE);
        this.addC(this.exportModeComboBox, 1, 2, 1, 0.5);
        this.pageBreakCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"AddPageBreaks"));
        this.addC(this.addInfo(this.pageBreakCheckBox, "AddPageBreaks"), 0, 3, 1, 0.5, -1);
        this.expandPanel.setWidth(360);
        this.expandPanel.setExpandedHeight(160);
        this.loadSettings();
    }

    @Override
    protected StiExportSettings getExportSettings() {
        StiHtmlExportSettings settings = new StiHtmlExportSettings(super.getExportSettings());
        settings.setImageFormat(StiImageFormat.valueOf((String)((String)this.imageFormatComboBox.getSelectedItem())));
        settings.setExportFormat(StiExportFormat.Html);
        settings.setExportMode(StiHtmlExportMode.valueOf((String)((String)this.exportModeComboBox.getSelectedItem())));
        Double zoom = 100.0;
        try {
            zoom = Double.parseDouble(((String)this.zoomComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
        }
        catch (Exception e) {
            System.out.println("Unable to parse zoom value: " + this.zoomComboBox.getSelectedItem());
            e.printStackTrace();
        }
        settings.setZoom(zoom / 100.0);
        settings.setAddPageBreaks(this.pageBreakCheckBox.isSelected());
        return settings;
    }

    private void loadSettings() {
        int storedZoom = StiSettings.getDoubleValue((String)"Export", (String)"HtmlZoom", (Double)100.0).intValue();
        if (!this.selectStringCombo(this.zoomComboBox, storedZoom + "%")) {
            this.zoomComboBox.setSelectedItem(String.valueOf(storedZoom));
        }
        this.selectStringCombo(this.imageFormatComboBox, StiSettings.getStringValue((String)"Export", (String)"HtmlImageFormat", (String)IMAGE_FORMATS[0]));
        this.selectStringCombo(this.exportModeComboBox, StiSettings.getStringValue((String)"viewer", (String)"HtmlExportMode", (String)EXPORT_MODE[0]));
        this.pageBreakCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"HtmlAddPagesBreaks", (Boolean)false));
        this.expandPanel.setExpanded(StiSettings.getBoolValue((String)"Export", (String)"HtmlSettingsPanelExpanded", (Boolean)false));
        this.openAfterExport.setSelected(StiSettings.getBoolValue((String)"Export", (String)"HtmlOpenAfterExport", (Boolean)true));
    }

    @Override
    protected void saveSettings() {
        StiSettings.setStringValue((String)"Export", (String)"HtmlImageFormat", (String)((String)this.imageFormatComboBox.getSelectedItem()));
        StiSettings.setStringValue((String)"Export", (String)"HtmlExportMode", (String)((String)this.exportModeComboBox.getSelectedItem()));
        StiSettings.setBoolValue((String)"Export", (String)"HtmlAddPagesBreaks", (Boolean)this.pageBreakCheckBox.isSelected());
        try {
            double zoom = Double.parseDouble(((String)this.zoomComboBox.getSelectedItem()).replaceAll("%", ""));
            StiSettings.setDoubleValue((String)"Export", (String)"HtmlZoom", (Double)zoom);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StiSettings.setBoolValue((String)"Export", (String)"HtmlSettingsPanelExpanded", (Boolean)this.expandPanel.getExpanded());
        StiSettings.setBoolValue((String)"Export", (String)"HtmlOpenAfterExport", (Boolean)this.openAfterExport.isSelected());
    }
}

