/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form.export;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.base.utils.StiCharsetHelper;
import com.stimulsoft.report.export.settings.StiCsvExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiSylkExportSettings;
import com.stimulsoft.report.export.settings.StiXmlExportSettings;
import com.stimulsoft.report.export.tools.StiDataExportMode;
import com.stimulsoft.viewer.controls.visual.StiLabel;
import com.stimulsoft.viewer.form.export.StiBaseExportDialog;
import java.awt.HeadlessException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.charset.Charset;
import java.text.DecimalFormatSymbols;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StiDataExportDialog
extends StiBaseExportDialog {
    private static final long serialVersionUID = 8504451915597681783L;
    protected static Charset[] SYLK_CHARSETS = new Charset[]{StiCharsetHelper.WINDOWS_1251, StiCharsetHelper.IBM437, StiCharsetHelper.IBM850, StiCharsetHelper.IBM852, StiCharsetHelper.IBM857, StiCharsetHelper.IBM860, StiCharsetHelper.IBM861, StiCharsetHelper.IBM862, StiCharsetHelper.IBM863, StiCharsetHelper.IBM865, StiCharsetHelper.IBM866, StiCharsetHelper.IBM869};
    protected static String[] SYLK_CHARSET_NAMES = new String[]{StiCharsetHelper.WINDOWS_1251.displayName(), StiCharsetHelper.IBM437.displayName(), StiCharsetHelper.IBM850.displayName(), StiCharsetHelper.IBM852.displayName(), StiCharsetHelper.IBM857.displayName(), StiCharsetHelper.IBM860.displayName(), StiCharsetHelper.IBM861.displayName(), StiCharsetHelper.IBM862.displayName(), StiCharsetHelper.IBM863.displayName(), StiCharsetHelper.IBM865.displayName(), StiCharsetHelper.IBM866.displayName(), StiCharsetHelper.IBM869.displayName()};
    protected JCheckBox exportDataCheckBox;
    protected JCheckBox useDefaultEncodingCheckBox;
    protected JComboBox encodingComboBox;
    protected JComboBox bandsComboBox;
    protected JTextField separatorTextField;
    protected JCheckBox skipHeadersCheckBox;
    protected JComboBox typeComboBox;

    private StiDataExportDialog(JFrame parent, Boolean sendEmail, int curretPage) throws HeadlessException {
        super(parent, sendEmail, curretPage);
    }

    public static StiExportSettings showDialog(JFrame parent, Boolean sendEmail, int curretPage) {
        StiDataExportDialog dialog = new StiDataExportDialog(parent, sendEmail, curretPage);
        dialog.setVisible(true);
        return dialog.okResult ? dialog.getExportSettings() : null;
    }

    @Override
    protected void buildComponent() {
        super.buildComponent();
        this.mainBuild();
    }

    protected void mainBuild() {
        this.addC(this.addInfo(new StiLabel("Type:"), "TypeExport"), 0, 0, 1);
        this.typeComboBox = new JComboBox<String>(new String[]{"Csv", "Xml", "Sylk"});
        this.addC(this.typeComboBox, 1, 0, 2, 0.0);
        if (StiSettings.getStringValue((String)"Export", (String)"CsvTypeExport", (String)"Csv").equals("Csv")) {
            this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"Encoding")), "EncodingData"), 0, 1, 1);
            this.encodingComboBox = new JComboBox<String>(StiCharsetHelper.CHARSET_NAMES);
            this.addC(this.encodingComboBox, 1, 1, 2, 0.0);
            this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"Separator")), "Separator"), 0, 2, 1);
            this.separatorTextField = new JTextField();
            this.addC(this.separatorTextField, 1, 2, 2, 0.0);
            this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"BandsFilter")), "ExportMode"), 0, 3, 1);
            this.bandsComboBox = new JComboBox<String>(new String[]{StiLocalization.getValue((String)"Export", (String)"DataOnly"), StiLocalization.getValue((String)"Export", (String)"DataAndHeadersFooters"), StiLocalization.getValue((String)"Export", (String)"AllBands")});
            this.addC(this.bandsComboBox, 1, 3, 2, 0.0);
            this.skipHeadersCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"SkipColumnHeaders"));
            this.addC(this.addInfo(this.skipHeadersCheckBox, "SkipColumnHeaders"), 0, 4, 2, 0.5, -1);
            this.typeComboBox.setSelectedIndex(0);
            this.expandPanel.setExpandedHeight(175);
        } else if (StiSettings.getStringValue((String)"Export", (String)"CsvTypeExport", (String)"Csv").equals("Xml")) {
            this.typeComboBox.setSelectedIndex(1);
            this.expandPanel.setExpandedHeight(65);
        } else if (StiSettings.getStringValue((String)"Export", (String)"CsvTypeExport", (String)"Csv").equals("Sylk")) {
            this.exportDataCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"ExportDataOnly"));
            this.addC(this.addInfo(this.exportDataCheckBox, "ExportDataOnly"), 0, 1, 2, 0.5, -1);
            this.useDefaultEncodingCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"UseDefaultSystemEncoding"));
            this.addC(this.addInfo(this.useDefaultEncodingCheckBox, "UseDefaultSystemEncoding"), 0, 2, 2, 0.5, -1);
            this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"Encoding")), "EncodingData"), 0, 3, 1);
            this.encodingComboBox = new JComboBox<String>(SYLK_CHARSET_NAMES);
            this.addC(this.encodingComboBox, 1, 3, 2, 0.0);
            this.typeComboBox.setSelectedIndex(2);
            this.expandPanel.setExpandedHeight(155);
        }
        this.expandPanel.setWidth(360);
        this.bindEvents();
        this.loadSettings();
    }

    protected void bindEvents() {
        this.typeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StiDataExportDialog.this.saveSettings();
                StiDataExportDialog.this.expandPanel.removeAll();
                StiDataExportDialog.this.mainBuild();
                StiDataExportDialog.this.expandPanel.revalidate();
                StiDataExportDialog.this.expandPanel.setExpanded(true);
            }
        });
        if (this.useDefaultEncodingCheckBox != null) {
            this.useDefaultEncodingCheckBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean selected = ((JCheckBox)e.getSource()).isSelected();
                    StiDataExportDialog.this.encodingComboBox.setEnabled(!selected);
                }
            });
        }
    }

    @Override
    protected StiExportSettings getExportSettings() {
        if (this.typeComboBox.getSelectedIndex() == 0) {
            StiCsvExportSettings settings = new StiCsvExportSettings(super.getExportSettings());
            settings.setEncoding(StiCharsetHelper.getCharsetFromName((String)((String)this.encodingComboBox.getItemAt(this.encodingComboBox.getSelectedIndex()))));
            settings.setSeparator(this.separatorTextField.getText().trim());
            settings.setSkipColumnHeaders(this.skipHeadersCheckBox.isSelected());
            switch (this.bandsComboBox.getSelectedIndex()) {
                case 0: {
                    settings.setDataExportMode(StiDataExportMode.Data);
                    break;
                }
                case 1: {
                    settings.setDataExportMode(StiDataExportMode.DataAndHeadersFooters);
                    break;
                }
                case 2: {
                    settings.setDataExportMode(StiDataExportMode.AllBands);
                }
            }
            return settings;
        }
        if (this.typeComboBox.getSelectedIndex() == 1) {
            return new StiXmlExportSettings(super.getExportSettings());
        }
        StiSylkExportSettings settings = new StiSylkExportSettings(super.getExportSettings());
        settings.setEncoding(StiCharsetHelper.getCharsetFromName((String)((String)this.encodingComboBox.getItemAt(this.encodingComboBox.getSelectedIndex())), (Charset[])SYLK_CHARSETS));
        settings.setExportDataOnly(this.exportDataCheckBox.isSelected());
        settings.setUseDefaultSystemEncoding(this.useDefaultEncodingCheckBox.isSelected());
        return settings;
    }

    private void loadSettings() {
        this.expandPanel.setExpanded(StiSettings.getBoolValue((String)"Export", (String)"CsvSettingsPanelExpanded", (Boolean)false));
        this.openAfterExport.setSelected(StiSettings.getBoolValue((String)"Export", (String)"CsvOpenAfterExport", (Boolean)true));
        this.selectStringCombo(this.typeComboBox, StiSettings.getStringValue((String)"Export", (String)"Excel2007Type", (String)"Csv"));
        if (this.separatorTextField != null) {
            this.selectStringCombo(this.encodingComboBox, StiSettings.getStringValue((String)"Export", (String)"CsvEncoding", (String)StiCharsetHelper.CHARSET_NAMES[0]));
            this.separatorTextField.setText(StiSettings.getStringValue((String)"Export", (String)"CsvSeparator", (String)Character.toString(new DecimalFormatSymbols().getPatternSeparator())));
            this.skipHeadersCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"CsvSkipColumnHeaders", (Boolean)false));
            this.bandsComboBox.setSelectedIndex(StiSettings.getIntValue((String)"Export", (String)"CsvDataExportMode", (Integer)0));
        } else if (this.useDefaultEncodingCheckBox != null) {
            this.selectStringCombo(this.encodingComboBox, StiSettings.getStringValue((String)"Export", (String)"SylkEncoding", (String)SYLK_CHARSET_NAMES[0]));
            this.exportDataCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"SylkExportDataOnly", (Boolean)true));
            this.useDefaultEncodingCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"SylkUseDefaultSystemEncoding", (Boolean)true));
        }
    }

    @Override
    protected void saveSettings() {
        StiSettings.setStringValue((String)"Export", (String)"CsvTypeExport", (String)((String)this.typeComboBox.getSelectedItem()));
        StiSettings.setBoolValue((String)"Export", (String)"CsvSettingsPanelExpanded", (Boolean)this.expandPanel.getExpanded());
        StiSettings.setBoolValue((String)"Export", (String)"CsvOpenAfterExport", (Boolean)this.openAfterExport.isSelected());
        if (this.skipHeadersCheckBox != null) {
            StiSettings.setStringValue((String)"Export", (String)"CsvEncoding", (String)((String)this.encodingComboBox.getSelectedItem()));
            StiSettings.setStringValue((String)"Export", (String)"CsvSeparator", (String)this.separatorTextField.getText().trim());
            StiSettings.setBoolValue((String)"Export", (String)"CsvSkipColumnHeaders", (Boolean)this.skipHeadersCheckBox.isSelected());
            StiSettings.setIntValue((String)"Export", (String)"CsvDataExportMode", (Integer)this.bandsComboBox.getSelectedIndex());
        } else if (this.exportDataCheckBox != null) {
            StiSettings.setStringValue((String)"Export", (String)"SylkEncoding", (String)((String)this.encodingComboBox.getSelectedItem()));
            StiSettings.setBoolValue((String)"Export", (String)"SylkExportDataOnly", (Boolean)this.exportDataCheckBox.isSelected());
            StiSettings.setBoolValue((String)"Export", (String)"SylkUseDefaultSystemEncoding", (Boolean)this.useDefaultEncodingCheckBox.isSelected());
        }
    }
}

