/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.controls.visual;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.viewer.controls.visual.StiPageVisual;
import com.stimulsoft.viewer.events.StiViewEventable;
import com.stimulsoft.viewer.logic.StiViewModel;
import com.stimulsoft.viewer.utils.StiPageNumberHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.border.LineBorder;

public class StiThumbPageVisual
extends StiPageVisual {
    private static final long serialVersionUID = 1300659507814198271L;
    private static final int BOTTOM_MARGIN = 10;
    private static final int MARGIN = 5;
    public static final Integer SELECTED_THUMB_BORDER_SIZE = 1;
    public static final Integer UNSELECTED_THUMB_BORDER_SIZE = 0;
    private Font pageNumberFont = new Font("Arial", 0, 11);
    private String pageNumber;
    private StiRectangle imgRect;
    private double zoom;

    public StiThumbPageVisual(StiViewEventable eventDispatcher, StiViewModel stiViewModel) {
        super(eventDispatcher, stiViewModel);
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.componentPait(graphics);
        if (this.page != null) {
            if (this.changeBitmap.booleanValue()) {
                this.stiViewModel.getPaintQueue().addVisual(this, this.zoom);
            }
            this.paintBackground((Graphics2D)graphics);
            this.paintBorderShadow((Graphics2D)graphics, this.imgRect);
            StiGraphics stiGraphics = new StiGraphics(graphics);
            this.drawBackground(stiGraphics, this.imgRect);
            graphics.drawImage(this.getImage(this.imgRect), this.imgRect.getXi(), this.imgRect.getYi(), this.imgRect.getWi(), this.imgRect.getHi(), null);
            StiPen borderPen = new StiPen(1.0, StiColorEnum.Black.color());
            borderPen.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
            stiGraphics.drawRectangle(this.imgRect, borderPen, null, Double.valueOf(this.zoom), Double.valueOf(1.0));
            this.changeBitmap = false;
            ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f));
        }
        this.drawPageNumber((Graphics2D)graphics);
    }

    private void paintBackground(Graphics2D graphics) {
        if (this.selected) {
            GradientPaint gradientPaint = new GradientPaint(this.getWidth() / 2, -this.getHeight() / 5, new Color(230, 160, 100), this.getWidth() / 2, this.getHeight() / 2, new Color(218, 119, 43), true);
            graphics.setPaint(gradientPaint);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void drawPageNumber(Graphics2D graphics) {
        Shape oldClip = graphics.getClip();
        graphics.setClip(null);
        graphics.setFont(this.pageNumberFont);
        String pageNumber = this.getPageNumber();
        float width = (float)this.pageNumberFont.getStringBounds(pageNumber, graphics.getFontRenderContext()).getWidth();
        float x = (float)(this.getWidth() / 2) - width / 2.0f;
        float y = this.getHeight() - 4;
        graphics.setColor(Color.BLACK);
        graphics.drawString(pageNumber, x, y);
        graphics.setClip(oldClip);
    }

    private String getPageNumber() {
        if (this.pageNumber == null) {
            Integer pageNum = StiPageNumberHelper.getPageStartNumber(this.page);
            this.pageNumber = pageNum.toString();
            if (!this.page.getDenyDrawSegmentMode() && StiOptions.Viewer.getAllowDrawSegmentMode() && (this.page.getSegmentPerWidth() > 1 || this.page.getSegmentPerHeight() > 1)) {
                this.pageNumber = this.pageNumber + ".." + (pageNum + this.page.getSegmentPerWidth() * this.page.getSegmentPerHeight() - 1);
            }
        }
        return this.pageNumber;
    }

    @Override
    public void setPage(StiPage page) {
        super.setPage(page);
        double pageWidth = page.ConvertToHInches(page.getUnit(), page.getDisplayRectangle().getWidth());
        double pageHeight = page.ConvertToHInches(page.getUnit(), page.getDisplayRectangle().getHeight());
        this.zoom = Math.min((double)(this.getWidth() - 10) / pageWidth, (double)(this.getHeight() - 5 - 10) / pageHeight);
        this.imgRect = new StiRectangle((double)(this.getWidth() / 2) - pageWidth * this.zoom / 2.0 + 5.0, (double)((this.getHeight() - 10) / 2) - pageHeight * this.zoom / 2.0 + 5.0, pageWidth * this.zoom - 10.0, pageHeight * this.zoom - 10.0);
        if (this.imgRect.height < 1.0) {
            this.imgRect.height = 1.0;
        }
        if (this.imgRect.width < 1.0) {
            this.imgRect.width = 1.0;
        }
    }

    @Override
    public void setSelected(Boolean selected) {
        this.borderSize = selected != false ? SELECTED_THUMB_BORDER_SIZE : UNSELECTED_THUMB_BORDER_SIZE;
        this.setBorder(new LineBorder(Color.GRAY, this.borderSize));
        this.selected = selected;
        this.repaint();
    }
}

