/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.controls.visual;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiGraphicsHelper;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.viewer.visual.StiVisual;
import com.stimulsoft.viewer.StiViewerFx;
import com.stimulsoft.viewer.controls.visual.StiThumbPageVisual;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventable;
import com.stimulsoft.viewer.logic.StiViewModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class StiPageVisual
extends StiVisual {
    private static final long serialVersionUID = 6167165386613154440L;
    public static final Integer SELECTED_BORDER_SIZE = 2;
    public static final Integer UNSELECTED_BORDER_SIZE = 1;
    public static final Color SELECTED_BORDER_COLOR = new Color(249, 173, 79);
    public static final Color UNSELECTED_BORDER_COLOR = Color.BLACK;
    public static final Integer SHADOW_SIZE = 5;
    private Integer pageIndex = -1;
    private Integer destLeft;
    private Integer line;
    private Integer destTop;
    private Integer destWidth;
    private Integer destHeight;
    protected Color borderColor;
    protected Integer borderSize;
    protected StiPage page;
    protected Double wd = 0.0;
    protected Double ht = 0.0;
    protected Boolean changeBitmap = true;
    protected StiViewModel stiViewModel;
    protected BufferedImage image;
    protected boolean selected = false;

    public StiPageVisual(StiViewEventable eventDispatcher, StiViewModel stiViewModel) {
        this.stiViewModel = stiViewModel;
        this.setBackground(StiViewerFx.BACKGROUND_COLOR);
        this.bindEvents(eventDispatcher);
    }

    protected void bindEvents(final StiViewEventable eventDispatcher) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((MouseListener)((Object)eventDispatcher)).mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ((MouseListener)((Object)eventDispatcher)).mouseReleased(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && StiPageVisual.this.pageIndex.intValue() != StiPageVisual.this.getCurrentPage()) {
                    eventDispatcher.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("CurrentPageChanged", StiPageVisual.this.pageIndex));
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ((MouseMotionListener)((Object)eventDispatcher)).mouseMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ((MouseMotionListener)((Object)eventDispatcher)).mouseDragged(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                StiPageVisual.this.changeBitmap = true;
            }
        });
    }

    protected void componentPait(Graphics graphics) {
        super.paintComponent(graphics);
    }

    protected void paintComponent(Graphics graphics) {
        this.componentPait(graphics);
        if (this.page != null) {
            if (this.changeBitmap.booleanValue()) {
                this.stiViewModel.getPaintQueue().addVisual(this, (double)this.getImageWidth() / this.wd);
            }
            Graphics2D graphics2d = (Graphics2D)graphics;
            StiRectangle paintRectangle = new StiRectangle(0L, 0L, (long)this.getImageWidth(), (long)this.getImageHeight());
            this.paintBorderShadow(graphics2d, paintRectangle);
            StiGraphics stiGraphics = new StiGraphics((Graphics)graphics2d);
            this.drawBackground(stiGraphics, paintRectangle);
            graphics2d.drawImage(this.getImage(paintRectangle), 0, 0, this.getImageWidth(), this.getImageHeight(), null);
            this.drawBorder(graphics2d);
            this.changeBitmap = false;
        }
    }

    private void drawBorder(Graphics2D graphics) {
        graphics.setStroke(new BasicStroke(this.borderSize.intValue()));
        graphics.setColor(this.borderColor);
        graphics.drawRect(this.selected ? 1 : 0, this.selected ? 1 : 0, this.getImageWidth(), this.getImageHeight());
    }

    private int getImageWidth() {
        return this.getWidth() - SHADOW_SIZE;
    }

    private int getImageHeight() {
        return this.getHeight() - SHADOW_SIZE;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width + SHADOW_SIZE, height + SHADOW_SIZE);
    }

    protected void paintBorderShadow(Graphics2D g2, StiRectangle rect) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape oldClip = g2.getClip();
        g2.setClip(this.getVisibleRect());
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.0f));
        for (int i = 0; i < SHADOW_SIZE; ++i) {
            GeneralPath path = new GeneralPath();
            path.moveTo(rect.getXi() + SHADOW_SIZE - i, rect.getBi());
            path.lineTo(rect.getXi() + SHADOW_SIZE, rect.getBi() + i);
            path.lineTo(rect.getRi(), rect.getBi() + i);
            path.moveTo(rect.getRi() + i, rect.getBi());
            path.curveTo((float)rect.getRi() + (float)i, (float)((double)rect.getBi() + (double)i * 0.5522847498), (float)((double)rect.getRi() + (double)i * 0.5522847498), (float)rect.getBi() + (float)i, rect.getRi(), (float)rect.getBi() + (float)i);
            path.moveTo(rect.getRi() + i, rect.getBi());
            path.lineTo(rect.getRi() + i, SHADOW_SIZE + rect.getYi());
            path.lineTo(rect.getRi(), SHADOW_SIZE - i + rect.getYi());
            g2.setColor(new Color(0.4f, 0.4f, 0.4f, 1.0f - (float)i / (float)(SHADOW_SIZE - 1)));
            g2.draw(path);
        }
        g2.setClip(oldClip);
        g2.setStroke(oldStroke);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void drawPage(StiGraphics g) {
        if (this.page != null) {
            this.page.paint(new StiPaintArgs(g, Boolean.valueOf(this instanceof StiThumbPageVisual)));
        }
    }

    protected void drawBackground(StiGraphics g, StiRectangle rectangle) {
        if (this.page != null) {
            g.drawRectangle(rectangle, null, this.page.getBrush(), Double.valueOf(1.0), Double.valueOf(1.0));
        }
    }

    public Point getMousePosition() {
        Point point = super.getMousePosition();
        if (point == null && this.stiViewModel.getParentFrame() != null && this.stiViewModel.getParentFrame().getGlassPane() != null && this.stiViewModel.getParentFrame().getGlassPane().isVisible()) {
            point = this.stiViewModel.getParentFrame().getGlassPane().getMousePosition();
        }
        return point;
    }

    public void setSelected(Boolean selected) {
        this.borderSize = selected != false ? SELECTED_BORDER_SIZE : UNSELECTED_BORDER_SIZE;
        this.borderColor = selected != false ? SELECTED_BORDER_COLOR : UNSELECTED_BORDER_COLOR;
        this.selected = selected;
        this.repaint();
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getDestLeft() {
        return this.destLeft;
    }

    public void setDestLeft(Integer destLeft) {
        this.destLeft = destLeft;
    }

    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public Integer getDestTop() {
        return this.destTop;
    }

    public void setDestTop(Integer destTop) {
        this.destTop = destTop;
    }

    public Integer getDestWidth() {
        return this.destWidth;
    }

    public void setDestWidth(Integer destWidth) {
        this.destWidth = destWidth;
    }

    public Integer getDestHeight() {
        return this.destHeight;
    }

    public void setDestHeight(Integer destHeight) {
        this.destHeight = destHeight;
    }

    public StiPage getPage() {
        return this.page;
    }

    public void setPage(StiPage page) {
        this.page = page;
        this.wd = page.getUnit().ConvertToHInches(page.getWidth() + page.getMargins().getLeft() + page.getMargins().getRight());
        this.ht = page.getUnit().ConvertToHInches(page.getHeight() + page.getMargins().getTop() + page.getMargins().getBottom());
    }

    public static long getSerialversionuid() {
        return 6167165386613154440L;
    }

    public void changeBitmap() {
        this.changeBitmap = true;
    }

    public Double getWd() {
        return this.wd;
    }

    public Double getHt() {
        return this.ht;
    }

    public BufferedImage getImage(StiRectangle rect) {
        if (this.image == null) {
            this.image = new BufferedImage(rect.getWi(), rect.getHi(), 2);
            Graphics2D graphics = this.image.createGraphics();
            String text = StiLocalization.getValue((String)"FormView", (String)"RenderingEvent") + "...";
            Font font = new Font("Arial", 1, 10);
            Rectangle2D fontStringBounds = font.getStringBounds(text, graphics.getFontRenderContext());
            font = new Font("Arial", 1, (int)Math.round(10.0 * ((double)rect.getWi() / 1.5) / fontStringBounds.getWidth()));
            fontStringBounds = font.getStringBounds(text, graphics.getFontRenderContext());
            StiGraphicsHelper.setRenderingHints((Graphics2D)graphics);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, rect.getWi(), rect.getHi());
            graphics.setColor(new Color(100, 100, 100, 100));
            graphics.setFont(font);
            graphics.drawString(text, (int)Math.round((double)(rect.getWi() / 2) - fontStringBounds.getWidth() / 2.0), Math.round(rect.getHi() / 2));
        }
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    protected int getCurrentPage() {
        return this.stiViewModel.getCurrentPage();
    }
}

