/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webviewer.helper;

import com.stimulsoft.base.licenses.StiCryptHelper;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiCharsetHelper;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.enums.StiDateRangeKind;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class StiCollectionsHelper {
    private static ConcurrentHashMap<String, HashMap<String, String>> LocalizationItems = new ConcurrentHashMap();

    private static HashMap<String, String> item(Charset value) {
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("key", value.name());
        item.put("value", value.name());
        return item;
    }

    public static List<HashMap<String, String>> getEncodingDataItems() {
        ArrayList<HashMap<String, String>> items = new ArrayList<HashMap<String, String>>();
        items.add(StiCollectionsHelper.item(StiCharsetHelper.UTF8));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.UTF_16));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.US_ASCII));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.IBM437));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.IBM850));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.IBM852));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.IBM857));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.IBM860));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.IBM861));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.IBM862));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.IBM863));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.IBM865));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.IBM866));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.IBM869));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.WINDOWS_1251));
        items.add(StiCollectionsHelper.item(StiCharsetHelper.WINDOWS_1252));
        return items;
    }

    public static void loadLocalizationFile(StiHttpServletRequest httpContext, String directoryPath, String filePath) {
        if (!StiValidationUtil.isNullOrEmpty((String)filePath)) {
            try {
                if ("default".equals(filePath.toLowerCase())) {
                    StiLocalization.loadDefConfig();
                } else {
                    String absolutePath;
                    if (!filePath.toLowerCase().endsWith(".xml")) {
                        filePath = filePath + ".xml";
                    }
                    if (StiValidationUtil.isNullOrEmpty((String)directoryPath)) {
                        directoryPath = "Localization";
                    }
                    if (!new File(absolutePath = filePath).exists()) {
                        absolutePath = httpContext.getSession().getServletContext().getRealPath(filePath);
                    }
                    if (!new File(absolutePath).exists()) {
                        absolutePath = httpContext.getSession().getServletContext().getRealPath(directoryPath + "/" + filePath);
                    }
                    if (!new File(absolutePath).exists()) {
                        absolutePath = httpContext.getSession().getServletContext().getRealPath("/" + filePath);
                    }
                    if (!new File(absolutePath).exists()) {
                        absolutePath = httpContext.getSession().getServletContext().getRealPath("/" + directoryPath + "/" + filePath);
                    }
                    if (new File(absolutePath).exists()) {
                        StiLocalization.load((InputStream)new FileInputStream(absolutePath));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ArrayList<HashMap<String, Object>> getLocalizationsList(StiHttpServletRequest httpContext, String directoryPath) {
        File dirFile;
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        if (StiValidationUtil.isNullOrEmpty((String)directoryPath)) {
            return list;
        }
        String absolutePath = directoryPath;
        if (!new File(absolutePath).exists()) {
            absolutePath = httpContext.getSession().getServletContext().getRealPath(directoryPath);
        }
        if (!new File(absolutePath).exists()) {
            absolutePath = httpContext.getSession().getServletContext().getRealPath("/" + directoryPath);
        }
        if ((dirFile = new File(absolutePath)).exists() && dirFile.isDirectory()) {
            File dir = new File(absolutePath);
            for (File file : dir.listFiles()) {
                if (!file.getAbsolutePath().endsWith(".xml") || file.getAbsolutePath().endsWith(".ext.xml")) continue;
                try {
                    HashMap param = StiLocalization.getParam((String)file.getAbsolutePath());
                    if (StiValidationUtil.isNullOrEmpty((String)((String)param.get("language")))) continue;
                    HashMap<String, String> loc = new HashMap<String, String>();
                    loc.put("FileName", file.getName());
                    loc.put("Language", (String)param.get("language"));
                    loc.put("Description", (String)param.get("description"));
                    loc.put("CultureName", (String)param.get("cultureName"));
                    list.add(loc);
                }
                catch (Exception e) {
                    if (StiLoggingUtil.getLogLevel() < 10) continue;
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    public static List<String> getPaperSizes() {
        return Arrays.asList("Letter", "Tabloid", "Legal", "Statement", "Executive", "A3", "A4", "A5", "B4", "B5");
    }

    public static HashMap<String, String> getLocalizationItems(StiRequestParams requestParams) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String path = requestParams.localization;
        String hash = StiCryptHelper.MD5((String)path);
        if (LocalizationItems.containsKey(hash)) {
            return LocalizationItems.get(hash);
        }
        StiCollectionsHelper.loadLocalizationFile(requestParams.httpContext, "", path);
        HashMap<String, String> words = new HashMap<String, String>();
        words.put("EditorToolTip", StiLocalization.Get((String)"FormViewer", (String)"Editor"));
        words.put("TellMeMore", StiLocalization.Get((String)"HelpDesigner", (String)"TellMeMore"));
        words.put("Print", StiLocalization.Get((String)"A_WebViewer", (String)"PrintReport"));
        words.put("PrintToolTip", StiLocalization.Get((String)"HelpViewer", (String)"Print"));
        words.put("Save", StiLocalization.Get((String)"A_WebViewer", (String)"SaveReport"));
        words.put("SaveToolTip", StiLocalization.Get((String)"HelpViewer", (String)"Save"));
        words.put("Open", StiLocalization.Get((String)"Buttons", (String)"Open"));
        words.put("OpenToolTip", StiLocalization.Get((String)"HelpViewer", (String)"Open"));
        words.put("SendEmail", StiLocalization.Get((String)"FormViewer", (String)"SendEMail").replace("...", ""));
        words.put("SendEmailToolTip", StiLocalization.Get((String)"HelpViewer", (String)"SendEMail"));
        words.put("BookmarksToolTip", StiLocalization.Get((String)"HelpViewer", (String)"Bookmarks"));
        words.put("ParametersToolTip", StiLocalization.Get((String)"HelpViewer", (String)"Parameters"));
        words.put("FindToolTip", StiLocalization.Get((String)"HelpViewer", (String)"Find"));
        words.put("FirstPageToolTip", StiLocalization.Get((String)"HelpViewer", (String)"PageFirst"));
        words.put("PrevPageToolTip", StiLocalization.Get((String)"HelpViewer", (String)"PagePrevious"));
        words.put("NextPageToolTip", StiLocalization.Get((String)"HelpViewer", (String)"PageNext"));
        words.put("LastPageToolTip", StiLocalization.Get((String)"HelpViewer", (String)"PageLast"));
        words.put("FullScreenToolTip", StiLocalization.Get((String)"HelpViewer", (String)"FullScreen"));
        words.put("ZoomToolTip", StiLocalization.Get((String)"FormViewer", (String)"Zoom"));
        words.put("Loading", StiLocalization.Get((String)"A_WebViewer", (String)"Loading").replace("...", ""));
        words.put("Bookmarks", StiLocalization.Get((String)"FormViewer", (String)"Bookmarks"));
        words.put("Parameters", StiLocalization.Get((String)"FormViewer", (String)"Parameters"));
        words.put("Time", StiLocalization.Get((String)"FormFormatEditor", (String)"Time"));
        words.put("Version", StiLocalization.Get((String)"PropertyMain", (String)"Version"));
        words.put("Maximum", StiLocalization.Get((String)"PropertyMain", (String)"Maximum"));
        words.put("FindWhat", StiLocalization.Get((String)"FormViewerFind", (String)"FindWhat"));
        words.put("FindPrevious", StiLocalization.Get((String)"FormViewerFind", (String)"FindPrevious"));
        words.put("FindNext", StiLocalization.Get((String)"FormViewerFind", (String)"FindNext"));
        words.put("MatchCase", StiLocalization.Get((String)"Editor", (String)"MatchCase"));
        words.put("MatchWholeWord", StiLocalization.Get((String)"Editor", (String)"MatchWholeWord"));
        words.put("EmailOptions", StiLocalization.Get((String)"A_WebViewer", (String)"EmailOptions"));
        words.put("Email", StiLocalization.Get((String)"A_WebViewer", (String)"Email"));
        words.put("Subject", StiLocalization.Get((String)"A_WebViewer", (String)"Subject"));
        words.put("Message", StiLocalization.Get((String)"A_WebViewer", (String)"Message"));
        words.put("Attachment", StiLocalization.Get((String)"A_WebViewer", (String)"Attachment"));
        words.put("SinglePage", StiLocalization.Get((String)"FormViewer", (String)"PageViewModeSinglePage"));
        words.put("Continuous", StiLocalization.Get((String)"FormViewer", (String)"PageViewModeContinuous"));
        words.put("MultiplePages", StiLocalization.Get((String)"FormViewer", (String)"PageViewModeMultiplePages"));
        words.put("ViewModeToolTip", StiLocalization.Get((String)"FormViewer", (String)"ViewMode"));
        words.put("Design", StiLocalization.Get((String)"Buttons", (String)"Design"));
        words.put("Page", StiLocalization.Get((String)"A_WebViewer", (String)"Page"));
        words.put("PageOf", StiLocalization.Get((String)"A_WebViewer", (String)"PageOf"));
        words.put("SaveDocument", StiLocalization.Get((String)"FormViewer", (String)"DocumentFile").replace("...", ""));
        words.put("SavePdf", StiLocalization.Get((String)"Export", (String)"ExportTypePdfFile").replace("...", ""));
        words.put("SaveXps", StiLocalization.Get((String)"Export", (String)"ExportTypeXpsFile").replace("...", ""));
        words.put("SavePpt2007", StiLocalization.Get((String)"Export", (String)"ExportTypePpt2007File").replace("...", ""));
        words.put("SaveHtml", StiLocalization.Get((String)"Export", (String)"ExportTypeHtmlFile").replace("...", ""));
        words.put("SaveText", StiLocalization.Get((String)"Export", (String)"ExportTypeTxtFile").replace("...", ""));
        words.put("SaveRtf", StiLocalization.Get((String)"Export", (String)"ExportTypeRtfFile").replace("...", ""));
        words.put("SaveWord2007", StiLocalization.Get((String)"Export", (String)"ExportTypeWord2007File").replace("...", ""));
        words.put("SaveOdt", StiLocalization.Get((String)"Export", (String)"ExportTypeWriterFile").replace("...", ""));
        words.put("SaveExcel", StiLocalization.Get((String)"Export", (String)"ExportTypeExcelFile").replace("...", ""));
        words.put("SaveOds", StiLocalization.Get((String)"Export", (String)"ExportTypeCalcFile").replace("...", ""));
        words.put("SaveData", StiLocalization.Get((String)"Export", (String)"ExportTypeDataFile").replace("...", ""));
        words.put("SaveImage", StiLocalization.Get((String)"Export", (String)"ExportTypeImageFile").replace("...", ""));
        words.put("PrintPdf", StiLocalization.Get((String)"A_WebViewer", (String)"PrintToPdf"));
        words.put("PrintWithPreview", StiLocalization.Get((String)"A_WebViewer", (String)"PrintWithPreview"));
        words.put("PrintWithoutPreview", StiLocalization.Get((String)"A_WebViewer", (String)"PrintWithoutPreview"));
        words.put("ZoomOnePage", StiLocalization.Get((String)"Zoom", (String)"PageHeight"));
        words.put("ZoomPageWidth", StiLocalization.Get((String)"FormViewer", (String)"ZoomPageWidth"));
        words.put("RemoveAll", StiLocalization.Get((String)"Buttons", (String)"RemoveAll"));
        words.put("NewItem", StiLocalization.Get((String)"FormDictionaryDesigner", (String)"NewItem"));
        words.put("Close", StiLocalization.Get((String)"Buttons", (String)"Close"));
        words.put("Reset", StiLocalization.Get((String)"Gui", (String)"cust_pm_reset"));
        words.put("Submit", StiLocalization.Get((String)"Buttons", (String)"Submit"));
        words.put("RangeFrom", StiLocalization.Get((String)"PropertyMain", (String)"RangeFrom"));
        words.put("RangeTo", StiLocalization.Get((String)"PropertyMain", (String)"RangeTo"));
        words.put("ExportFormTitle", StiLocalization.Get((String)"Export", (String)"title"));
        words.put("ButtonOk", StiLocalization.Get((String)"Gui", (String)"barname_ok"));
        words.put("ButtonCancel", StiLocalization.Get((String)"Gui", (String)"barname_cancel"));
        words.put("PagesRange", StiLocalization.Get((String)"Report", (String)"RangePage"));
        words.put("PagesRangeAll", StiLocalization.Get((String)"Report", (String)"RangeAll"));
        words.put("PagesRangeCurrentPage", StiLocalization.Get((String)"Report", (String)"RangeCurrentPage"));
        words.put("PagesRangePages", StiLocalization.Get((String)"Report", (String)"RangePages"));
        words.put("PagesRangeAllTooltip", StiLocalization.Get((String)"HelpViewer", (String)"PageAll"));
        words.put("PagesRangeCurrentPageTooltip", StiLocalization.Get((String)"HelpViewer", (String)"CurrentPage"));
        words.put("PagesRangePagesTooltip", StiLocalization.Get((String)"HelpViewer", (String)"RangePages"));
        words.put("SettingsGroup", StiLocalization.Get((String)"Export", (String)"Settings"));
        words.put("Type", StiLocalization.Get((String)"PropertyMain", (String)"Type") + ":");
        words.put("TypeTooltip", StiLocalization.Get((String)"HelpViewer", (String)"TypeExport"));
        words.put("ZoomHtml", StiLocalization.Get((String)"Export", (String)"Scale"));
        words.put("ZoomHtmlTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ScaleHtml"));
        words.put("ImageFormatForHtml", StiLocalization.Get((String)"Export", (String)"ImageFormat"));
        words.put("ImageFormatForHtmlTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ImageFormat"));
        words.put("SavingReport", StiLocalization.Get((String)"DesignerFx", (String)"SavingReport"));
        words.put("EmailSuccessfullySent", StiLocalization.Get((String)"DesignerFx", (String)"EmailSuccessfullySent"));
        words.put("SaveReportMdc", StiLocalization.Get((String)"FormViewer", (String)"DocumentFile").replace("...", "") + " (.mdc)");
        words.put("SaveReportMdz", StiLocalization.Get((String)"FormViewer", (String)"CompressedDocumentFile") + " (.mdz)");
        words.put("SaveReportMdx", StiLocalization.Get((String)"FormViewer", (String)"EncryptedDocumentFile") + " (.mdx)");
        words.put("PasswordEnter", StiLocalization.Get((String)"Password", (String)"lbPasswordLoad"));
        words.put("PasswordSaveReport", StiLocalization.Get((String)"Report", (String)"LabelPassword"));
        words.put("PasswordSaveReportTooltip", StiLocalization.Get((String)"HelpViewer", (String)"UserPassword"));
        words.put("ExportMode", StiLocalization.Get((String)"Export", (String)"ExportMode"));
        words.put("ExportModeTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ExportMode"));
        words.put("CompressToArchive", StiLocalization.Get((String)"Export", (String)"CompressToArchive"));
        words.put("CompressToArchiveTooltip", StiLocalization.Get((String)"HelpViewer", (String)"CompressToArchive"));
        words.put("EmbeddedImageData", StiLocalization.Get((String)"Export", (String)"EmbeddedImageData"));
        words.put("EmbeddedImageDataTooltip", StiLocalization.Get((String)"HelpViewer", (String)"EmbeddedImageData"));
        words.put("AddPageBreaks", StiLocalization.Get((String)"Export", (String)"AddPageBreaks"));
        words.put("AddPageBreaksTooltip", StiLocalization.Get((String)"HelpViewer", (String)"AddPageBreaks"));
        words.put("ImageResolution", StiLocalization.Get((String)"Export", (String)"ImageResolution"));
        words.put("ImageResolutionTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ImageResolution"));
        words.put("ImageCompressionMethod", StiLocalization.Get((String)"Export", (String)"ImageCompressionMethod"));
        words.put("ImageCompressionMethodTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ImageCompressionMethod"));
        words.put("ImageQuality", StiLocalization.Get((String)"Export", (String)"ImageQuality"));
        words.put("ImageQualityTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ImageQuality"));
        words.put("ContinuousPages", StiLocalization.Get((String)"Export", (String)"ContinuousPages"));
        words.put("ContinuousPagesTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ContinuousPages"));
        words.put("StandardPDFFonts", StiLocalization.Get((String)"Export", (String)"StandardPDFFonts"));
        words.put("StandardPDFFontsTooltip", StiLocalization.Get((String)"HelpViewer", (String)"StandardPdfFonts"));
        words.put("EmbeddedFonts", StiLocalization.Get((String)"Export", (String)"EmbeddedFonts"));
        words.put("EmbeddedFontsTooltip", StiLocalization.Get((String)"HelpViewer", (String)"EmbeddedFonts"));
        words.put("UseUnicode", StiLocalization.Get((String)"Export", (String)"UseUnicode"));
        words.put("UseUnicodeTooltip", StiLocalization.Get((String)"HelpViewer", (String)"UseUnicode"));
        words.put("Compressed", StiLocalization.Get((String)"Export", (String)"Compressed"));
        words.put("CompressedTooltip", StiLocalization.Get((String)"HelpViewer", (String)"Compressed"));
        words.put("ExportRtfTextAsImage", StiLocalization.Get((String)"Export", (String)"ExportRtfTextAsImage"));
        words.put("ExportRtfTextAsImageTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ExportRtfTextAsImage"));
        words.put("PdfACompliance", StiLocalization.Get((String)"Export", (String)"PdfACompliance"));
        words.put("PdfAComplianceTooltip", StiLocalization.Get((String)"HelpViewer", (String)"PdfACompliance"));
        words.put("KillSpaceLines", StiLocalization.Get((String)"Export", (String)"TxtKillSpaceLines"));
        words.put("KillSpaceLinesTooltip", StiLocalization.Get((String)"HelpViewer", (String)"KillSpaceLines"));
        words.put("PutFeedPageCode", StiLocalization.Get((String)"Export", (String)"TxtPutFeedPageCode"));
        words.put("PutFeedPageCodeTooltip", StiLocalization.Get((String)"HelpViewer", (String)"PutFeedPageCode"));
        words.put("DrawBorder", StiLocalization.Get((String)"Export", (String)"TxtDrawBorder"));
        words.put("DrawBorderTooltip", StiLocalization.Get((String)"HelpViewer", (String)"DrawBorder"));
        words.put("CutLongLines", StiLocalization.Get((String)"Export", (String)"TxtCutLongLines"));
        words.put("CutLongLinesTooltip", StiLocalization.Get((String)"HelpViewer", (String)"CutLongLines"));
        words.put("BorderType", StiLocalization.Get((String)"Export", (String)"TxtBorderType"));
        words.put("BorderTypeTooltip", StiLocalization.Get((String)"HelpViewer", (String)"BorderType"));
        words.put("BorderTypeSimple", StiLocalization.Get((String)"Export", (String)"TxtBorderTypeSimple"));
        words.put("BorderTypeSingle", StiLocalization.Get((String)"Export", (String)"TxtBorderTypeSingle"));
        words.put("BorderTypeDouble", StiLocalization.Get((String)"Export", (String)"TxtBorderTypeDouble"));
        words.put("ZoomXY", StiLocalization.Get((String)"Export", (String)"Zoom"));
        words.put("ZoomXYTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ZoomTxt"));
        words.put("EncodingData", StiLocalization.Get((String)"Export", (String)"Encoding"));
        words.put("EncodingDataTooltip", StiLocalization.Get((String)"HelpViewer", (String)"EncodingData"));
        words.put("ImageFormat", StiLocalization.Get((String)"Export", (String)"ImageType"));
        words.put("ImageFormatTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ImageType"));
        words.put("ImageFormatColor", StiLocalization.Get((String)"PropertyMain", (String)"Color"));
        words.put("ImageFormatGrayscale", StiLocalization.Get((String)"Export", (String)"ImageGrayscale"));
        words.put("ImageFormatMonochrome", StiLocalization.Get((String)"Export", (String)"ImageMonochrome"));
        words.put("MonochromeDitheringType", StiLocalization.Get((String)"Export", (String)"MonochromeDitheringType"));
        words.put("MonochromeDitheringTypeTooltip", StiLocalization.Get((String)"HelpViewer", (String)"DitheringType"));
        words.put("TiffCompressionScheme", StiLocalization.Get((String)"Export", (String)"TiffCompressionScheme"));
        words.put("TiffCompressionSchemeTooltip", StiLocalization.Get((String)"HelpViewer", (String)"TiffCompressionScheme"));
        words.put("CutEdges", StiLocalization.Get((String)"Export", (String)"ImageCutEdges"));
        words.put("CutEdgesTooltip", StiLocalization.Get((String)"HelpViewer", (String)"CutEdges"));
        words.put("MultipleFiles", StiLocalization.Get((String)"Export", (String)"MultipleFiles"));
        words.put("MultipleFilesTooltip", StiLocalization.Get((String)"HelpViewer", (String)"MultipleFiles"));
        words.put("ExportDataOnly", StiLocalization.Get((String)"Export", (String)"ExportDataOnly"));
        words.put("ExportDataOnlyTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ExportDataOnly"));
        words.put("UseDefaultSystemEncoding", StiLocalization.Get((String)"Export", (String)"UseDefaultSystemEncoding"));
        words.put("UseDefaultSystemEncodingTooltip", StiLocalization.Get((String)"HelpViewer", (String)"UseDefaultSystemEncoding"));
        words.put("EncodingDifFile", StiLocalization.Get((String)"Export", (String)"Encoding"));
        words.put("EncodingDifFileTooltip", StiLocalization.Get((String)"HelpViewer", (String)"EncodingData"));
        words.put("ExportModeRtf", StiLocalization.Get((String)"Export", (String)"ExportMode"));
        words.put("ExportModeRtfTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ExportModeRtf"));
        words.put("ExportModeRtfTable", StiLocalization.Get((String)"Export", (String)"ExportModeTable"));
        words.put("ExportModeRtfFrame", StiLocalization.Get((String)"Export", (String)"ExportModeFrame"));
        words.put("UsePageHeadersFooters", StiLocalization.Get((String)"Export", (String)"UsePageHeadersAndFooters"));
        words.put("UsePageHeadersFootersTooltip", StiLocalization.Get((String)"HelpViewer", (String)"UsePageHeadersAndFooters"));
        words.put("RemoveEmptySpace", StiLocalization.Get((String)"Export", (String)"RemoveEmptySpaceAtBottom"));
        words.put("RemoveEmptySpaceTooltip", StiLocalization.Get((String)"HelpViewer", (String)"RemoveEmptySpaceAtBottom"));
        words.put("Separator", StiLocalization.Get((String)"Export", (String)"Separator"));
        words.put("SeparatorTooltip", StiLocalization.Get((String)"HelpViewer", (String)"Separator"));
        words.put("SkipColumnHeaders", StiLocalization.Get((String)"Export", (String)"SkipColumnHeaders"));
        words.put("SkipColumnHeadersTooltip", StiLocalization.Get((String)"HelpViewer", (String)"SkipColumnHeaders"));
        words.put("ExportObjectFormatting", StiLocalization.Get((String)"Export", (String)"ExportObjectFormatting"));
        words.put("ExportObjectFormattingTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ExportObjectFormatting"));
        words.put("UseOnePageHeaderFooter", StiLocalization.Get((String)"Export", (String)"UseOnePageHeaderAndFooter"));
        words.put("UseOnePageHeaderFooterTooltip", StiLocalization.Get((String)"HelpViewer", (String)"UseOnePageHeaderAndFooter"));
        words.put("ExportEachPageToSheet", StiLocalization.Get((String)"Export", (String)"ExportEachPageToSheet"));
        words.put("ExportEachPageToSheetTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ExportEachPageToSheet"));
        words.put("ExportPageBreaks", StiLocalization.Get((String)"Export", (String)"ExportPageBreaks"));
        words.put("ExportPageBreaksTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ExportPageBreaks"));
        words.put("EncodingDbfFile", StiLocalization.Get((String)"Export", (String)"Encoding"));
        words.put("EncodingDbfFileTooltip", StiLocalization.Get((String)"HelpViewer", (String)"EncodingData"));
        words.put("DocumentSecurityButton", StiLocalization.Get((String)"Export", (String)"DocumentSecurity"));
        words.put("DigitalSignatureButton", StiLocalization.Get((String)"Export", (String)"DigitalSignature"));
        words.put("OpenAfterExport", StiLocalization.Get((String)"Export", (String)"OpenAfterExport"));
        words.put("OpenAfterExportTooltip", StiLocalization.Get((String)"HelpViewer", (String)"OpenAfterExport"));
        words.put("AllowEditable", StiLocalization.Get((String)"Export", (String)"AllowEditable"));
        words.put("AllowEditableTooltip", StiLocalization.Get((String)"HelpViewer", (String)"AllowEditable"));
        words.put("NameYes", StiLocalization.Get((String)"FormFormatEditor", (String)"nameYes"));
        words.put("NameNo", StiLocalization.Get((String)"FormFormatEditor", (String)"nameNo"));
        words.put("UserPassword", StiLocalization.Get((String)"Export", (String)"labelUserPassword"));
        words.put("UserPasswordTooltip", StiLocalization.Get((String)"HelpViewer", (String)"UserPassword"));
        words.put("OwnerPassword", StiLocalization.Get((String)"Export", (String)"labelOwnerPassword"));
        words.put("OwnerPasswordTooltip", StiLocalization.Get((String)"HelpViewer", (String)"OwnerPassword"));
        words.put("BandsFilter", StiLocalization.Get((String)"Export", (String)"BandsFilter"));
        words.put("BandsFilterTooltip", StiLocalization.Get((String)"HelpViewer", (String)"ExportMode"));
        words.put("BandsFilterAllBands", StiLocalization.Get((String)"Export", (String)"AllBands"));
        words.put("BandsFilterDataOnly", StiLocalization.Get((String)"Export", (String)"DataOnly"));
        words.put("BandsFilterDataAndHeaders", StiLocalization.Get((String)"Export", (String)"DataAndHeaders"));
        words.put("BandsFilterDataAndHeadersFooters", StiLocalization.Get((String)"Export", (String)"DataAndHeadersFooters"));
        words.put("Null", StiLocalization.Get((String)"Report", (String)"Null"));
        words.put("AllowPrintDocument", StiLocalization.Get((String)"Export", (String)"AllowPrintDocument"));
        words.put("AllowPrintDocumentTooltip", StiLocalization.Get((String)"HelpViewer", (String)"AllowPrintDocument"));
        words.put("AllowModifyContents", StiLocalization.Get((String)"Export", (String)"AllowModifyContents"));
        words.put("AllowModifyContentsTooltip", StiLocalization.Get((String)"HelpViewer", (String)"AllowModifyContents"));
        words.put("AllowCopyTextAndGraphics", StiLocalization.Get((String)"Export", (String)"AllowCopyTextAndGraphics"));
        words.put("AllowCopyTextAndGraphicsTooltip", StiLocalization.Get((String)"HelpViewer", (String)"AllowCopyTextAndGraphics"));
        words.put("AllowAddOrModifyTextAnnotations", StiLocalization.Get((String)"Export", (String)"AllowAddOrModifyTextAnnotations"));
        words.put("AllowAddOrModifyTextAnnotationsTooltip", StiLocalization.Get((String)"HelpViewer", (String)"AllowAddOrModifyTextAnnotations"));
        words.put("EncryptionKeyLength", StiLocalization.Get((String)"Export", (String)"labelEncryptionKeyLength"));
        words.put("EncryptionKeyLengthTooltip", StiLocalization.Get((String)"HelpViewer", (String)"EncryptionKeyLength"));
        words.put("UseDigitalSignature", StiLocalization.Get((String)"Export", (String)"UseDigitalSignature"));
        words.put("UseDigitalSignatureTooltip", StiLocalization.Get((String)"HelpViewer", (String)"DigitalSignature"));
        words.put("GetCertificateFromCryptoUI", StiLocalization.Get((String)"Export", (String)"GetCertificateFromCryptoUI"));
        words.put("GetCertificateFromCryptoUITooltip", StiLocalization.Get((String)"HelpViewer", (String)"GetCertificateFromCryptoUI"));
        words.put("SubjectNameString", StiLocalization.Get((String)"Export", (String)"labelSubjectNameString"));
        words.put("SubjectNameStringTooltip", StiLocalization.Get((String)"HelpViewer", (String)"SubjectNameString"));
        words.put("MonthJanuary", StiLocalization.Get((String)"A_WebViewer", (String)"MonthJanuary"));
        words.put("MonthFebruary", StiLocalization.Get((String)"A_WebViewer", (String)"MonthFebruary"));
        words.put("MonthMarch", StiLocalization.Get((String)"A_WebViewer", (String)"MonthMarch"));
        words.put("MonthApril", StiLocalization.Get((String)"A_WebViewer", (String)"MonthApril"));
        words.put("MonthMay", StiLocalization.Get((String)"A_WebViewer", (String)"MonthMay"));
        words.put("MonthJune", StiLocalization.Get((String)"A_WebViewer", (String)"MonthJune"));
        words.put("MonthJuly", StiLocalization.Get((String)"A_WebViewer", (String)"MonthJuly"));
        words.put("MonthAugust", StiLocalization.Get((String)"A_WebViewer", (String)"MonthAugust"));
        words.put("MonthSeptember", StiLocalization.Get((String)"A_WebViewer", (String)"MonthSeptember"));
        words.put("MonthOctober", StiLocalization.Get((String)"A_WebViewer", (String)"MonthOctober"));
        words.put("MonthNovember", StiLocalization.Get((String)"A_WebViewer", (String)"MonthNovember"));
        words.put("MonthDecember", StiLocalization.Get((String)"A_WebViewer", (String)"MonthDecember"));
        words.put("DayMonday", StiLocalization.Get((String)"A_WebViewer", (String)"DayMonday"));
        words.put("DayTuesday", StiLocalization.Get((String)"A_WebViewer", (String)"DayTuesday"));
        words.put("DayWednesday", StiLocalization.Get((String)"A_WebViewer", (String)"DayWednesday"));
        words.put("DayThursday", StiLocalization.Get((String)"A_WebViewer", (String)"DayThursday"));
        words.put("DayFriday", StiLocalization.Get((String)"A_WebViewer", (String)"DayFriday"));
        words.put("DaySaturday", StiLocalization.Get((String)"A_WebViewer", (String)"DaySaturday"));
        words.put("DaySunday", StiLocalization.Get((String)"A_WebViewer", (String)"DaySunday"));
        words.put("FormViewerTitle", StiLocalization.Get((String)"FormViewer", (String)"title"));
        words.put("Error", StiLocalization.Get((String)"Errors", (String)"Error"));
        words.put("SelectAll", StiLocalization.Get((String)"MainMenu", (String)"menuEditSelectAll").replace("&", ""));
        words.put("CurrentMonth", StiLocalization.Get((String)"DatePickerRanges", (String)"CurrentMonth"));
        words.put("CurrentQuarter", StiLocalization.Get((String)"DatePickerRanges", (String)"CurrentQuarter"));
        words.put("CurrentWeek", StiLocalization.Get((String)"DatePickerRanges", (String)"CurrentWeek"));
        words.put("CurrentYear", StiLocalization.Get((String)"DatePickerRanges", (String)"CurrentYear"));
        words.put("NextMonth", StiLocalization.Get((String)"DatePickerRanges", (String)"NextMonth"));
        words.put("NextQuarter", StiLocalization.Get((String)"DatePickerRanges", (String)"NextQuarter"));
        words.put("NextWeek", StiLocalization.Get((String)"DatePickerRanges", (String)"NextWeek"));
        words.put("NextYear", StiLocalization.Get((String)"DatePickerRanges", (String)"NextYear"));
        words.put("PreviousMonth", StiLocalization.Get((String)"DatePickerRanges", (String)"PreviousMonth"));
        words.put("PreviousQuarter", StiLocalization.Get((String)"DatePickerRanges", (String)"PreviousQuarter"));
        words.put("PreviousWeek", StiLocalization.Get((String)"DatePickerRanges", (String)"PreviousWeek"));
        words.put("PreviousYear", StiLocalization.Get((String)"DatePickerRanges", (String)"PreviousYear"));
        words.put("FirstQuarter", StiLocalization.Get((String)"DatePickerRanges", (String)"FirstQuarter"));
        words.put("SecondQuarter", StiLocalization.Get((String)"DatePickerRanges", (String)"SecondQuarter"));
        words.put("ThirdQuarter", StiLocalization.Get((String)"DatePickerRanges", (String)"ThirdQuarter"));
        words.put("FourthQuarter", StiLocalization.Get((String)"DatePickerRanges", (String)"FourthQuarter"));
        words.put("MonthToDate", StiLocalization.Get((String)"DatePickerRanges", (String)"MonthToDate"));
        words.put("QuarterToDate", StiLocalization.Get((String)"DatePickerRanges", (String)"QuarterToDate"));
        words.put("WeekToDate", StiLocalization.Get((String)"DatePickerRanges", (String)"WeekToDate"));
        words.put("YearToDate", StiLocalization.Get((String)"DatePickerRanges", (String)"YearToDate"));
        words.put("Today", StiLocalization.Get((String)"DatePickerRanges", (String)"Today"));
        words.put("Tomorrow", StiLocalization.Get((String)"DatePickerRanges", (String)"Tomorrow"));
        words.put("Yesterday", StiLocalization.Get((String)"DatePickerRanges", (String)"Yesterday"));
        words.put("Resources", StiLocalization.Get((String)"PropertyMain", (String)"Resources"));
        words.put("ResourcesToolTip", StiLocalization.Get((String)"PropertyMain", (String)"Resources"));
        words.put("SaveFile", StiLocalization.Get((String)"Cloud", (String)"SaveFile"));
        words.put("ButtonView", StiLocalization.Get((String)"Cloud", (String)"ButtonView"));
        words.put("NewReport", StiLocalization.Get((String)"MainMenu", (String)"menuFileNew").replace("&", ""));
        words.put("EditReport", StiLocalization.Get((String)"MainMenu", (String)"menuEditEdit"));
        words.put("QuotaMaximumReportPagesCountExceeded", StiLocalization.Get((String)"Notices", (String)"QuotaMaximumReportPagesCountExceeded"));
        words.put("QuotaMaximumDataRowsCountExceeded", StiLocalization.Get((String)"Notices", (String)"QuotaMaximumDataRowsCountExceeded"));
        words.put("New", StiLocalization.Get((String)"MainMenu", (String)"menuFileNew").replace("&", ""));
        words.put("Edit", StiLocalization.Get((String)"MainMenu", (String)"menuEditEdit"));
        words.put("NoticesYourTrialHasExpired", StiLocalization.Get((String)"Notices", (String)"YourTrialHasExpired"));
        words.put("NoticesYouUsingTrialVersion", StiLocalization.Get((String)"Notices", (String)"YouUsingTrialVersion"));
        LocalizationItems.put(hash, words);
        return words;
    }

    public static ArrayList<String> getDateRangesItems() {
        ArrayList<String> items = new ArrayList<String>();
        for (StiDateRangeKind item : StiOptions.Viewer.getRequestFromUserDateRanges()) {
            items.add(item.toString());
        }
        return items;
    }
}

