/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webviewer.helper;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.json.StiJSONHelper;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.mail.StiMailProperties;
import com.stimulsoft.base.settings.StiConfig;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.web.cache.StiCacheOptions;
import com.stimulsoft.web.classes.StiDefaultExportSettings;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.helper.StiExportsHelper;
import com.stimulsoft.web.helper.StiLicenseHelper;
import com.stimulsoft.web.helper.StiReportResourceHelper;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import com.stimulsoft.web.proxyee.StiHttpServletResponse;
import com.stimulsoft.webviewer.StiAngularViewerHandler;
import com.stimulsoft.webviewer.StiWebViewerHelper;
import com.stimulsoft.webviewer.StiWebViewerOptions;
import com.stimulsoft.webviewer.helper.StiCollectionsHelper;
import com.stimulsoft.webviewer.helper.StiResourcesHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StiAngularViewerHelper {
    protected static final Logger LOG = Logger.getLogger(StiAngularViewerHelper.class.getName());
    private static ConcurrentHashMap<String, HashMap<String, String>> localizationHash = new ConcurrentHashMap();

    public static StiWebActionResult initViewer(StiHttpServletRequest request, StiHttpServletResponse response) throws IOException, JSONException {
        StiWebViewerOptions options;
        StiRequestParams requestParams = StiWebViewerHelper.getRequestParams(request, response);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StiAngularViewerHandler handler = request.getAngularHandler() != null && request.getAngularHandler() instanceof StiAngularViewerHandler ? (StiAngularViewerHandler)request.getAngularHandler() : null;
        StiWebViewerOptions stiWebViewerOptions = options = handler != null ? handler.getOptions(request, response) : null;
        if (options == null) {
            options = new StiWebViewerOptions();
        }
        if (handler != null) {
            StiMailProperties mailProperties = handler.getMailProperties(request, response);
            StiReport report = handler.getReport(request, response, StiAngularViewerHelper.getClientProperties(requestParams));
            StiCacheOptions.cache.storeObject(request, (Object)report, options.getViewerID() + "webviewer_cached_report");
            StiCacheOptions.cache.storeObject(request, (Object)mailProperties, options.getViewerID() + "mailProperties" + "webviewer_cached_report");
            StiCacheOptions.cache.storeObject(request, (Object)options.getExceptionHandler(), "exceptionHandlerwebviewer_cached_report");
        }
        requestParams.theme = options.getTheme().toString();
        if (!StiValidationUtil.isNullOrEmpty((String)options.getLocalization())) {
            requestParams.localization = options.getLocalization();
        }
        parameters.put("action", "AngularViewerData");
        parameters.put("options", StiAngularViewerHelper.getOptions(options));
        parameters.put("defaultSettings", StiExportsHelper.getDefaultExportSettings((StiDefaultExportSettings)options.getExports().getDefaultSettings()));
        parameters.put("images", StiResourcesHelper.getImagesArray(requestParams, Math.max(requestParams.getDouble("stiweb_imagesScalingFactor"), 1.0)));
        parameters.put("styles", StiResourcesHelper.getViewerStylesBase64(requestParams.theme));
        parameters.put("loc", StiAngularViewerHelper.getLocalizationItems(options));
        parameters.put("encodingData", StiCollectionsHelper.getEncodingDataItems());
        parameters.put("dateRanges", StiCollectionsHelper.getDateRangesItems());
        parameters.put("months", new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"});
        parameters.put("dayOfWeek", new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"});
        parameters.put("paperSizes", StiCollectionsHelper.getPaperSizes());
        parameters.put("pdfSecurityCertificates", new ArrayList());
        parameters.put("jsOptions", StiAngularViewerHelper.getJsOptions(options));
        return new StiWebActionResult(new JSONObject(parameters).toString());
    }

    private static JSONObject getClientProperties(StiRequestParams requestParams) {
        try {
            String propsBase64 = new String(StiBase64DecoderUtil.decode((String)requestParams.all.get("properties").toString()), "UTF-8");
            return new JSONObject(propsBase64);
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    private static HashMap<String, Object> getJsOptions(StiWebViewerOptions options) {
        boolean isTrial;
        String productVersion = StiAttribute.getVersion().trim();
        boolean bl = isTrial = !StiLicenseKeyValidator.isValidOnJavaFramework(null);
        if (!isTrial) {
            productVersion = productVersion + " ";
        }
        HashMap<String, Object> jsOptions = new HashMap<String, Object>();
        jsOptions.put("theme", (Object)options.getTheme());
        jsOptions.put("cultureName", StiLocalization.getLocalization().getCultureName());
        jsOptions.put("localization", options.getLocalization());
        jsOptions.put("shortProductVersion", StiAttribute.getSimpleVersion());
        jsOptions.put("productVersion", productVersion.replace(", Java", ""));
        jsOptions.put("licenseUserName", StiLicenseHelper.getUserName());
        jsOptions.put("licenseIsValid", StiLicenseKeyValidator.isValidOnJavaFramework(null));
        jsOptions.put("frameworkType", "Java");
        jsOptions.put("stimulsoftFontContent", StiReportResourceHelper.getStimulsoftFontBase64Data());
        jsOptions.put("dashboardAssemblyLoaded", false);
        jsOptions.put("alternateValid", StiLicenseHelper.checkAnyLicense());
        jsOptions.put("buildDate", StiAttribute.CREATED.toString("MM/dd/yyyy hh:mm:ss a"));
        jsOptions.put("viewerId", options.getViewerID());
        return jsOptions;
    }

    private static JSONObject getOptions(StiWebViewerOptions options) throws JSONException {
        JSONObject jsOptions = new JSONObject();
        jsOptions.put("actions", (Object)options.getActions());
        jsOptions.put("server", (Object)StiJSONHelper.toHash((Object)options.getServer()));
        jsOptions.put("appearance", (Object)StiJSONHelper.toHash((Object)options.getAppearance()));
        jsOptions.put("toolbar", (Object)StiJSONHelper.toHash((Object)options.getToolbar()));
        jsOptions.put("exports", (Object)StiJSONHelper.toHash((Object)options.getExports()));
        jsOptions.put("email", (Object)StiJSONHelper.toHash((Object)options.getEmail()));
        return jsOptions;
    }

    private static HashMap<String, String> getLocalizationItems(StiWebViewerOptions options) {
        StiLocalization localization = null;
        if (options.getLocalizationStream() != null) {
            try {
                localization = StiLocalization.load((InputStream)options.getLocalizationStream());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Unable to load localization ", e);
            }
        } else if (StiValidationUtil.isNotNullOrEmpty((String)options.getLocalization())) {
            if (localizationHash.containsKey(options.getLocalization())) {
                return localizationHash.get(options.getLocalization());
            }
            File localizationFile = new File(options.getLocalization());
            try {
                localization = StiLocalization.load((InputStream)new FileInputStream(options.getLocalization()));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Unable to load localization file: " + localizationFile.getAbsolutePath());
            }
        } else {
            InputStream stream = StiConfig.class.getResourceAsStream("/com/stimulsoft/deflocalization.xml");
            try {
                localization = StiLocalization.load((InputStream)stream);
            }
            catch (StiException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, String> words = new HashMap<String, String>();
        if (localization != null) {
            words.put("Viewer", localization.getValueLoc("FormViewer", "title"));
            words.put("Upgrade", localization.getValueLoc("Buttons", "Upgrade"));
            words.put("UpgradeNow", localization.getValueLoc("Buttons", "UpgradeNow"));
            words.put("Purchase", localization.getValueLoc("Cloud", "ButtonPurchase"));
            words.put("EditorToolTip", localization.getValueLoc("FormViewer", "Editor"));
            words.put("TellMeMore", localization.getValueLoc("HelpDesigner", "TellMeMore"));
            words.put("Print", localization.getValueLoc("A_WebViewer", "PrintReport"));
            words.put("PrintToolTip", localization.getValueLoc("HelpViewer", "Print"));
            words.put("Save", localization.getValueLoc("A_WebViewer", "SaveReport"));
            words.put("SaveToolTip", localization.getValueLoc("HelpViewer", "Save"));
            words.put("Open", localization.getValueLoc("Buttons", "Open"));
            words.put("OpenToolTip", localization.getValueLoc("HelpViewer", "Open"));
            words.put("SendEmail", localization.getValueLoc("FormViewer", "SendEMail").replace("...", ""));
            words.put("SendEmailToolTip", localization.getValueLoc("HelpViewer", "SendEMail"));
            words.put("Resources", localization.getValueLoc("PropertyMain", "Resources"));
            words.put("ResourcesToolTip", localization.getValueLoc("PropertyMain", "Resources"));
            words.put("Signature", localization.getValueLoc("Components", "StiSignature"));
            words.put("SignatureToolTip", localization.getValueLoc("Export", "DigitalSignature"));
            words.put("BookmarksToolTip", localization.getValueLoc("HelpViewer", "Bookmarks"));
            words.put("ParametersToolTip", localization.getValueLoc("HelpViewer", "Parameters"));
            words.put("FindToolTip", localization.getValueLoc("HelpViewer", "Find"));
            words.put("FirstPageToolTip", localization.getValueLoc("HelpViewer", "PageFirst"));
            words.put("PrevPageToolTip", localization.getValueLoc("HelpViewer", "PagePrevious"));
            words.put("NextPageToolTip", localization.getValueLoc("HelpViewer", "PageNext"));
            words.put("LastPageToolTip", localization.getValueLoc("HelpViewer", "PageLast"));
            words.put("FullScreenToolTip", localization.getValueLoc("HelpViewer", "FullScreen"));
            words.put("ZoomToolTip", localization.getValueLoc("FormViewer", "Zoom"));
            words.put("Loading", localization.getValueLoc("A_WebViewer", "Loading").replace("...", ""));
            words.put("Bookmarks", localization.getValueLoc("FormViewer", "Bookmarks"));
            words.put("Parameters", localization.getValueLoc("FormViewer", "Parameters"));
            words.put("Time", localization.getValueLoc("FormFormatEditor", "Time"));
            words.put("Version", localization.getValueLoc("PropertyMain", "Version"));
            words.put("Maximum", localization.getValueLoc("PropertyMain", "Maximum"));
            words.put("Copy", localization.getValueLoc("Report", "CopyOf"));
            words.put("FindWhat", localization.getValueLoc("FormViewerFind", "FindWhat"));
            words.put("FindPrevious", localization.getValueLoc("FormViewerFind", "FindPrevious"));
            words.put("FindNext", localization.getValueLoc("FormViewerFind", "FindNext"));
            words.put("MatchCase", localization.getValueLoc("Editor", "MatchCase"));
            words.put("MatchWholeWord", localization.getValueLoc("Editor", "MatchWholeWord"));
            words.put("TypeToSearch", localization.getValueLoc("Editor", "TypeToSearch"));
            words.put("EmailOptions", localization.getValueLoc("A_WebViewer", "EmailOptions"));
            words.put("Email", localization.getValueLoc("A_WebViewer", "Email").replace(":", ""));
            words.put("Subject", localization.getValueLoc("A_WebViewer", "Subject").replace(":", ""));
            words.put("Message", localization.getValueLoc("A_WebViewer", "Message").replace(":", ""));
            words.put("Attachment", localization.getValueLoc("A_WebViewer", "Attachment").replace(":", ""));
            words.put("SinglePage", localization.getValueLoc("FormViewer", "PageViewModeSinglePage"));
            words.put("Continuous", localization.getValueLoc("FormViewer", "PageViewModeContinuous"));
            words.put("MultiplePages", localization.getValueLoc("FormViewer", "PageViewModeMultiplePages"));
            words.put("ViewModeToolTip", localization.getValueLoc("FormViewer", "ViewMode"));
            words.put("Design", localization.getValueLoc("Buttons", "Design"));
            words.put("Page", localization.getValueLoc("A_WebViewer", "Page"));
            words.put("PageOf", localization.getValueLoc("A_WebViewer", "PageOf"));
            words.put("PrintPdf", localization.getValueLoc("A_WebViewer", "PrintToPdf"));
            words.put("PrintWithPreview", localization.getValueLoc("A_WebViewer", "PrintWithPreview"));
            words.put("PrintWithoutPreview", localization.getValueLoc("A_WebViewer", "PrintWithoutPreview"));
            words.put("ZoomOnePage", localization.getValueLoc("Zoom", "PageHeight"));
            words.put("ZoomPageWidth", localization.getValueLoc("FormViewer", "ZoomPageWidth"));
            words.put("RemoveAll", localization.getValueLoc("Buttons", "RemoveAll"));
            words.put("NewItem", localization.getValueLoc("FormDictionaryDesigner", "NewItem"));
            words.put("Close", localization.getValueLoc("Buttons", "Close"));
            words.put("Reset", localization.getValueLoc("Gui", "cust_pm_reset"));
            words.put("Submit", localization.getValueLoc("Buttons", "Submit"));
            words.put("RangeFrom", localization.getValueLoc("PropertyMain", "RangeFrom"));
            words.put("RangeTo", localization.getValueLoc("PropertyMain", "RangeTo"));
            words.put("ExportFormTitle", localization.getValueLoc("Export", "title"));
            words.put("ButtonOk", localization.getValueLoc("Gui", "barname_ok"));
            words.put("ButtonCancel", localization.getValueLoc("Gui", "barname_cancel"));
            words.put("PagesRange", localization.getValueLoc("Report", "RangePage"));
            words.put("PagesRangeAll", localization.getValueLoc("Report", "RangeAll"));
            words.put("PagesRangeCurrentPage", localization.getValueLoc("Report", "RangeCurrentPage"));
            words.put("PagesRangePages", localization.getValueLoc("Report", "RangePages").replace(":", ""));
            words.put("PagesRangeAllTooltip", localization.getValueLoc("HelpViewer", "PageAll"));
            words.put("PagesRangeCurrentPageTooltip", localization.getValueLoc("HelpViewer", "CurrentPage"));
            words.put("PagesRangePagesTooltip", localization.getValueLoc("HelpViewer", "RangePages"));
            words.put("SettingsGroup", localization.getValueLoc("Export", "Settings"));
            words.put("Type", localization.getValueLoc("PropertyMain", "Type").replace(":", ""));
            words.put("TypeTooltip", localization.getValueLoc("HelpViewer", "TypeExport"));
            words.put("ZoomHtml", localization.getValueLoc("Export", "Scale").replace(":", ""));
            words.put("ZoomHtmlTooltip", localization.getValueLoc("HelpViewer", "ScaleHtml"));
            words.put("ImageFormatForHtml", localization.getValueLoc("Export", "ImageFormat").replace(":", ""));
            words.put("ImageFormatForHtmlTooltip", localization.getValueLoc("HelpViewer", "ImageFormat"));
            words.put("SavingReport", localization.getValueLoc("DesignerFx", "SavingReport"));
            words.put("EmailSuccessfullySent", localization.getValueLoc("DesignerFx", "EmailSuccessfullySent"));
            words.put("SaveReportMdc", localization.getValueLoc("FormViewer", "DocumentFile").replace("...", "") + " (.mdc)");
            words.put("SaveReportMdz", localization.getValueLoc("FormViewer", "CompressedDocumentFile") + " (.mdz)");
            words.put("SaveReportMdx", localization.getValueLoc("FormViewer", "EncryptedDocumentFile") + " (.mdx)");
            words.put("PasswordEnter", localization.getValueLoc("Password", "lbPasswordLoad"));
            words.put("PasswordSaveReport", localization.getValueLoc("Report", "LabelPassword"));
            words.put("PasswordSaveReportTooltip", localization.getValueLoc("HelpViewer", "UserPassword"));
            words.put("PasswordNotEntered", localization.getValueLoc("Password", "PasswordNotEntered"));
            words.put("ExportMode", localization.getValueLoc("Export", "ExportMode").replace(":", ""));
            words.put("ExportModeTooltip", localization.getValueLoc("HelpViewer", "ExportMode"));
            words.put("CompressToArchive", localization.getValueLoc("Export", "CompressToArchive"));
            words.put("CompressToArchiveTooltip", localization.getValueLoc("HelpViewer", "CompressToArchive"));
            words.put("EmbeddedImageData", localization.getValueLoc("Export", "EmbeddedImageData"));
            words.put("EmbeddedImageDataTooltip", localization.getValueLoc("HelpViewer", "EmbeddedImageData"));
            words.put("AddPageBreaks", localization.getValueLoc("Export", "AddPageBreaks"));
            words.put("AddPageBreaksTooltip", localization.getValueLoc("HelpViewer", "AddPageBreaks"));
            words.put("ImageResolution", localization.getValueLoc("Export", "ImageResolution").replace(":", ""));
            words.put("ImageResolutionTooltip", localization.getValueLoc("HelpViewer", "ImageResolution"));
            words.put("ImageCompressionMethod", localization.getValueLoc("Export", "ImageCompressionMethod").replace(":", ""));
            words.put("ImageCompressionMethodTooltip", localization.getValueLoc("HelpViewer", "ImageCompressionMethod"));
            words.put("ImageQuality", localization.getValueLoc("Export", "ImageQuality").replace(":", ""));
            words.put("ImageQualityTooltip", localization.getValueLoc("HelpViewer", "ImageQuality"));
            words.put("RestrictEditing", localization.getValueLoc("Export", "RestrictEditing").replace(":", ""));
            words.put("RestrictEditingTooltip", localization.getValueLoc("HelpViewer", "RestrictEditing"));
            words.put("ExceptEditableFields", localization.getValueLoc("Export", "ExceptEditableFields"));
            words.put("ContinuousPages", localization.getValueLoc("Export", "ContinuousPages"));
            words.put("ContinuousPagesTooltip", localization.getValueLoc("HelpViewer", "ContinuousPages"));
            words.put("StandardPDFFonts", localization.getValueLoc("Export", "StandardPDFFonts"));
            words.put("StandardPDFFontsTooltip", localization.getValueLoc("HelpViewer", "StandardPdfFonts"));
            words.put("EmbeddedFonts", localization.getValueLoc("Export", "EmbeddedFonts"));
            words.put("EmbeddedFontsTooltip", localization.getValueLoc("HelpViewer", "EmbeddedFonts"));
            words.put("UseUnicode", localization.getValueLoc("Export", "UseUnicode"));
            words.put("UseUnicodeTooltip", localization.getValueLoc("HelpViewer", "UseUnicode"));
            words.put("Compressed", localization.getValueLoc("Export", "Compressed"));
            words.put("CompressedTooltip", localization.getValueLoc("HelpViewer", "Compressed"));
            words.put("ExportRtfTextAsImage", localization.getValueLoc("Export", "ExportRtfTextAsImage"));
            words.put("ExportRtfTextAsImageTooltip", localization.getValueLoc("HelpViewer", "ExportRtfTextAsImage"));
            words.put("PdfACompliance", localization.getValueLoc("Export", "PdfACompliance"));
            words.put("PdfAComplianceTooltip", localization.getValueLoc("HelpViewer", "PdfACompliance"));
            words.put("KillSpaceLines", localization.getValueLoc("Export", "TxtKillSpaceLines"));
            words.put("KillSpaceLinesTooltip", localization.getValueLoc("HelpViewer", "KillSpaceLines"));
            words.put("PutFeedPageCode", localization.getValueLoc("Export", "TxtPutFeedPageCode"));
            words.put("PutFeedPageCodeTooltip", localization.getValueLoc("HelpViewer", "PutFeedPageCode"));
            words.put("DrawBorder", localization.getValueLoc("Export", "TxtDrawBorder"));
            words.put("DrawBorderTooltip", localization.getValueLoc("HelpViewer", "DrawBorder"));
            words.put("CutLongLines", localization.getValueLoc("Export", "TxtCutLongLines"));
            words.put("CutLongLinesTooltip", localization.getValueLoc("HelpViewer", "CutLongLines"));
            words.put("BorderType", localization.getValueLoc("Export", "TxtBorderType").replace(":", ""));
            words.put("BorderTypeTooltip", localization.getValueLoc("HelpViewer", "BorderType"));
            words.put("BorderTypeSimple", localization.getValueLoc("Export", "TxtBorderTypeSimple"));
            words.put("BorderTypeSingle", localization.getValueLoc("Export", "TxtBorderTypeSingle"));
            words.put("BorderTypeDouble", localization.getValueLoc("Export", "TxtBorderTypeDouble"));
            words.put("ZoomXY", localization.getValueLoc("Export", "Zoom").replace(":", ""));
            words.put("ZoomXYTooltip", localization.getValueLoc("HelpViewer", "ZoomTxt"));
            words.put("EncodingData", localization.getValueLoc("Export", "Encoding").replace(":", ""));
            words.put("EncodingDataTooltip", localization.getValueLoc("HelpViewer", "EncodingData"));
            words.put("ImageFormat", localization.getValueLoc("Export", "ImageType"));
            words.put("ImageFormatTooltip", localization.getValueLoc("HelpViewer", "ImageType"));
            words.put("ImageFormatColor", localization.getValueLoc("PropertyMain", "Color"));
            words.put("ImageFormatGrayscale", localization.getValueLoc("Export", "ImageGrayscale"));
            words.put("ImageFormatMonochrome", localization.getValueLoc("Export", "ImageMonochrome").replace(":", ""));
            words.put("MonochromeDitheringType", localization.getValueLoc("Export", "MonochromeDitheringType").replace(":", ""));
            words.put("MonochromeDitheringTypeTooltip", localization.getValueLoc("HelpViewer", "DitheringType"));
            words.put("TiffCompressionScheme", localization.getValueLoc("Export", "TiffCompressionScheme").replace(":", ""));
            words.put("TiffCompressionSchemeTooltip", localization.getValueLoc("HelpViewer", "TiffCompressionScheme"));
            words.put("CutEdges", localization.getValueLoc("Export", "ImageCutEdges"));
            words.put("CutEdgesTooltip", localization.getValueLoc("HelpViewer", "CutEdges"));
            words.put("MultipleFiles", localization.getValueLoc("Export", "MultipleFiles"));
            words.put("MultipleFilesTooltip", localization.getValueLoc("HelpViewer", "MultipleFiles"));
            words.put("ExportDataOnly", localization.getValueLoc("Export", "ExportDataOnly"));
            words.put("ExportDataOnlyTooltip", localization.getValueLoc("HelpViewer", "ExportDataOnly"));
            words.put("UseDefaultSystemEncoding", localization.getValueLoc("Export", "UseDefaultSystemEncoding"));
            words.put("UseDefaultSystemEncodingTooltip", localization.getValueLoc("HelpViewer", "UseDefaultSystemEncoding"));
            words.put("EncodingDifFile", localization.getValueLoc("Export", "Encoding").replace(":", ""));
            words.put("EncodingDifFileTooltip", localization.getValueLoc("HelpViewer", "EncodingData"));
            words.put("ExportModeRtf", localization.getValueLoc("Export", "ExportMode").replace(":", ""));
            words.put("ExportModeRtfTooltip", localization.getValueLoc("HelpViewer", "ExportModeRtf"));
            words.put("ExportModeRtfTable", localization.getValueLoc("Export", "ExportModeTable"));
            words.put("ExportModeRtfFrame", localization.getValueLoc("Export", "ExportModeFrame"));
            words.put("UsePageHeadersFooters", localization.getValueLoc("Export", "UsePageHeadersAndFooters"));
            words.put("UsePageHeadersFootersTooltip", localization.getValueLoc("HelpViewer", "UsePageHeadersAndFooters"));
            words.put("RemoveEmptySpace", localization.getValueLoc("Export", "RemoveEmptySpaceAtBottom"));
            words.put("RemoveEmptySpaceTooltip", localization.getValueLoc("HelpViewer", "RemoveEmptySpaceAtBottom"));
            words.put("Separator", localization.getValueLoc("Export", "Separator").replace(":", ""));
            words.put("SeparatorTooltip", localization.getValueLoc("HelpViewer", "Separator"));
            words.put("SkipColumnHeaders", localization.getValueLoc("Export", "SkipColumnHeaders"));
            words.put("SkipColumnHeadersTooltip", localization.getValueLoc("HelpViewer", "SkipColumnHeaders"));
            words.put("ExportObjectFormatting", localization.getValueLoc("Export", "ExportObjectFormatting"));
            words.put("ExportObjectFormattingTooltip", localization.getValueLoc("HelpViewer", "ExportObjectFormatting"));
            words.put("UseOnePageHeaderFooter", localization.getValueLoc("Export", "UseOnePageHeaderAndFooter"));
            words.put("UseOnePageHeaderFooterTooltip", localization.getValueLoc("HelpViewer", "UseOnePageHeaderAndFooter"));
            words.put("ExportEachPageToSheet", localization.getValueLoc("Export", "ExportEachPageToSheet"));
            words.put("ExportEachPageToSheetTooltip", localization.getValueLoc("HelpViewer", "ExportEachPageToSheet"));
            words.put("ExportPageBreaks", localization.getValueLoc("Export", "ExportPageBreaks"));
            words.put("ExportPageBreaksTooltip", localization.getValueLoc("HelpViewer", "ExportPageBreaks"));
            words.put("EncodingDbfFile", localization.getValueLoc("Export", "Encoding").replace(":", ""));
            words.put("EncodingDbfFileTooltip", localization.getValueLoc("HelpViewer", "EncodingData"));
            words.put("DocumentSecurityButton", localization.getValueLoc("Export", "DocumentSecurity"));
            words.put("DigitalSignatureButton", localization.getValueLoc("Export", "DigitalSignature"));
            words.put("OpenAfterExport", localization.getValueLoc("Export", "OpenAfterExport"));
            words.put("OpenAfterExportTooltip", localization.getValueLoc("HelpViewer", "OpenAfterExport"));
            words.put("AllowEditable", localization.getValueLoc("Export", "AllowEditable").replace(":", ""));
            words.put("AllowEditableTooltip", localization.getValueLoc("HelpViewer", "AllowEditable"));
            words.put("NameYes", localization.getValueLoc("FormFormatEditor", "nameYes"));
            words.put("NameNo", localization.getValueLoc("FormFormatEditor", "nameNo"));
            words.put("UserPassword", localization.getValueLoc("Export", "labelUserPassword").replace(":", ""));
            words.put("UserPasswordTooltip", localization.getValueLoc("HelpViewer", "UserPassword"));
            words.put("OwnerPassword", localization.getValueLoc("Export", "labelOwnerPassword").replace(":", ""));
            words.put("OwnerPasswordTooltip", localization.getValueLoc("HelpViewer", "OwnerPassword"));
            words.put("BandsFilter", localization.getValueLoc("Export", "BandsFilter").replace(":", ""));
            words.put("BandsFilterTooltip", localization.getValueLoc("HelpViewer", "ExportMode"));
            words.put("BandsFilterAllBands", localization.getValueLoc("Export", "AllBands"));
            words.put("BandsFilterDataOnly", localization.getValueLoc("Export", "DataOnly"));
            words.put("BandsFilterDataAndHeaders", localization.getValueLoc("Export", "DataAndHeaders"));
            words.put("BandsFilterDataAndHeadersFooters", localization.getValueLoc("Export", "DataAndHeadersFooters"));
            words.put("Null", localization.getValueLoc("Report", "Null"));
            words.put("ViewData", localization.getValueLoc("FormTitles", "ViewDataForm"));
            words.put("SelectColumns", localization.getValueLoc("Wizards", "SelectColumns"));
            words.put("ImageResolutionModeExactly", localization.getValueLoc("Export", "Exactly"));
            words.put("ImageResolutionModeNoMoreThan", localization.getValueLoc("Export", "NoMoreThan"));
            words.put("ImageResolutionModeAuto", localization.getValueLoc("Export", "Auto"));
            words.put("ImageResolutionMode", localization.getValueLoc("Export", "ImageResolutionMode").replace(":", ""));
            words.put("AllowPrintDocument", localization.getValueLoc("Export", "AllowPrintDocument"));
            words.put("AllowPrintDocumentTooltip", localization.getValueLoc("HelpViewer", "AllowPrintDocument"));
            words.put("AllowModifyContents", localization.getValueLoc("Export", "AllowModifyContents"));
            words.put("AllowModifyContentsTooltip", localization.getValueLoc("HelpViewer", "AllowModifyContents"));
            words.put("AllowCopyTextAndGraphics", localization.getValueLoc("Export", "AllowCopyTextAndGraphics"));
            words.put("AllowCopyTextAndGraphicsTooltip", localization.getValueLoc("HelpViewer", "AllowCopyTextAndGraphics"));
            words.put("AllowAddOrModifyTextAnnotations", localization.getValueLoc("Export", "AllowAddOrModifyTextAnnotations"));
            words.put("AllowAddOrModifyTextAnnotationsTooltip", localization.getValueLoc("HelpViewer", "AllowAddOrModifyTextAnnotations"));
            words.put("EncryptionKeyLength", localization.getValueLoc("Export", "labelEncryptionKeyLength"));
            words.put("EncryptionKeyLengthTooltip", localization.getValueLoc("HelpViewer", "EncryptionKeyLength"));
            words.put("EnableAnimation", localization.getValueLoc("Export", "EnableAnimation"));
            words.put("UseDigitalSignature", localization.getValueLoc("Export", "UseDigitalSignature"));
            words.put("UseDigitalSignatureTooltip", localization.getValueLoc("HelpViewer", "DigitalSignature"));
            words.put("GetCertificateFromCryptoUI", localization.getValueLoc("Export", "GetCertificateFromCryptoUI"));
            words.put("GetCertificateFromCryptoUITooltip", localization.getValueLoc("HelpViewer", "GetCertificateFromCryptoUI"));
            words.put("SubjectNameString", localization.getValueLoc("Export", "labelSubjectNameString").replace(":", ""));
            words.put("SubjectNameStringTooltip", localization.getValueLoc("HelpViewer", "SubjectNameString"));
            words.put("MonthJanuary", localization.getValueLoc("A_WebViewer", "MonthJanuary"));
            words.put("MonthFebruary", localization.getValueLoc("A_WebViewer", "MonthFebruary"));
            words.put("MonthMarch", localization.getValueLoc("A_WebViewer", "MonthMarch"));
            words.put("MonthApril", localization.getValueLoc("A_WebViewer", "MonthApril"));
            words.put("MonthMay", localization.getValueLoc("A_WebViewer", "MonthMay"));
            words.put("MonthJune", localization.getValueLoc("A_WebViewer", "MonthJune"));
            words.put("MonthJuly", localization.getValueLoc("A_WebViewer", "MonthJuly"));
            words.put("MonthAugust", localization.getValueLoc("A_WebViewer", "MonthAugust"));
            words.put("MonthSeptember", localization.getValueLoc("A_WebViewer", "MonthSeptember"));
            words.put("MonthOctober", localization.getValueLoc("A_WebViewer", "MonthOctober"));
            words.put("MonthNovember", localization.getValueLoc("A_WebViewer", "MonthNovember"));
            words.put("MonthDecember", localization.getValueLoc("A_WebViewer", "MonthDecember"));
            words.put("DayMonday", localization.getValueLoc("A_WebViewer", "DayMonday"));
            words.put("DayTuesday", localization.getValueLoc("A_WebViewer", "DayTuesday"));
            words.put("DayWednesday", localization.getValueLoc("A_WebViewer", "DayWednesday"));
            words.put("DayThursday", localization.getValueLoc("A_WebViewer", "DayThursday"));
            words.put("DayFriday", localization.getValueLoc("A_WebViewer", "DayFriday"));
            words.put("DaySaturday", localization.getValueLoc("A_WebViewer", "DaySaturday"));
            words.put("DaySunday", localization.getValueLoc("A_WebViewer", "DaySunday"));
            words.put("AbbreviatedDayMonday", localization.getValueLoc("A_WebViewer", "AbbreviatedDayMonday"));
            words.put("AbbreviatedDayTuesday", localization.getValueLoc("A_WebViewer", "AbbreviatedDayTuesday"));
            words.put("AbbreviatedDayWednesday", localization.getValueLoc("A_WebViewer", "AbbreviatedDayWednesday"));
            words.put("AbbreviatedDayThursday", localization.getValueLoc("A_WebViewer", "AbbreviatedDayThursday"));
            words.put("AbbreviatedDayFriday", localization.getValueLoc("A_WebViewer", "AbbreviatedDayFriday"));
            words.put("AbbreviatedDaySaturday", localization.getValueLoc("A_WebViewer", "AbbreviatedDaySaturday"));
            words.put("AbbreviatedDaySunday", localization.getValueLoc("A_WebViewer", "AbbreviatedDaySunday"));
            words.put("FormViewerTitle", localization.getValueLoc("FormViewer", "title"));
            words.put("Error", localization.getValueLoc("Errors", "Error"));
            words.put("SelectAll", localization.getValueLoc("MainMenu", "menuEditSelectAll").replace("&", ""));
            words.put("CurrentMonth", localization.getValueLoc("DatePickerRanges", "CurrentMonth"));
            words.put("CurrentQuarter", localization.getValueLoc("DatePickerRanges", "CurrentQuarter"));
            words.put("CurrentWeek", localization.getValueLoc("DatePickerRanges", "CurrentWeek"));
            words.put("CurrentYear", localization.getValueLoc("DatePickerRanges", "CurrentYear"));
            words.put("NextMonth", localization.getValueLoc("DatePickerRanges", "NextMonth"));
            words.put("NextQuarter", localization.getValueLoc("DatePickerRanges", "NextQuarter"));
            words.put("NextWeek", localization.getValueLoc("DatePickerRanges", "NextWeek"));
            words.put("NextYear", localization.getValueLoc("DatePickerRanges", "NextYear"));
            words.put("PreviousMonth", localization.getValueLoc("DatePickerRanges", "PreviousMonth"));
            words.put("PreviousQuarter", localization.getValueLoc("DatePickerRanges", "PreviousQuarter"));
            words.put("PreviousWeek", localization.getValueLoc("DatePickerRanges", "PreviousWeek"));
            words.put("PreviousYear", localization.getValueLoc("DatePickerRanges", "PreviousYear"));
            words.put("FirstQuarter", localization.getValueLoc("DatePickerRanges", "FirstQuarter"));
            words.put("SecondQuarter", localization.getValueLoc("DatePickerRanges", "SecondQuarter"));
            words.put("ThirdQuarter", localization.getValueLoc("DatePickerRanges", "ThirdQuarter"));
            words.put("FourthQuarter", localization.getValueLoc("DatePickerRanges", "FourthQuarter"));
            words.put("MonthToDate", localization.getValueLoc("DatePickerRanges", "MonthToDate"));
            words.put("QuarterToDate", localization.getValueLoc("DatePickerRanges", "QuarterToDate"));
            words.put("WeekToDate", localization.getValueLoc("DatePickerRanges", "WeekToDate"));
            words.put("YearToDate", localization.getValueLoc("DatePickerRanges", "YearToDate"));
            words.put("Today", localization.getValueLoc("DatePickerRanges", "Today"));
            words.put("Tomorrow", localization.getValueLoc("DatePickerRanges", "Tomorrow"));
            words.put("Yesterday", localization.getValueLoc("DatePickerRanges", "Yesterday"));
            words.put("Last7Days", localization.getValueLoc("DatePickerRanges", "Last7Days"));
            words.put("Last14Days", localization.getValueLoc("DatePickerRanges", "Last14Days"));
            words.put("Last30Days", localization.getValueLoc("DatePickerRanges", "Last30Days"));
            words.put("SaveFile", localization.getValueLoc("Cloud", "SaveFile"));
            words.put("ButtonView", localization.getValueLoc("Cloud", "ButtonView"));
            words.put("QuotaMaximumReportPagesCountExceeded", localization.getValueLoc("Notices", "QuotaMaximumReportPagesCountExceeded"));
            words.put("QuotaMaximumDataRowsCountExceeded", localization.getValueLoc("Notices", "QuotaMaximumDataRowsCountExceeded"));
            words.put("QuotaMaximumResourceSizeExceeded", localization.getValueLoc("Notices", "QuotaMaximumResourceSizeExceeded"));
            words.put("QuotaMaximumResourcesCountExceeded", localization.getValueLoc("Notices", "QuotaMaximumResourcesCountExceeded"));
            words.put("QuotaMaximumDataRowsCountExceeded", localization.getValueLoc("Notices", "QuotaMaximumDataRowsCountExceeded"));
            words.put("QuotaMaximumRefreshCountExceeded", localization.getValueLoc("Notices", "QuotaMaximumRefreshCountExceeded"));
            words.put("New", localization.getValueLoc("MainMenu", "menuFileNew").replace("&", ""));
            words.put("Edit", localization.getValueLoc("MainMenu", "menuEditEdit"));
            words.put("DashboardSortSmallestToLargest", localization.getValueLoc("Dashboard", "SortSmallestToLargest"));
            words.put("DashboardSortLargestToSmallest", localization.getValueLoc("Dashboard", "SortLargestToSmallest"));
            words.put("DashboardSortAZ", localization.getValueLoc("Dashboard", "SortAZ"));
            words.put("DashboardSortZA", localization.getValueLoc("Dashboard", "SortZA"));
            words.put("DashboardSortOldestToNewest", localization.getValueLoc("Dashboard", "SortOldestToNewest"));
            words.put("DashboardSortNewestToOldest", localization.getValueLoc("Dashboard", "SortNewestToOldest"));
            words.put("FormBandNoSort", localization.getValueLoc("FormBand", "NoSort"));
            words.put("DashboardNulls", localization.getValueLoc("Dashboard", "Nulls"));
            words.put("DashboardBlanks", localization.getValueLoc("Dashboard", "Blanks"));
            words.put("DashboardNumberFilters", localization.getValueLoc("Dashboard", "NumberFilters"));
            words.put("DashboardDateFilters", localization.getValueLoc("Dashboard", "DateFilters"));
            words.put("DashboardBooleanFilters", localization.getValueLoc("Dashboard", "BooleanFilters"));
            words.put("DashboardStringFilters", localization.getValueLoc("Dashboard", "StringFilters"));
            words.put("DashboardCustomFilter", localization.getValueLoc("Dashboard", "CustomFilter").replace("&", "").replace("...", ""));
            words.put("DashboardNSelected", localization.getValueLoc("Dashboard", "NSelected"));
            words.put("DrillDown", localization.getValueLoc("Dashboard", "DrillDown"));
            words.put("DrillUp", localization.getValueLoc("Dashboard", "DrillUp"));
            words.put("DrillDownSelected", localization.getValueLoc("Dashboard", "DrillDownSelected"));
            words.put("ReportSnapshot", localization.getValueLoc("Dashboard", "ReportSnapshot"));
            words.put("Dashboard", localization.getValueLoc("Components", "StiDashboard"));
            words.put("Report", localization.getValueLoc("Components", "StiReport"));
            words.put("Sort", localization.getValueLoc("PropertyMain", "Sort"));
            words.put("SortBy", localization.getValueLoc("PropertyMain", "SortBy"));
            words.put("SortAsc", localization.getValueLoc("PropertyEnum", "StiSortDirectionAsc"));
            words.put("SortDesc", localization.getValueLoc("PropertyEnum", "StiSortDirectionDesc"));
            words.put("SortNone", localization.getValueLoc("PropertyEnum", "StiSortDirectionNone"));
            words.put("Variation", localization.getValueLoc("PropertyEnum", "StiTargetModeVariation"));
            words.put("DataNotFound", localization.getValueLoc("Errors", "DataNotFound"));
            words.put("NoResult", localization.getValueLoc("Dashboard", "NoResult"));
            words.put("Filter", localization.getValueLoc("PropertyMain", "Filter"));
            words.put("Filters", localization.getValueLoc("PropertyMain", "Filters"));
            words.put("AddFilter", localization.getValueLoc("FormBand", "AddFilter").replace("&", ""));
            words.put("RemoveFilter", localization.getValueLoc("FormBand", "RemoveFilter").replace("&", ""));
            words.put("FilterOn", localization.getValueLoc("PropertyMain", "FilterOn"));
            words.put("NameTrue", localization.getValueLoc("FormFormatEditor", "nameTrue"));
            words.put("NameFalse", localization.getValueLoc("FormFormatEditor", "nameFalse"));
            words.put("FilterModeAnd", localization.getValueLoc("PropertyEnum", "StiFilterModeAnd"));
            words.put("Expression", localization.getValueLoc("PropertyMain", "Expression"));
            words.put("All", localization.getValueLoc("Report", "RangeAll"));
            words.put("FilterMode", localization.getValueLoc("PropertyMain", "FilterMode"));
            words.put("ConditionEqualTo", localization.getValueLoc("PropertyEnum", "StiFilterConditionEqualTo"));
            words.put("ConditionNotEqualTo", localization.getValueLoc("PropertyEnum", "StiFilterConditionNotEqualTo"));
            words.put("ConditionContaining", localization.getValueLoc("PropertyEnum", "StiFilterConditionContaining"));
            words.put("ConditionNotContaining", localization.getValueLoc("PropertyEnum", "StiFilterConditionNotContaining"));
            words.put("ConditionBeginningWith", localization.getValueLoc("PropertyEnum", "StiFilterConditionBeginningWith"));
            words.put("ConditionEndingWith", localization.getValueLoc("PropertyEnum", "StiFilterConditionEndingWith"));
            words.put("ConditionIsNull", localization.getValueLoc("PropertyEnum", "StiFilterConditionIsNull"));
            words.put("ConditionIsNotNull", localization.getValueLoc("PropertyEnum", "StiFilterConditionIsNotNull"));
            words.put("ConditionIsBlank", localization.getValueLoc("PropertyEnum", "StiFilterConditionIsBlank"));
            words.put("ConditionIsNotBlank", localization.getValueLoc("PropertyEnum", "StiFilterConditionIsNotBlank"));
            words.put("ConditionBetween", localization.getValueLoc("PropertyEnum", "StiFilterConditionBetween"));
            words.put("ConditionNotBetween", localization.getValueLoc("PropertyEnum", "StiFilterConditionNotBetween"));
            words.put("ConditionGreaterThan", localization.getValueLoc("PropertyEnum", "StiFilterConditionGreaterThan"));
            words.put("ConditionGreaterThanOrEqualTo", localization.getValueLoc("PropertyEnum", "StiFilterConditionGreaterThanOrEqualTo"));
            words.put("ConditionLessThan", localization.getValueLoc("PropertyEnum", "StiFilterConditionLessThan"));
            words.put("ConditionLessThanOrEqualTo", localization.getValueLoc("PropertyEnum", "StiFilterConditionLessThanOrEqualTo"));
            words.put("Refresh", localization.getValueLoc("PropertyMain", "Refresh"));
            words.put("FullScreen", localization.getValueLoc("FormViewer", "FullScreen"));
            words.put("Image", localization.getValueLoc("PropertyMain", "Image"));
            words.put("Data", localization.getValueLoc("PropertyMain", "Data"));
            words.put("Text", localization.getValueLoc("PropertyMain", "Text"));
            words.put("RichText", localization.getValueLoc("Components", "StiRichText"));
            words.put("PaperSize", localization.getValueLoc("PropertyMain", "PaperSize"));
            words.put("Orientation", localization.getValueLoc("PropertyMain", "Orientation"));
            words.put("Landscape", localization.getValueLoc("PropertyEnum", "StiPageOrientationLandscape"));
            words.put("Portrait", localization.getValueLoc("PropertyEnum", "StiPageOrientationPortrait"));
            words.put("Scale", localization.getValueLoc("PropertyMain", "Scale").replace(":", ""));
            words.put("DataType", localization.getValueLoc("PropertyMain", "DataType"));
            words.put("AuthorizationWindowTitleLogin", localization.getValueLoc("Cloud", "WindowTitleLogin"));
            words.put("AuthorizationWindowTitleSignUp", localization.getValueLoc("Cloud", "WindowTitleSignUp"));
            words.put("AuthorizationWindowTitleForgotPassword", localization.getValueLoc("Cloud", "WindowTitleForgotPassword"));
            words.put("AuthorizationTextUserName", localization.getValueLoc("Cloud", "TextUserName"));
            words.put("AuthorizationTextPassword", localization.getValueLoc("Password", "StiSavePasswordForm"));
            words.put("AuthorizationCheckBoxRememberMe", localization.getValueLoc("Cloud", "CheckBoxRememberMe"));
            words.put("AuthorizationButtonLogin", localization.getValueLoc("Cloud", "Login"));
            words.put("AuthorizationButtonSignUp", localization.getValueLoc("Cloud", "ButtonSignUp"));
            words.put("NoticesYourTrialHasExpired", localization.getValueLoc("Notices", "YourTrialHasExpired"));
            words.put("NoticesYouUsingTrialVersion", localization.getValueLoc("Notices", "YouUsingTrialVersion"));
            words.put("ResetAllFilters", localization.getValueLoc("PropertyMain", "ResetAllFilters"));
            words.put("FullName", localization.getValueLoc("PropertyMain", "FullName"));
            words.put("Initials", localization.getValueLoc("PropertyMain", "Initials"));
            words.put("ThemeColors", localization.getValueLoc("Gui", "colorpicker_themecolorslabel"));
            words.put("StandardColors", localization.getValueLoc("Gui", "colorpicker_standardcolorslabel"));
            words.put("MoreColors", localization.getValueLoc("Gui", "colorpicker_morecolors").replace("&", ""));
            words.put("NoFill", localization.getValueLoc("Gui", "colorpicker_nofill").replace("&", ""));
            words.put("Clear", localization.getValueLoc("Gui", "monthcalendar_clearbutton"));
            words.put("Custom", localization.getValueLoc("FormColorBoxPopup", "Custom"));
            words.put("Web", localization.getValueLoc("FormColorBoxPopup", "Web"));
            words.put("ColorsCategory", localization.getValueLoc("PropertyCategory", "ColorsCategory"));
            words.put("RedColor", localization.getValueLoc("PropertyColor", "Red"));
            words.put("GreenColor", localization.getValueLoc("PropertyColor", "Green"));
            words.put("BlueColor", localization.getValueLoc("PropertyColor", "Blue"));
            words.put("Draw", localization.getValueLoc("PropertyEnum", "StiSignatureTypeDraw"));
            words.put("Style", localization.getValueLoc("ChartRibbon", "Style"));
            words.put("UseBrush", localization.getValueLoc("Signature", "UseBrush"));
            words.put("InsertText", localization.getValueLoc("Signature", "InsertText"));
            words.put("InsertImage", localization.getValueLoc("Signature", "InsertImage"));
            words.put("FontStyleBold", localization.getValueLoc("HelpDesigner", "FontStyleBold"));
            words.put("FontStyleItalic", localization.getValueLoc("HelpDesigner", "FontStyleItalic"));
            words.put("FontStyleUnderline", localization.getValueLoc("HelpDesigner", "FontStyleUnderline"));
            words.put("AlignLeft", localization.getValueLoc("HelpDesigner", "AlignLeft"));
            words.put("AlignCenter", localization.getValueLoc("HelpDesigner", "AlignCenter"));
            words.put("AlignRight", localization.getValueLoc("HelpDesigner", "AlignRight"));
            words.put("AlignTop", localization.getValueLoc("HelpDesigner", "AlignTop"));
            words.put("AlignMiddle", localization.getValueLoc("HelpDesigner", "AlignMiddle"));
            words.put("AlignBottom", localization.getValueLoc("HelpDesigner", "AlignBottom"));
            words.put("ButtonBack", localization.getValueLoc("Wizards", "ButtonBack").replace("&", ""));
            words.put("ButtonNext", localization.getValueLoc("Wizards", "ButtonNext").replace("&", ""));
            words.put("ButtonSign", localization.getValueLoc("Buttons", "Sign"));
            words.put("ButtonRemove", localization.getValueLoc("Buttons", "Remove"));
            words.put("TextDropImageHere", localization.getValueLoc("FormDictionaryDesigner", "TextDropImageHere"));
            words.put("AspectRatio", localization.getValueLoc("PropertyMain", "AspectRatio"));
            words.put("Stretch", localization.getValueLoc("PropertyMain", "Stretch"));
            words.put("CheckIssues", localization.getValueLoc("MainMenu", "menuCheckIssues"));
            words.put("CantFind", localization.getValueLoc("Editor", "CantFind"));
            words.put("Compilation", localization.getValueLoc("PropertyEnum", "StiCalculationModeCompilation"));
            words.put("OpenInSafeMode", localization.getValueLoc("Buttons", "OpenInSafeMode"));
            words.put("UnsafeCompilation1", localization.getValueLoc("HelpViewer", "UnsafeCompilation1"));
            words.put("UnsafeCompilation2", localization.getValueLoc("HelpViewer", "UnsafeCompilation2"));
            words.put("SignatureSavedSuccessfully", localization.getValueLoc("Signature", "SignatureSavedSuccessfully"));
        }
        return words;
    }
}

