/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webviewer;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.report.enums.StiHtmlChartType;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.web.classes.StiDefaultExportSettings;
import com.stimulsoft.web.enums.StiContentAlignment;
import com.stimulsoft.web.enums.StiFirstDayOfWeek;
import com.stimulsoft.web.enums.StiInterfaceType;
import com.stimulsoft.web.enums.StiParametersPanelPosition;
import com.stimulsoft.web.enums.StiPrintToPdfMode;
import com.stimulsoft.web.enums.StiReportDisplayMode;
import com.stimulsoft.web.enums.StiToolbarDisplayMode;
import com.stimulsoft.web.enums.StiWebViewMode;
import com.stimulsoft.webviewer.StiWebViewerExceptionHandler;
import com.stimulsoft.webviewer.enums.StiPrintDestination;
import com.stimulsoft.webviewer.enums.StiShowMenuMode;
import com.stimulsoft.webviewer.enums.StiWebViewerTheme;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class StiWebViewerOptions
implements Serializable {
    private static final long serialVersionUID = -6149795460340938150L;
    String jsObject;
    private String viewerID = "WebViewer1" + StiGuid.newGuidStringPlain();
    private StiWebViewerTheme theme = StiWebViewerTheme.Office2022WhiteBlue;
    private String width = "100%";
    private String height = "100%";
    private String localization = "";
    private InputStream localizationStream = null;
    private int refreshTimeout = 0;
    private Collection<StiExportSettings> defaultExportSettings = new ArrayList<StiExportSettings>();
    private Integer requestTimeout = 120;
    private StiWebViewerExceptionHandler exceptionHandler;
    private ServerOptions server = new ServerOptions();
    private AppearanceOptions appearance = new AppearanceOptions();
    private ToolbarOptions toolbar = new ToolbarOptions();
    private ExportOptions exports = new ExportOptions();
    private EmailOptions email = new EmailOptions();

    public JSONObject getActions() {
        JSONObject result = new JSONObject();
        try {
            result.put("getReportSnapshot", (Object)"ReportSnapshot");
            result.put("getReport", (Object)"GetReport");
            result.put("viewerEvent", (Object)"ViewEvent");
            result.put("printReport", (Object)"ViewEvent");
            result.put("exportReport", (Object)"ViewEvent");
            result.put("designReport", (Object)("Design&report=" + this.server.getDesignReport()));
            result.put("newReport", (Object)"Design");
            result.put("interaction", (Object)"ViewerIteraction");
            result.put("emailReport", (Object)"Email");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ServerOptions getServer() {
        return this.server;
    }

    public void setServer(ServerOptions server) {
        this.server = server;
    }

    public AppearanceOptions getAppearance() {
        return this.appearance;
    }

    public void setAppearance(AppearanceOptions appearance) {
        this.appearance = appearance;
    }

    public ToolbarOptions getToolbar() {
        return this.toolbar;
    }

    public void setToolbar(ToolbarOptions toolbar) {
        this.toolbar = toolbar;
    }

    public ExportOptions getExports() {
        return this.exports;
    }

    public void setExports(ExportOptions exports) {
        this.exports = exports;
    }

    public EmailOptions getEmail() {
        return this.email;
    }

    public void setEmail(EmailOptions email) {
        this.email = email;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public String getJsObject() {
        return this.jsObject;
    }

    public void setJsObject(String jsObject) {
        this.jsObject = jsObject;
    }

    public String getViewerID() {
        return this.viewerID;
    }

    public void setViewerID(String viewerID) {
        this.viewerID = viewerID + StiGuid.newGuidStringPlain();
    }

    public void setViewerIDInternal(String viewerID) {
        this.viewerID = viewerID;
    }

    public boolean isServerCacheAsObject() {
        return true;
    }

    public StiWebViewerTheme getTheme() {
        return this.theme;
    }

    public void setTheme(StiWebViewerTheme theme) {
        this.theme = theme;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    @Deprecated
    public StiColor getBackColor() {
        return this.appearance.getBackgroundColor();
    }

    @Deprecated
    public void setBackColor(StiColor backColor) {
        this.appearance.setBackgroundColor(backColor);
    }

    @Deprecated
    public int getCountColumnsParameters() {
        return this.appearance.getParametersPanelColumnsCount();
    }

    @Deprecated
    public void setCountColumnsParameters(int countColumnsParameters) {
        this.appearance.setParametersPanelColumnsCount(countColumnsParameters);
    }

    public String getLocalization() {
        return this.localization;
    }

    public void setLocalization(String localization) {
        this.localization = localization;
    }

    @Deprecated
    public boolean isRightToLeft() {
        return this.appearance.isRightToLeft();
    }

    @Deprecated
    public void setRightToLeft(boolean rightToLeft) {
        this.appearance.setRightToLeft(rightToLeft);
    }

    @Deprecated
    public boolean isScrollbarsMode() {
        return this.appearance.isScrollbarsMode();
    }

    @Deprecated
    public void setScrollbarsMode(boolean scrollbarsMode) {
        this.appearance.setScrollbarsMode(scrollbarsMode);
    }

    @Deprecated
    public boolean isMenuAnimation() {
        return this.toolbar.isMenuAnimation();
    }

    @Deprecated
    public void setMenuAnimation(boolean menuAnimation) {
        this.toolbar.setMenuAnimation(menuAnimation);
    }

    @Deprecated
    public StiShowMenuMode getMenuShowMode() {
        return this.toolbar.showMenuMode;
    }

    @Deprecated
    public void setMenuShowMode(StiShowMenuMode menuShowMode) {
        this.toolbar.setShowMenuMode(menuShowMode);
    }

    @Deprecated
    public StiPrintDestination getMenuPrintDestination() {
        return this.toolbar.getPrintDestination();
    }

    @Deprecated
    public void setMenuPrintDestination(StiPrintDestination menuPrintDestination) {
        this.toolbar.setPrintDestination(menuPrintDestination);
    }

    @Deprecated
    protected StiWebViewMode getMenuViewMode() {
        return this.toolbar.getViewMode();
    }

    @Deprecated
    protected void setMenuViewMode(StiWebViewMode menuViewMode) {
        this.toolbar.setViewMode(menuViewMode);
    }

    @Deprecated
    public StiWebViewMode getPagesViewMode() {
        return this.toolbar.getViewMode();
    }

    @Deprecated
    public void setPagesViewMode(StiWebViewMode menuViewMode) {
        this.toolbar.setViewMode(menuViewMode);
    }

    @Deprecated
    public int getMenuZoom() {
        return this.toolbar.getZoom();
    }

    @Deprecated
    public void setMenuZoom(int menuZoom) {
        this.toolbar.setZoom(menuZoom);
    }

    @Deprecated
    public StiContentAlignment getPageAlignment() {
        return this.appearance.getPageAlignment();
    }

    @Deprecated
    public void setPageAlignment(StiContentAlignment pageAlignment) {
        this.appearance.setPageAlignment(pageAlignment);
    }

    @Deprecated
    public boolean isPageShowShadow() {
        return this.appearance.isShowPageShadow();
    }

    @Deprecated
    public void setPageShowShadow(boolean pageShowShadow) {
        this.appearance.setShowPageShadow(pageShowShadow);
    }

    @Deprecated
    public StiColor getPageBorderColor() {
        return this.appearance.getPageBorderColor();
    }

    @Deprecated
    public void setPageBorderColor(StiColor pageBorderColor) {
        this.appearance.setPageBorderColor(pageBorderColor);
    }

    @Deprecated
    public boolean isBookmarksVisible() {
        return this.toolbar.isShowBookmarksButton();
    }

    @Deprecated
    public void setBookmarksVisible(boolean bookmarksVisible) {
        this.toolbar.setShowBookmarksButton(bookmarksVisible);
    }

    @Deprecated
    public boolean isBookmarksPrint() {
        return this.appearance.isBookmarksPrint();
    }

    @Deprecated
    public void setBookmarksPrint(boolean bookmarksPrint) {
        this.appearance.setBookmarksPrint(bookmarksPrint);
    }

    @Deprecated
    public int getBookmarksTreeWidth() {
        return this.appearance.getBookmarksTreeWidth();
    }

    @Deprecated
    public void setBookmarksTreeWidth(int bookmarksTreeWidth) {
        this.appearance.setBookmarksTreeWidth(bookmarksTreeWidth);
    }

    @Deprecated
    public boolean isToolbarVisible() {
        return this.toolbar.isVisible();
    }

    @Deprecated
    public void setToolbarVisible(boolean toolbarVisible) {
        this.toolbar.setVisible(toolbarVisible);
    }

    @Deprecated
    public StiColor getToolbarBackgroundColor() {
        return this.toolbar.getBackgroundColor();
    }

    @Deprecated
    public void setToolbarBackgroundColor(StiColor toolbarBackgroundColor) {
        this.toolbar.setBackgroundColor(toolbarBackgroundColor);
    }

    @Deprecated
    public StiColor getToolbarFontColor() {
        return this.toolbar.getFontColor();
    }

    @Deprecated
    public void setToolbarFontColor(StiColor toolbarFontColor) {
        this.toolbar.setFontColor(toolbarFontColor);
    }

    @Deprecated
    public String getToolbarFontFamily() {
        return this.toolbar.getFontFamily();
    }

    @Deprecated
    public void setToolbarFontFamily(String toolbarFontFamily) {
        this.toolbar.setFontFamily(toolbarFontFamily);
    }

    @Deprecated
    public StiContentAlignment getToolbarAlignment() {
        return this.toolbar.getAlignment();
    }

    @Deprecated
    public void setToolbarAlignment(StiContentAlignment toolbarAlignment) {
        this.toolbar.setAlignment(toolbarAlignment);
    }

    @Deprecated
    public boolean isToolbarButtonCaptions() {
        return this.toolbar.isShowButtonCaptions();
    }

    @Deprecated
    public void setToolbarButtonCaptions(boolean toolbarButtonCaptions) {
        this.toolbar.setShowButtonCaptions(toolbarButtonCaptions);
    }

    @Deprecated
    public boolean isToolbarMenuCaptions() {
        return this.toolbar.isShowButtonCaptions();
    }

    @Deprecated
    public void setToolbarMenuCaptions(boolean toolbarMenuCaptions) {
        this.toolbar.setShowButtonCaptions(toolbarMenuCaptions);
    }

    @Deprecated
    public boolean isShowCurrentPageControl() {
        return this.toolbar.isShowCurrentPageControl();
    }

    @Deprecated
    public void setShowCurrentPageControl(boolean showCurrentPageControl) {
        this.toolbar.setShowCurrentPageControl(showCurrentPageControl);
    }

    @Deprecated
    public boolean isShowButtonPrint() {
        return this.toolbar.isShowPrintButton();
    }

    @Deprecated
    public void setShowButtonPrint(boolean showButtonPrint) {
        this.toolbar.setShowPrintButton(showButtonPrint);
    }

    @Deprecated
    public boolean isShowButtonSave() {
        return this.toolbar.isShowSaveButton();
    }

    @Deprecated
    public void setShowButtonSave(boolean showButtonSave) {
        this.toolbar.setShowSaveButton(showButtonSave);
    }

    @Deprecated
    public boolean isShowButtonBookmarks() {
        return this.toolbar.isShowBookmarksButton();
    }

    @Deprecated
    public void setShowButtonBookmarks(boolean showButtonBookmarks) {
        this.toolbar.setShowBookmarksButton(showButtonBookmarks);
    }

    @Deprecated
    public boolean isShowButtonParameters() {
        return this.toolbar.isShowParametersButton();
    }

    @Deprecated
    public void setShowButtonParameters(boolean showButtonParameters) {
        this.toolbar.setShowParametersButton(showButtonParameters);
    }

    @Deprecated
    public boolean isShowButtonFirstPage() {
        return this.toolbar.isShowFirstPageButton();
    }

    @Deprecated
    public void setShowButtonFirstPage(boolean showButtonFirstPage) {
        this.toolbar.setShowFirstPageButton(showButtonFirstPage);
    }

    @Deprecated
    public boolean isShowButtonPreviousPage() {
        return this.toolbar.isShowPreviousPageButton();
    }

    @Deprecated
    public void setShowButtonPreviousPage(boolean showButtonPreviousPage) {
        this.toolbar.setShowPreviousPageButton(showButtonPreviousPage);
    }

    @Deprecated
    public boolean isShowButtonNextPage() {
        return this.toolbar.isShowNextPageButton();
    }

    @Deprecated
    public void setShowButtonNextPage(boolean showButtonNextPage) {
        this.toolbar.setShowNextPageButton(showButtonNextPage);
    }

    @Deprecated
    public boolean isShowButtonLastPage() {
        return this.toolbar.isShowLastPageButton();
    }

    @Deprecated
    public void setShowButtonLastPage(boolean showButtonLastPage) {
        this.toolbar.setShowLastPageButton(showButtonLastPage);
    }

    @Deprecated
    public boolean isShowButtonZoom() {
        return this.toolbar.isShowZoomButton();
    }

    @Deprecated
    public void setShowButtonZoom(boolean showButtonZoom) {
        this.toolbar.setShowZoomButton(showButtonZoom);
    }

    @Deprecated
    public boolean isShowButtonViewMode() {
        return this.toolbar.isShowViewModeButton();
    }

    @Deprecated
    public void setShowButtonViewMode(boolean showButtonViewMode) {
        this.toolbar.setShowViewModeButton(showButtonViewMode);
    }

    @Deprecated
    public boolean isShowButtonDesign() {
        return this.toolbar.isShowDesignButton();
    }

    @Deprecated
    public void setShowButtonDesign(boolean showButtonDesign) {
        this.toolbar.setShowDesignButton(showButtonDesign);
    }

    @Deprecated
    public boolean isShowExportDialog() {
        return this.exports.isShowExportDialog();
    }

    @Deprecated
    public void setShowExportDialog(boolean showExportDialog) {
        this.exports.setShowExportDialog(showExportDialog);
    }

    @Deprecated
    public boolean isShowExportToDocument() {
        return this.exports.isShowExportToDocument();
    }

    @Deprecated
    public void setShowExportToDocument(boolean showExportToDocument) {
        this.exports.setShowExportToDocument(showExportToDocument);
    }

    @Deprecated
    public boolean isShowExportToPdf() {
        return this.exports.isShowExportToPdf();
    }

    @Deprecated
    public void setShowExportToPdf(boolean showExportToPdf) {
        this.exports.setShowExportToPdf(showExportToPdf);
    }

    @Deprecated
    public boolean isShowExportToXps() {
        return this.exports.isShowExportToXps();
    }

    @Deprecated
    public void setShowExportToXps(boolean showExportToXps) {
        this.exports.setShowExportToXps(showExportToXps);
    }

    public boolean isShowExportToPowerPoint() {
        return false;
    }

    @Deprecated
    public boolean isShowExportToHtml() {
        return this.exports.isShowExportToHtml();
    }

    @Deprecated
    public void setShowExportToHtml(boolean showExportToHtml) {
        this.exports.setShowExportToHtml(showExportToHtml);
    }

    @Deprecated
    public boolean isShowExportToHtml5() {
        return false;
    }

    @Deprecated
    public boolean isShowExportToMht() {
        return false;
    }

    @Deprecated
    public boolean isShowExportToText() {
        return this.exports.isShowExportToText();
    }

    @Deprecated
    public void setShowExportToText(boolean showExportToText) {
        this.exports.setShowExportToText(showExportToText);
    }

    @Deprecated
    public boolean isShowExportToRtf() {
        return this.exports.isShowExportToRtf();
    }

    @Deprecated
    public void setShowExportToRtf(boolean showExportToRtf) {
        this.exports.setShowExportToRtf(showExportToRtf);
    }

    @Deprecated
    public boolean isShowExportToWord2007() {
        return this.exports.isShowExportToWord2007();
    }

    @Deprecated
    public void setShowExportToWord2007(boolean showExportToWord2007) {
        this.exports.setShowExportToWord2007(showExportToWord2007);
    }

    @Deprecated
    public boolean isShowExportToOpenDocumentWriter() {
        return false;
    }

    @Deprecated
    public boolean isShowExportToExcel() {
        return this.exports.isShowExportToExcel();
    }

    @Deprecated
    public void setShowExportToExcel(boolean showExportToExcel) {
        this.exports.setShowExportToExcel(showExportToExcel);
    }

    @Deprecated
    public boolean isShowExportToExcelXml() {
        return this.exports.isShowExportToExcelXml();
    }

    @Deprecated
    public void setShowExportToExcelXml(boolean showExportToExcelXml) {
        this.exports.setShowExportToExcelXml(showExportToExcelXml);
    }

    @Deprecated
    public boolean isShowExportToExcel2007() {
        return this.exports.isShowExportToExcel2007();
    }

    @Deprecated
    public void setShowExportToExcel2007(boolean showExportToExcel2007) {
        this.exports.setShowExportToExcel2007(showExportToExcel2007);
    }

    @Deprecated
    public boolean isShowExportToOpenDocumentCalc() {
        return false;
    }

    @Deprecated
    public boolean isShowExportToCsv() {
        return this.exports.isShowExportToCsv();
    }

    @Deprecated
    public void setShowExportToCsv(boolean showExportToCsv) {
        this.exports.setShowExportToCsv(showExportToCsv);
    }

    @Deprecated
    public boolean isShowExportToDbf() {
        return false;
    }

    @Deprecated
    public boolean isShowExportToXml() {
        return this.exports.isShowExportToXml();
    }

    @Deprecated
    public void setShowExportToXml(boolean showExportToXml) {
        this.exports.setShowExportToXml(showExportToXml);
    }

    @Deprecated
    public boolean isShowExportToDif() {
        return false;
    }

    @Deprecated
    public boolean isShowExportToSylk() {
        return this.exports.isShowExportToSylk();
    }

    @Deprecated
    public void setShowExportToSylk(boolean showExportToSylk) {
        this.exports.setShowExportToSylk(showExportToSylk);
    }

    @Deprecated
    public boolean isShowExportToImageBmp() {
        return this.exports.isShowExportToImageBmp();
    }

    @Deprecated
    public void setShowExportToImageBmp(boolean showExportToImageBmp) {
        this.exports.setShowExportToImageBmp(showExportToImageBmp);
    }

    @Deprecated
    public boolean isShowExportToImageGif() {
        return false;
    }

    @Deprecated
    public boolean isShowExportToImageJpeg() {
        return this.exports.isShowExportToImageJpeg();
    }

    @Deprecated
    public void setShowExportToImageJpeg(boolean showExportToImageJpeg) {
        this.exports.setShowExportToImageJpeg(showExportToImageJpeg);
    }

    @Deprecated
    public boolean isShowExportToImagePcx() {
        return this.exports.isShowExportToImagePcx();
    }

    @Deprecated
    public boolean isShowExportToImagePng() {
        return this.exports.isShowExportToImagePng();
    }

    @Deprecated
    public void setShowExportToImagePng(boolean showExportToImagePng) {
        this.exports.setShowExportToImagePng(showExportToImagePng);
    }

    @Deprecated
    public boolean isShowExportToImageTiff() {
        return false;
    }

    @Deprecated
    public boolean isShowExportToImageMetafile() {
        return false;
    }

    @Deprecated
    public boolean isShowExportToImageSvg() {
        return this.exports.isShowExportToImageSvg();
    }

    @Deprecated
    public void setShowExportToImageSvg(boolean showExportToImageSvg) {
        this.exports.setShowExportToImageSvg(showExportToImageSvg);
    }

    @Deprecated
    public boolean isShowExportToImageSvgz() {
        return this.exports.isShowExportToImageSvgz();
    }

    @Deprecated
    public void setShowExportToImageSvgz(boolean showExportToImageSvgz) {
        this.exports.setShowExportToImageSvgz(showExportToImageSvgz);
    }

    public int getRefreshTimeout() {
        return this.refreshTimeout;
    }

    public void setRefreshTimeout(int refreshTimeout) {
        this.refreshTimeout = refreshTimeout;
    }

    @Deprecated
    public String getOpenExportedReportTarget() {
        return this.appearance.getOpenExportedReportTarget();
    }

    @Deprecated
    public void setOpenExportedReportTarget(String openExportedReportTarget) {
        this.appearance.setOpenExportedReportTarget(openExportedReportTarget);
    }

    @Deprecated
    public String getOpenLinksTarget() {
        return this.appearance.getOpenLinksTarget();
    }

    @Deprecated
    public void setOpenLinksTarget(String openLinksTarget) {
        this.appearance.setOpenLinksTarget(openLinksTarget);
    }

    @Deprecated
    public boolean isShowAboutButton() {
        return this.toolbar.isShowAboutButton();
    }

    @Deprecated
    public void setShowAboutButton(boolean showAboutButton) {
        this.toolbar.setShowAboutButton(showAboutButton);
    }

    @Deprecated
    public boolean isShowTooltips() {
        return this.appearance.isShowTooltips();
    }

    @Deprecated
    public void setShowTooltips(boolean showTooltips) {
        this.appearance.setShowTooltips(showTooltips);
    }

    public Collection<StiExportSettings> getDefaultExportSettings() {
        return this.defaultExportSettings;
    }

    public void setDefaultExportSettings(Collection<StiExportSettings> defaultExportSettings) {
        this.defaultExportSettings = defaultExportSettings;
    }

    @Deprecated
    public boolean isShowButtonSendEmail() {
        return this.toolbar.isShowSendEmailButton();
    }

    @Deprecated
    public void setShowButtonSendEmail(boolean showButtonSendEmail) {
        this.toolbar.setShowSendEmailButton(showButtonSendEmail);
    }

    @Deprecated
    public boolean isShowEmailDialog() {
        return this.email.isShowEmailDialog();
    }

    @Deprecated
    public void setShowEmailDialog(boolean showEmailDialog) {
        this.email.setShowEmailDialog(showEmailDialog);
    }

    @Deprecated
    public String getDefaultEmailAdress() {
        return this.email.getDefaultEmailAddress();
    }

    @Deprecated
    public void setDefaultEmailAdress(String defaultEmailAdress) {
        this.email.setDefaultEmailAddress(defaultEmailAdress);
    }

    @Deprecated
    public String getDefaultEmailSubject() {
        return this.email.getDefaultEmailSubject();
    }

    @Deprecated
    public void setDefaultEmailSubject(String defaultEmailSubject) {
        this.email.setDefaultEmailSubject(defaultEmailSubject);
    }

    @Deprecated
    public String getDefaultEmailMessage() {
        return this.email.getDefaultEmailMessage();
    }

    @Deprecated
    public void setDefaultEmailMessage(String defaultEmailMessage) {
        this.email.setDefaultEmailMessage(defaultEmailMessage);
    }

    public StiWebViewerExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(StiWebViewerExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public InputStream getLocalizationStream() {
        return this.localizationStream;
    }

    public void setLocalizationStream(InputStream localizationStream) {
        this.localizationStream = localizationStream;
    }

    public class EmailOptions {
        private boolean showEmailDialog = true;
        private boolean showExportDialog = true;
        private String defaultEmailAddress = "";
        private String defaultEmailSubject = "";
        private String defaultEmailMessage = "";

        public boolean isShowEmailDialog() {
            return this.showEmailDialog;
        }

        public void setShowEmailDialog(boolean showEmailDialog) {
            this.showEmailDialog = showEmailDialog;
        }

        public boolean isShowExportDialog() {
            return this.showExportDialog;
        }

        public void setShowExportDialog(boolean showExportDialog) {
            this.showExportDialog = showExportDialog;
        }

        public String getDefaultEmailAddress() {
            return this.defaultEmailAddress;
        }

        public void setDefaultEmailAddress(String defaultEmailAddress) {
            this.defaultEmailAddress = defaultEmailAddress;
        }

        public String getDefaultEmailSubject() {
            return this.defaultEmailSubject;
        }

        public void setDefaultEmailSubject(String defaultEmailSubject) {
            this.defaultEmailSubject = defaultEmailSubject;
        }

        public String getDefaultEmailMessage() {
            return this.defaultEmailMessage;
        }

        public void setDefaultEmailMessage(String defaultEmailMessage) {
            this.defaultEmailMessage = defaultEmailMessage;
        }
    }

    public class ExportOptions {
        private StiDefaultExportSettings defaultSettings = new StiDefaultExportSettings();
        private boolean showExportDialog = true;
        private boolean showExportToDocument = true;
        private boolean showExportToPdf = true;
        private boolean showExportToXps = true;
        private boolean showExportToHtml = true;
        private boolean showExportToPowerPoint = true;
        private boolean showExportToHtml5 = false;
        private boolean showExportToMht = true;
        private boolean showExportToText = true;
        private boolean showExportToRtf = true;
        private boolean showExportToWord2007 = true;
        private boolean showExportToExcel = true;
        private boolean showExportToOdt = true;
        private boolean showExportToOds = true;
        private boolean showExportToExcelXml = true;
        private boolean showExportToExcel2007 = true;
        private boolean showExportToCsv = true;
        private boolean showExportToXml = true;
        private boolean showExportToSylk = true;
        private boolean showExportToImageBmp = true;
        private boolean showExportToImageJpeg = true;
        private boolean showExportToImagePcx = true;
        private boolean showExportToImagePng = true;
        private boolean showExportToImageSvg = true;
        private boolean showExportToImageSvgz = true;
        public boolean storeExportSettings = true;
        public boolean showOpenAfterExport = true;
        public boolean openAfterExport = true;

        public boolean isShowOpenAfterExport() {
            return this.showOpenAfterExport;
        }

        public void setShowOpenAfterExport(boolean showOpenAfterExport) {
            this.showOpenAfterExport = showOpenAfterExport;
        }

        public boolean isOpenAfterExport() {
            return this.openAfterExport;
        }

        public void setOpenAfterExport(boolean openAfterExport) {
            this.openAfterExport = openAfterExport;
        }

        public boolean isStoreExportSettings() {
            return this.storeExportSettings;
        }

        public void setStoreExportSettings(boolean storeExportSettings) {
            this.storeExportSettings = storeExportSettings;
        }

        public StiDefaultExportSettings getDefaultSettings() {
            return this.defaultSettings;
        }

        public void setDefaultSettings(StiDefaultExportSettings defaultSettings) {
            this.defaultSettings = defaultSettings;
        }

        public boolean isShowExportDialog() {
            return this.showExportDialog;
        }

        public void setShowExportDialog(boolean showExportDialog) {
            this.showExportDialog = showExportDialog;
        }

        public boolean isShowExportToDocument() {
            return this.showExportToDocument;
        }

        public void setShowExportToDocument(boolean showExportToDocument) {
            this.showExportToDocument = showExportToDocument;
        }

        public boolean isShowExportToPdf() {
            return this.showExportToPdf;
        }

        public void setShowExportToPdf(boolean showExportToPdf) {
            this.showExportToPdf = showExportToPdf;
        }

        public boolean isShowExportToXps() {
            return this.showExportToXps;
        }

        public void setShowExportToXps(boolean showExportToXps) {
            this.showExportToXps = showExportToXps;
        }

        public boolean isShowExportToPowerPoint() {
            return this.showExportToPowerPoint;
        }

        public void setShowExportToPowerPoint(boolean showExportToPowerPoint) {
            this.showExportToPowerPoint = showExportToPowerPoint;
        }

        public boolean isShowExportToHtml() {
            return this.showExportToHtml;
        }

        public void setShowExportToHtml(boolean showExportToHtml) {
            this.showExportToHtml = showExportToHtml;
        }

        public boolean isShowExportToHtml5() {
            return this.showExportToHtml5;
        }

        public boolean isShowExportToMht() {
            return this.showExportToMht;
        }

        public void setShowExportToMht(boolean showExportToMht) {
            this.showExportToMht = showExportToMht;
        }

        public boolean isShowExportToText() {
            return this.showExportToText;
        }

        public void setShowExportToText(boolean showExportToText) {
            this.showExportToText = showExportToText;
        }

        public boolean isShowExportToRtf() {
            return this.showExportToRtf;
        }

        public void setShowExportToRtf(boolean showExportToRtf) {
            this.showExportToRtf = showExportToRtf;
        }

        public boolean isShowExportToWord2007() {
            return this.showExportToWord2007;
        }

        public void setShowExportToWord2007(boolean showExportToWord2007) {
            this.showExportToWord2007 = showExportToWord2007;
        }

        public boolean isShowExportToOpenDocumentWriter() {
            return this.showExportToOdt;
        }

        public void setShowExportToOpenDocumentWriter(boolean value) {
            this.showExportToOdt = value;
        }

        public boolean isShowExportToExcel() {
            return this.showExportToExcel;
        }

        public void setShowExportToExcel(boolean showExportToExcel) {
            this.showExportToExcel = showExportToExcel;
        }

        public boolean isShowExportToExcelXml() {
            return this.showExportToExcelXml;
        }

        public void setShowExportToExcelXml(boolean showExportToExcelXml) {
            this.showExportToExcelXml = showExportToExcelXml;
        }

        public boolean isShowExportToExcel2007() {
            return this.showExportToExcel2007;
        }

        public void setShowExportToExcel2007(boolean showExportToExcel2007) {
            this.showExportToExcel2007 = showExportToExcel2007;
        }

        public boolean isShowExportToOpenDocumentCalc() {
            return this.showExportToOds;
        }

        public void setShowExportToOpenDocumentCalc(boolean value) {
            this.showExportToOds = value;
        }

        public boolean isShowExportToCsv() {
            return this.showExportToCsv;
        }

        public void setShowExportToCsv(boolean showExportToCsv) {
            this.showExportToCsv = showExportToCsv;
        }

        public boolean isShowExportToDbf() {
            return false;
        }

        public boolean isShowExportToXml() {
            return this.showExportToXml;
        }

        public void setShowExportToXml(boolean showExportToXml) {
            this.showExportToXml = showExportToXml;
        }

        public boolean isShowExportToDif() {
            return false;
        }

        public boolean isShowExportToSylk() {
            return this.showExportToSylk;
        }

        public void setShowExportToSylk(boolean showExportToSylk) {
            this.showExportToSylk = showExportToSylk;
        }

        public boolean isShowExportToImageBmp() {
            return this.showExportToImageBmp;
        }

        public void setShowExportToImageBmp(boolean showExportToImageBmp) {
            this.showExportToImageBmp = showExportToImageBmp;
        }

        public boolean isShowExportToImageGif() {
            return false;
        }

        public boolean isShowExportToImageJpeg() {
            return this.showExportToImageJpeg;
        }

        public void setShowExportToImageJpeg(boolean showExportToImageJpeg) {
            this.showExportToImageJpeg = showExportToImageJpeg;
        }

        public boolean isShowExportToImagePcx() {
            return this.showExportToImagePcx;
        }

        public void setShowExportToImagePcx(boolean showExportToImagePcx) {
            this.showExportToImagePcx = showExportToImagePcx;
        }

        public boolean isShowExportToImagePng() {
            return this.showExportToImagePng;
        }

        public void setShowExportToImagePng(boolean showExportToImagePng) {
            this.showExportToImagePng = showExportToImagePng;
        }

        public boolean isShowExportToImageTiff() {
            return false;
        }

        public boolean isShowExportToImageMetafile() {
            return false;
        }

        public boolean isShowExportToImageSvg() {
            return this.showExportToImageSvg;
        }

        public void setShowExportToImageSvg(boolean showExportToImageSvg) {
            this.showExportToImageSvg = showExportToImageSvg;
        }

        public boolean isShowExportToImageSvgz() {
            return this.showExportToImageSvgz;
        }

        public void setShowExportToImageSvgz(boolean showExportToImageSvgz) {
            this.showExportToImageSvgz = showExportToImageSvgz;
        }
    }

    public class ToolbarOptions {
        private boolean visible = true;
        private StiColor backgroundColor = null;
        private StiColor borderColor = null;
        private StiColor fontColor = null;
        private String fontFamily = "Arial";
        private StiContentAlignment alignment = StiContentAlignment.Default;
        private boolean showButtonCaptions = true;
        private boolean showPrintButton = true;
        private boolean showSaveButton = true;
        private boolean showSendEmailButton = false;
        private boolean showBookmarksButton = true;
        private boolean showParametersButton = true;
        private boolean showEditorButton = true;
        private boolean showResourcesButton = true;
        private boolean showFullScreenButton = true;
        private boolean showFirstPageButton = true;
        private boolean showPreviousPageButton = true;
        private boolean showCurrentPageControl = true;
        private boolean showNextPageButton = true;
        private boolean showLastPageButton = true;
        private boolean showZoomButton = true;
        private boolean showViewModeButton = true;
        private boolean showDesignButton = false;
        private boolean showAboutButton = true;
        private boolean showToolbar = true;
        private boolean showFindButton = true;
        private boolean showOpenButton = false;
        private boolean showPinToolbarButton = true;
        private StiToolbarDisplayMode displayMode = StiToolbarDisplayMode.Simple;
        private StiPrintDestination printDestination = StiPrintDestination.Default;
        private StiWebViewMode viewMode = StiWebViewMode.SinglePage;
        private int zoom = 100;
        private boolean menuAnimation = true;
        private StiShowMenuMode showMenuMode = StiShowMenuMode.Click;
        private StiColor toolbarBackgroundColor = StiColorEnum.Empty.color();
        private StiColor toolbarBorderColor = StiColorEnum.Empty.color();
        private boolean autoHide = false;

        public boolean isShowResourcesButton() {
            return this.showResourcesButton;
        }

        public void setShowResourcesButton(boolean showResourcesButton) {
            this.showResourcesButton = showResourcesButton;
        }

        public boolean isAutoHide() {
            return this.autoHide;
        }

        public void setAutoHide(boolean autoHide) {
            this.autoHide = autoHide;
        }

        public boolean isShowPinToolbarButton() {
            return this.showPinToolbarButton;
        }

        public void setShowPinToolbarButton(boolean showPinToolbarButton) {
            this.showPinToolbarButton = showPinToolbarButton;
        }

        public StiToolbarDisplayMode getDisplayMode() {
            return this.displayMode;
        }

        public void setDisplayMode(StiToolbarDisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        public boolean isShowOpenButton() {
            return this.showOpenButton;
        }

        public void setShowOpenButton(boolean showOpenButton) {
            this.showOpenButton = showOpenButton;
        }

        public boolean isShowFindButton() {
            return this.showFindButton;
        }

        public void setShowFindButton(boolean showFindButton) {
            this.showFindButton = showFindButton;
        }

        public StiColor getToolbarBorderColor() {
            return this.toolbarBorderColor;
        }

        public void setToolbarBorderColor(StiColor toolbarBorderColor) {
            this.toolbarBorderColor = toolbarBorderColor;
        }

        public StiColor getToolbarBackgroundColor() {
            return this.toolbarBackgroundColor;
        }

        public void setToolbarBackgroundColor(StiColor toolbarBackgroundColor) {
            this.toolbarBackgroundColor = toolbarBackgroundColor;
        }

        public boolean isShowToolbar() {
            return this.showToolbar;
        }

        public void setShowToolbar(boolean showToolbar) {
            this.showToolbar = showToolbar;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public StiColor getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(StiColor backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public StiColor getBorderColor() {
            return this.borderColor;
        }

        public void setBorderColor(StiColor borderColor) {
            this.borderColor = borderColor;
        }

        public StiColor getFontColor() {
            return this.fontColor;
        }

        public void setFontColor(StiColor fontColor) {
            this.fontColor = fontColor;
        }

        public String getFontFamily() {
            return this.fontFamily;
        }

        public void setFontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
        }

        public StiContentAlignment getAlignment() {
            return this.alignment;
        }

        public void setAlignment(StiContentAlignment alignment) {
            this.alignment = alignment;
        }

        public boolean isShowButtonCaptions() {
            return this.showButtonCaptions;
        }

        public void setShowButtonCaptions(boolean showButtonCaptions) {
            this.showButtonCaptions = showButtonCaptions;
        }

        public boolean isShowPrintButton() {
            return this.showPrintButton;
        }

        public void setShowPrintButton(boolean showPrintButton) {
            this.showPrintButton = showPrintButton;
        }

        public boolean isShowSaveButton() {
            return this.showSaveButton;
        }

        public void setShowSaveButton(boolean showSaveButton) {
            this.showSaveButton = showSaveButton;
        }

        public boolean isShowSendEmailButton() {
            return this.showSendEmailButton;
        }

        public void setShowSendEmailButton(boolean showSendEmailButton) {
            this.showSendEmailButton = showSendEmailButton;
        }

        public boolean isShowBookmarksButton() {
            return this.showBookmarksButton;
        }

        public void setShowBookmarksButton(boolean showBookmarksButton) {
            this.showBookmarksButton = showBookmarksButton;
        }

        public boolean isShowParametersButton() {
            return this.showParametersButton;
        }

        public void setShowParametersButton(boolean showParametersButton) {
            this.showParametersButton = showParametersButton;
        }

        public boolean isShowEditorButton() {
            return this.showEditorButton;
        }

        public void setShowEditorButton(boolean showEditorButton) {
            this.showEditorButton = showEditorButton;
        }

        public boolean isShowFullScreenButton() {
            return this.showFullScreenButton;
        }

        public void setShowFullScreenButton(boolean showFullScreenButton) {
            this.showFullScreenButton = showFullScreenButton;
        }

        public boolean isShowFirstPageButton() {
            return this.showFirstPageButton;
        }

        public void setShowFirstPageButton(boolean showFirstPageButton) {
            this.showFirstPageButton = showFirstPageButton;
        }

        public boolean isShowPreviousPageButton() {
            return this.showPreviousPageButton;
        }

        public void setShowPreviousPageButton(boolean showPreviousPageButton) {
            this.showPreviousPageButton = showPreviousPageButton;
        }

        public boolean isShowCurrentPageControl() {
            return this.showCurrentPageControl;
        }

        public void setShowCurrentPageControl(boolean showCurrentPageControl) {
            this.showCurrentPageControl = showCurrentPageControl;
        }

        public boolean isShowNextPageButton() {
            return this.showNextPageButton;
        }

        public void setShowNextPageButton(boolean showNextPageButton) {
            this.showNextPageButton = showNextPageButton;
        }

        public boolean isShowLastPageButton() {
            return this.showLastPageButton;
        }

        public void setShowLastPageButton(boolean showLastPageButton) {
            this.showLastPageButton = showLastPageButton;
        }

        public boolean isShowZoomButton() {
            return this.showZoomButton;
        }

        public void setShowZoomButton(boolean showZoomButton) {
            this.showZoomButton = showZoomButton;
        }

        public boolean isShowViewModeButton() {
            return this.showViewModeButton;
        }

        public void setShowViewModeButton(boolean showViewModeButton) {
            this.showViewModeButton = showViewModeButton;
        }

        public boolean isShowDesignButton() {
            return this.showDesignButton;
        }

        public void setShowDesignButton(boolean showDesignButton) {
            this.showDesignButton = showDesignButton;
        }

        public boolean isShowAboutButton() {
            return this.showAboutButton;
        }

        public void setShowAboutButton(boolean showAboutButton) {
            this.showAboutButton = showAboutButton;
        }

        public StiPrintDestination getPrintDestination() {
            return this.printDestination;
        }

        public void setPrintDestination(StiPrintDestination printDestination) {
            this.printDestination = printDestination;
        }

        public StiWebViewMode getViewMode() {
            return this.viewMode;
        }

        public void setViewMode(StiWebViewMode viewMode) {
            this.viewMode = viewMode;
        }

        public int getZoom() {
            return this.zoom;
        }

        public void setZoom(int zoom) {
            this.zoom = zoom;
        }

        public boolean isMenuAnimation() {
            return this.menuAnimation;
        }

        public void setMenuAnimation(boolean menuAnimation) {
            this.menuAnimation = menuAnimation;
        }

        public StiShowMenuMode getShowMenuMode() {
            return this.showMenuMode;
        }

        public void setShowMenuMode(StiShowMenuMode showMenuMode) {
            this.showMenuMode = showMenuMode;
        }
    }

    public class AppearanceOptions {
        private StiColor backgroundColor = StiColor.White;
        private boolean rightToLeft = false;
        private boolean fullScreenMode = false;
        private boolean scrollbarsMode = false;
        private String openLinksTarget = "_self";
        private String openExportedReportTarget = "_blank";
        private boolean showTooltips = true;
        private StiContentAlignment pageAlignment = StiContentAlignment.Center;
        private boolean showPageShadow = false;
        private StiColor pageBorderColor = StiColor.Gray;
        private boolean bookmarksPrint = false;
        private int bookmarksTreeWidth = 180;
        private int parametersPanelMaxHeight = 300;
        private int parametersPanelColumnsCount = 2;
        private String parametersPanelDateFormat = "";
        private StiInterfaceType interfaceType = StiInterfaceType.Auto;
        private StiHtmlChartType chartRenderType = StiHtmlChartType.AnimatedVector;
        private String openLinksWindow = "_blank";
        private String openExportedReportWindow = "_blank";
        private String designWindow = "_self";
        private boolean showTooltipsHelp = true;
        private StiReportDisplayMode reportDisplayMode = StiReportDisplayMode.FromReport;
        private StiFirstDayOfWeek datePickerFirstDayOfWeek = StiFirstDayOfWeek.Monday;
        private boolean storeExportSettings = true;
        public StiParametersPanelPosition parametersPanelPosition = StiParametersPanelPosition.Top;
        public String customCss;
        private boolean allowTouchZoom = true;
        public StiPrintToPdfMode printToPdfMode;

        public StiPrintToPdfMode getPrintToPdfMode() {
            return this.printToPdfMode;
        }

        public void setPrintToPdfMode(StiPrintToPdfMode printToPdfMode) {
            this.printToPdfMode = printToPdfMode;
        }

        public boolean isAllowTouchZoom() {
            return this.allowTouchZoom;
        }

        public void setAllowTouchZoom(boolean allowTouchZoom) {
            this.allowTouchZoom = allowTouchZoom;
        }

        public String getCustomCss() {
            return this.customCss;
        }

        public void setCustomCss(String customCss) {
            this.customCss = customCss;
        }

        public StiParametersPanelPosition getParametersPanelPosition() {
            return this.parametersPanelPosition;
        }

        public void setParametersPanelPosition(StiParametersPanelPosition parametersPanelPosition) {
            this.parametersPanelPosition = parametersPanelPosition;
        }

        public boolean isStoreExportSettings() {
            return this.storeExportSettings;
        }

        public void setStoreExportSettings(boolean storeExportSettings) {
            this.storeExportSettings = storeExportSettings;
        }

        public StiFirstDayOfWeek getDatePickerFirstDayOfWeek() {
            return this.datePickerFirstDayOfWeek;
        }

        public void setDatePickerFirstDayOfWeek(StiFirstDayOfWeek datePickerFirstDayOfWeek) {
            this.datePickerFirstDayOfWeek = datePickerFirstDayOfWeek;
        }

        public StiReportDisplayMode getReportDisplayMode() {
            return this.reportDisplayMode;
        }

        public void setReportDisplayMode(StiReportDisplayMode reportDisplayMode) {
            this.reportDisplayMode = reportDisplayMode;
        }

        public boolean isShowTooltipsHelp() {
            return this.showTooltipsHelp;
        }

        public void setShowTooltipsHelp(boolean showTooltipsHelp) {
            this.showTooltipsHelp = showTooltipsHelp;
        }

        public String getDesignWindow() {
            return this.designWindow;
        }

        public void setDesignWindow(String designWindow) {
            this.designWindow = designWindow;
        }

        public String getOpenExportedReportWindow() {
            return this.openExportedReportWindow;
        }

        public void setOpenExportedReportWindow(String openExportedReportWindow) {
            this.openExportedReportWindow = openExportedReportWindow;
        }

        public String getOpenLinksWindow() {
            return this.openLinksWindow;
        }

        public void setOpenLinksWindow(String openLinksWindow) {
            this.openLinksWindow = openLinksWindow;
        }

        public StiColor getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(StiColor backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public boolean isRightToLeft() {
            return this.rightToLeft;
        }

        public void setRightToLeft(boolean rightToLeft) {
            this.rightToLeft = rightToLeft;
        }

        public boolean isFullScreenMode() {
            return this.fullScreenMode;
        }

        public void setFullScreenMode(boolean fullScreenMode) {
            this.fullScreenMode = fullScreenMode;
        }

        public boolean isScrollbarsMode() {
            return this.scrollbarsMode;
        }

        public void setScrollbarsMode(boolean scrollbarsMode) {
            this.scrollbarsMode = scrollbarsMode;
        }

        public String getOpenLinksTarget() {
            return this.openLinksTarget;
        }

        public void setOpenLinksTarget(String openLinksTarget) {
            this.openLinksTarget = openLinksTarget;
        }

        public String getOpenExportedReportTarget() {
            return this.openExportedReportTarget;
        }

        public void setOpenExportedReportTarget(String openExportedReportTarget) {
            this.openExportedReportTarget = openExportedReportTarget;
        }

        public boolean isShowTooltips() {
            return this.showTooltips;
        }

        public void setShowTooltips(boolean showTooltips) {
            this.showTooltips = showTooltips;
        }

        public StiContentAlignment getPageAlignment() {
            return this.pageAlignment;
        }

        public void setPageAlignment(StiContentAlignment pageAlignment) {
            this.pageAlignment = pageAlignment;
        }

        public boolean isShowPageShadow() {
            return this.showPageShadow;
        }

        public void setShowPageShadow(boolean showPageShadow) {
            this.showPageShadow = showPageShadow;
        }

        public StiColor getPageBorderColor() {
            return this.pageBorderColor;
        }

        public void setPageBorderColor(StiColor pageBorderColor) {
            this.pageBorderColor = pageBorderColor;
        }

        public boolean isBookmarksPrint() {
            return this.bookmarksPrint;
        }

        public void setBookmarksPrint(boolean bookmarksPrint) {
            this.bookmarksPrint = bookmarksPrint;
        }

        public int getBookmarksTreeWidth() {
            return this.bookmarksTreeWidth;
        }

        public void setBookmarksTreeWidth(int bookmarksTreeWidth) {
            this.bookmarksTreeWidth = bookmarksTreeWidth;
        }

        public int getParametersPanelMaxHeight() {
            return this.parametersPanelMaxHeight;
        }

        public void setParametersPanelMaxHeight(int parametersPanelMaxHeight) {
            this.parametersPanelMaxHeight = parametersPanelMaxHeight;
        }

        public int getParametersPanelColumnsCount() {
            return this.parametersPanelColumnsCount;
        }

        public void setParametersPanelColumnsCount(int parametersPanelColumnsCount) {
            this.parametersPanelColumnsCount = parametersPanelColumnsCount;
        }

        public String getParametersPanelDateFormat() {
            return this.parametersPanelDateFormat;
        }

        public void setParametersPanelDateFormat(String parametersPanelDateFormat) {
            this.parametersPanelDateFormat = parametersPanelDateFormat;
        }

        public StiInterfaceType getInterfaceType() {
            return this.interfaceType;
        }

        public void setInterfaceType(StiInterfaceType interfaceType) {
            this.interfaceType = interfaceType;
        }

        public StiHtmlChartType getChartRenderType() {
            return this.chartRenderType;
        }

        public void setChartRenderType(StiHtmlChartType chartRenderType) {
            this.chartRenderType = chartRenderType;
        }
    }

    public class ServerOptions {
        private String controller = "";
        private int requestTimeout = 150;
        private int cacheTimeout = 150;
        private boolean globalReportCache = true;
        private boolean useRelativeUrls = false;
        private boolean passQueryParametersForResources = true;
        private boolean passFormValues = false;
        private String designReport;
        private boolean clearCashe = true;
        private boolean showServerErrorPage = true;
        public boolean useCompression = false;
        private boolean allowAutoUpdateCache = true;
        public boolean useCacheForResources = true;

        public boolean isAllowAutoUpdateCache() {
            return this.allowAutoUpdateCache;
        }

        public void setAllowAutoUpdateCache(boolean allowAutoUpdateCache) {
            this.allowAutoUpdateCache = allowAutoUpdateCache;
        }

        public boolean isUseCompression() {
            return this.useCompression;
        }

        public void setUseCompression(boolean useCompression) {
            this.useCompression = useCompression;
        }

        public boolean isShowServerErrorPage() {
            return this.showServerErrorPage;
        }

        public void setShowServerErrorPage(boolean showServerErrorPage) {
            this.showServerErrorPage = showServerErrorPage;
        }

        @Deprecated
        public boolean isClearCashe() {
            return this.clearCashe;
        }

        @Deprecated
        public void setClearCashe(boolean clearCashe) {
            this.clearCashe = clearCashe;
        }

        public boolean isClearCache() {
            return this.clearCashe;
        }

        public void setClearCache(boolean clearCache) {
            this.clearCashe = clearCache;
        }

        public String getDesignReport() {
            return this.designReport;
        }

        public void setDesignReport(String designReport) {
            this.designReport = designReport;
        }

        public String getController() {
            return this.controller;
        }

        public void setController(String controller) {
            this.controller = controller;
        }

        public int getRequestTimeout() {
            return this.requestTimeout;
        }

        public void setRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
        }

        public int getCacheTimeout() {
            return this.cacheTimeout;
        }

        public void setCacheTimeout(int cacheTimeout) {
            this.cacheTimeout = cacheTimeout;
        }

        public boolean isGlobalReportCache() {
            return this.globalReportCache;
        }

        public void setGlobalReportCache(boolean globalReportCache) {
            this.globalReportCache = globalReportCache;
        }

        public boolean isUseRelativeUrls() {
            return this.useRelativeUrls;
        }

        public void setUseRelativeUrls(boolean useRelativeUrls) {
            this.useRelativeUrls = useRelativeUrls;
        }

        public boolean isPassQueryParametersForResources() {
            return this.passQueryParametersForResources;
        }

        public void setPassQueryParametersForResources(boolean passQueryParametersForResources) {
            this.passQueryParametersForResources = passQueryParametersForResources;
        }

        public boolean isPassFormValues() {
            return this.passFormValues;
        }

        public void setPassFormValues(boolean passFormValues) {
            this.passFormValues = passFormValues;
        }
    }
}

