/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webviewer;

import com.stimulsoft.base.elements.StiKeyHelper;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.mail.StiMailProperties;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.web.cache.StiCacheOptions;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.enums.StiComponentType;
import com.stimulsoft.web.helper.StiExportsHelper;
import com.stimulsoft.web.helper.StiReportHelper;
import com.stimulsoft.web.helper.StiReportResourceHelper;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import com.stimulsoft.web.proxyee.StiHttpServletResponse;
import com.stimulsoft.webviewer.StiWebViewerHelper;
import com.stimulsoft.webviewer.helper.StiResourcesHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.xml.sax.SAXException;

public class StiWebViewerActions {
    public static StiWebActionResult getReportResult(StiHttpServletRequest request, StiHttpServletResponse response) throws IOException, JSONException, NoSuchAlgorithmException, StiException, SAXException, StiDeserializationException {
        StiRequestParams requestParams = StiWebViewerHelper.getRequestParams(request, response);
        StiReport report = (StiReport)StiCacheOptions.cache.getObject(request, requestParams.id + "webviewer_cached_report");
        if (report != null) {
            report.setKey(StiKeyHelper.generateKey());
        }
        return StiWebViewerActions.getReportResult(requestParams, report, request, response);
    }

    public static StiWebActionResult getReportResult(StiRequestParams requestParams, StiReport report, StiHttpServletRequest request, StiHttpServletResponse response) throws NoSuchAlgorithmException, IOException, JSONException, StiException, SAXException, StiDeserializationException {
        if (requestParams == null) {
            requestParams = StiWebViewerHelper.getRequestParams(request, response);
        }
        requestParams.cache.helper.saveReportInternal(requestParams, report, request);
        return StiWebViewerActions.viewerEventResult(requestParams, report, request, response);
    }

    public static StiWebActionResult exportReportResult(StiRequestParams requestParams, StiReport report, StiHttpServletRequest httpContext, StiHttpServletResponse response) throws NoSuchAlgorithmException, StiException, IOException, JSONException {
        return StiWebViewerActions.exportReportResult(requestParams, report, null, httpContext, response);
    }

    public static StiWebActionResult exportReportResult(StiHttpServletRequest httpContext, StiHttpServletResponse response, StiRequestParams requestParams, StiExportSettings settings) throws NoSuchAlgorithmException, StiException, IOException, JSONException {
        return StiWebViewerActions.exportReportResult(requestParams, null, settings, httpContext, response);
    }

    public static StiWebActionResult exportReportResult(StiRequestParams requestParams, StiReport report, StiExportSettings settings, StiHttpServletRequest httpContext, StiHttpServletResponse response) throws NoSuchAlgorithmException, StiException, IOException, JSONException {
        if (requestParams == null) {
            requestParams = StiWebViewerHelper.getRequestParams(httpContext, response);
        }
        if (report == null) {
            report = StiWebViewerHelper.getReportObject(httpContext, requestParams);
        }
        if (settings == null) {
            settings = StiWebViewerHelper.getExportSettings(requestParams);
        }
        StiWebActionResult result = StiExportsHelper.exportReportResult((StiRequestParams)requestParams, (StiReport)report, (StiExportSettings)settings);
        return new StiWebActionResult(result.getData(), result.getFileName(), result.getContentType(), !StiValidationUtil.isNullOrEmpty((String)result.getFileName()));
    }

    public static StiWebActionResult printReportResult(StiRequestParams requestParams, StiReport report) throws StiException, IOException {
        StiExportSettings settings = StiWebViewerHelper.getExportSettings(requestParams);
        return StiWebViewerActions.printReportResult(requestParams, report, settings);
    }

    public static StiWebActionResult printReportResult(StiRequestParams requestParams, StiReport report, StiExportSettings settings) throws StiException, IOException {
        StiWebActionResult result = StiExportsHelper.printReportResult((StiRequestParams)requestParams, (StiReport)report, (StiExportSettings)settings);
        return new StiWebActionResult(result.getData(), result.getContentType());
    }

    public static StiWebActionResult emailReportResult(StiHttpServletRequest request, StiHttpServletResponse response) throws IOException, JSONException, NoSuchAlgorithmException, StiException {
        StiRequestParams requestParams = StiWebViewerHelper.getRequestParams(request, response);
        StiMailProperties mailProperties = (StiMailProperties)StiCacheOptions.cache.getObject(request, requestParams.id + "mailProperties" + "webviewer_cached_report");
        StiReport report = StiWebViewerHelper.getReportObject(request, requestParams);
        StiExportSettings settings = StiWebViewerHelper.getExportSettings(requestParams);
        return StiWebViewerActions.emailReportResult(requestParams, report, mailProperties, settings, request, response);
    }

    public static StiWebActionResult emailReportResult(StiRequestParams requestParams, StiReport report, StiMailProperties options, StiExportSettings settings, StiHttpServletRequest request, StiHttpServletResponse response) throws NoSuchAlgorithmException, IOException, StiException, JSONException {
        if (requestParams == null) {
            requestParams = StiWebViewerHelper.getRequestParams(request, response);
        }
        if (report == null) {
            report = StiWebViewerHelper.getReportObject(request, requestParams);
        }
        if (settings == null) {
            settings = StiWebViewerHelper.getExportSettings(requestParams);
        }
        StiWebActionResult result = StiExportsHelper.emailReportResult((StiRequestParams)requestParams, (StiReport)report, (StiExportSettings)settings, (StiMailProperties)options, (StiHttpServletRequest)request);
        return new StiWebActionResult(result.getData(), result.getContentType());
    }

    public static StiWebActionResult reportResourceResult(StiRequestParams requestParams, StiReport report) throws IOException {
        StiResource resource;
        String resourceName = (String)requestParams.reportResourceParams.get("resourceName");
        if (report != null && (resource = report.getDictionary().getResources().get(resourceName)) != null && resource.content != null) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(resource.content, 0, resource.content.length);
            String viewType = (String)requestParams.reportResourceParams.get("viewType");
            String fileName = "SaveFile".equals(viewType) ? resource.getName() + StiReportResourceHelper.getResourceFileExt((StiResource)resource) : null;
            return new StiWebActionResult(stream, StiReportResourceHelper.getResourceContentType((StiResource)resource), fileName);
        }
        return null;
    }

    public static Object interactionResult(StiHttpServletRequest httpContext, StiHttpServletResponse response) throws IOException, JSONException, SAXException, StiDeserializationException, StiException {
        return StiWebViewerActions.interactionResult(null, null, httpContext, response);
    }

    public static Object interactionResult(StiRequestParams requestParams, StiHttpServletRequest httpContext, StiHttpServletResponse response) throws IOException, SAXException, StiDeserializationException, StiException, JSONException {
        return StiWebViewerActions.interactionResult(requestParams, null, httpContext, response);
    }

    public static StiWebActionResult interactionResult(StiReport report, StiHttpServletRequest httpContext, StiHttpServletResponse response) throws IOException, JSONException, SAXException, StiDeserializationException, StiException {
        return StiWebViewerActions.interactionResult(null, report, httpContext, response);
    }

    public static StiWebActionResult interactionResult(StiRequestParams requestParams, StiReport report, StiHttpServletRequest httpContext, StiHttpServletResponse response) throws IOException, SAXException, StiDeserializationException, StiException, JSONException {
        if (requestParams == null) {
            requestParams = StiWebViewerHelper.getRequestParams(httpContext, response);
        }
        if (report == null) {
            report = StiWebViewerHelper.getReportObject(httpContext, requestParams);
        }
        StiWebActionResult result = StiReportHelper.interactionResult((StiRequestParams)requestParams, (StiReport)report, (StiHttpServletRequest)httpContext);
        return new StiWebActionResult(result.getData(), result.getContentType());
    }

    public static Object viewerEventResult(StiHttpServletRequest httpContext, StiHttpServletResponse response) throws IOException, JSONException, NoSuchAlgorithmException, StiException, SAXException, StiDeserializationException {
        return StiWebViewerActions.viewerEventResult(null, null, httpContext, response);
    }

    public static Object viewerEventResult(StiReport report, StiHttpServletRequest httpContext, StiHttpServletResponse response) throws IOException, JSONException, NoSuchAlgorithmException, StiException, SAXException, StiDeserializationException {
        return StiWebViewerActions.viewerEventResult(null, report, httpContext, response);
    }

    public static Object viewerEventResult(StiRequestParams requestParams, StiHttpServletRequest httpContext, StiHttpServletResponse response) throws NoSuchAlgorithmException, IOException, JSONException, StiException, SAXException, StiDeserializationException {
        return StiWebViewerActions.viewerEventResult(requestParams, null, httpContext, response);
    }

    public static StiWebActionResult viewerEventResult(StiRequestParams requestParams, StiReport report, StiHttpServletRequest httpContext, StiHttpServletResponse response) throws IOException, JSONException, StiException, NoSuchAlgorithmException, SAXException, StiDeserializationException {
        if (requestParams == null) {
            requestParams = StiWebViewerHelper.getRequestParams(httpContext, response);
        }
        if (requestParams.component == StiComponentType.Viewer && requestParams.action != StiAction.Undefined) {
            StiWebActionResult result = null;
            if (report == null && requestParams.action != StiAction.OpenReport && requestParams.action != StiAction.Resource) {
                report = StiWebViewerHelper.getReportObject(httpContext, requestParams);
            }
            switch (requestParams.action) {
                case Resource: {
                    result = StiResourcesHelper.get(null, requestParams);
                    return new StiWebActionResult(result.getData(), result.getFileName(), result.getContentType(), false, true);
                }
                case OpenReport: {
                    result = StiReportHelper.openReportResult((StiRequestParams)requestParams, (StiHttpServletRequest)httpContext);
                    break;
                }
                case PrintReport: {
                    return StiWebViewerActions.printReportResult(requestParams, report);
                }
                case ExportReport: {
                    return StiWebViewerActions.exportReportResult(requestParams, report, httpContext, response);
                }
                case ReportResource: {
                    result = StiWebViewerActions.reportResourceResult(requestParams, report);
                    break;
                }
                case InitVars: 
                case Variables: 
                case Sorting: 
                case DrillDown: 
                case Collapsing: 
                case RefreshReport: {
                    return StiWebViewerActions.interactionResult(requestParams, report, httpContext, response);
                }
            }
            if (result == null) {
                result = StiReportHelper.viewerResult((StiRequestParams)requestParams, (StiReport)report);
            }
            boolean isResourceAction = requestParams.action == StiAction.Resource;
            return new StiWebActionResult(result.getData(), result.getContentType(), result.getFileName(), !StiValidationUtil.isNullOrEmpty((String)result.getFileName()) && !isResourceAction, isResourceAction);
        }
        return new StiWebActionResult();
    }
}

